/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.ADynInputsOperation;
import certa.vics.ide.fbd.InputPin;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class InputsEditDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static InputsEditDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JComboBox<String> cmbxCount;
    int minCount;

    public static boolean showDialog(ADynInputsOperation block, Component owner, int screenX, int screenY) {
        if (dialog == null) {
            dialog = new InputsEditDialog(MainFrame.instance);
        }
        InputsEditDialog.dialog.cmbxCount.requestFocusInWindow();
        InputsEditDialog.dialog.okPressed = false;
        dialog.setControls(block);
        Main.setDlgLocation(dialog, owner, screenX, screenY);
        dialog.setVisible(true);
        if (InputsEditDialog.dialog.okPressed) {
            dialog.updateBlock(block);
            return true;
        }
        return false;
    }

    public InputsEditDialog(JFrame parent) {
        super(parent, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0445\u043e\u0434\u043e\u0432");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.cmbxCount = new JComboBox();
        this.cmbxCount.setMaximumRowCount(20);
        pnlContents.add(this.cmbxCount, "alignx center, wrap");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(ADynInputsOperation block) {
        this.minCount = Math.max(block.getDynInputsCount(), 2);
        int fixedCount = block.getFixedInputsCount();
        for (int i = block.inputs.size() - 1; i > fixedCount + 1 && ((InputPin)block.inputs.get(i)).getSource() == null; --i) {
            --this.minCount;
        }
        String[] s = new String[31 - this.minCount];
        for (int i = 0; i < s.length; ++i) {
            s[i] = Integer.toString(this.minCount + i);
        }
        this.cmbxCount.setModel(new DefaultComboBoxModel<String>(s));
        this.cmbxCount.setSelectedIndex(block.inputs.size() - this.minCount - fixedCount);
    }

    void updateBlock(ADynInputsOperation block) {
        block.setDynInputsCount(this.cmbxCount.getSelectedIndex() + this.minCount);
    }
}

