/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.code;

import certa.vics.Utils;
import certa.vics.compiler.Argument;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.code.CodeActions;
import certa.vics.ide.code.VicsCodeTokenMaker;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.TextAction;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.json.JSONObject;

public class CodeEditor
extends IdeEditor
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    CodeActions actions;
    protected final MainFrame mainFrame;
    RSyntaxTextArea textArea;
    VicsCodeTokenMaker tokenMaker;
    TextAction copyAction;
    TextAction cutAction;
    TextAction pasteAction;
    TextAction undoAction;
    TextAction redoAction;
    int savedHash;
    boolean internalUpdate;

    public CodeEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u041a\u043e\u0434 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", false);
        this.mainFrame = mainFrame;
        this.textArea = new RSyntaxTextArea();
        this.textArea.setMarkOccurrences(true);
        try {
            Theme.load(Utils.getResource("code_theme.xml").openStream()).apply(this.textArea);
        }
        catch (IOException e) {
            Utils.ProcessException(e, false);
        }
        this.textArea.setFont(new Font("Monospaced", 0, 18));
        JPopupMenu m = this.textArea.getPopupMenu();
        m.remove(m.getComponentCount() - 1);
        m.remove(m.getComponentCount() - 1);
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/vics", "certa.vics.ide.code.VicsCodeTokenMaker");
        this.textArea.setSyntaxEditingStyle("text/vics");
        this.tokenMaker = VicsCodeTokenMaker.lastInstance;
        this.textArea.getDocument().addDocumentListener(this);
        RTextScrollPane scroll = new RTextScrollPane(this.textArea);
        this.add((Component)scroll, "Center");
        this.buildMenu();
    }

    private void buildMenu() {
        this.copyAction = RTextArea.getAction(0);
        this.copyAction.putValue("SmallIcon", Utils.loadImageIcon("copy.png"));
        this.cutAction = RTextArea.getAction(1);
        this.cutAction.putValue("SmallIcon", Utils.loadImageIcon("cut.png"));
        this.pasteAction = RTextArea.getAction(3);
        this.pasteAction.putValue("SmallIcon", Utils.loadImageIcon("paste.png"));
        this.undoAction = RTextArea.getAction(6);
        this.undoAction.putValue("SmallIcon", Utils.loadImageIcon("undo.png"));
        this.redoAction = RTextArea.getAction(4);
        this.redoAction.putValue("SmallIcon", Utils.loadImageIcon("redo.png"));
        this.menu.add(new JMenuItem(this.undoAction));
        this.menu.add(new JMenuItem(this.redoAction));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.copyAction));
        this.menu.add(new JMenuItem(this.cutAction));
        this.menu.add(new JMenuItem(this.pasteAction));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.check));
        this.toolBar.add(this.actions.check).setFocusable(false);
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new CodeActions(this);
        return this.actions;
    }

    protected void resetEditor() {
        this.textArea.discardAllEdits();
        this.textArea.setCaretPosition(0);
        this.markSavedToDisk();
    }

    public boolean canUndo() {
        return this.textArea.canUndo();
    }

    public boolean canRedo() {
        return this.textArea.canRedo();
    }

    public void undo() {
        this.textArea.undoLastAction();
    }

    public void redo() {
        this.textArea.redoLastAction();
    }

    public void checkCode() {
        try {
            this.mainFrame.program.clearVars();
            try {
                this.mainFrame.getVarsEditor().updateProgram(null);
            }
            catch (SyntaxError e) {
                throw new ErrorInFile("Variables", e.getMessage());
            }
            this.updateProgram(null);
            this.tokenMaker.updateIdentifiers(this.mainFrame.program);
            this.textArea.repaint();
        }
        catch (ErrorInFile ex) {
            JOptionPane.showMessageDialog(this.mainFrame, ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            int line = ex.line - 1;
            Element e = this.textArea.getDocument().getDefaultRootElement();
            if (line >= e.getElementCount()) {
                line = e.getElementCount() - 1;
            }
            if (line < 0) {
                line = 0;
            }
            e = e.getElement(line);
            int start = e.getStartOffset();
            int end = e.getEndOffset();
            this.textArea.setCaretPosition(start);
            this.textArea.setSelectionStart(start);
            this.textArea.setSelectionEnd(Math.max(start, end - 1));
        }
    }

    @Override
    public void titleClicked() {
        this.initFocus();
    }

    @Override
    public void initFocus() {
        this.textArea.requestFocusInWindow();
    }

    private void setEditText(String text) {
        if (this.mainFrame.program == null) {
            return;
        }
        this.tokenMaker.updateVariables(this.mainFrame.getVarsEditor());
        this.tokenMaker.updateIdentifiers(this.mainFrame.program);
        this.internalUpdate = true;
        try {
            this.textArea.setText(text);
        }
        finally {
            this.internalUpdate = false;
        }
    }

    @Override
    public void clear() {
        this.setEditText(null);
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        this.savedHash = this.textArea.getText().hashCode();
    }

    @Override
    public void initNewProgram() {
        this.setEditText("Main\n  #Put your code here\nEndMain");
        this.mainFrame.getVarsEditor().clearCodeRefs();
        this.resetEditor();
    }

    String listToString(ArrayList<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.setEditText(this.listToString(this.mainFrame.program.codeSource));
        this.updateVarRefs();
        this.resetEditor();
    }

    @Override
    public void updateProgram(JSONObject json) throws ErrorInFile {
        this.mainFrame.program.loadCode(this.textArea.getText().split("\\r?\\n"));
        this.updateVarRefs();
    }

    @Override
    public void saveProps() {
    }

    private void checkModified() {
        if (this.savedHash != this.textArea.getText().hashCode()) {
            this.mainFrame.markModified();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.internalUpdate) {
            this.checkModified();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.internalUpdate) {
            this.checkModified();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void updateCodeVarRefs(CodeBlock cb, VariablesEditor ved) {
        for (Command cmd : cb.Items) {
            for (Argument arg : cmd.Args) {
                VariableDef vd;
                if (arg.Type != 2 || (vd = ved.locateVarDef((Variable)arg.Value)) == null) continue;
                vd.addCodeLineRef(cmd.srcLine, !arg.def.IsReadOnly);
            }
        }
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearCodeRefs();
        Program prg = this.mainFrame.program;
        this.updateCodeVarRefs(prg.MainCode, ved);
        for (CodeBlock sub : prg.Subs.values()) {
            this.updateCodeVarRefs(sub, ved);
        }
    }

    @Override
    public void updateVarList() {
        this.tokenMaker.updateVariables(this.mainFrame.getVarsEditor());
    }
}

