/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.compiler.Program;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;

public class ProgramInfoDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static ProgramInfoDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JLabel lblTarget;
    JLabel lblHint;
    JLabel lblNameError;
    JTextField tfProgId;
    JPanel pnlComment;
    JTextArea txtComment;
    DocumentListener editUpdate = new DocumentListener(){

        public void doUpdate() {
            ProgramInfoDialog.this.validData();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }
    };

    public static boolean showDialog(boolean isNew) {
        if (dialog == null) {
            dialog = new ProgramInfoDialog(MainFrame.instance);
        }
        if (isNew) {
            ProgramInfoDialog.dialog.tfProgId.requestFocusInWindow();
        } else {
            ProgramInfoDialog.dialog.btnOk.requestFocusInWindow();
        }
        ProgramInfoDialog.dialog.okPressed = false;
        Program prog = MainFrame.instance.program;
        dialog.setControls(prog);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (ProgramInfoDialog.dialog.okPressed) {
            return dialog.updateProgram(prog);
        }
        return false;
    }

    public ProgramInfoDialog(JFrame parent) {
        super(parent, "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgramInfoDialog.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.lblHint = new JLabel("<html>\u041f\u0440\u0438\u0434\u0443\u043c\u0430\u0439\u0442\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442, \u0438\u043b\u0438 \u0448\u0438\u0444\u0440, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043f\u043e\u043c\u043e\u0436\u0435\u0442 \u0412\u0430\u043c \u0432 \u0431\u0443\u0434\u0443\u0449\u0435\u043c<br>\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443.<br>\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f - 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.</html>");
        this.lblHint.setOpaque(true);
        this.lblHint.setBackground(SystemColor.info);
        this.lblHint.setForeground(SystemColor.infoText);
        this.lblHint.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.txtComment = new JTextArea();
        this.txtComment.setLineWrap(false);
        this.txtComment.setFont(new JTextField().getFont());
        this.pnlComment = new JPanel(new BorderLayout());
        this.pnlComment.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        JScrollPane scroll = new JScrollPane(this.txtComment);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        this.pnlComment.add((Component)scroll, "Center");
        this.lblNameError = new DialogErrorLabel(" \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
        this.lblNameError.setVisible(false);
        this.tfProgId = new JTextField(10);
        Font f = this.tfProgId.getFont();
        this.tfProgId.setFont(new Font("Monospaced", 1, f.getSize() * 3 / 2));
        ((AbstractDocument)this.tfProgId.getDocument()).setDocumentFilter(new LimitDocumentFilter(8));
        this.tfProgId.getDocument().addDocumentListener(this.editUpdate);
        this.lblTarget = new JLabel("<>");
        this.lblTarget.addMouseListener(MainFrame.instance.modelClick);
        this.lblTarget.setCursor(Cursor.getPredefinedCursor(12));
        pnlContents.add((Component)this.lblTarget, "span, gapbottom 6px, wrap");
        pnlContents.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b:"), "alignx right");
        pnlContents.add((Component)this.tfProgId, "");
        pnlContents.add((Component)this.lblNameError, "span, wrap");
        pnlContents.add((Component)this.lblHint, "span, wrap");
        pnlContents.add((Component)this.pnlComment, "w 500px, growx, h 300px, span");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        this.btnOk = new JButton("\u041e\u041a");
        this.btnOk.addActionListener(ok);
        pane.add((Component)this.btnOk, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(Program prg) {
        this.lblTarget.setText("<html>\u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440: <b>" + prg.device.Name + "</b></html>");
        this.tfProgId.setText(prg.getHumanId());
        this.txtComment.setText(prg.comment.trim());
        this.validData();
    }

    boolean updateProgram(Program prg) {
        String id = this.tfProgId.getText();
        String c = this.txtComment.getText().trim();
        boolean mod = !id.equals(prg.getHumanId()) || !c.equals(prg.comment);
        prg.setHumanId(id);
        prg.comment = c;
        return mod;
    }

    boolean validData() {
        boolean error = false;
        if (this.tfProgId.getText().trim().length() == 0) {
            this.lblNameError.setVisible(true);
            error = true;
        } else {
            this.lblNameError.setVisible(false);
        }
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }

    class LimitDocumentFilter
    extends DocumentFilter {
        private int limit;

        public LimitDocumentFilter(int limit) {
            this.limit = limit;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            int currentLength;
            int overLimit;
            if (this.limit > 0 && (overLimit = (currentLength = fb.getDocument().getLength()) + text.length() - this.limit - length) > 0) {
                text = text.substring(0, Math.max(text.length() - overLimit, 0));
            }
            super.replace(fb, offset, length, text, attrs);
        }
    }
}

