/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.AboutDialog;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.FlashDialog;
import certa.vics.ide.HelpAction;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ProgramInfoDialog;
import certa.vics.ide.modbus.ConnectDialog;
import certa.vics.ide.modbus.ModbusEditor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MainActions
extends ActionsBundle {
    final MainFrame mainFrame;
    public final Action setUi = new SetEditor(this, "\u041e\u043a\u043d\u0430", "editor_ui.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0435\u043d\u044e \u0438 \u043e\u043a\u043e\u043d", 0, null, 5);
    public final Action setCode = new SetEditor(this, "\u041a\u043e\u0434", "editor_code.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u0434\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 0, null, 4);
    public final Action setFbd = new SetEditor(this, "FBD", "editor_fbd.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u044b \u0431\u043b\u043e\u043a\u043e\u0432", 0, null, 3);
    public final Action setModbus = new SetEditor(this, "MODBUS1", "editor_modbus.png", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 MODBUS \u0434\u043b\u044f \u043f\u043e\u0440\u0442\u0430 \u21161", 0, null, 6);
    public final Action setModbus2 = new SetEditor(this, "MODBUS2", "editor_modbus2.png", "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 MODBUS \u0434\u043b\u044f \u043f\u043e\u0440\u0442\u0430 \u21162", 0, null, 7);
    public final Action setSchedule = new SetEditor(this, "\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435", "editor_schedule.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f", 0, null, 1);
    public final Action setArchive = new SetEditor(this, "\u0410\u0440\u0445\u0438\u0432", "editor_archive.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u0440\u0445\u0438\u0432\u0430", 0, null, 2);
    public final NewProg newSpider = new NewProg(this, "Spider", null, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0434\u043b\u044f Spider", 0, null, "spider.devprops");
    public final NewProg newAtom20 = new NewProg(this, "Atom 20", null, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0434\u043b\u044f Atom 20", 0, null, "atom20.devprops");
    public final NewProg newAtom21 = new NewProg(this, "Atom 21", null, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0434\u043b\u044f Atom 21", 0, null, "atom21.devprops");
    public final Action load = new LoadVics(this, "\u041e\u0442\u043a\u0440\u044b\u0442\u044c...", "load.png", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 0, null);
    public final Action save = new SaveVics(this, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save.png", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443", 0, KeyStroke.getKeyStroke(83, 2), false);
    public final Action saveAs = new SaveVics(this, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u0430\u043a...", null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u043f\u043e\u0434 \u043d\u043e\u0432\u044b\u043c \u0438\u043c\u0435\u043d\u0435\u043c", 0, null, true);
    public final Action about = new About(this, "\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", "about.png", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 0, null);
    public final Action modbusHelp = new HelpAction(this, "MODBUS", "help.png", "\u041e\u0431\u043c\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u043f\u043e \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0443 MODBUS", 0, null, "modbus", "MODBUS (\u0441\u043f\u0440\u0430\u0432\u043a\u0430)", null);
    public final Action varsHelp = new HelpAction(this, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435", "help.png", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0438\u0434\u043e\u0432 \u043f\u0430\u043c\u044f\u0442\u0438 \u0438 \u0442\u0438\u043f\u043e\u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445", 0, null, "variables", "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 (\u0441\u043f\u0440\u0430\u0432\u043a\u0430)", null);
    public final Action flashHelp = new HelpAction(this, "\u0417\u0430\u043f\u0438\u0441\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", "help.png", "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440", 0, null, "flash", "\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", null);
    public final Action infoSpider = new HelpAction(this, "\u041a\u043b\u0435\u043c\u043c\u043d\u0438\u043a Spider", "devicehelp.png", "\u041a\u0440\u0430\u0442\u043a\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0435 Spider", 0, null, "descr_spider", "Spider", null);
    public final Action infoAtom20 = new HelpAction(this, "\u041a\u043b\u0435\u043c\u043c\u043d\u0438\u043a Atom 20", "devicehelp.png", "\u041a\u0440\u0430\u0442\u043a\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0435 Atom 20", 0, null, "descr_atom20", "Atom 20", null);
    public final Action infoAtom21 = new HelpAction(this, "\u041a\u043b\u0435\u043c\u043c\u043d\u0438\u043a Atom 21", "devicehelp.png", "\u041a\u0440\u0430\u0442\u043a\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0435 Atom 21", 0, null, "descr_atom21", "Atom 21", null);
    public final Action exit = new Exit(this, "\u0412\u044b\u0445\u043e\u0434", "exit.png", "\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 0, null);
    public final Action flash = new Flash(this, "\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c...", "flash.png", "\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0432 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", 0, null);
    public final Action info = new ProgInfo(this, "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435...", "prog_info.png", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 0, null);
    public final Action zoomIn = new Zoom(this, "\u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c", null, "\u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c \u043c\u0430\u0441\u0448\u0442\u0430\u0431", 0, KeyStroke.getKeyStroke(107, 0), 10);
    public final Action zoomOut = new Zoom(this, "\u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c", null, "\u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u043c\u0430\u0441\u0448\u0442\u0430\u0431", 0, KeyStroke.getKeyStroke(109, 0), -10);
    public final Action zoomReset = new Zoom(this, "100%", null, "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043c\u0430\u0441\u0448\u0442\u0430\u0431", 0, KeyStroke.getKeyStroke(106, 0), 0);
    public final Action exportVics = new Export(this, "\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0432 vics", "export.png", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0432 \u043a\u043e\u0434 ViCS", 0, null);
    public final Action exportV6 = new ExportForV6(this, "\u0434\u043b\u044f ViCS 6.x", "export.png", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443 \u0434\u043b\u044f \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 ViCS 6.x", 0, null);
    public final Action exportModbus1 = new ExportModbus(1, this, "modbus1 \u0432 html", "export_doc.png", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 MODBUS \u21161 \u0432 HTML", 0, null);
    public final Action exportModbus2 = new ExportModbus(2, this, "modbus2 \u0432 html", "export_doc.png", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 MODBUS \u21162 \u0432 HTML", 0, null);
    public final Action exportUi = new ExportUi(this, "\u043c\u0435\u043d\u044e \u0432 png", "export_doc.png", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u043c\u0435\u043d\u044e \u0432 PNG-\u0444\u0430\u0439\u043b", 0, null);
    public final Action connectModbus1 = new ConnectSlave(1, this, "\u041e\u043f\u0440\u043e\u0441 MODBUS 1", "connect-modbus.png", "\u041e\u043f\u0440\u043e\u0441\u0438\u0442\u044c 1-\u0439 \u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430", 0, null);
    public final Action connectModbus2 = new ConnectSlave(2, this, "\u041e\u043f\u0440\u043e\u0441 MODBUS 2", "connect-modbus.png", "\u041e\u043f\u0440\u043e\u0441\u0438\u0442\u044c 2-\u0439 \u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430", 0, null);
    public static final String VICS_FILES_DIR = "ui.vicsFilesDir";
    static final String VICS_EXT = "vics";
    static final String FBD_EXT = "vics-fbd";
    static final FileNameExtensionFilter ALL_FILTER = new FileNameExtensionFilter("All ViCS files (*.vics-fbd, *.vics)", "vics-fbd", "vics");
    static final FileNameExtensionFilter VICS_FILTER = new FileNameExtensionFilter("ViCS code file (*.vics)", "vics");
    static final FileNameExtensionFilter FBD_FILTER = new FileNameExtensionFilter("ViCS FBD file (*.vics-fbd)", "vics-fbd");
    static final String HTML_EXT = "html";
    static final FileNameExtensionFilter HTML_FILTER = new FileNameExtensionFilter("HTML file (*.html)", "html");
    static final String PNG_EXT = "png";
    static final FileNameExtensionFilter PNG_FILTER = new FileNameExtensionFilter("PNG file (*.png)", "png");

    public MainActions(MainFrame mainFrame) {
        super(null);
        this.mainFrame = mainFrame;
    }

    public static File setExtension(File f, String suffix, String newExt) {
        String s = f.getAbsolutePath();
        s = Utils.clearFileExt(s, VICS_EXT);
        s = Utils.clearFileExt(s, FBD_EXT);
        s = Utils.clearFileExt(s, newExt);
        return new File(s + suffix + "." + newExt);
    }

    private void setDefDir(JFileChooser dialog) {
        String s = Main.props.getString(VICS_FILES_DIR, null);
        dialog.setCurrentDirectory(s != null ? new File(s) : new File(Utils.RootDir));
    }

    public class ConnectSlave
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final int portNumber;

        public ConnectSlave(int portNumber, ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.portNumber = portNumber;
        }

        @Override
        protected boolean canExec() {
            ModbusEditor editor = MainActions.this.mainFrame.getModbusEditor(this.portNumber);
            return MainActions.this.mainFrame.program != null && editor.isAvailable() && !editor.isMaster();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConnectDialog.showDialog(MainActions.this.mainFrame.getModbusEditor(this.portNumber));
        }
    }

    public class ExportUi
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;

        public ExportUi(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
            this.dialog.setFileFilter(PNG_FILTER);
            String s = Main.props.getString(MainActions.VICS_FILES_DIR, null);
            this.dialog.setCurrentDirectory(s != null ? new File(s) : new File(Utils.RootDir));
        }

        @Override
        protected boolean canExec() {
            return MainActions.this.mainFrame.program != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = MainActions.this.mainFrame.getCurrentFile();
            try {
                block6: {
                    if (f != null) {
                        this.dialog.setSelectedFile(MainActions.setExtension(f, "_menu", MainActions.PNG_EXT));
                    }
                    while (this.dialog.showSaveDialog(MainActions.this.mainFrame) == 0) {
                        f = MainActions.setExtension(this.dialog.getSelectedFile(), "", MainActions.PNG_EXT);
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + f.getName() + "?", "\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", 1);
                            if (result == 2) {
                                return;
                            }
                            if (result != 0) continue;
                        }
                        break block6;
                    }
                    return;
                }
                MainActions.this.mainFrame.getUiEditor().exportImage(f, MainActions.PNG_EXT);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, false);
                JOptionPane.showMessageDialog(MainActions.this.mainFrame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public class ExportModbus
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;
        final int portNumber;

        public ExportModbus(int portNumber, ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.portNumber = portNumber;
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
            this.dialog.setFileFilter(HTML_FILTER);
            String s = Main.props.getString(MainActions.VICS_FILES_DIR, null);
            this.dialog.setCurrentDirectory(s != null ? new File(s) : new File(Utils.RootDir));
        }

        @Override
        protected boolean canExec() {
            ModbusEditor me = MainActions.this.mainFrame.getModbusEditor(this.portNumber);
            return MainActions.this.mainFrame.program != null && me.isAvailable() && !me.isMaster();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = MainActions.this.mainFrame.getCurrentFile();
            try {
                block6: {
                    if (f != null) {
                        this.dialog.setSelectedFile(MainActions.setExtension(f, "_MODBUS" + this.portNumber, MainActions.HTML_EXT));
                    }
                    while (this.dialog.showSaveDialog(MainActions.this.mainFrame) == 0) {
                        f = MainActions.setExtension(this.dialog.getSelectedFile(), "", MainActions.HTML_EXT);
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + f.getName() + "?", "\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", 1);
                            if (result == 2) {
                                return;
                            }
                            if (result != 0) continue;
                        }
                        break block6;
                    }
                    return;
                }
                MainActions.this.mainFrame.getModbusEditor(this.portNumber).exportText(f);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, false);
                JOptionPane.showMessageDialog(MainActions.this.mainFrame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public class Sample
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        private final String fileName;

        public Sample(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, String fileName) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.fileName = fileName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainActions.this.mainFrame.canClose()) {
                MainActions.this.mainFrame.openSample(this.fileName);
            }
        }
    }

    public class Zoom
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        public final int step;

        public Zoom(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, int step) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.step = step;
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeEditor editor = MainActions.this.mainFrame.getActiveEditor();
            if (editor == null) {
                return;
            }
            if (this.step == 0) {
                editor.setZoom(100);
            } else {
                editor.setZoom(editor.getZoom() + this.step);
            }
        }
    }

    public class ProgInfo
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public ProgInfo(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProgramInfoDialog.showDialog(false)) {
                MainActions.this.mainFrame.markModified();
                MainActions.this.mainFrame.updateProgId();
            }
        }
    }

    public class Flash
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Flash(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            return !MainActions.this.mainFrame.isModified() && MainActions.this.mainFrame.getCurrentFile() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlashDialog.showDialog();
        }
    }

    public class Exit
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Exit(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainActions.this.mainFrame.dispose();
        }
    }

    public class About
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public About(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog dlg = new AboutDialog();
            dlg.setLocationRelativeTo(MainActions.this.mainFrame);
            dlg.setVisible(true);
        }
    }

    public class SaveVics
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;
        final boolean useDialog;

        public SaveVics(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean useDialog) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.useDialog = useDialog;
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
        }

        @Override
        protected boolean canExec() {
            if (MainActions.this.mainFrame.program == null) {
                return false;
            }
            if (!this.useDialog) {
                return MainActions.this.mainFrame.isModified() || MainActions.this.mainFrame.getCurrentFile() == null;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainActions.this.setDefDir(this.dialog);
            File f = MainActions.this.mainFrame.getCurrentFile();
            try {
                int result;
                if (f == null || this.useDialog) {
                    block8: {
                        this.dialog.setSelectedFile(f);
                        if (f == null) {
                            MainActions.this.setDefDir(this.dialog);
                            this.dialog.setSelectedFile(new File(""));
                            this.dialog.setSelectedFile(null);
                        }
                        this.dialog.resetChoosableFileFilters();
                        this.dialog.setFileFilter(MainActions.this.mainFrame.isFbdMode() ? FBD_FILTER : VICS_FILTER);
                        while (this.dialog.showSaveDialog(MainActions.this.mainFrame) == 0) {
                            f = MainActions.setExtension(this.dialog.getSelectedFile(), "", MainActions.this.mainFrame.isFbdMode() ? MainActions.FBD_EXT : MainActions.VICS_EXT);
                            if (f.exists()) {
                                result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + f.getName() + "?", "\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", 1);
                                if (result == 2) {
                                    return;
                                }
                                if (result != 0) continue;
                            }
                            break block8;
                        }
                        return;
                    }
                    Main.props.saveString(MainActions.VICS_FILES_DIR, this.dialog.getCurrentDirectory().getAbsolutePath());
                }
                if (MainActions.this.mainFrame.program.fileVersion < 202 && (result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u0424\u0430\u0439\u043b '" + f.getName() + "'\n\u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u0432 \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 ViCS.\n\n\u0415\u0441\u043b\u0438 \u0432\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0435\u0433\u043e, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u0434\u0430\u043d\u043d\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430, \u0442\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \n\u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0435\u0433\u043e \u0432 \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0438 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0441\u043e \u0441\u0442\u0430\u0440\u043e\u0439 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u043e\u0439. \n\n\u0412\u044b \u043d\u0430\u0441\u0442\u0430\u0438\u0432\u0430\u0435\u0442\u0435 \u043d\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438? \n(\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441\u0442\u0430\u043d\u0435\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0439 \u0441\u043e \u0441\u0442\u0430\u0440\u043e\u0439 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u043e\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430)", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435!", 0)) != 0) {
                    return;
                }
                MainActions.this.mainFrame.saveVics(f, false, false);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, this.getClass().getName(), false);
                JOptionPane.showMessageDialog(MainActions.this.mainFrame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public class LoadVics
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;

        public LoadVics(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
            this.dialog.setFileFilter(ALL_FILTER);
            this.dialog.addChoosableFileFilter(FBD_FILTER);
            this.dialog.addChoosableFileFilter(VICS_FILTER);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MainActions.this.mainFrame.canClose()) {
                return;
            }
            MainActions.this.setDefDir(this.dialog);
            if (this.dialog.showOpenDialog(MainActions.this.mainFrame) == 0) {
                MainActions.this.mainFrame.loadVics(this.dialog.getSelectedFile());
                Main.props.saveString(MainActions.VICS_FILES_DIR, this.dialog.getCurrentDirectory().getAbsolutePath());
            }
        }
    }

    public class NewProg
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        public final String deviceFile;

        public NewProg(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, String devFile) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.deviceFile = devFile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainActions.this.mainFrame.canClose()) {
                MainActions.this.mainFrame.createNewProgram(this.deviceFile);
            }
        }
    }

    public class ExportForV6
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;

        public ExportForV6(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
            this.dialog.setFileFilter(FBD_FILTER);
        }

        @Override
        protected boolean canExec() {
            return MainActions.this.mainFrame.program != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainActions.this.setDefDir(this.dialog);
            File f = MainActions.this.mainFrame.getCurrentFile();
            try {
                block6: {
                    if (f != null) {
                        this.dialog.setSelectedFile(MainActions.setExtension(f, "_vics6", MainActions.FBD_EXT));
                    }
                    while (this.dialog.showSaveDialog(MainActions.this.mainFrame) == 0) {
                        f = MainActions.setExtension(this.dialog.getSelectedFile(), "", MainActions.FBD_EXT);
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + f.getName() + "?", "\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", 1);
                            if (result == 2) {
                                return;
                            }
                            if (result != 0) continue;
                        }
                        break block6;
                    }
                    return;
                }
                MainActions.this.mainFrame.saveVics(f, false, true);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, false);
                JOptionPane.showMessageDialog(MainActions.this.mainFrame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public class Export
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final JFileChooser dialog;

        public Export(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dialog = new JFileChooser();
            this.dialog.setAcceptAllFileFilterUsed(false);
            this.dialog.setFileFilter(VICS_FILTER);
        }

        @Override
        protected boolean canExec() {
            return MainActions.this.mainFrame.program != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainActions.this.setDefDir(this.dialog);
            File f = MainActions.this.mainFrame.getCurrentFile();
            try {
                block6: {
                    if (f != null) {
                        this.dialog.setSelectedFile(MainActions.setExtension(f, "", MainActions.VICS_EXT));
                    }
                    while (this.dialog.showSaveDialog(MainActions.this.mainFrame) == 0) {
                        f = MainActions.setExtension(this.dialog.getSelectedFile(), "", MainActions.VICS_EXT);
                        if (f.exists()) {
                            int result = JOptionPane.showConfirmDialog(MainActions.this.mainFrame, "\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + f.getName() + "?", "\u0424\u0430\u0439\u043b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", 1);
                            if (result == 2) {
                                return;
                            }
                            if (result != 0) continue;
                        }
                        break block6;
                    }
                    return;
                }
                MainActions.this.mainFrame.saveVics(f, true, false);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, false);
                JOptionPane.showMessageDialog(MainActions.this.mainFrame, ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Error", 0);
            }
        }
    }

    public class SetEditor
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final int index;
        final ArrayList<AbstractButton> buttons;

        public SetEditor(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, int index) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.buttons = new ArrayList();
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainActions.this.mainFrame.setEditor(this.index);
        }

        @Override
        public final void update() {
            MainActions.this.mainFrame.updateTitle();
            this.putValue("SwingSelectedKey", MainActions.this.mainFrame.getActiveEditorIndex() == this.index);
            for (AbstractButton b : this.buttons) {
                b.setVisible(MainActions.this.mainFrame.editors.get(this.index).isAvailable());
            }
            this.setEnabled(this.bundle.available);
        }

        public void addButton(AbstractButton btn) {
            this.buttons.add(btn);
        }
    }
}

