/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.MainFrame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.json.JSONObject;

public final class ClipboardUtils {
    static final String VICS_MAGIC = "ViCS";
    static final String MAGIC = "ViCS202";
    public static final char TYPE_FBD = 'b';
    public static final char TYPE_WINDOWS = 'w';
    public static final char TYPE_VARS = 'v';

    private ClipboardUtils() {
    }

    public static void putData(JSONObject data, char dataType) {
        String s = MAGIC + dataType + data.toString();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new VicsTransferable(s), null);
    }

    public static JSONObject getData(char dataType) {
        String s = null;
        try {
            Transferable tr = MainFrame.clipboard.getContents(null);
            if (tr.isDataFlavorSupported(VicsTransferable.dataFlavor)) {
                s = (String)tr.getTransferData(VicsTransferable.dataFlavor);
            }
            int offset = VICS_MAGIC.length();
            if (!Utils.strEmpty(s) && s.startsWith(VICS_MAGIC)) {
                while (s.charAt(offset) >= '0' && s.charAt(offset) <= '9') {
                    ++offset;
                }
                if (s.charAt(offset) == dataType) {
                    return new JSONObject(s.substring(offset + 1));
                }
            }
        }
        catch (Throwable t) {
            Utils.ProcessException(t, false);
        }
        return null;
    }

    public static class VicsTransferable
    implements Transferable {
        public static final DataFlavor dataFlavor = DataFlavor.stringFlavor;
        private final DataFlavor[] flavors = new DataFlavor[]{dataFlavor};
        private String data = "";

        public VicsTransferable(String data) {
            this.data = data;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor != null) {
                return flavor.equals(this.flavors[0]);
            }
            return false;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.flavors.clone();
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.flavors[0])) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

