/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.Archive;
import certa.vics.compiler.Argument;
import certa.vics.compiler.ArgumentDef;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.Device;
import certa.vics.compiler.DevpropsError;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.ScheduleBlock;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Program {
    public static final int CURRENT_FILE_VERSION = 202;
    public static final String ZIP_ENTRY_NAME = "program";
    public static final int CURRENT_COMPILER_VERSION = 3;
    public static final String[] KEYS = new String[]{"UPDOWN", "LEFTRIGHT", "DOWNLEFT", "UPRIGHT"};
    public final VariablesBlock Constants = new VariablesBlock("Const", "ROM", true);
    public final VariablesBlock RamVars = new VariablesBlock("Ram", "RAM", false);
    public final VariablesBlock ExtVars = new VariablesBlock("Ext", "NVRAM", false);
    public final VariablesBlock StoreVars = new VariablesBlock("Store", "EEPROM", false);
    VariablesBlock[] AllVars;
    VariablesBlock[] SysVars;
    VariablesBlock[] UserVars;
    public final CodeBlock MainCode = new CodeBlock("Main");
    public final LinkedHashMap<String, CodeBlock> Subs = new LinkedHashMap();
    public final LinkedHashMap<String, StringList> Strings = new LinkedHashMap();
    public final LinkedHashMap<String, Window> Windows = new LinkedHashMap();
    public Window firstWindow = null;
    public final Window[] keyWindows = new Window[4];
    public final ModbusBlock Modbus1 = new ModbusBlock();
    public final ModbusBlock Modbus2 = new ModbusBlock();
    public final ScheduleBlock Schedules = new ScheduleBlock();
    public final Archive archive = new Archive();
    public final ArrayList<String> codeSource = new ArrayList();
    public final ArrayList<String> lastComments = new ArrayList();
    public String extraData;
    private String id = "";
    public int codeCrc = 0;
    public String comment = "";
    public int fileVersion;
    public Device device;
    protected String SourceFile;
    ParseState State;
    public byte[] flash;
    public byte[] store;
    public byte[] ext;
    public static final String DUMB_VAR_NAME = "___DUMB";
    static final char[] NAME_CHARS = new char[]{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '_', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '_', '_', '_', '_', '\u0411', '\u0413', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041b', '\u041f', '\u0423', '\u0424', '\u0427', '\u0428', '\u042a', '\u042b', '\u042d', '\u042e', '\u042f', '\u0431', '\u0432', '\u0433', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043f', '\u0442', '\u0447', '\u0448', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\"', '\"', '\"', '\"', '\u2116', '_', 'f', 'L', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '\u0414', '\u0426', '\u0429', '\u0434', '\u0444', '\u0446', '\u0449', '\'', '_', '~', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'};
    private static final String tableSrc1 = "\u0456\u0406\u0457\u0407\u0454\u0404";
    private static final String tableDst1 = "iIiI\u0435\u0415";
    private static final String tableSrc2 = "\u0410\u0430\u0412\u0415\u0435\u041a\u041c\u041d\u041e\u043e\u0420\u0440\u0421\u0441\u0422\u0425\u0445\u0443\u042c";
    private static final String tableDst2 = "AaBEeKMHOoPpCcTXxyb";
    boolean saveRaw;
    int lineNum;
    public static final String UTF8_BOM = "\ufeff";
    private String[] tokens;
    private int tokenIndex;
    private StringBuilder sbExtraData = new StringBuilder();
    private VariablesBlock varBlock;
    private Variable varCurrent;
    private boolean varInitOnly;
    private int arrayValueIndex;
    private ModbusBlock modbus;
    private int mbRegType;
    private int mbRegAddr;
    private String tmpVar;
    private String arcString1;
    private CodeBlock codeBlock;
    private CommandDef retCommand;
    private Command codeItem;
    private int codeArgIndex;
    private int codeArgListSize;
    private int codeArgListIndex;
    private StringList stringList;
    private Window window;
    private String windowParam;
    private int keyWindowIndex;
    private Schedule schedule;
    private String scheduleParam;
    private int mbMasterReqType;
    private int mbMasterReqId;
    private int mbMasterReqAddr;
    private int windowsFlashAddress;
    private int constantsFlashAddress;
    private int ramInitFlashAddress;
    private int archiveFlashAddress;
    private int modbus1FlashAddress;
    private int modbus2FlashAddress;

    public Program() {
        this.clear(false);
    }

    public Program(Device dev) {
        this.clear(false);
        this.assignDevice(dev);
        this.fileVersion = 202;
    }

    public static String regsToHumanId(int r1, int r2, int r3, int r4) {
        int i;
        String s = "" + NAME_CHARS[r1 & 0xFF] + NAME_CHARS[r1 >>> 8 & 0xFF] + NAME_CHARS[r2 & 0xFF] + NAME_CHARS[r2 >>> 8 & 0xFF] + NAME_CHARS[r3 & 0xFF] + NAME_CHARS[r3 >>> 8 & 0xFF] + NAME_CHARS[r4 & 0xFF] + NAME_CHARS[r4 >>> 8 & 0xFF];
        for (i = s.length() - 1; i > 0 && s.charAt(i) <= ' '; --i) {
        }
        return s.substring(0, i + 1);
    }

    public String getHumanId() {
        StringBuilder sb = new StringBuilder("        ");
        if (Utils.strEmpty(this.id) || this.id.trim().length() == 0) {
            return "";
        }
        int i = 0;
        int bi = 0;
        while (i < this.id.length() && bi < sb.length()) {
            char c = this.id.charAt(i);
            if (c == '#' && this.id.length() > i + 2) {
                try {
                    sb.setCharAt(bi, NAME_CHARS[Integer.parseInt(this.id.substring(i + 1, i + 3), 16)]);
                    i += 3;
                    ++bi;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.setCharAt(bi, c);
            ++i;
            ++bi;
        }
        i = sb.length();
        while (--i >= 0 && sb.charAt(i) <= ' ') {
            sb.setLength(i);
        }
        return sb.toString();
    }

    private int charCode(char c) {
        int i = tableSrc1.indexOf(c);
        if (i >= 0) {
            c = tableDst1.charAt(i);
        }
        if ((i = tableSrc2.indexOf(c)) >= 0) {
            c = tableDst2.charAt(i);
        }
        for (i = 0; i < NAME_CHARS.length; ++i) {
            if (NAME_CHARS[i] != c) continue;
            return i;
        }
        return 95;
    }

    public void setHumanId(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(id.length(), 8); ++i) {
            int c = this.charCode(id.charAt(i));
            sb.append('#');
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        this.id = sb.toString();
    }

    public String getEncodedId() {
        return Utils.strEmpty(this.id) ? "_" : this.id;
    }

    public boolean hasDisplay() {
        return this.device.HasDisplay;
    }

    public boolean hasSchedule() {
        return this.device.HasSchedule;
    }

    public boolean hasArchive() {
        return this.device.HasArchive;
    }

    public void clear(boolean preserveDevice) {
        if (!preserveDevice) {
            this.device = null;
            this.AllVars = null;
            this.SysVars = null;
            this.UserVars = null;
        }
        this.clearVars();
        this.Strings.clear();
        this.Windows.clear();
        this.Schedules.clear();
        this.archive.clear();
        this.firstWindow = null;
        Arrays.fill(this.keyWindows, null);
        this.clearCode();
        this.extraData = "";
    }

    public void clearVars() {
        this.RamVars.clear();
        this.ExtVars.clear();
        this.Constants.clear();
        this.StoreVars.clear();
        try {
            Variable dumb = this.RamVars.createSimpleVar(DUMB_VAR_NAME, 2, true, -1);
            this.Modbus1.clear(dumb);
            this.Modbus2.clear(dumb);
        }
        catch (SyntaxError e) {
            throw new Error(e);
        }
    }

    protected void clearCode() {
        this.codeSource.clear();
        this.lastComments.clear();
        this.saveRaw = false;
        this.MainCode.clear();
        this.Subs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String fileName, boolean resolve) throws IOException, ErrorInFile, DevpropsError {
        Path path = Paths.get(fileName, new String[0]).toRealPath(new LinkOption[0]);
        Charset charset = Charset.forName("UTF-8");
        BufferedReader reader = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(path.toFile());
        }
        catch (ZipException e) {
            reader = Files.newBufferedReader(path, charset);
        }
        if (zip != null) {
            ZipEntry ze = zip.getEntry(ZIP_ENTRY_NAME);
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(ze), charset));
        }
        try {
            this.load(reader, resolve, path.toString());
        }
        finally {
            reader.close();
            if (zip != null) {
                zip.close();
            }
        }
    }

    public void load(BufferedReader reader, boolean resolve, String file) throws IOException, ErrorInFile, DevpropsError {
        this.SourceFile = file;
        this.lineNum = 1;
        this.State = ParseState.PARSE_START;
        this.fileVersion = 0;
        try {
            this.clear(false);
            this.sbExtraData.setLength(0);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(UTF8_BOM)) {
                    line = line.substring(1);
                }
                this.parseLine(line, false);
                ++this.lineNum;
            }
            if (this.State != ParseState.PARSE_END) {
                throw new SyntaxError("Unexpected end of file (End is required)");
            }
            this.extraData = this.sbExtraData.toString().trim();
            this.lineNum = 0;
            if (resolve) {
                if (!Utils.strEmpty(this.extraData)) {
                    throw new SyntaxError("This is not ViCS file");
                }
                this.resolveLinks();
            }
        }
        catch (MalformedInputException e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, "Invalid file charset (must be UTF-8)");
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, e.line > 0 ? e.line : this.lineNum, e);
        }
        catch (DevpropsError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
        }
        this.checkAllCode();
        this.trimSource();
    }

    public void resolveLinks() throws SyntaxError {
        if (this.hasDisplay()) {
            for (Window w : this.Windows.values()) {
                w.resolveLinks();
            }
        }
        this.Modbus1.resolveLinks(this);
        if (this.device.SecondRS485) {
            this.Modbus2.resolveLinks(this);
        }
        if (this.hasSchedule()) {
            this.Schedules.resolveLinks(this);
        }
        if (this.hasArchive()) {
            this.archive.resolve(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCode(String[] lines) throws ErrorInFile {
        String t = this.SourceFile;
        this.SourceFile = "Code";
        try {
            this.lineNum = 1;
            this.State = ParseState.BLOCK_BEGIN;
            try {
                this.clearCode();
                for (String s : lines) {
                    this.parseLine(s, true);
                    ++this.lineNum;
                }
            }
            catch (SyntaxError e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e);
            }
            catch (Exception e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
            }
            this.checkAllCode();
            this.trimSource();
        }
        finally {
            this.SourceFile = t;
        }
    }

    protected void parseLine(String line, boolean onlyCode) throws FileNotFoundException, SyntaxError, IOException, ErrorInFile, DevpropsError {
        if (this.State == ParseState.PARSE_END) {
            this.sbExtraData.append(line);
            this.sbExtraData.append('\n');
            return;
        }
        String rawLine = line;
        if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) {
            this.lastComments.add(rawLine);
        } else {
            this.tokens = line.split("\\s+");
            this.tokenIndex = 0;
            while (this.tokenIndex < this.tokens.length && this.State != ParseState.PARSE_END) {
                this.State = this.parseToken(this.tokens[this.tokenIndex], onlyCode, this.tokenIndex == this.tokens.length - 1);
                ++this.tokenIndex;
            }
            if (this.State == ParseState.WND_PARAM_VAL) {
                this.State = this.parseWindowParamValue("");
            }
            if (this.saveRaw) {
                this.codeSource.addAll(this.lastComments);
                this.codeSource.add(rawLine);
            }
            this.lastComments.clear();
        }
    }

    private void checkAllCode() throws ErrorInFile {
        this.checkCode(this.MainCode);
        for (CodeBlock sub : this.Subs.values()) {
            this.checkCode(sub);
        }
    }

    private void checkCode(CodeBlock cb) throws ErrorInFile {
        int line = 0;
        try {
            for (Command ci : cb.Items) {
                line = ci.srcLine;
                for (Argument arg : ci.Args) {
                    if (arg.Type == 3) {
                        this.resolveLabel((String)arg.Value, cb);
                        continue;
                    }
                    if (arg.Type != 4) continue;
                    this.resolveSub((String)arg.Value);
                }
            }
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, line, e);
        }
    }

    protected void trimSource() {
        while (this.codeSource.size() > 0 && this.codeSource.get(0).trim().length() == 0) {
            this.codeSource.remove(0);
        }
    }

    public String getSourceFile() {
        return this.SourceFile;
    }

    private void processVersion(String s) throws SyntaxError {
        try {
            this.fileVersion = Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("Invalid file version: " + s);
        }
        if (this.fileVersion > 202) {
            throw new OldEditorError();
        }
    }

    private void assignDevice(Device dev) {
        this.device = dev;
        this.AllVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars, this.Constants, this.RamVars, this.ExtVars, this.StoreVars};
        this.SysVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars};
        this.UserVars = new VariablesBlock[]{this.Constants, this.RamVars, this.ExtVars, this.StoreVars};
    }

    private VariablesBlock locateBlock(VariablesBlock[] blocks, String name) {
        if (blocks != null) {
            for (VariablesBlock b : blocks) {
                if (!b.name.equalsIgnoreCase(name)) continue;
                return b;
            }
        }
        return null;
    }

    public VariablesBlock locateSysBlock(String name) {
        return this.locateBlock(this.SysVars, name);
    }

    public VariablesBlock locateUserBlock(String name) {
        return this.locateBlock(this.UserVars, name);
    }

    private ParseState parseToken(String token, boolean onlyCode, boolean endOfLine) throws SyntaxError, FileNotFoundException, IOException, ErrorInFile, DevpropsError {
        if (this.State == ParseState.PARSE_START) {
            if (token.equalsIgnoreCase("FileVersion")) {
                return ParseState.FILE_VERSION;
            }
            if (token.equalsIgnoreCase("ID")) {
                return ParseState.PROG_ID;
            }
            if (token.equalsIgnoreCase("CodeCRC")) {
                return ParseState.CODE_CRC;
            }
            this.require(token, "Target");
            return ParseState.TARGET;
        }
        if (this.State == ParseState.FILE_VERSION) {
            this.processVersion(token);
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.PROG_ID) {
            this.id = token;
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.CODE_CRC) {
            this.codeCrc = Program.decodeInt(token, "Invalid number");
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.TARGET) {
            this.assignDevice(new Device(token));
            return ParseState.BLOCK_BEGIN;
        }
        if (this.State == ParseState.BLOCK_BEGIN) {
            this.saveRaw = false;
            if (token.equalsIgnoreCase(this.MainCode.Name)) {
                return this.openCodeBlock(this.MainCode, this.device.CommandMap.get("END"));
            }
            if (token.equalsIgnoreCase("Sub")) {
                this.saveRaw = true;
                return ParseState.SUB;
            }
            if (onlyCode) {
                throw new SyntaxError("Unknown block: \"" + token + "\" (expected Main, Sub)");
            }
            if (token.equalsIgnoreCase("Const")) {
                return this.openVarDomain(this.Constants, false);
            }
            if (token.equalsIgnoreCase("Ram")) {
                return this.openVarDomain(this.RamVars, false);
            }
            if (token.equalsIgnoreCase("Ext")) {
                return this.openVarDomain(this.ExtVars, false);
            }
            if (token.equalsIgnoreCase("Store")) {
                return this.openVarDomain(this.StoreVars, false);
            }
            if (token.equalsIgnoreCase("SysOut")) {
                return this.openVarDomain(this.device.SysOutVars, true);
            }
            if (token.equalsIgnoreCase("SysStore")) {
                return this.openVarDomain(this.device.SysStoreVars, true);
            }
            if (token.equalsIgnoreCase("SysExt")) {
                return this.openVarDomain(this.device.SysExtVars, true);
            }
            if (token.equalsIgnoreCase("Modbus")) {
                this.modbus = this.Modbus1;
                return ParseState.MODBUS_MODE;
            }
            if (token.equalsIgnoreCase("Modbus2")) {
                this.modbus = this.Modbus2;
                return ParseState.MODBUS_MODE;
            }
            if (token.equalsIgnoreCase("Strings")) {
                return ParseState.STRINGS;
            }
            if (token.equalsIgnoreCase("Window")) {
                return ParseState.WINDOW;
            }
            if (token.equalsIgnoreCase("Schedule")) {
                return ParseState.SCHEDULE;
            }
            if (token.equalsIgnoreCase("Archive")) {
                return ParseState.ARCHIVE_VAR;
            }
            if (token.equalsIgnoreCase("Keys")) {
                return ParseState.KEY;
            }
            if (token.equalsIgnoreCase("End")) {
                return ParseState.PARSE_END;
            }
            throw new SyntaxError("Unknown block: \"" + token + "\"");
        }
        if (this.State == ParseState.VAR_NAME) {
            return this.parseVarName(token);
        }
        if (this.State == ParseState.VAR_VALUE) {
            return this.parseVarValue(token);
        }
        if (this.State == ParseState.MODBUS_MODE) {
            return this.parseModbusMode(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_REG) {
            return this.parseMbSlaveReg(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_VAR) {
            return this.parseMbSlaveVar(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_K) {
            if (token.equals("$")) {
                return ParseState.MODBUS_SLAVE_K_VALUE;
            }
            this.modbus.slave().allocUnresolved(this.mbRegType, this.mbRegAddr, this.tmpVar, 0);
            return this.parseMbSlaveReg(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_K_VALUE) {
            return this.parseMbSlaveKValue(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_TIMEOUT) {
            return this.parseMbMasterTimeout(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_PAUSE) {
            return this.parseMbMasterPause(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQUEST) {
            return this.parseMbMasterReqStart(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_TYPE) {
            return this.parseMbMasterReqType(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_ID) {
            return this.parseMbMasterReqId(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_ADDR) {
            return this.parseMbMasterReqAddr(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_CMDVAR) {
            return this.parseMbMasterReqCmdVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_STATUSVAR) {
            return this.parseMbMasterReqStatusVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REGISTER) {
            return this.parseMbMasterRegVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REG_K) {
            if (token.equals("$")) {
                return ParseState.MODBUS_MASTER_REG_K_VALUE;
            }
            this.modbus.master().allocUnresolvedVar(this.tmpVar, 0);
            return this.parseMbMasterRegVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REG_K_VALUE) {
            return this.parseMbMasterKValue(token);
        }
        if (this.State == ParseState.CMD) {
            return this.parseCommand(token);
        }
        if (this.State == ParseState.CMD_ARG) {
            return this.parseCommandArg(token);
        }
        if (this.State == ParseState.SUB) {
            return this.parseSub(token);
        }
        if (this.State == ParseState.STRINGS) {
            return this.parseStrings(token);
        }
        if (this.State == ParseState.STRING_NUM) {
            return this.parseStringNum(token);
        }
        if (this.State == ParseState.STRING_TEXT) {
            return this.parseStringText(token);
        }
        if (this.State == ParseState.WINDOW) {
            return this.parseWindow(token);
        }
        if (this.State == ParseState.WND_PARAM_NAME) {
            return this.parseWindowParamName(token);
        }
        if (this.State == ParseState.WND_PARAM_VAL) {
            return this.parseWindowParamValue(token);
        }
        if (this.State == ParseState.SCHEDULE) {
            return this.parseSchedule(token);
        }
        if (this.State == ParseState.ARCHIVE_VAR) {
            return this.parseArchiveVar(token, endOfLine);
        }
        if (this.State == ParseState.ARCHIVE_STRING1) {
            return this.parseArchiveString1(token, endOfLine);
        }
        if (this.State == ParseState.ARCHIVE_STRING2) {
            return this.parseArchiveString2(token);
        }
        if (this.State == ParseState.SCHED_PARAM_NAME) {
            return this.parseScheduleParamName(token);
        }
        if (this.State == ParseState.SCHED_PARAM_VALUE) {
            return this.parseScheduleParamValue(token);
        }
        if (this.State == ParseState.KEY) {
            return this.parseKey(token);
        }
        if (this.State == ParseState.KEY_WINDOW) {
            return this.parseKeyWindow(token);
        }
        if (this.State == ParseState.PARSE_END) {
            throw new SyntaxError("Symbols after End not allowed: \"" + token + "\"");
        }
        throw new SyntaxError("Parser Error");
    }

    private ParseState openVarDomain(VariablesBlock d, boolean initOnly) {
        this.varBlock = d;
        this.varCurrent = null;
        this.varInitOnly = initOnly;
        return ParseState.VAR_NAME;
    }

    private ParseState openCodeBlock(CodeBlock b, CommandDef ret) throws SyntaxError {
        this.codeBlock = b;
        if (this.codeBlock.Items.size() > 0) {
            throw new SyntaxError("Duplicate code block: " + b.Name);
        }
        this.retCommand = ret;
        this.saveRaw = true;
        return ParseState.CMD;
    }

    private ParseState parseVarName(String token) throws SyntaxError {
        String varName;
        int varType;
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        if (token.equals("=")) {
            this.arrayValueIndex = 0;
            return ParseState.VAR_VALUE;
        }
        if (token.equals("#")) {
            return this.parseVarComment();
        }
        try {
            varType = Variable.stringToType(token.substring(0, 1));
            if (varType == 0) {
                throw new SyntaxError("Invalid variable type: \"" + token + "\" (expected b, i, f)");
            }
            varName = token.substring(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SyntaxError("Invalid variable name: \"" + token + "\"");
        }
        if (this.varInitOnly) {
            this.varCurrent = this.varBlock.locateVar(varName, varType);
        } else {
            int p0 = varName.indexOf(123);
            int p1 = varName.indexOf(125);
            if (p0 > 0 && p1 > p0 + 1) {
                String s = varName.substring(p0 + 1, p1);
                int size = Program.decodeInt(s, "Invalid array size");
                this.varCurrent = this.varBlock.createArrayVar(varName.substring(0, p0), varType, size, this.Constants);
            } else {
                this.varCurrent = this.varBlock.createSimpleVar(varName, varType, false, -1);
            }
        }
        if (this.varCurrent == null) {
            throw new SyntaxError("Unknown variable: \"" + token + "\"");
        }
        return ParseState.VAR_NAME;
    }

    private ParseState parseVarComment() throws SyntaxError {
        String c = "";
        if (++this.tokenIndex < this.tokens.length) {
            c = this.tokens[this.tokenIndex++];
        }
        while (this.tokenIndex < this.tokens.length) {
            c = c + " " + this.tokens[this.tokenIndex++];
        }
        if (Utils.strEmpty(this.varCurrent.comment)) {
            this.varCurrent.comment = c;
        }
        return ParseState.VAR_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParseState parseVarValue(String token) throws SyntaxError {
        double v;
        if (this.varCurrent.type == 1) {
            if (token.equals("1")) {
                v = 1.0;
            } else {
                if (!token.equals("0")) throw new SyntaxError("Invalid bool value: \"" + token + "\" (expected 0, 1)");
                v = 0.0;
            }
        } else if (this.varCurrent.type == 2) {
            v = Program.decodeInt(token, "Invalid int value");
        } else {
            if (this.varCurrent.type != 3) throw new SyntaxError("Internal error");
            try {
                v = Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid float value: \"" + token + "\"");
            }
        }
        if (this.varCurrent.arrayItems != null) {
            this.varCurrent.arrayItems[this.arrayValueIndex].initValue = v;
            if (++this.arrayValueIndex < this.varCurrent.arrayItems.length) return ParseState.VAR_VALUE;
            return ParseState.VAR_NAME;
        }
        this.varCurrent.initValue = v;
        return ParseState.VAR_NAME;
    }

    private ParseState parseModbusMode(String token) throws SyntaxError {
        this.modbus.init(token.equalsIgnoreCase("MASTER"));
        if (this.modbus.isMaster()) {
            return ParseState.MODBUS_MASTER_TIMEOUT;
        }
        return this.parseMbSlaveReg(token);
    }

    private ParseState parseMbMasterTimeout(String token) throws SyntaxError {
        this.modbus.master().timeout = Program.decodeInt(token, "Invalid int value");
        return ParseState.MODBUS_MASTER_PAUSE;
    }

    private ParseState parseMbMasterPause(String token) throws SyntaxError {
        this.modbus.master().pause = Program.decodeInt(token, "Invalid int value");
        return ParseState.MODBUS_MASTER_REQUEST;
    }

    private ParseState parseMbMasterReqStart(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("REQUEST")) {
            return ParseState.MODBUS_MASTER_REQ_TYPE;
        }
        if (token.equalsIgnoreCase("ENDMODBUS")) {
            return ParseState.BLOCK_BEGIN;
        }
        throw new SyntaxError("Invalid MODBUS Master request: " + token);
    }

    private ParseState parseMbMasterReqType(String token) throws SyntaxError {
        this.mbMasterReqType = Program.decodeIntRange(token, "Invalid MODBUS function", 1, 16);
        return ParseState.MODBUS_MASTER_REQ_ID;
    }

    private ParseState parseMbMasterReqId(String token) throws SyntaxError {
        this.mbMasterReqId = Program.decodeIntRange(token, "Invalid MODBUS ID", 0, 255);
        return ParseState.MODBUS_MASTER_REQ_ADDR;
    }

    private ParseState parseMbMasterReqAddr(String token) throws SyntaxError {
        this.mbMasterReqAddr = Program.decodeIntRange(token, "Invalid MODBUS register address", 0, 65535);
        return ParseState.MODBUS_MASTER_REQ_CMDVAR;
    }

    private ParseState parseMbMasterReqCmdVar(String token) {
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_MASTER_REQ_STATUSVAR;
    }

    private ParseState parseMbMasterReqStatusVar(String token) {
        String sv = token.equals("0") ? null : token;
        this.modbus.master().allocUnresolvedRequest(this.mbMasterReqType, this.mbMasterReqId, this.mbMasterReqAddr, this.tmpVar, sv);
        return ParseState.MODBUS_MASTER_REGISTER;
    }

    private ParseState parseMbMasterRegVar(String token) {
        if (token.equalsIgnoreCase("REQUEST")) {
            return ParseState.MODBUS_MASTER_REQ_TYPE;
        }
        if (token.equalsIgnoreCase("ENDMODBUS")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_MASTER_REG_K;
    }

    private ParseState parseMbMasterKValue(String token) throws SyntaxError {
        int digits = Program.decodeIntRange(token, "Invalid MODBUS register K", 0, 3);
        this.modbus.master().allocUnresolvedVar(this.tmpVar, digits);
        return ParseState.MODBUS_MASTER_REGISTER;
    }

    private ParseState parseMbSlaveReg(String token) throws SyntaxError {
        block7: {
            try {
                String t = token.toUpperCase();
                if (t.startsWith("INPUT")) {
                    this.mbRegType = 1;
                    this.mbRegAddr = Integer.decode(token.substring(5));
                    break block7;
                }
                if (t.startsWith("COIL")) {
                    this.mbRegType = 2;
                    this.mbRegAddr = Integer.decode(token.substring(4));
                    break block7;
                }
                if (t.startsWith("IR")) {
                    this.mbRegType = 3;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("HR")) {
                    this.mbRegType = 4;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("END")) {
                    return ParseState.BLOCK_BEGIN;
                }
                throw new SyntaxError("Invalid MODBUS register: " + token);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid MODBUS register address: " + token);
            }
        }
        return ParseState.MODBUS_SLAVE_VAR;
    }

    private ParseState parseMbSlaveVar(String token) throws SyntaxError {
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_SLAVE_K;
    }

    private ParseState parseMbSlaveKValue(String token) throws SyntaxError {
        int digits = Program.decodeIntRange(token, "Invalid MODBUS register K", 0, 3);
        this.modbus.slave().allocUnresolved(this.mbRegType, this.mbRegAddr, this.tmpVar, digits);
        return ParseState.MODBUS_SLAVE_REG;
    }

    private ParseState parseArchiveVar(String token, boolean endOfLine) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        String string = this.tmpVar = token.equals("0") ? null : token;
        if (this.tmpVar != null) {
            if (endOfLine) {
                throw new SyntaxError("Archive string #1 is missing");
            }
            return ParseState.ARCHIVE_STRING1;
        }
        this.archive.add(null, this.newArchiveString(null), this.newArchiveString(null));
        return ParseState.ARCHIVE_VAR;
    }

    private ParseState parseArchiveString1(String token, boolean endOfLine) throws SyntaxError {
        this.arcString1 = token;
        if (endOfLine) {
            throw new SyntaxError("Archive string #2 is missing");
        }
        return ParseState.ARCHIVE_STRING2;
    }

    public WindowString newArchiveString(String src) {
        return new WindowString(src, this.device.FONT, this.device.DISPLAY_COLS);
    }

    private ParseState parseArchiveString2(String token) throws SyntaxError {
        if (this.hasArchive()) {
            this.archive.add(this.tmpVar, this.newArchiveString(this.arcString1), this.newArchiveString(token));
        }
        return ParseState.ARCHIVE_VAR;
    }

    private void require(String srcToken, String reqToken) throws SyntaxError {
        if (!srcToken.equalsIgnoreCase(reqToken)) {
            throw new SyntaxError("\"" + reqToken + "\" is missing");
        }
    }

    public Variable locateVar(String fullName) throws SyntaxError {
        Variable.NameParser vn = new Variable.NameParser(fullName);
        for (VariablesBlock d : this.AllVars) {
            Variable var;
            if (!d.name.equalsIgnoreCase(vn.domain) || (var = d.locateVar(vn.name, vn.type)) == null) continue;
            return var;
        }
        throw new SyntaxError("Unknown variable: \"" + fullName + "\"");
    }

    public StringList locateStrings(String name) throws SyntaxError {
        StringList sl = this.Strings.get(name.toUpperCase());
        if (sl == null) {
            throw new SyntaxError("Unknown string list: \"" + name + "\"");
        }
        return sl;
    }

    public Window locateWindow(String name, String place) throws SyntaxError {
        Window w = this.Windows.get(name.toUpperCase());
        if (w == null) {
            throw new SyntaxError("Unknown window: \"" + name + "\" (at " + place + ")");
        }
        return w;
    }

    private int getCodeLineNum() {
        return this.codeSource.size() + this.lastComments.size() + 1;
    }

    private ParseState parseCommand(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            this.codeBlock.addItem(this.retCommand, this.getCodeLineNum());
            return ParseState.BLOCK_BEGIN;
        }
        if (token.startsWith(":")) {
            this.codeBlock.addLabel(token.substring(1));
            return ParseState.CMD;
        }
        CommandDef cmd = this.device.CommandMap.get(token.toUpperCase());
        if (cmd == null) {
            throw new SyntaxError("Unknown command: \"" + token + "\"");
        }
        this.codeItem = this.codeBlock.addItem(cmd, this.getCodeLineNum());
        this.codeArgIndex = 0;
        this.codeArgListSize = 0;
        this.codeArgListIndex = -1;
        if (cmd.Args.length == 0) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    private ParseState parseCommandArg(String token) throws SyntaxError {
        ArgumentDef arg = this.codeItem.cmdDef.Args[this.codeArgIndex];
        if (arg.IsList) {
            if (this.codeArgListIndex < 0) {
                if (!arg.NoListSize) {
                    this.codeArgListSize = Program.decodeInt(token, "Invalid number");
                    if (this.codeArgListSize <= 0 || this.codeArgListSize > 255) {
                        throw new SyntaxError("Invalid list size:" + this.codeArgListSize);
                    }
                    this.codeItem.addNumArg(arg, this.codeArgListSize, false);
                    this.codeArgListIndex = 0;
                    return ParseState.CMD_ARG;
                }
                this.codeArgListIndex = 0;
            }
            this.addSingleArg(token, arg);
            ++this.codeArgListIndex;
            if (this.codeArgListIndex >= this.codeArgListSize) {
                ++this.codeArgIndex;
                this.codeArgListIndex = -1;
            }
        } else {
            this.addSingleArg(token, arg);
            ++this.codeArgIndex;
        }
        if (this.codeArgIndex >= this.codeItem.cmdDef.Args.length) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    private void addSingleArg(String fullName, ArgumentDef def) throws SyntaxError {
        if (def.Type == 100) {
            this.codeItem.addLabelArg(def, fullName);
        } else if (def.Type == 101) {
            this.codeItem.addSubCallArg(def, fullName);
        } else if (def.Type == 102) {
            this.codeItem.addNumArg(def, Program.decodeInt(fullName, "Invalid number"), false);
        } else {
            Variable var = this.locateVar(fullName + (def.IsArray ? "[0]" : ""));
            if (var.type != def.Type) {
                throw new SyntaxError("Invalid variable type (" + fullName + "). Must be " + Variable.typeToString(def.Type));
            }
            if (var.block.readOnly && !def.IsReadOnly) {
                throw new SyntaxError("Read only variable (" + fullName + ") is forbidden here");
            }
            this.codeItem.addVarArg(def, var);
            if (def.IsArray && def.IsCheckedSize) {
                this.codeItem.addNumArg(def, var.arrayItems.length, true);
            }
        }
    }

    private ParseState parseSub(String token) throws SyntaxError {
        String name = token.toUpperCase();
        if (this.Subs.containsKey(name)) {
            throw new SyntaxError("Duplicate subprogram name: \"" + token + "\"");
        }
        this.openCodeBlock(new CodeBlock(token), this.device.CommandMap.get("RET"));
        this.Subs.put(name, this.codeBlock);
        return ParseState.CMD;
    }

    private ParseState parseStrings(String token) throws SyntaxError {
        String name = token.toUpperCase();
        if (this.containsStrings(name)) {
            throw new SyntaxError("Duplicate string list name: " + name);
        }
        this.stringList = new StringList(name);
        return ParseState.STRING_NUM;
    }

    private ParseState parseStringNum(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            this.registerStrings(this.stringList);
            return ParseState.BLOCK_BEGIN;
        }
        int num = -1;
        try {
            num = Integer.decode(token);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (num != this.stringList.Strings.size()) {
            throw new SyntaxError("Invalid value: \"" + token + "\". Must be " + this.stringList.Strings.size());
        }
        return ParseState.STRING_TEXT;
    }

    private ParseState parseStringText(String token) throws SyntaxError {
        this.stringList.Strings.add(new WindowString(token, this.device.FONT, this.device.STRING_SIZE));
        return ParseState.STRING_NUM;
    }

    public boolean containsStrings(String name) {
        return this.Strings.containsKey(name);
    }

    public void registerStrings(StringList sl) throws SyntaxError {
        if (this.Strings.containsKey(sl.Name)) {
            throw new SyntaxError("String list already exists: " + sl.Name);
        }
        this.Strings.put(sl.Name, sl);
    }

    public void registerWindow(Window w) throws SyntaxError {
        String key = w.Name.toUpperCase();
        if (this.Windows.containsKey(key)) {
            throw new SyntaxError("Duplicate window name: \"" + w.Name + "\"");
        }
        this.Windows.put(key, w);
        if (this.firstWindow == null) {
            this.firstWindow = w;
            w.visible = null;
        }
    }

    private ParseState parseWindow(String token) throws SyntaxError {
        this.window = new Window(token, this);
        this.registerWindow(this.window);
        return ParseState.WND_PARAM_NAME;
    }

    private ParseState parseWindowParamName(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.windowParam = token;
        return ParseState.WND_PARAM_VAL;
    }

    private ParseState parseWindowParamValue(String token) throws SyntaxError {
        this.window.setParam(this.windowParam, token);
        return ParseState.WND_PARAM_NAME;
    }

    private ParseState parseSchedule(String token) throws SyntaxError {
        if (this.hasSchedule()) {
            this.schedule = this.Schedules.alloc(Program.decodeInt(token, "Invalid schedule number"));
        }
        return ParseState.SCHED_PARAM_NAME;
    }

    private ParseState parseScheduleParamName(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.scheduleParam = token;
        return ParseState.SCHED_PARAM_VALUE;
    }

    private ParseState parseScheduleParamValue(String token) throws SyntaxError {
        if (this.hasSchedule()) {
            this.schedule.setParam(this.scheduleParam, token, this);
        }
        return ParseState.SCHED_PARAM_NAME;
    }

    private ParseState parseKey(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        for (int i = 0; i < KEYS.length; ++i) {
            if (!KEYS[i].equalsIgnoreCase(token)) continue;
            this.keyWindowIndex = i;
            return ParseState.KEY_WINDOW;
        }
        throw new SyntaxError("Unknown key: \"" + token + "\", must be " + Arrays.toString(KEYS));
    }

    private ParseState parseKeyWindow(String token) throws SyntaxError {
        Window w = null;
        if (!token.equals("0")) {
            w = this.locateWindow(token, "Keys -> " + (Object)((Object)ParseState.KEY));
        }
        this.keyWindows[this.keyWindowIndex] = w;
        return ParseState.KEY;
    }

    public static int decodeInt(String s, String errorPrefix) throws SyntaxError {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public static int decodeIntRange(String s, String errorPrefix, int min, int max) throws SyntaxError {
        try {
            int v = Integer.decode(s);
            if (v < min || v > max) {
                throw new SyntaxError(errorPrefix + ": " + v + " out of range + (" + min + "..." + max + ")");
            }
            return v;
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public int getRamSize() {
        return this.RamVars.getSize();
    }

    public int getExtSize() {
        return this.ExtVars.getSize();
    }

    public int getStoreSize() {
        return this.StoreVars.getSize();
    }

    public int getAllCodeSize() {
        int size = this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            size += cb.getSize();
        }
        return size;
    }

    public int getWindowsSize() {
        int size = 0;
        for (Window w : this.Windows.values()) {
            size += w.getSize();
        }
        for (StringList sl : this.Strings.values()) {
            size += sl.getBytesCount();
        }
        return size;
    }

    public int getRamInitSize() {
        int size = 2;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            size += 3 + v.getSize();
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            size += 3 + v.getSize();
        }
        return size;
    }

    public int getConstSize() {
        return this.Constants.getSize();
    }

    public int getFlashSize() {
        int size = this.device.FLASH_HEADER_SIZE + this.getRamInitSize() + this.getAllCodeSize() + this.Modbus1.getSize() + this.Modbus2.getSize() + this.getWindowsSize() + this.getConstSize();
        if (this.hasArchive()) {
            size += this.archive.getFlashSize();
        }
        return size;
    }

    private void CheckMemSize(int size, int max, String memType) throws ErrorInFile {
        if (size > max) {
            throw new ErrorInFile(memType + " overflow (" + size + " > " + max + ")");
        }
    }

    public static int fillByte(int b, byte[] buf, int offset) {
        buf[offset] = (byte)b;
        return offset + 1;
    }

    public static int fillWord(int w, byte[] buf, int offset) {
        buf[offset + 0] = (byte)w;
        buf[offset + 1] = (byte)(w >>> 8);
        return offset + 2;
    }

    public static int fillWord32(int w, byte[] buf, int offset) {
        buf[offset + 0] = (byte)w;
        buf[offset + 1] = (byte)(w >>> 8);
        buf[offset + 2] = (byte)(w >>> 16);
        buf[offset + 3] = (byte)(w >>> 24);
        return offset + 4;
    }

    public static int fillBytes(byte[] bytes, byte[] buf, int offset) {
        for (byte b : bytes) {
            buf[offset++] = b;
        }
        return offset;
    }

    private int fillValues(VariablesBlock vb, byte[] buf, int offset) {
        for (Variable v : vb.map.values()) {
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    protected int resolveLabel(String label, CodeBlock cb) throws SyntaxError {
        Integer addr = cb.Labels.get(label.toUpperCase());
        if (addr == null) {
            throw new SyntaxError("Unknown label: " + label);
        }
        return cb.startAddress + addr;
    }

    protected int resolveSub(String name) throws SyntaxError {
        CodeBlock sub = this.Subs.get(name.toUpperCase());
        if (sub == null) {
            throw new SyntaxError("Unknown subprogram: " + sub);
        }
        return sub.startAddress;
    }

    private int fillCode(CodeBlock cb, byte[] buf, int offset) throws SyntaxError {
        for (Command ci : cb.Items) {
            offset = Program.fillWord(ci.cmdDef.Code, buf, offset);
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    offset = Program.fillByte((byte)((Integer)arg.Value).intValue(), buf, offset);
                    continue;
                }
                if (arg.Type == 5) {
                    offset = Program.fillWord((Integer)arg.Value, buf, offset);
                    continue;
                }
                if (arg.Type == 2) {
                    offset = Program.fillWord(((Variable)arg.Value).getAddress(), buf, offset);
                    continue;
                }
                if (arg.Type == 3) {
                    offset = Program.fillWord(this.resolveLabel((String)arg.Value, cb), buf, offset);
                    continue;
                }
                if (arg.Type == 4) {
                    offset = Program.fillWord(this.resolveSub((String)arg.Value), buf, offset);
                    continue;
                }
                throw new SyntaxError("Internal error. Arg type=" + arg.Type);
            }
        }
        return offset;
    }

    int fillWindowString(WindowString value, byte[] buf, int offset) {
        return Program.fillBytes(value.Bytes, buf, offset);
    }

    private int fillWindowAddress(Window w, int defAddr, byte[] buf, int offset) {
        if (w != null) {
            return Program.fillWord(w.startAddress, buf, offset);
        }
        return Program.fillWord(defAddr, buf, offset);
    }

    private int fillWindowRef(Window w, byte[] buf, int offset) throws SyntaxError {
        return Program.fillWord(w.startAddress, buf, offset);
    }

    public static int varTypeEncode(int type, int digits) throws SyntaxError {
        int res = 0;
        if (type == 2) {
            res = 1;
        } else if (type == 3) {
            if (digits == 0) {
                res = 2;
            } else if (digits == 1) {
                res = 3;
            } else if (digits == 2) {
                res = 4;
            } else if (digits == 3) {
                res = 5;
            } else {
                throw new SyntaxError("Invalid digits: " + digits);
            }
        }
        return res;
    }

    public static int digitsDecode(int encodedType) {
        if (encodedType == 3) {
            return 1;
        }
        if (encodedType == 4) {
            return 2;
        }
        if (encodedType == 5) {
            return 3;
        }
        return 0;
    }

    private int fillWindowVar(Variable var, int digits, int editMode, int min, int max, byte[] buf, int offset, String varName) throws SyntaxError {
        if (var == null) {
            throw new SyntaxError(varName + " is not set");
        }
        offset = Program.fillWord(var.getAddress(), buf, offset);
        int type = Program.varTypeEncode(var.type, digits);
        offset = Program.fillByte((byte)type, buf, offset);
        offset = Program.fillByte((byte)editMode, buf, offset);
        offset = Program.fillWord(min, buf, offset);
        offset = Program.fillWord(max, buf, offset);
        return offset;
    }

    private int fillWindowCommonData(Window w, int param, boolean down, boolean leftRight, boolean titleVar, boolean var, byte[] buf, int offset) throws SyntaxError {
        offset = Program.fillByte((byte)param, buf, offset);
        offset = this.fillWindowString(w.title, buf, offset);
        offset = this.fillWindowString(w.text, buf, offset);
        offset = Program.fillWord(w.strings.startAddress, buf, offset);
        offset = this.fillWindowRef(w.upLink, buf, offset);
        offset = this.fillWindowRef(down ? w.downLink : null, buf, offset);
        offset = this.fillWindowRef(leftRight ? w.leftLink : null, buf, offset);
        offset = this.fillWindowRef(leftRight ? w.rightLink : null, buf, offset);
        if (titleVar) {
            offset = this.fillWindowVar(w.titleVar, w.titleDigits, 0, 0, 0, buf, offset, "TitleVar");
        }
        if (var) {
            offset = this.fillWindowVar(w.var, w.digits, w.cursorEdit && !w.instEdit ? 1 : 0, w.min, w.max, buf, offset, "Var");
        }
        return offset;
    }

    private int fillWindows(byte[] buf, int offset) throws SyntaxError {
        for (Window w : this.Windows.values()) {
            w.validate();
            offset = w.type != Window.WindowType.PASSWORD && w.visible != null ? Program.fillWord(w.visible.getAddress(), buf, offset) : Program.fillWord(0, buf, offset);
            offset = Program.fillByte((byte)w.type.code, buf, offset);
            if (w.type == Window.WindowType.STATIC) {
                offset = this.fillWindowCommonData(w, 0, true, true, false, false, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.DISP_NUM) {
                offset = this.fillWindowCommonData(w, 0, true, true, false, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.DISP_TEXT) {
                offset = this.fillWindowCommonData(w, w.strings.Strings.size(), true, true, false, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.EDIT_NUM) {
                offset = this.fillWindowCommonData(w, w.instEdit ? 1 : 0, false, true, false, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.EDIT_TEXT) {
                offset = this.fillWindowCommonData(w, w.strings.Strings.size(), false, true, false, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.PASSWORD) {
                offset = this.fillWindowCommonData(w, w.level, true, false, false, false, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.TABLEEDIT) {
                offset = this.fillWindowCommonData(w, w.var.arraySize(), false, false, true, true, buf, offset);
                continue;
            }
            if (this.hasSchedule() && w.type == Window.WindowType.SCHEDULE) {
                offset = this.fillWindowString(w.text, buf, offset);
                offset = this.fillWindowRef(w.upLink, buf, offset);
                offset = Program.fillWord(w.startAddress + 27, buf, offset);
                offset = this.fillWindowRef(w.leftLink, buf, offset);
                offset = this.fillWindowRef(w.rightLink, buf, offset);
                int si = w.schedule - 1;
                Schedule sch = si >= 0 ? this.Schedules.items[si] : null;
                Variable var = sch != null ? sch.var : null;
                if (var == null) continue;
                offset = Program.fillWord(0, buf, offset);
                offset = Program.fillByte(11, buf, offset);
                offset = Program.fillByte((byte)si, buf, offset);
                if (var.type != 3) {
                    offset = Program.fillWord(sch.strings != null ? sch.strings.startAddress : 0, buf, offset);
                }
                offset = Program.fillWord(w.startAddress, buf, offset);
                continue;
            }
            if (this.hasArchive() && w.type == Window.WindowType.ARCHIVE) {
                offset = this.fillWindowString(w.text, buf, offset);
                offset = this.fillWindowRef(w.upLink, buf, offset);
                offset = Program.fillWord(w.startAddress + 27, buf, offset);
                offset = this.fillWindowRef(w.leftLink, buf, offset);
                offset = this.fillWindowRef(w.rightLink, buf, offset);
                offset = Program.fillWord(0, buf, offset);
                offset = Program.fillByte(10, buf, offset);
                offset = Program.fillWord(this.archiveFlashAddress, buf, offset);
                offset = Program.fillWord(w.startAddress, buf, offset);
                continue;
            }
            throw new IllegalStateException("Invalid window type: " + (Object)((Object)w.type));
        }
        for (StringList sl : this.Strings.values()) {
            for (WindowString ws : sl.Strings) {
                offset = Program.fillBytes(ws.Bytes, buf, offset);
            }
        }
        return offset;
    }

    private int fillRamVar(Variable v, byte[] buf, int offset) {
        if (v.hasRamInitValue()) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
            int type = 0;
            if (v.type == 2) {
                type = 1;
            } else if (v.type == 3) {
                type = 2;
            }
            offset = Program.fillByte((byte)type, buf, offset);
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    private int fillRamInit(byte[] buf, int offset) {
        int count = 0;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            ++count;
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            ++count;
        }
        offset = Program.fillWord(count, buf, offset);
        for (Variable v : this.RamVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        return offset;
    }

    public void makeBinaryData() throws SyntaxError, ErrorInFile {
        this.MainCode.startAddress = this.device.FlashStart + this.device.FLASH_HEADER_SIZE;
        int addr = this.MainCode.startAddress + this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            cb.startAddress = addr;
            addr += cb.getSize();
        }
        this.ramInitFlashAddress = addr;
        this.modbus1FlashAddress = addr += this.getRamInitSize();
        this.modbus2FlashAddress = addr += this.Modbus1.getSize();
        this.windowsFlashAddress = addr += this.Modbus2.getSize();
        for (Window w : this.Windows.values()) {
            w.startAddress = addr;
            addr += w.getSize();
        }
        for (StringList sl : this.Strings.values()) {
            sl.startAddress = addr;
            addr += sl.getBytesCount();
        }
        if (this.hasArchive()) {
            this.archiveFlashAddress = addr;
            addr += this.archive.getFlashSize();
        }
        this.constantsFlashAddress = addr;
        this.Constants.startAddress = 49152;
        this.RamVars.startAddress = this.device.RamStart;
        this.ExtVars.startAddress = this.device.NvramStart;
        this.StoreVars.startAddress = this.device.EepromStart;
        this.CheckMemSize(this.getFlashSize(), this.device.FlashSize, "ROM memory");
        this.CheckMemSize(this.getRamSize(), this.device.RamSize, "RAM");
        this.CheckMemSize(this.getStoreSize(), this.device.EepromSize, "EEPROM");
        this.CheckMemSize(this.getExtSize(), this.device.NvramSize, "NVRAM");
        this.store = new byte[this.getStoreSize()];
        this.fillValues(this.StoreVars, this.store, 0);
        this.ext = new byte[this.getExtSize()];
        this.fillValues(this.ExtVars, this.ext, 0);
        this.flash = new byte[this.getFlashSize()];
        Arrays.fill(this.flash, (byte)-1);
        this.fillWindowAddress(this.firstWindow, 0, this.flash, 0);
        int defWindowAddr = this.firstWindow != null ? this.firstWindow.startAddress : 0;
        this.fillWindowAddress(this.keyWindows[0], defWindowAddr, this.flash, 2);
        this.fillWindowAddress(this.keyWindows[1], defWindowAddr, this.flash, 4);
        this.fillWindowAddress(this.keyWindows[2], defWindowAddr, this.flash, 6);
        this.fillWindowAddress(this.keyWindows[3], defWindowAddr, this.flash, 8);
        Program.fillWord(this.ramInitFlashAddress, this.flash, 10);
        Program.fillWord(this.constantsFlashAddress, this.flash, 12);
        Program.fillByte(this.Modbus1.isMaster() ? 1 : 0, this.flash, 14);
        Program.fillWord(this.modbus1FlashAddress, this.flash, 15);
        Program.fillByte(this.Modbus2.isMaster() ? 1 : 0, this.flash, 17);
        Program.fillWord(this.modbus2FlashAddress, this.flash, 18);
        int offset = this.Schedules.compileData(this.flash, 128);
        if (offset != this.MainCode.startAddress - this.device.FlashStart) {
            throw new SyntaxError("Invalid code address");
        }
        offset = this.fillCode(this.MainCode, this.flash, offset);
        for (CodeBlock cb : this.Subs.values()) {
            offset = this.fillCode(cb, this.flash, offset);
        }
        if (offset != this.ramInitFlashAddress - this.device.FlashStart) {
            throw new SyntaxError("Invalid RAM init address");
        }
        if ((offset = this.fillRamInit(this.flash, offset)) != this.modbus1FlashAddress - this.device.FlashStart) {
            throw new SyntaxError("Invalid MODBUS1 address");
        }
        if ((offset = this.Modbus1.fillFlash(this.flash, offset)) != this.modbus2FlashAddress - this.device.FlashStart) {
            throw new SyntaxError("Invalid MODBUS2 address");
        }
        offset = this.Modbus2.fillFlash(this.flash, offset);
        if (this.hasDisplay()) {
            if (offset != this.windowsFlashAddress - this.device.FlashStart) {
                throw new SyntaxError("Invalid windows address");
            }
            offset = this.fillWindows(this.flash, offset);
        }
        if (this.hasArchive()) {
            if (offset != this.archiveFlashAddress - this.device.FlashStart) {
                throw new SyntaxError("Invalid archive address");
            }
            offset = this.archive.compileData(this.flash, offset, this);
        }
        if (offset != this.constantsFlashAddress - this.device.FlashStart) {
            throw new SyntaxError("Invalid constants address");
        }
        if ((offset = this.fillValues(this.Constants, this.flash, offset)) != this.flash.length) {
            throw new Error("Internal error (" + offset + " != " + this.flash.length + ")");
        }
        Program.fillWord(3, this.flash, 64);
        this.codeCrc = this.calcFlashCRC32();
        Program.fillWord(this.codeCrc, this.flash, 68);
        Program.fillWord(this.codeCrc >>> 16, this.flash, 66);
        GregorianCalendar c = new GregorianCalendar();
        Program.fillByte(c.get(1) % 100, this.flash, 70);
        Program.fillByte(c.get(2) + 1, this.flash, 71);
        Program.fillByte(c.get(5), this.flash, 72);
        byte[] b = new byte[8];
        this.device.FONT.encodeString(this.id, b);
        Program.fillBytes(b, this.flash, 73);
        Program.fillWord(this.flash.length - 128, this.flash, 124);
        Program.fillWord(this.calcFlashChecksum16(), this.flash, 126);
    }

    protected int getWindowsFlashAddress() {
        return this.windowsFlashAddress;
    }

    private int calcFlashCRC32() {
        CRC32 crc = new CRC32();
        crc.update(this.flash, 0, 19);
        crc.update(this.flash, 128, this.flash.length - 128);
        return (int)crc.getValue();
    }

    private int calcFlashChecksum16() {
        int i;
        int sum = 0;
        for (i = 0; i < 20; ++i) {
            sum = (sum + (this.flash[i] & 0xFF)) % 65536;
        }
        for (i = 128; i < this.flash.length; ++i) {
            sum = (sum + (this.flash[i] & 0xFF)) % 65536;
        }
        return sum;
    }

    public void dumpBinaryData(PrintWriter pw) {
        pw.println(";---------------------- FLASH -----------------------------------------------------");
        pw.println();
        if (this.hasSchedule()) {
            pw.println("; Schedules info at $" + Integer.toHexString(128 + this.device.FlashStart) + ", size: 60");
        }
        pw.println("; Code at $" + Integer.toHexString(this.MainCode.startAddress) + ", size: " + this.getAllCodeSize());
        pw.println("; RAM init table at $" + Integer.toHexString(this.ramInitFlashAddress) + ", size: " + this.getRamInitSize());
        pw.println("; Modbus1 at $" + Integer.toHexString(this.modbus1FlashAddress) + ", size: " + this.Modbus1.getSize());
        pw.println("; Modbus2 at $" + Integer.toHexString(this.modbus2FlashAddress) + ", size: " + this.Modbus2.getSize());
        if (this.hasDisplay()) {
            pw.println("; Windows and strings at $" + Integer.toHexString(this.windowsFlashAddress) + ", size: " + this.getWindowsSize());
        }
        if (this.hasArchive()) {
            pw.println("; Archive strings at $" + Integer.toHexString(this.archiveFlashAddress) + ", size: " + this.archive.getFlashSize());
        }
        pw.println("; Constants at $" + Integer.toHexString(this.constantsFlashAddress) + ", size: " + this.getConstSize());
        pw.println(";");
        this.printBytes(this.flash, this.device.FlashStart, ".db ", pw);
        pw.println();
        for (Variable v : this.Constants.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.name);
        }
        pw.println();
        pw.println(";------------------------------- EEPROM (Store) -----------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.StoreVars.startAddress) + ", size: " + this.store.length);
        pw.println();
        this.printBytes(this.store, this.StoreVars.startAddress, "; ", pw);
        pw.println();
        for (Variable v : this.StoreVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.name);
        }
        pw.println();
        pw.println(";------------------------------- NVRAM (Ext) --------------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.ExtVars.startAddress) + ", size: " + this.ext.length);
        pw.println();
        this.printBytes(this.ext, this.ExtVars.startAddress, "; ", pw);
        pw.println();
        for (Variable v : this.ExtVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.name);
        }
        pw.println();
        pw.println(";------------------------------- External EEPROM ----------------------------------");
        pw.println();
        if (this.hasSchedule()) {
            int block = 512;
            for (int i = 0; i < this.Schedules.items.length; ++i) {
                Schedule s = this.Schedules.items[i];
                if (s.var == null) continue;
                int start = this.device.ExtEepromScheduleStart + block * i;
                pw.println("; Schedule " + (i + 1) + " at: $" + Integer.toHexString(start) + ", size: " + block);
                pw.println();
                this.printBytes(Arrays.copyOfRange(this.Schedules.eeprom, block * i, block * (i + 1)), this.device.ExtEepromScheduleStart + block * i, "; ", pw);
                pw.println();
                pw.println();
            }
        }
        pw.println();
        pw.println(";------------------------------- RAM variables ------------------------------------");
        pw.println();
        for (Variable v : this.RamVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.name);
        }
    }

    protected String byteToHex(int b) {
        return "$" + Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected String byteToHex2(int b) {
        return Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected String wordToHex2(int w) {
        return this.byteToHex2(w >>> 8) + this.byteToHex2(w);
    }

    private void printBytes(byte[] buf, int addr, String dataPrefix, PrintWriter pw) {
        int start = 0;
        int i = 0;
        String s = "";
        while (start + i < buf.length) {
            s = s.length() == 0 ? dataPrefix + this.byteToHex(buf[start + i]) : s + ", " + this.byteToHex(buf[start + i]);
            if (++i < 16 && start + i < buf.length) continue;
            pw.println("; $" + this.wordToHex2(addr + start) + ":");
            pw.println(s);
            start += i;
            i = 0;
            s = "";
        }
    }

    public static class OldEditorError
    extends SyntaxError {
        private static final long serialVersionUID = 1L;

        public OldEditorError() {
            super("File was made by newer version of editor");
        }
    }

    static enum ParseState {
        PARSE_START,
        FILE_VERSION,
        PROG_ID,
        CODE_CRC,
        TARGET,
        BLOCK_BEGIN,
        VAR_NAME,
        VAR_VALUE,
        MODBUS_MODE,
        MODBUS_SLAVE_REG,
        MODBUS_SLAVE_VAR,
        MODBUS_SLAVE_K,
        MODBUS_SLAVE_K_VALUE,
        MODBUS_MASTER_TIMEOUT,
        MODBUS_MASTER_PAUSE,
        MODBUS_MASTER_REQUEST,
        MODBUS_MASTER_REQ_TYPE,
        MODBUS_MASTER_REQ_ID,
        MODBUS_MASTER_REQ_ADDR,
        MODBUS_MASTER_REQ_CMDVAR,
        MODBUS_MASTER_REQ_STATUSVAR,
        MODBUS_MASTER_REGISTER,
        MODBUS_MASTER_REG_K,
        MODBUS_MASTER_REG_K_VALUE,
        CMD,
        CMD_ARG,
        SUB,
        STRINGS,
        STRING_NUM,
        STRING_TEXT,
        WINDOW,
        WND_PARAM_NAME,
        WND_PARAM_VAL,
        KEY,
        KEY_WINDOW,
        SCHEDULE,
        SCHED_PARAM_NAME,
        SCHED_PARAM_VALUE,
        ARCHIVE_VAR,
        ARCHIVE_STRING1,
        ARCHIVE_STRING2,
        PARSE_END;

    }
}

