/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.Command;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.SyntaxError;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class CodeBlock {
    public final String Name;
    public final ArrayList<Command> Items = new ArrayList();
    public final LinkedHashMap<String, Integer> Labels = new LinkedHashMap();
    public int startAddress;
    private Command lastItem;

    public CodeBlock(String name) {
        this.Name = name;
    }

    public void clear() {
        this.Items.clear();
        this.Labels.clear();
        this.lastItem = null;
    }

    public int getSize() {
        if (this.lastItem != null) {
            return this.lastItem.offset + this.lastItem.getSize();
        }
        return 0;
    }

    public Command addItem(CommandDef cmd, int srcLine) {
        this.lastItem = new Command(cmd, this.getSize(), srcLine);
        this.Items.add(this.lastItem);
        return this.lastItem;
    }

    public void addLabel(String name) throws SyntaxError {
        if (name.length() < 1) {
            throw new SyntaxError("Invalid label name");
        }
        String key = name.toUpperCase();
        if (this.Labels.containsKey(key)) {
            throw new SyntaxError("Duplicate label: \"" + name + "\"");
        }
        this.Labels.put(key, this.getSize());
    }

    public void resolveLabels() {
    }

    public void resolveCalls() {
    }

    public String toString() {
        return this.Name;
    }
}

