/*
 * Decompiled with CFR 0.152.
 */
package ua.com.certa.modbus.server;

import ua.com.certa.modbus.ModbusConstants;
import ua.com.certa.modbus.ModbusPdu;
import ua.com.certa.modbus.server.AModbusServer;
import ua.com.certa.modbus.server.RegistersTable;
import ua.com.certa.modbus.server.RequestProcessor;

public class DefaultRequestProcessor
implements ModbusConstants,
RequestProcessor {
    public final AModbusServer server;

    public DefaultRequestProcessor(AModbusServer server) {
        this.server = server;
    }

    protected void setException(ModbusPdu pdu, int code) {
        this.server.log.debug("Sending exception {}", (Object)code);
        pdu.setPduSize(2);
        pdu.writeByteToPDU(0, (byte)(pdu.readByteFromPDU(0) | 0x80));
        pdu.writeByteToPDU(1, (byte)code);
    }

    private boolean validRange(ModbusPdu pdu, int startAddr, int count, RegistersTable table, String name, int maxCount) {
        if (count < 1 || count > maxCount) {
            this.server.log.warn("Invalid {} count ({}). Must be 1..{}", name, count, maxCount);
            this.setException(pdu, 3);
            return false;
        }
        int endAddr = startAddr + count - 1;
        if (!table.isValidAddress(startAddr) || !table.isValidAddress(endAddr)) {
            this.server.log.warn("Invalid {} range ({} - {}). Can be {} - {}", name, startAddr, endAddr, table.firstAddress(), table.lastAddress());
            this.setException(pdu, 2);
            return false;
        }
        return true;
    }

    private boolean validPduSize(ModbusPdu pdu, int expectedSize) {
        if (pdu.getPduSize() < expectedSize) {
            this.server.log.warn("Invalid PDU size ({}). Must be {}", (Object)pdu.getPduSize(), (Object)expectedSize);
            pdu.setPduSize(0);
            return false;
        }
        return true;
    }

    private void processReadBits(ModbusPdu pdu, RegistersTable table, String name) {
        int i;
        int addr = pdu.readInt16FromPDU(1, true);
        int count = pdu.readInt16FromPDU(3, true);
        this.server.log.debug("Read {}: addr={}, count={}", name, addr, count);
        if (!this.validRange(pdu, addr, count, table, name, 2000)) {
            return;
        }
        int nBytes = ModbusPdu.bytesCount(count);
        pdu.setPduSize(2 + nBytes);
        pdu.writeByteToPDU(1, (byte)nBytes);
        for (i = 0; i < nBytes; ++i) {
            pdu.writeByteToPDU(2 + i, (byte)0);
        }
        for (i = 0; i < count; ++i) {
            pdu.writeBitToPDU(2, i, table.getBool(i));
        }
    }

    private void processReadInts(ModbusPdu pdu, RegistersTable table, String name) {
        int addr = pdu.readInt16FromPDU(1, true);
        int count = pdu.readInt16FromPDU(3, true);
        this.server.log.debug("Read {}: addr={}, count={}", name, addr, count);
        if (!this.validRange(pdu, addr, count, table, name, 125)) {
            return;
        }
        int nBytes = count * 2;
        pdu.setPduSize(2 + nBytes);
        pdu.writeByteToPDU(1, (byte)nBytes);
        for (int i = 0; i < count; ++i) {
            pdu.writeInt16ToPDU(2 + i * 2, table.getInt(addr + i));
        }
    }

    private void processWriteSingleCoil(ModbusPdu pdu) {
        int addr = pdu.readInt16FromPDU(1, true);
        int value = pdu.readInt16FromPDU(3, true);
        this.server.log.debug("Write single coil {}, value: {}", (Object)addr, (Object)value);
        if (value != 0 & value != 65280) {
            this.server.log.warn("Invalid write coil value ({}). Must be 0 or 0xFF00 (65280)", (Object)value);
            this.setException(pdu, 3);
            return;
        }
        if (!this.server.coils.isValidAddress(addr)) {
            this.server.log.warn("Invalid write coil address ({})", (Object)addr);
            this.setException(pdu, 2);
            return;
        }
        if (this.server.handler == null || !this.server.handler.OnWriteCoil(this.server, addr, value > 0)) {
            this.server.log.warn("Writing coil {} failed", (Object)addr);
            this.setException(pdu, 4);
            return;
        }
        pdu.setPduSize(5);
    }

    private void processWriteSingleHReg(ModbusPdu pdu) {
        int addr = pdu.readInt16FromPDU(1, true);
        int value = pdu.readInt16FromPDU(3, false);
        this.server.log.debug("Write single register {}, value: {}", (Object)addr, (Object)value);
        if (!this.server.hregs.isValidAddress(addr)) {
            this.server.log.warn("Invalid write reg address ({})", (Object)addr);
            this.setException(pdu, 2);
            return;
        }
        if (this.server.handler == null || !this.server.handler.OnWriteHReg(this.server, addr, value)) {
            this.server.log.warn("Writing register {} failed", (Object)addr);
            this.setException(pdu, 4);
            return;
        }
        pdu.setPduSize(5);
    }

    private void processWriteCoils(ModbusPdu pdu) {
        int addr = pdu.readInt16FromPDU(1, true);
        int count = pdu.readInt16FromPDU(3, true);
        int nBytes = pdu.readByteFromPDU(5, true);
        this.server.log.debug("Write multiple coils: addr={}, count={}", (Object)addr, (Object)count);
        if (!this.validPduSize(pdu, 6 + nBytes)) {
            return;
        }
        if (!this.validRange(pdu, addr, count, this.server.coils, "coils", 1968)) {
            return;
        }
        int bytesCount = ModbusPdu.bytesCount(count);
        if (nBytes != bytesCount) {
            this.server.log.warn("Write byte count (N={}) doesn't match coils count ({}). N must be {}", nBytes, count, bytesCount);
            this.setException(pdu, 3);
            return;
        }
        boolean fail = this.server.handler == null;
        for (int i = 0; !fail && i < count; ++i) {
            fail = !this.server.handler.OnWriteCoil(this.server, addr + i, pdu.readBitFromPDU(6, i));
        }
        if (fail) {
            this.server.log.warn("Writing coils at {}, count {} failed", (Object)addr, (Object)count);
            this.setException(pdu, 4);
            return;
        }
        pdu.setPduSize(5);
    }

    private void processWriteHRegs(ModbusPdu pdu) {
        int addr = pdu.readInt16FromPDU(1, true);
        int count = pdu.readInt16FromPDU(3, true);
        int nBytes = pdu.readByteFromPDU(5, true);
        this.server.log.debug("Write multiple reg-s: addr={}, count={}", (Object)addr, (Object)count);
        if (!this.validPduSize(pdu, 6 + nBytes)) {
            return;
        }
        if (!this.validRange(pdu, addr, count, this.server.hregs, "holding reg-s", 123)) {
            return;
        }
        if (nBytes != 2 * count) {
            this.server.log.warn("Write byte count (N={}) doesn't match reg-s count ({}). N must be {}", nBytes, count, 2 * count);
            this.setException(pdu, 3);
            return;
        }
        boolean fail = this.server.handler == null;
        for (int i = 0; !fail && i < count; ++i) {
            fail = !this.server.handler.OnWriteHReg(this.server, addr + i, pdu.readInt16FromPDU(6 + i * 2, false));
        }
        if (fail) {
            this.server.log.warn("Writing reg-s at {}, count {} failed", (Object)addr, (Object)count);
            this.setException(pdu, 4);
            return;
        }
        pdu.setPduSize(5);
    }

    @Override
    public boolean processRequest(ModbusPdu pdu) {
        if (pdu.getPduSize() < 5) {
            this.server.log.error("Invalid PDU size ({} < 5)", (Object)pdu.getPduSize());
            return false;
        }
        int func = pdu.getFunction();
        if (func == 1) {
            this.processReadBits(pdu, this.server.coils, "coils");
        } else if (func == 2) {
            this.processReadBits(pdu, this.server.inputs, "inputs");
        } else if (func == 3) {
            this.processReadInts(pdu, this.server.hregs, "holding reg-s");
        } else if (func == 4) {
            this.processReadInts(pdu, this.server.iregs, "input reg-s");
        } else if (func == 5) {
            this.processWriteSingleCoil(pdu);
        } else if (func == 6) {
            this.processWriteSingleHReg(pdu);
        } else if (func == 15) {
            this.processWriteCoils(pdu);
        } else if (func == 16) {
            this.processWriteHRegs(pdu);
        } else {
            this.server.log.error("Unknown function: {}", (Object)func);
            this.setException(pdu, 1);
        }
        return true;
    }
}

