/*
 * Decompiled with CFR 0.152.
 */
package certa.model;

import java.util.Arrays;

public class Model3Point {
    static final int travel_time = 180;
    static final int min_imp = 200;
    static final double Kp = 5.0;
    static final double Ti = 16.0;
    static final double object_K = 0.1;
    static final double object_T = 120.0;
    static final int object_tau = 1000;
    static final int TIME_SPAN = 500000;
    static final int LOG_PERIOD = 1000;
    static int time_cs = 0;
    static int time_s = 0;
    static double valve_pos = 0.0;
    static double object_out = 0.0;
    static double setpoint = 5.0;
    static boolean valve_open = false;
    static boolean valve_close = false;
    static double e;
    static double e1;
    static double u1;
    static int pulse;
    static int prevTime;
    static final DelayBuffer delayed_obj_in;

    static void controller() {
        valve_open = false;
        valve_close = false;
        e = setpoint - object_out;
        if (e > 0.5) {
            valve_open = true;
        } else if (e < -0.5) {
            valve_close = true;
        }
    }

    static void actuator() {
        double d = 0.005555555555555556;
        if (valve_close) {
            valve_pos -= d;
        } else if (valve_open) {
            valve_pos += d;
        }
        if (valve_pos < 0.0) {
            valve_pos = 0.0;
        }
        if (valve_pos > 100.0) {
            valve_pos = 100.0;
        }
    }

    static void object() {
        double dt = 0.01;
        object_out = (0.1 * delayed_obj_in.get() * dt + 120.0 * object_out) / (120.0 + dt);
        delayed_obj_in.put(valve_pos);
        if (time_cs == 200000) {
            object_out += 2.0;
        }
    }

    public static void main(String[] args) {
        for (time_cs = 0; time_cs <= 500000; ++time_cs) {
            if (time_cs > 0 && time_cs % 100 == 0) {
                ++time_s;
            }
            Model3Point.object();
            Model3Point.controller();
            Model3Point.actuator();
            if (time_cs % 1000 != 0) continue;
            System.out.println(time_s + " " + valve_pos + " " + object_out + " " + pulse);
        }
    }

    static {
        delayed_obj_in = new DelayBuffer(1000);
    }

    static class DelayBuffer {
        final double[] data;
        int ptr = 0;

        DelayBuffer(int size) {
            this.data = new double[size];
            Arrays.fill(this.data, 0.0);
        }

        void put(double value) {
            this.data[this.ptr] = value;
            this.ptr = (this.ptr + 1) % this.data.length;
        }

        double get() {
            return this.data[this.ptr];
        }
    }
}

