/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.modbus;

import ua.com.certa.modbus.client.ModbusClient;

public class FlashModbusClient
extends ModbusClient {
    public static final byte EXT_FN_SET_WRITE_MODE = 65;
    public static final byte EXT_FN_STORE_FLASH_HALFPAGE1 = 66;
    public static final byte EXT_FN_STORE_FLASH_HALFPAGE2 = 67;
    public static final byte EXT_FN_WRITE_FLASH_PAGE = 68;
    public static final byte EXT_FN_WRITE_INT_EEPROM = 69;
    public static final byte EXT_FN_WRITE_NVRAM = 70;
    public static final byte EXT_FN_READ_FLASH = 71;
    public static final byte EXT_FN_READ_INT_EEPROM = 72;
    public static final byte EXT_FN_READ_NVRAM = 73;
    public static final byte EXT_FN_WRITE_EXT_EEPROM = 75;
    public static final byte EXT_FN_READ_EXT_EEPROM = 76;

    public void InitSetWriteModeRequest(int serverId, int password, boolean writeMode) {
        this.initRequest(serverId, 5, (byte)65, password, writeMode ? 256 : 0, -1, -1, 8);
        this.setPduSize(4);
    }

    public void InitStoreFlashHalfPageRequest(int serverId, int pageNumber, byte[] page, boolean secondHalf) {
        this.initRequest(serverId, 130, secondHalf ? (byte)67 : 66, pageNumber << 8, 0, -1, -1, 130);
        int offset = secondHalf ? 128 : 0;
        for (int i = 0; i < 128; ++i) {
            if (i + offset < page.length) {
                this.writeByteToPDU(i + 2, page[i + offset]);
                continue;
            }
            this.writeByteToPDU(i + 2, (byte)-1);
        }
    }

    public void InitWriteFlashPageRequest(int serverId, int pageNumber) {
        this.initRequest(serverId, 5, (byte)68, pageNumber << 8, 0, -1, -1, 2);
        this.setPduSize(2);
    }

    public void InitWriteIntEepromRequest(int serverId, int address, byte[] data) {
        this.initRequest(serverId, 4 + data.length, (byte)69, address, data.length << 8, -1, -1, 4 + data.length);
        for (int i = 0; i < data.length; ++i) {
            this.writeByteToPDU(i + 4, data[i]);
        }
    }

    public void InitWriteNvramRequest(int serverId, int address, byte[] data) {
        this.initRequest(serverId, 4 + data.length, (byte)70, address, data.length << 8, -1, -1, 4 + data.length);
        for (int i = 0; i < data.length; ++i) {
            this.writeByteToPDU(i + 4, data[i]);
        }
    }

    public void InitWriteExtEepromRequest(int serverId, int address, byte[] data) {
        this.initRequest(serverId, 4 + data.length, (byte)75, address, data.length << 8, -1, -1, 4 + data.length);
        for (int i = 0; i < data.length; ++i) {
            this.writeByteToPDU(i + 4, data[i]);
        }
    }

    public void InitReadFlashRequest(int serverId, int address, int length) {
        this.initRequest(serverId, 5, (byte)71, address, length << 8, -1, -1, 4 + length);
        this.setPduSize(4);
    }

    public void InitReadIntEepromRequest(int serverId, int address, int length) {
        this.initRequest(serverId, 5, (byte)72, address, length << 8, -1, -1, 4 + length);
        this.setPduSize(4);
    }

    public void InitReadNvramRequest(int serverId, int address, int length) {
        this.initRequest(serverId, 5, (byte)73, address, length << 8, -1, -1, 4 + length);
        this.setPduSize(4);
    }

    public void InitReadExtEepromRequest(int serverId, int address, int length) {
        this.initRequest(serverId, 5, (byte)76, address, length << 8, -1, -1, 4 + length);
        this.setPduSize(4);
    }
}

