/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.ClipboardUtils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.AFbdComment;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.AFbdView;
import certa.vics.ide.fbd.AbstractOperation;
import certa.vics.ide.fbd.BlockCreateDialog;
import certa.vics.ide.fbd.BlocksTree;
import certa.vics.ide.fbd.FbdActions;
import certa.vics.ide.fbd.FbdCommentRect;
import certa.vics.ide.fbd.FbdCommentText;
import certa.vics.ide.fbd.FbdConstants;
import certa.vics.ide.fbd.FbdNumber;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.NumberCreateDialog;
import certa.vics.ide.fbd.NumberEditDialog;
import certa.vics.ide.fbd.OutputPin;
import certa.vics.ide.fbd.PageActions;
import certa.vics.ide.fbd.VariableCreateDialog;
import certa.vics.ide.fbd.VariableSelectDialog;
import certa.vics.ide.fbd.blocks.MoveB;
import certa.vics.ide.fbd.blocks.MoveF;
import certa.vics.ide.fbd.blocks.MoveI;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import certa.vics.tools.ExportSource;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdEditor
extends IdeEditor
implements FbdConstants,
MouseListener,
MouseMotionListener,
ListSelectionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private int zoom = 100;
    private JPopupMenu popupItem;
    private JPopupMenu popupComment;
    protected JPopupMenu popupEmpty;
    private JPopupMenu popupPage;
    private JPopupMenu popupPageEmpty;
    private JPopupMenu popupInPin;
    FbdActions actions;
    PageActions pageActions;
    public final MainFrame mainFrame;
    protected ArrayList<FbdPage> pages = new ArrayList();
    VariableDef selVar;
    protected EditPane pane;
    protected JScrollPane paneScroll;
    PagesListModel pagesModel;
    JList<FbdPage> pagesList;
    JScrollPane pagesScroll;
    IdeUtils.BorderedPanel pnlPages;
    JSplitPane blocksSplitter;
    IdeUtils.BorderedPanel pnlBlocks;
    BlocksTree blocks;
    FbdPage page;
    protected AFbdPin hoveredPin;
    protected InputPin connectingInputPin;
    protected AFbdView hoveredView;
    protected AFbdView focusedView;
    protected AFbdComment focusedComment;
    protected AFbdItem focusedItem;
    protected String currentTipText;
    private Rectangle scrollRect = new Rectangle();
    static final Cursor CURSOR_RESIZE = Cursor.getPredefinedCursor(5);
    private boolean connecting;
    protected OutputPin sourcePin;
    protected InputPin oldTargetPin;
    private InputPin newTargetPin;
    private Point targetPoint = new Point();
    private Rectangle connRect = new Rectangle();
    private boolean draggingItem;
    private boolean dragAdding;
    protected AFbdItem dragItem;
    private Rectangle dragRect = new Rectangle();
    private boolean dragAllowed;
    private int dragDX;
    private int dragDY;
    private int dragLeftGap;
    private int dragTopGap;
    private AFbdView dragComment;
    private boolean dragCmtResize;
    private int dragCmtDX;
    private int dragCmtDY;
    int popupX;
    int popupY;
    private boolean mouseDown;
    private boolean panning;
    private long mouseUpClickTime = 0L;
    private AFbdView prevFocusedView = null;
    private int dragStartX0;
    private int dragStartY0;
    private AFbdView dragStartView;
    private Rectangle autoscrollRect = new Rectangle(0, 0, 1, 1);
    static final String DEF_PAGE_NAME = "Main";
    static final String JSON_PAGES_KEY = "pages";
    protected Variable bOne;
    protected Variable bNull;
    protected Variable iNull;
    protected Variable fNull;
    protected Variable bNullArray;
    protected Variable iNullArray;
    protected Variable fNullArray;
    static final String PROP_ZOOM = "fbd.zoom";
    static final String PROP_BLOCKS_SPLIT = "fbd.bsplit";
    private ArrayList<Variable> constNumbers = new ArrayList();
    private ArrayList<Variable> globalVars = new ArrayList();
    private ArrayList<Variable> localVars = new ArrayList();
    private Set<Variable> usedLocalVars = new HashSet<Variable>();
    private static final String JSON_BLOCKS = "blocks";
    private static final String JSON_PAGES = "pages";

    public FbdEditor(final MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0414\u0438\u0430\u0433\u0440\u0430\u043c\u043c\u0430", false);
        this.setBackground(Color.WHITE);
        this.mainFrame = mainFrame;
        this.zoom = Main.props.getInt(PROP_ZOOM, this.zoom);
        this.pagesModel = new PagesListModel();
        this.pagesList = new JList<FbdPage>(this.pagesModel);
        this.pagesList.setSelectionMode(0);
        this.pagesList.addListSelectionListener(this);
        this.pagesList.addMouseListener(new MouseAdapter(){
            private long mouseUpClickTime = 0L;
            private int prevIndex = -1;

            @Override
            public void mousePressed(MouseEvent e) {
                int index = FbdEditor.this.pagesList.locationToIndex(e.getPoint());
                FbdEditor.this.pagesList.setSelectedIndex(index);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    long now = System.currentTimeMillis();
                    int i = FbdEditor.this.pagesList.getSelectedIndex();
                    if (now - this.mouseUpClickTime <= (long)Main.DOUBLE_CLICK_TIME && this.prevIndex == i) {
                        Point p = e.getLocationOnScreen();
                        FbdEditor.this.pageActions.editPage.perform(p.x, p.y);
                        this.mouseUpClickTime = 0L;
                    } else {
                        this.mouseUpClickTime = now;
                        this.prevIndex = i;
                    }
                }
            }
        });
        MouseListener ml = IdeUtils.createOnClickFocuser(this.pagesList);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.addMouseListener(ml);
        pnl.add(this.pagesList, "North");
        pnl.setBackground(this.pagesList.getBackground());
        this.pagesScroll = new JScrollPane(pnl);
        this.pagesList.setComponentPopupMenu(this.popupPage);
        this.pagesList.addMouseListener(ml);
        pnl.setComponentPopupMenu(this.popupPageEmpty);
        JToolBar tb = IdeUtils.newToolBar();
        tb.addMouseListener(ml);
        tb.add(this.pageActions.addPage).setFocusable(false);
        tb.add(this.pageActions.copy).setFocusable(false);
        tb.add(this.pageActions.paste).setFocusable(false);
        tb.addSeparator();
        tb.add(this.pageActions.deletePage).setFocusable(false);
        tb.addSeparator();
        tb.add(this.pageActions.movePageUp).setFocusable(false);
        tb.add(this.pageActions.movePageDown).setFocusable(false);
        this.pnlPages.add((Component)tb, "First");
        this.pnlPages.add((Component)this.pagesScroll, "Center");
        IdeUtils.bindActions(this.pagesList, this.pageActions);
        this.pnlBlocks.add((Component)this.blocks, "Center");
        this.pane.updateZoom();
        this.paneScroll = new JScrollPane(this.pane);
        this.paneScroll.getVerticalScrollBar().setUnitIncrement(27);
        this.paneScroll.getViewport().setBackground(Color.WHITE);
        this.pane.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;
            boolean active = false;

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                if (info.isDrop() && info.isDataFlavorSupported(AddingItem.FLAVOR)) {
                    Point p = info.getDropLocation().getDropPoint();
                    int x = p.x * 100 / FbdEditor.this.zoom;
                    int y = p.y * 100 / FbdEditor.this.zoom;
                    Transferable t = info.getTransferable();
                    if (!this.active) {
                        this.active = true;
                        FbdEditor.this.cancelMouseOperations();
                        try {
                            AFbdItem item = (AFbdItem)t.getTransferData(AddingItem.FLAVOR);
                            item.cellBounds.x = x / 27 - item.padLeft;
                            item.cellBounds.y = y / 27 - item.padTop;
                            item.updateBounds();
                            FbdEditor.this.startDragging(item.pxBounds.x + 13, item.pxBounds.y + 13, item);
                        }
                        catch (Exception e) {
                            Utils.ProcessException(e, false);
                            return false;
                        }
                    } else {
                        FbdEditor.this.updateDragRect(x, y);
                        FbdEditor.this.pane.repaint();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                this.active = false;
                FbdEditor.this.endDragging(FbdEditor.this.dragAllowed);
                return true;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 0;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return null;
            }
        });
        this.blocksSplitter = new JSplitPane(0, this.pnlPages, this.pnlBlocks);
        IdeUtils.setupDivider(this.blocksSplitter);
        this.add((Component)this.paneScroll, "Center");
        this.pane.setAutoscrolls(true);
        this.pane.addMouseListener(this);
        this.pane.addMouseMotionListener(this);
        this.addKeyListener(this);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                mainFrame.removeWindowListener(this);
                FbdEditor.this.blocksSplitter.setDividerLocation(Main.props.getInt(FbdEditor.PROP_BLOCKS_SPLIT, 200));
            }
        });
    }

    @Override
    protected void focusChanged() {
        super.focusChanged();
        if (!this.isFocused()) {
            this.clearFocus();
        }
    }

    @Override
    public void updateFocus(Component focusOwner) {
        super.updateFocus(focusOwner);
        this.pnlPages.updateFocus(focusOwner);
        this.pnlBlocks.updateFocus(focusOwner);
    }

    @Override
    protected ActionsBundle createActions() {
        this.pnlPages = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                FbdEditor.this.pagesList.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                FbdEditor.this.pageActions.update();
            }
        };
        this.pnlBlocks = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0431\u043b\u043e\u043a\u043e\u0432"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                FbdEditor.this.blocks.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                FbdEditor.this.blocks.actions.update();
            }
        };
        this.actions = new FbdActions(this);
        this.pageActions = new PageActions(this);
        this.blocks = new BlocksTree(this, true);
        this.actions.update();
        this.blocks.actions.update();
        this.pageActions.update();
        this.pane = new EditPane();
        IdeUtils.bindActions(this.pane, this.actions);
        this.menu.add(new JMenuItem(this.actions.copy));
        this.menu.add(new JMenuItem(this.actions.cut));
        this.menu.add(new JMenuItem(this.actions.paste));
        this.menu.add(new JMenuItem(this.actions.selectAll));
        this.menu.addSeparator();
        JMenu addMenu = new JMenu("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        addMenu.add(new JMenuItem(this.actions.addNumber));
        addMenu.add(new JMenuItem(this.actions.addVariable));
        addMenu.add(new JMenuItem(this.actions.addBlock));
        addMenu.add(new JMenuItem(this.actions.addCommentT));
        addMenu.add(new JMenuItem(this.actions.addCommentR));
        this.menu.add(addMenu);
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.moveLeft));
        this.menu.add(new JMenuItem(this.actions.moveRight));
        this.menu.add(new JMenuItem(this.actions.moveUp));
        this.menu.add(new JMenuItem(this.actions.moveDown));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.delete));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.editOrder));
        this.menu.add(new JMenuItem(this.actions.changeVar));
        this.menu.add(new JMenuItem(this.actions.editProps));
        this.toolBar.add(this.actions.copy).setFocusable(false);
        this.toolBar.add(this.actions.cut).setFocusable(false);
        this.toolBar.add(this.actions.paste).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.addPopup).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.delete).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.editProps).setFocusable(false);
        this.popupItem = new JPopupMenu();
        this.popupItem.add(new JMenuItem(this.actions.copy));
        this.popupItem.add(new JMenuItem(this.actions.cut));
        this.popupItem.add(new JMenuItem(this.actions.paste));
        this.popupItem.addSeparator();
        this.popupItem.add(new JMenuItem(this.actions.moveLeft));
        this.popupItem.add(new JMenuItem(this.actions.moveRight));
        this.popupItem.add(new JMenuItem(this.actions.moveUp));
        this.popupItem.add(new JMenuItem(this.actions.moveDown));
        this.popupItem.addSeparator();
        this.popupItem.add(new JMenuItem(this.actions.delete));
        this.popupItem.addSeparator();
        this.popupItem.add(new JMenuItem(this.actions.editOrder));
        this.popupItem.add(new JMenuItem(this.actions.changeVar));
        this.popupItem.add(new JMenuItem(this.actions.editProps));
        this.popupItem.addSeparator();
        this.popupItem.add(new JMenuItem(this.actions.itemHelp));
        this.popupComment = new JPopupMenu();
        this.popupComment.add(new JMenuItem(this.actions.copy));
        this.popupComment.add(new JMenuItem(this.actions.cut));
        this.popupComment.add(new JMenuItem(this.actions.paste));
        this.popupComment.addSeparator();
        this.popupComment.add(new JMenuItem(this.actions.delete));
        this.popupComment.addSeparator();
        this.popupComment.add(new JMenuItem(this.actions.editComment));
        this.popupEmpty = new JPopupMenu();
        this.popupEmpty.add(new JMenuItem(this.actions.paste));
        this.popupEmpty.add(new JMenuItem(this.actions.selectAll));
        this.popupEmpty.addSeparator();
        this.popupEmpty.add(new JMenuItem(this.actions.addNumber));
        this.popupEmpty.add(new JMenuItem(this.actions.addVariable));
        this.popupEmpty.add(new JMenuItem(this.actions.addBlock));
        this.popupEmpty.add(new JMenuItem(this.actions.addCommentT));
        this.popupEmpty.add(new JMenuItem(this.actions.addCommentR));
        this.popupPage = new JPopupMenu();
        this.popupPage.add(new JMenuItem(this.pageActions.editPage));
        this.popupPage.add(new JMenuItem(this.pageActions.addPage));
        this.popupPage.addSeparator();
        this.popupPage.add(new JMenuItem(this.pageActions.copy));
        this.popupPage.add(new JMenuItem(this.pageActions.cut));
        this.popupPage.add(new JMenuItem(this.pageActions.paste));
        this.popupPage.addSeparator();
        this.popupPage.add(new JMenuItem(this.pageActions.deletePage));
        this.popupPage.addSeparator();
        this.popupPage.add(new JMenuItem(this.pageActions.movePageUp));
        this.popupPage.add(new JMenuItem(this.pageActions.movePageDown));
        this.popupPageEmpty = new JPopupMenu();
        this.popupPageEmpty.add(new JMenuItem(this.pageActions.addPage));
        this.popupPageEmpty.add(new JMenuItem(this.pageActions.paste));
        this.popupInPin = new JPopupMenu();
        this.popupInPin.add(new JMenuItem(this.actions.connectNum));
        this.popupInPin.add(new JMenuItem(this.actions.connectVar));
        return this.actions;
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    void scrollPaneToRect(int x, int y, int w, int h) {
        this.scrollRect.x = x * this.zoom / 100;
        this.scrollRect.y = y * this.zoom / 100;
        this.scrollRect.width = w * this.zoom / 100;
        this.scrollRect.height = h * this.zoom / 100;
        this.pane.scrollRectToVisible(this.scrollRect);
    }

    void scrollPaneToRect(Rectangle r) {
        this.scrollPaneToRect(r.x, r.y, r.width, r.height);
    }

    void scrollToFocused() {
        if (this.focusedItem != null) {
            this.scrollPaneToRect(this.focusedItem.pxBounds);
        }
        if (this.focusedComment != null) {
            this.scrollPaneToRect(this.focusedComment.pxBounds);
        }
    }

    @Override
    public void setZoom(int zoom) {
        if (zoom < 20) {
            zoom = 20;
        }
        if (zoom > 200) {
            zoom = 200;
        }
        if (this.zoom != zoom) {
            this.zoom = zoom;
            this.saveProps();
            this.pane.updateSize();
            this.pane.updateZoom();
            this.pane.repaint();
            this.scrollToFocused();
        }
    }

    protected void clearFocus() {
        this.hoveredView = null;
        this.focusedView = null;
        this.focusedComment = null;
        this.focusedItem = null;
        this.hoveredPin = null;
        this.currentTipText = null;
    }

    public void deleteSelected() {
        if (this.page != null) {
            if (this.page.selectedList.size() > 1 && !IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b (" + this.page.selectedList.size() + " \u0448\u0442.)?")) {
                return;
            }
            for (AFbdView view : this.page.selectedList) {
                if (view instanceof AFbdItem) {
                    this.page.removeItem((AFbdItem)view);
                    continue;
                }
                if (!this.page.comments.remove(view)) continue;
                this.markModified();
            }
            this.clearSelection();
            this.clearFocus();
            this.pane.updateSize();
            this.pane.repaint();
            IdeAction.updateAll();
        }
    }

    public void commitAction() {
        this.updateVarRefs();
        this.pane.updateSize();
        this.pane.repaint();
        this.saveState();
    }

    private void saveState() {
        IdeAction.updateAll();
    }

    protected void reset() {
        this.clearFocus();
        this.pagesModel.update();
        this.pagesList.setSelectedIndex(0);
        this.valueChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateHover(int x, int y) {
        if (this.page == null) {
            return false;
        }
        AFbdPin pin = this.page.getPinAt(x, y);
        AFbdView view = null;
        view = this.focusedView != null && this.focusedView.containsPx(x, y) ? this.focusedView : (pin == null ? this.page.getViewAtPx(x, y) : null);
        try {
            if (this.hoveredView != view || this.hoveredPin != pin) {
                this.hoveredView = view;
                this.hoveredPin = pin;
                this.currentTipText = this.hoveredView != null ? this.hoveredView.getTipText() : null;
                this.currentTipText = Utils.strEmpty(this.currentTipText) ? null : "<html>" + this.currentTipText + "</html>";
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.hoveredView instanceof FbdCommentRect && ((FbdCommentRect)this.hoveredView).isResizeArea(x, y)) {
                this.pane.setCursor(CURSOR_RESIZE);
            } else {
                this.pane.setCursor(null);
            }
        }
    }

    private boolean updateFocusedView(AFbdView view) {
        if (view == this.focusedView) {
            return false;
        }
        this.focusedView = view;
        this.focusedItem = null;
        this.focusedComment = null;
        if (view instanceof AFbdItem) {
            this.focusedItem = (AFbdItem)view;
        }
        if (view instanceof AFbdComment) {
            this.focusedComment = (AFbdComment)view;
        }
        IdeAction.updateAll();
        return true;
    }

    public boolean hasSelection() {
        return this.page != null && !this.page.selectedList.isEmpty();
    }

    public void selectAll() {
        this.clearSelection();
        if (this.page != null) {
            for (AFbdItem aFbdItem : this.page.items) {
                this.addToSelList(aFbdItem);
            }
            for (AFbdView aFbdView : this.page.comments) {
                this.addToSelList(aFbdView);
            }
        }
        IdeAction.updateAll();
        this.pane.repaint();
    }

    protected void clearSelection() {
        if (this.page != null) {
            for (AFbdView view : this.page.selectedList) {
                view.selected = false;
            }
            this.page.selectedList.clear();
        }
    }

    public boolean unselectAll() {
        if (this.page != null && this.page.selectedList.size() > 0) {
            this.clearSelection();
            IdeAction.updateAll();
            return true;
        }
        return false;
    }

    private void addToSelList(AFbdView view) {
        if (this.page != null) {
            view.selected = true;
            this.page.selectedList.add(view);
        }
    }

    private void removeFromSelList(AFbdView view) {
        if (this.page != null) {
            view.selected = false;
            this.page.selectedList.remove(view);
        }
    }

    public boolean selectItem(AFbdView view, boolean addRemove) {
        if (view == null) {
            return false;
        }
        if (addRemove) {
            if (!view.selected) {
                this.addToSelList(view);
            } else {
                this.removeFromSelList(view);
            }
            IdeAction.updateAll();
            return true;
        }
        if (!view.selected) {
            this.clearSelection();
            this.addToSelList(view);
            IdeAction.updateAll();
            return true;
        }
        return false;
    }

    private boolean updateSelection(AFbdView view, boolean addRemove) {
        if (view != null) {
            return this.selectItem(view, addRemove);
        }
        if (!addRemove) {
            return this.unselectAll();
        }
        return false;
    }

    @Override
    public void clear() {
        this.reset();
    }

    private void startConnecting(int x, int y) {
        this.connecting = true;
        this.updateConnectionTarget(x, y);
        if (this.hoveredPin instanceof InputPin) {
            this.oldTargetPin = (InputPin)this.hoveredPin;
            this.sourcePin = this.oldTargetPin.getSource();
        } else {
            this.sourcePin = (OutputPin)this.hoveredPin;
            this.oldTargetPin = null;
        }
        if (this.sourcePin == null) {
            this.endConnecting(false);
        }
        this.newTargetPin = this.oldTargetPin;
    }

    private void updateConnectionTarget(int x, int y) {
        InputPin in;
        this.targetPoint.x = x;
        this.targetPoint.y = y;
        this.newTargetPin = null;
        this.connRect.x = x;
        this.connRect.y = y - 5;
        this.connRect.width = 11;
        this.connRect.height = 11;
        AFbdPin pin = this.page.getPinAt(this.connRect);
        if (pin instanceof InputPin && (in = (InputPin)pin).canConnectSource(this.sourcePin)) {
            Point tp = in.getLinkPoint();
            this.targetPoint.x = tp.x;
            this.targetPoint.y = tp.y;
            this.newTargetPin = in;
        }
    }

    private InputPin createConnection(OutputPin source, InputPin target) {
        if (source.type != target.type) {
            return null;
        }
        if (target.owner instanceof FbdVariable && (source.owner instanceof FbdVariable || source.owner instanceof FbdNumber)) {
            try {
                int i;
                AbstractOperation b;
                if (source.type == 1) {
                    b = new MoveB(this.page, null);
                } else if (source.type == 2) {
                    b = new MoveI(this.page, null);
                } else if (source.type == 3) {
                    b = new MoveF(this.page, null);
                } else {
                    return null;
                }
                Rectangle r = target.owner.cellBounds;
                b.cellBounds.y = r.y - (b.padTop - target.owner.padTop);
                b.cellBounds.x = Math.max(r.x - b.cellBounds.width, 0);
                if (this.page.hasItemsAtCells(b.cellBounds)) {
                    b.cellBounds.x = r.x;
                    for (i = 0; i < b.cellBounds.width; ++i) {
                        target.owner.pushX(true, false, false);
                    }
                }
                for (i = 0; this.page.hasItemsAtCells(b.cellBounds) && i < b.cellBounds.height; ++i) {
                    b.pushY(true, false, false);
                }
                this.page.addItem(b);
                InputPin input = b.inputs.get(0);
                input.connectSource(source);
                target.connectSource(b.outputs.get(0));
                return input;
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
                return null;
            }
        }
        target.connectSource(source);
        return target;
    }

    private void endConnecting(boolean apply) {
        if (this.connecting && apply && this.sourcePin != null && this.newTargetPin != this.oldTargetPin) {
            if (this.oldTargetPin != null) {
                this.oldTargetPin.connectSource(null);
            }
            if (this.newTargetPin != null) {
                this.createConnection(this.sourcePin, this.newTargetPin);
            }
        }
        this.connecting = false;
        this.sourcePin = null;
        this.oldTargetPin = null;
        this.newTargetPin = null;
        if (apply) {
            this.commitAction();
        } else {
            this.pane.repaint();
            IdeAction.updateAll();
        }
    }

    private void startDragging(int x, int y, AFbdItem item) {
        if (this.page == null) {
            return;
        }
        this.draggingItem = true;
        this.dragAdding = !this.page.items.contains(item);
        this.dragItem = item;
        this.dragDX = item.pxBounds.x + 13 - x;
        this.dragDY = item.pxBounds.y + 13 - y;
        this.dragRect.width = item.cellBounds.width;
        this.dragRect.height = item.cellBounds.height;
        this.dragLeftGap = item.padLeft;
        this.dragTopGap = item.padTop;
        this.updateDragRect(x, y);
        this.clearFocus();
        this.pane.repaint();
        IdeAction.updateAll();
    }

    private void updateDragRect(int x, int y) {
        this.dragRect.x = Math.max((x + this.dragDX) / 27 - this.dragLeftGap, 0);
        this.dragRect.y = Math.max((y + this.dragDY) / 27 - this.dragTopGap, 0);
        this.dragAllowed = true;
        for (AFbdItem item : this.page.items) {
            if (item == this.dragItem || !item.cellBounds.intersects(this.dragRect)) continue;
            this.dragAllowed = false;
            break;
        }
    }

    private void endDragging(boolean apply) {
        if (this.dragItem != null) {
            if (apply) {
                this.dragItem.setCellPosition(this.dragRect.x, this.dragRect.y);
                this.selectItem(this.dragItem, false);
                if (!this.page.items.contains(this.dragItem)) {
                    this.page.addItem(this.dragItem);
                }
                this.pane.requestFocusInWindow();
            } else if (!this.page.items.contains(this.dragItem)) {
                this.dragItem.disconnectAll();
            }
            this.focusedItem = this.dragItem;
            this.focusedView = this.focusedItem;
        }
        this.connectingInputPin = null;
        this.focusedComment = null;
        this.draggingItem = false;
        this.dragItem = null;
        this.hoveredPin = null;
        this.hoveredView = null;
        this.currentTipText = null;
        if (apply) {
            this.commitAction();
        } else {
            this.pane.repaint();
            IdeAction.updateAll();
        }
        this.scrollToFocused();
    }

    private void startDragComment(int x, int y, AFbdView cmt) {
        if (this.page == null) {
            return;
        }
        this.dragComment = cmt;
        boolean bl = this.dragCmtResize = this.dragComment instanceof FbdCommentRect && this.pane.getCursor() == CURSOR_RESIZE;
        if (this.dragCmtResize) {
            this.dragCmtDX = cmt.pxBounds.width - x;
            this.dragCmtDY = cmt.pxBounds.height - y;
        } else {
            this.dragCmtDX = cmt.pxBounds.x - x;
            this.dragCmtDY = cmt.pxBounds.y - y;
        }
        this.pane.repaint();
    }

    private void updateDragComment(int x, int y) {
        if (this.dragCmtResize) {
            this.dragComment.setPxSize(x + this.dragCmtDX, y + this.dragCmtDY);
        } else {
            this.dragComment.setPxPosition(x + this.dragCmtDX, y + this.dragCmtDY);
        }
        this.pane.repaint();
    }

    private void endDragComment() {
        this.dragComment = null;
        this.pane.updateSize();
        IdeAction.updateAll();
    }

    private boolean inputPinPopup(Component invoker, int x, int y) {
        if (this.hoveredPin instanceof InputPin) {
            this.connectingInputPin = (InputPin)this.hoveredPin;
            if (this.connectingInputPin.getSource() == null) {
                this.popupInPin.show(invoker, x, y);
                return true;
            }
            this.connectingInputPin = null;
        }
        return false;
    }

    private void showPopup(Component invoker, int x, int y) {
        this.popupX = x;
        this.popupY = y;
        if (this.hoveredPin instanceof AFbdPin) {
            this.inputPinPopup(invoker, x, y);
            return;
        }
        if (this.focusedItem != null) {
            this.popupItem.show(invoker, x, y);
        } else if (this.focusedComment != null) {
            this.popupComment.show(invoker, x, y);
        } else {
            this.popupEmpty.show(invoker, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        this.panning = false;
        this.pane.requestFocusInWindow();
        try {
            this.dragStartView = null;
            if (this.page == null) {
                return;
            }
            if (this.connecting) {
                this.endConnecting(SwingUtilities.isLeftMouseButton(e));
                return;
            }
            if (this.draggingItem) {
                this.endDragging(this.dragAllowed && SwingUtilities.isLeftMouseButton(e));
                return;
            }
            if (this.dragComment != null) {
                this.endDragComment();
                return;
            }
            this.mouseDown = true;
            int mX = e.getX() * 100 / this.zoom;
            int mY = e.getY() * 100 / this.zoom;
            if (SwingUtilities.isMiddleMouseButton(e)) {
                this.panning = true;
                return;
            }
            this.connectingInputPin = null;
            this.updateHover(mX, mY);
            this.updateFocusedView(this.hoveredView);
            int keyMask = 192;
            this.updateSelection(this.focusedView, (e.getModifiersEx() & keyMask) != 0);
            if (this.hoveredPin != null) {
                if (this.inputPinPopup(e.getComponent(), e.getX(), e.getY())) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    this.startConnecting(mX, mY);
                } else {
                    return;
                }
            }
            if (e.isPopupTrigger()) {
                this.showPopup(e.getComponent(), e.getX(), e.getY());
                return;
            }
        }
        finally {
            this.pane.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragStartView = null;
        if (this.page == null) {
            return;
        }
        if (this.panning) {
            this.panning = false;
            return;
        }
        if (this.connecting) {
            this.endConnecting(true);
            return;
        }
        if (this.draggingItem) {
            this.endDragging(this.dragAllowed);
            return;
        }
        if (this.dragComment != null) {
            this.endDragComment();
            return;
        }
        if (!this.mouseDown) {
            this.mousePressed(e);
        }
        this.mouseDown = false;
        if (e.isPopupTrigger()) {
            this.showPopup(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            long now = System.currentTimeMillis();
            if (now - this.mouseUpClickTime <= (long)Main.DOUBLE_CLICK_TIME && this.prevFocusedView == this.focusedView) {
                if (this.actions.editProps.isEnabled()) {
                    Point p = e.getLocationOnScreen();
                    this.actions.editProps.perform(this.paneScroll, p.x, p.y);
                } else if (this.actions.editComment.isEnabled()) {
                    Point p = e.getLocationOnScreen();
                    this.actions.editComment.perform(this.paneScroll, p.x, p.y);
                }
                this.mouseUpClickTime = 0L;
            } else {
                this.mouseUpClickTime = now;
                this.prevFocusedView = this.focusedView;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.page == null) {
            return;
        }
        if (this.panning) {
            return;
        }
        this.autoscrollRect.x = e.getX();
        this.autoscrollRect.y = e.getY();
        this.pane.scrollRectToVisible(this.autoscrollRect);
        int x = e.getX() * 100 / this.zoom;
        int y = e.getY() * 100 / this.zoom;
        if (this.connecting) {
            this.updateConnectionTarget(x, y);
            this.pane.repaint();
            return;
        }
        if (this.draggingItem) {
            this.updateDragRect(x, y);
            this.pane.repaint();
            return;
        }
        if (this.dragComment != null) {
            this.updateDragComment(x, y);
            return;
        }
        if (this.focusedView != null) {
            if (this.focusedView == this.dragStartView) {
                if (Math.abs(this.dragStartX0 - x) >= 6 || Math.abs(this.dragStartY0 - y) >= 6) {
                    if (this.focusedItem != null) {
                        this.startDragging(this.dragStartX0, this.dragStartY0, this.focusedItem);
                    }
                    if (this.focusedComment != null) {
                        this.startDragComment(x, y, this.focusedComment);
                    }
                    this.pane.repaint();
                    return;
                }
            } else {
                this.dragStartView = this.focusedView;
                this.dragStartX0 = x;
                this.dragStartY0 = y;
                return;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.page == null) {
            return;
        }
        int x = e.getX() * 100 / this.zoom;
        int y = e.getY() * 100 / this.zoom;
        if (this.connecting) {
            this.updateConnectionTarget(x, y);
            this.pane.repaint();
            return;
        }
        if (this.draggingItem) {
            this.updateDragRect(x, y);
            this.pane.repaint();
            return;
        }
        if (this.dragComment != null) {
            this.updateDragComment(x, y);
            return;
        }
        if (this.updateHover(x, y)) {
            this.pane.repaint();
        }
    }

    @Override
    public void initNewProgram() {
        this.pages.clear();
        this.pages.add(new FbdPage(this, DEF_PAGE_NAME));
        this.reset();
        this.updateVarRefs();
    }

    private void loadFbdPages(JSONObject json) throws JSONException, FbdLoadError {
        this.pages.clear();
        JSONArray jsonPages = json.getJSONArray("pages");
        for (int i = 0; i < jsonPages.length(); ++i) {
            this.pages.add(new FbdPage(this, jsonPages.getJSONObject(i), false));
        }
        if (this.pages.isEmpty()) {
            this.pages.add(new FbdPage(this, DEF_PAGE_NAME));
        }
    }

    @Override
    public void loadProgram(JSONObject json, int version) throws JSONException, FbdLoadError {
        this.loadFbdPages(json);
        this.reset();
        this.updateVarRefs();
    }

    private void saveFbdPages(JSONObject main) {
        JSONArray jsonPages = new JSONArray();
        main.remove("pages");
        main.put("pages", jsonPages);
        for (FbdPage p : this.pages) {
            JSONObject jso = new JSONObject();
            p.saveToJson(jso, null);
            jsonPages.put(jso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProgram(JSONObject json) throws SyntaxError, ErrorInFile {
        if (json != null) {
            this.saveFbdPages(json);
        }
        this.constNumbers.clear();
        this.localVars.clear();
        this.globalVars.clear();
        this.bOne = this.mainFrame.program.Constants.createSimpleVar("__bOne", 1, false, -1);
        this.bOne.initValue = 1.0;
        this.bNull = this.mainFrame.program.Constants.createSimpleVar("__bNull", 1, false, -1);
        this.iNull = this.mainFrame.program.Constants.createSimpleVar("__iNull", 2, false, -1);
        this.fNull = this.mainFrame.program.Constants.createSimpleVar("__fNull", 3, false, -1);
        for (FbdPage p : this.pages) {
            p.compileVars();
        }
        ArrayList<String> code = new ArrayList<String>();
        code.add(DEF_PAGE_NAME);
        int i = 1;
        for (FbdPage p : this.pages) {
            p.compileCode(code, i++);
        }
        this.mainFrame.program.Schedules.compileCode(code, this.bOne, this.mainFrame.program);
        this.mainFrame.program.archive.compileCode(code, this.bNull, this.mainFrame.program);
        code.add("EndMain");
        try {
            this.mainFrame.program.loadCode(code.toArray(new String[0]));
        }
        catch (Exception e) {
            try (PrintWriter pw = new PrintWriter(Utils.RootDir + File.separatorChar + "bad_code.dump", "UTF-8");){
                ExportSource.printSource(this.mainFrame.program, pw, false);
                pw.println("\nERROR: \n" + e.getMessage() + "\n");
                i = 1;
                for (String s : code) {
                    pw.println(i++ + ": " + s);
                }
            }
            catch (Exception ex) {
                Utils.ProcessException(ex, false);
            }
            throw e;
        }
    }

    @Override
    public void saveProps() {
        Main.props.saveInt(PROP_ZOOM, this.zoom);
        Main.props.saveInt(PROP_BLOCKS_SPLIT, this.blocksSplitter.getDividerLocation());
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearFbdRefs();
        for (FbdPage p : this.pages) {
            for (AFbdItem item : p.items) {
                if (!(item instanceof FbdVariable)) continue;
                ((FbdVariable)item).updateVarRef();
            }
        }
    }

    @Override
    public void updateVarList() {
    }

    @Override
    public void titleClicked() {
        this.initFocus();
    }

    @Override
    public void initFocus() {
        this.pane.requestFocusInWindow();
    }

    public Variable allocNumberConst(int type, double value) throws SyntaxError {
        for (Variable v : this.constNumbers) {
            if (v.type != type || v.initValue != value) continue;
            return v;
        }
        Variable v = this.mainFrame.program.Constants.createSimpleVar("__num" + (this.constNumbers.size() + 1), type, false, -1);
        v.initValue = value;
        this.constNumbers.add(v);
        return v;
    }

    public Variable allocGlobalVar(int type, double initValue) throws SyntaxError {
        return this.allocGlobalVar(type, initValue, false);
    }

    public Variable allocGlobalVar(int type, double initValue, boolean nv) throws SyntaxError {
        VariablesBlock vb = nv ? this.mainFrame.program.ExtVars : this.mainFrame.program.RamVars;
        Variable v = vb.createSimpleVar("__gvar" + (this.globalVars.size() + 1), type, false, -1);
        v.initValue = initValue;
        this.globalVars.add(v);
        return v;
    }

    protected void freeUsedLocalVars() {
        this.usedLocalVars.clear();
    }

    public Variable allocLocalVar(int type) throws SyntaxError {
        for (Variable v : this.localVars) {
            if (v.type != type || this.usedLocalVars.contains(v)) continue;
            this.usedLocalVars.add(v);
            return v;
        }
        Variable v = this.mainFrame.program.RamVars.createSimpleVar("__lvar" + (this.localVars.size() + 1), type, false, -1);
        this.localVars.add(v);
        this.usedLocalVars.add(v);
        return v;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.cancelMouseOperations();
        this.page = this.pagesList.getSelectedValue();
        this.setTitle("<html>\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 &quot;<b>" + (this.page != null ? this.page.getName() : "") + "</b>&quot;<html>");
        this.clearFocus();
        this.pane.updateSize();
        this.pane.repaint();
        IdeAction.updateAll();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancelMouseOperations();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void startInserting(AFbdItem item) {
        if (item == null) {
            return;
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point p2 = this.pane.getLocationOnScreen();
        p.translate(-p2.x, -p2.y);
        item.cellBounds.x = p.x / 27 - item.padLeft;
        item.cellBounds.y = p.y / 27 - item.padTop;
        item.updateBounds();
        this.startDragging(item.pxBounds.x + 13, item.pxBounds.y + 13, item);
    }

    public void createNumber() {
        if (this.page == null) {
            return;
        }
        this.cancelMouseOperations();
        try {
            this.startInserting(NumberCreateDialog.showDialog(this.page, this.paneScroll, -1, -1));
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
        }
    }

    public void createVariable() {
        if (this.page == null) {
            return;
        }
        this.cancelMouseOperations();
        try {
            this.startInserting(VariableCreateDialog.showDialog(this.page, this.paneScroll, -1, -1));
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
        }
    }

    public void createBlock() {
        if (this.page == null) {
            return;
        }
        this.cancelMouseOperations();
        try {
            this.startInserting(BlockCreateDialog.showDialog(this.page, this.paneScroll));
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
        }
    }

    public void createComment(boolean isText, int x, int y) {
        if (this.page == null) {
            return;
        }
        this.cancelMouseOperations();
        AFbdComment c = null;
        try {
            c = isText ? new FbdCommentText(this.page, null) : new FbdCommentRect(this.page, null);
        }
        catch (FbdLoadError | JSONException e) {
            Utils.ProcessException(e, false);
        }
        if (c != null) {
            this.pane.requestFocusInWindow();
            this.page.comments.add(c);
            if (x < 0 || y < 0) {
                Point p = this.paneScroll.getViewport().getViewPosition();
                x = p.x + 1;
                y = p.y + 1;
            }
            c.pxBounds.x = x;
            c.pxBounds.y = y;
            this.clearFocus();
            this.updateFocusedView(c);
            this.markModified();
            this.commitAction();
        }
    }

    private boolean fits(AFbdItem item, int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        item.cellBounds.x = x;
        item.cellBounds.y = y;
        for (AFbdItem t : this.page.items) {
            if (!t.cellBounds.intersects(item.cellBounds)) continue;
            return false;
        }
        return true;
    }

    public void connectNumber() {
        if (this.page == null || this.connectingInputPin == null) {
            return;
        }
        Point p = new Point(this.connectingInputPin.bounds.x, this.connectingInputPin.bounds.y);
        SwingUtilities.convertPointToScreen(p, this.pane);
        try {
            FbdNumber num = new FbdNumber(this.page, this.connectingInputPin.type);
            if (NumberEditDialog.showDialog(num, this.paneScroll, p.x, p.y)) {
                this.connectingInputPin = this.createConnection(num.outPin, this.connectingInputPin);
                if (this.connectingInputPin == null) {
                    return;
                }
                if (this.fits(num, this.connectingInputPin.owner.cellBounds.x - num.cellBounds.width, this.connectingInputPin.getCellY())) {
                    this.page.addItem(num);
                } else {
                    this.startInserting(num);
                }
            } else {
                this.connectingInputPin = null;
            }
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
        }
    }

    public void connectVariable() {
        if (this.page == null || this.connectingInputPin == null) {
            return;
        }
        Point p = new Point(this.connectingInputPin.bounds.x, this.connectingInputPin.bounds.y);
        SwingUtilities.convertPointToScreen(p, this.pane);
        try {
            VariableRef vr = VariableSelectDialog.showDialog(null, this.connectingInputPin.type, this.paneScroll, p.x, p.y);
            if (vr != null) {
                FbdVariable var = new FbdVariable(this.page, vr);
                this.connectingInputPin = this.createConnection(var.outPin, this.connectingInputPin);
                if (this.connectingInputPin == null) {
                    return;
                }
                if (this.fits(var, this.connectingInputPin.owner.cellBounds.x - var.cellBounds.width, this.connectingInputPin.getCellY())) {
                    this.page.addItem(var);
                } else {
                    this.startInserting(var);
                }
            } else {
                this.connectingInputPin = null;
            }
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
        }
    }

    public FbdPage currentPage() {
        return this.page;
    }

    public int getPageIndex() {
        return this.pagesList.getSelectedIndex();
    }

    public int getPagesCount() {
        return this.pages.size();
    }

    protected void cancelMouseOperations() {
        this.endConnecting(false);
        this.endDragging(false);
    }

    @Override
    public JComponent getLeftPane() {
        return this.blocksSplitter;
    }

    public void copyToClipboard(boolean cut) {
        this.cancelMouseOperations();
        if (this.hasSelection()) {
            ClipboardUtils.putData(this.saveForClipboard(this.page.selectedList), 'b');
            if (cut) {
                this.deleteSelected();
            }
        }
    }

    public void pasteFromClipboard() {
        this.cancelMouseOperations();
        JSONObject json = ClipboardUtils.getData('b');
        if (json != null) {
            try {
                this.loadFromClipboard(json);
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
            }
        }
    }

    private JSONObject saveForClipboard(List<AFbdView> list) {
        JSONObject jsonFbd = new JSONObject();
        ArrayList<VariableDef> vars = new ArrayList<VariableDef>();
        ArrayList<AFbdItem> items = new ArrayList<AFbdItem>();
        ArrayList<AFbdComment> comments = new ArrayList<AFbdComment>();
        for (AFbdView view : list) {
            if (view instanceof AFbdItem) {
                items.add((AFbdItem)view);
                continue;
            }
            if (!(view instanceof AFbdComment)) continue;
            comments.add((AFbdComment)view);
        }
        this.page.saveItemsToJSON(jsonFbd, items, vars, true);
        FbdPage.saveCommentsToJSON(jsonFbd, comments);
        JSONObject jsonClipboard = new JSONObject();
        VariablesEditor.saveToJson(jsonClipboard, vars);
        jsonClipboard.put(JSON_BLOCKS, jsonFbd);
        return jsonClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromClipboard(JSONObject json) throws SyntaxError, JSONException, FbdLoadError {
        List<AFbdView> added;
        JSONObject jso = json.optJSONObject(JSON_BLOCKS);
        if (jso == null) {
            return;
        }
        int startY = 0;
        for (AFbdItem item : this.page.items) {
            startY = Math.max(startY, item.pxBounds.y + item.pxBounds.height);
        }
        for (AFbdComment c : this.page.comments) {
            startY = Math.max(startY, c.pxBounds.y + c.pxBounds.height);
        }
        startY = (startY / 27 + 1) * 27;
        HashMap<String, String> varMap = new HashMap<String, String>();
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        if (!ved.loadFromClipboard(json, false, false, varMap)) {
            return;
        }
        ved.setVarMap(varMap);
        try {
            added = this.page.loadFromJson(jso, true, true);
        }
        finally {
            ved.setVarMap(null);
        }
        if (added.isEmpty()) {
            return;
        }
        if (added.size() == 1 && added.get(0) instanceof AFbdItem) {
            this.clearSelection();
            this.startInserting((AFbdItem)added.get(0));
            return;
        }
        this.markModified();
        for (AFbdView v : added) {
            if (v instanceof AFbdItem) {
                this.page.addItem((AFbdItem)v);
                continue;
            }
            if (!(v instanceof AFbdComment)) continue;
            this.page.comments.add((AFbdComment)v);
        }
        int x0 = Integer.MAX_VALUE;
        int y0 = Integer.MAX_VALUE;
        int w = 0;
        int h = 0;
        for (AFbdView view : added) {
            if (view instanceof AFbdItem) {
                x0 = Math.min(x0, ((AFbdItem)view).cellBounds.x);
                y0 = Math.min(y0, ((AFbdItem)view).cellBounds.y);
            } else {
                x0 = Math.min(x0, view.pxBounds.x / 27);
                y0 = Math.min(y0, view.pxBounds.y / 27);
            }
            w = Math.max(w, view.pxBounds.x + view.pxBounds.width);
            h = Math.max(h, view.pxBounds.y + view.pxBounds.height);
        }
        w -= (x0 *= 27);
        h -= (y0 *= 27);
        this.clearSelection();
        for (AFbdView view : added) {
            this.addToSelList(view);
            if (view instanceof AFbdItem) {
                AFbdItem item = (AFbdItem)view;
                item.cellBounds.x -= x0 / 27;
                item.cellBounds.y += (startY - y0) / 27;
                item.updateBounds();
                continue;
            }
            view.pxBounds.x -= x0;
            view.pxBounds.y += startY - y0;
        }
        this.pane.updateSize();
        if (!added.isEmpty()) {
            this.updateFocusedView(added.get(0));
        } else {
            this.updateFocusedView(null);
        }
        this.scrollPaneToRect(0, startY, w + 10, h + 10);
        this.pane.repaint();
    }

    public void copyPagesToClipboard(boolean cut) {
        this.cancelMouseOperations();
        if (this.page != null) {
            ArrayList<FbdPage> plist = new ArrayList<FbdPage>();
            plist.add(this.page);
            ClipboardUtils.putData(this.savePagesForClipboard(plist), 'b');
            if (cut) {
                this.deletePage();
            }
        }
    }

    public void pastePagesFromClipboard() {
        this.cancelMouseOperations();
        JSONObject json = ClipboardUtils.getData('b');
        if (json != null) {
            try {
                this.loadPagesFromClipboard(json);
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
            }
            this.markModified();
            this.commitAction();
        }
    }

    private JSONObject savePagesForClipboard(List<FbdPage> pages) {
        JSONArray jsonPages = new JSONArray();
        ArrayList<VariableDef> vars = new ArrayList<VariableDef>();
        for (FbdPage p : pages) {
            JSONObject jso = new JSONObject();
            p.saveToJson(jso, vars);
            jsonPages.put(jso);
        }
        JSONObject jsonClipboard = new JSONObject();
        VariablesEditor.saveToJson(jsonClipboard, vars);
        jsonClipboard.put("pages", jsonPages);
        return jsonClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPagesFromClipboard(JSONObject json) throws SyntaxError, JSONException, FbdLoadError {
        JSONArray jsa = json.optJSONArray("pages");
        if (jsa == null) {
            return;
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        if (!ved.loadFromClipboard(json, false, false, varMap)) {
            return;
        }
        ved.setVarMap(varMap);
        try {
            int index = this.pages.size();
            for (int i = 0; i < jsa.length(); ++i) {
                this.pages.add(new FbdPage(this, jsa.getJSONObject(i), true));
            }
            this.pagesModel.update();
            this.pagesList.setSelectedIndex(index);
        }
        finally {
            ved.setVarMap(null);
        }
    }

    public void deletePage() {
        if (this.page != null && this.getPagesCount() > 1) {
            if (!IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 '" + this.page.getName() + "'?")) {
                return;
            }
            this.cancelMouseOperations();
            this.pages.remove(this.page);
            this.pagesModel.update();
            if (this.pagesList.getSelectedIndex() == 0) {
                this.valueChanged(null);
            } else {
                this.pagesList.setSelectedIndex(0);
            }
            this.markModified();
            this.commitAction();
        }
    }

    public void updateVars() {
        for (FbdPage p : this.pages) {
            p.updateVars();
        }
        this.pane.repaint();
    }

    public void deleteVars(List<VariableDef> vars) {
        for (FbdPage p : this.pages) {
            p.deleteVars(vars);
        }
        this.pane.repaint();
    }

    class PagesListModel
    extends AbstractListModel<FbdPage> {
        private static final long serialVersionUID = 1L;

        PagesListModel() {
        }

        @Override
        public int getSize() {
            return FbdEditor.this.pages.size();
        }

        @Override
        public FbdPage getElementAt(int index) {
            return FbdEditor.this.pages.get(index);
        }

        void update() {
            this.fireContentsChanged(this, 0, FbdEditor.this.pages.size());
        }
    }

    class EditPane
    extends JComponent {
        private static final long serialVersionUID = 1L;
        Color GRID_COLOR = new Color(240, 240, 240);
        Stroke GRID_STROKE;
        Font EMPTY_FONT = new Font("Sans", 0, 24);
        Stroke EMPTY_STROKE = new BasicStroke(4.0f);
        final Stroke CONNECT_STROKE = new BasicStroke(2.0f);
        final Composite DRAG_COMP = AlphaComposite.getInstance(3, 0.4f);

        void updateZoom() {
            this.GRID_STROKE = new BasicStroke(100.0f / (float)FbdEditor.this.zoom);
        }

        EditPane() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return FbdEditor.this.currentTipText;
        }

        private void paintEmpty(Graphics2D g2d) {
            g2d.setColor(new Color(220, 220, 220));
            g2d.setFont(this.EMPTY_FONT);
            String s = "\u041f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u0441\u044e\u0434\u0430 \u0431\u043b\u043e\u043a\u0438 \u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435";
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(s, g2d);
            int x = Math.max(0, (this.getWidth() - (int)rect.getWidth() * FbdEditor.this.zoom / 100) / 2);
            int y = Math.max(0, (this.getHeight() - (int)rect.getHeight() * FbdEditor.this.zoom / 100) / 2);
            g2d.drawString(s, x * 100 / FbdEditor.this.zoom, y * 100 / FbdEditor.this.zoom);
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                FbdEditor.this.selVar = FbdEditor.this.mainFrame.getVarsEditor().getSelectedVariable();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.scale((double)FbdEditor.this.zoom / 100.0, (double)FbdEditor.this.zoom / 100.0);
                if (FbdEditor.this.page != null) {
                    if (FbdEditor.this.page.items.size() == 0 && FbdEditor.this.page.comments.size() == 0) {
                        this.paintEmpty(g2d);
                    }
                    for (AFbdItem aFbdItem : FbdEditor.this.page.items) {
                        aFbdItem.paintShape(g2d);
                    }
                    for (AFbdItem aFbdItem : FbdEditor.this.page.items) {
                        aFbdItem.paintLinks(g2d);
                    }
                    for (AFbdView aFbdView : FbdEditor.this.page.comments) {
                        aFbdView.paintShape(g2d);
                    }
                    if (FbdEditor.this.connecting) {
                        g2d.setStroke(this.CONNECT_STROKE);
                        g2d.setColor(FbdEditor.this.newTargetPin != null ? Color.GREEN : Color.RED);
                        FbdEditor.this.sourcePin.paintLink(g2d, FbdEditor.this.targetPoint);
                        FbdEditor.this.sourcePin.paintTarget(g2d, FbdEditor.this.targetPoint, true, FbdEditor.this.newTargetPin != null);
                        FbdEditor.this.sourcePin.paintSource(g2d);
                    }
                    if (FbdEditor.this.draggingItem) {
                        g2d.setColor(FbdEditor.this.dragAllowed ? Color.GREEN : Color.RED);
                        Composite cmp = g2d.getComposite();
                        g2d.setComposite(this.DRAG_COMP);
                        g2d.fillRect((((FbdEditor)FbdEditor.this).dragRect.x + FbdEditor.this.dragLeftGap) * 27, (((FbdEditor)FbdEditor.this).dragRect.y + FbdEditor.this.dragTopGap) * 27, (((FbdEditor)FbdEditor.this).dragRect.width - FbdEditor.this.dragLeftGap) * 27, (((FbdEditor)FbdEditor.this).dragRect.height - FbdEditor.this.dragTopGap) * 27);
                        if (!FbdEditor.this.dragAdding) {
                            g2d.setColor(Color.ORANGE);
                            Rectangle rectangle = FbdEditor.this.dragItem.pxBounds;
                            g2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        g2d.setComposite(cmp);
                    }
                }
            }
            catch (Throwable e) {
                Utils.ProcessException(e, true);
            }
        }

        protected void updateSize() {
            int w = 10;
            int h = 10;
            if (FbdEditor.this.page != null) {
                for (AFbdItem item : FbdEditor.this.page.items) {
                    Rectangle cb = item.cellBounds;
                    if (cb.x < 0) {
                        cb.x = 0;
                    }
                    if (cb.y < 0) {
                        cb.y = 0;
                    }
                    w = Math.max(w, cb.x + cb.width + 4);
                    h = Math.max(h, cb.y + cb.height + 4);
                }
                w *= 27;
                h *= 27;
                for (AFbdComment c : FbdEditor.this.page.comments) {
                    Rectangle pb = c.pxBounds;
                    w = Math.max(w, pb.x + pb.width + 60);
                    h = Math.max(h, pb.y + pb.height + 60);
                }
            }
            this.setPreferredSize(new Dimension(w * FbdEditor.this.zoom / 100, h * FbdEditor.this.zoom / 100));
            this.setSize(this.getPreferredSize());
        }
    }

    public static class AddingItem
    implements Transferable {
        public static final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + AFbdItem.class.getName(), "FBD item");
        private static final DataFlavor[] flavors = new DataFlavor[]{FLAVOR};
        AFbdItem data;

        public AddingItem(AFbdItem data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

