/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.ModbusMasterBlock;
import certa.vics.compiler.ModbusSlaveBlock;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;

public class ModbusBlock {
    private ModbusSlaveBlock slave;
    private ModbusMasterBlock master;
    private Variable dumb;

    public void init(boolean isMaster) {
        this.master = null;
        this.slave = null;
        if (isMaster) {
            this.master = new ModbusMasterBlock();
            this.master.clear();
        } else {
            this.slave = new ModbusSlaveBlock();
            this.slave.clear(this.dumb);
        }
    }

    public boolean isMaster() {
        return this.master != null;
    }

    public ModbusSlaveBlock slave() {
        return this.slave;
    }

    public ModbusMasterBlock master() {
        return this.master;
    }

    public void clear(Variable dumb) {
        this.dumb = dumb;
        if (this.master != null) {
            this.master.clear();
        }
        if (this.slave != null) {
            this.slave.clear(dumb);
        }
    }

    protected void resolveLinks(Program prg) throws SyntaxError {
        if (this.master != null) {
            this.master.resolveLinks(prg);
        }
        if (this.slave != null) {
            this.slave.resolveLinks(prg);
        }
    }

    public int getSize() {
        if (this.master != null) {
            return this.master.getFlashSize();
        }
        if (this.slave != null) {
            return this.slave.getFlashSize();
        }
        return 0;
    }

    public int fillFlash(byte[] buf, int offset) throws SyntaxError {
        if (this.master != null) {
            return this.master.fillFlash(buf, offset);
        }
        if (this.slave != null) {
            return this.slave.fillFlash(buf, offset);
        }
        return offset;
    }
}

