/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.Variable;
import certa.vics.modbus.FlashModbusClient;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flash {
    private static final Logger log = LoggerFactory.getLogger(Flash.class);
    public final Program program;
    private static final int CHUNK_SIZE = 248;
    static final int MEM_FLASH = 0;
    static final int MEM_EEPROM = 1;
    static final int MEM_NVRAM = 2;
    static final int MEM_EXT_EEPROM = 3;
    byte[] readFlash;
    byte[] readStore;
    byte[] readExt;
    private ProgressListener listener;
    private int step;

    public Flash(Program program) {
        this.program = program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProgram(String comPort, int id, int password) throws Exception {
        this.program.makeBinaryData();
        System.out.println("Source: " + this.program.getSourceFile());
        System.out.println();
        System.out.println("Memory usage (bytes)");
        System.out.println("  RAM:          " + this.program.getRamSize() + ",   (max: " + this.program.device.RamSize + ")");
        System.out.println("  EEPROM:       " + this.program.getStoreSize() + ",   (max: " + this.program.device.EepromSize + ")");
        System.out.println("  NVRAM:        " + this.program.getExtSize() + ",   (max: " + this.program.device.NvramSize + ")");
        System.out.println("  FLASH:        " + this.program.getFlashSize() + ",   (max: " + this.program.device.FlashSize + ")");
        System.out.println("    code:         " + this.program.getAllCodeSize());
        System.out.println("    modbus:       " + this.program.getModbusSize());
        System.out.println("    RAM init:     " + this.program.getRamInitSize());
        System.out.println("    windows:      " + this.program.getWindowsSize());
        System.out.println("    arc. strings: " + this.program.archive.getFlashSize());
        System.out.println("    constants:    " + this.program.getConstSize());
        System.out.println();
        System.out.println("Writing program (" + comPort + ", id:" + id + ", password=" + password + "). Press Ctrl+C to break.");
        System.out.println();
        try (FlashModbusClient mc = new FlashModbusClient();){
            mc.setTransport(new RtuTransportJSerialComm(comPort, 9600, 8, 0, 2, 2000, 1000));
            System.out.println("Enter programming mode...");
            this.setWriteMode(mc, id, password, true);
            System.out.println("FLASH...");
            this.writeFlash(mc, id);
            System.out.println("EEPROM...");
            this.writeIntEeprom(mc, id);
            System.out.println("NVRAM...");
            this.writeNvRam(mc, id);
            System.out.println("External EEPROM...");
            this.writeExtEeprom(mc, id);
            System.out.println("Exit programming mode...");
            this.setWriteMode(mc, id, password, false);
            System.out.println("OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashBinaryData(ModbusClientTransport transport, int id, int password) throws Exception {
        try (FlashModbusClient mc = new FlashModbusClient();){
            mc.setTransport(transport);
            this.setWriteMode(mc, id, password, true);
            this.writeFlash(mc, id);
            this.writeIntEeprom(mc, id);
            this.writeNvRam(mc, id);
            this.writeExtEeprom(mc, id);
            this.setWriteMode(mc, id, password, false);
        }
    }

    private void resetWriteMode(FlashModbusClient mc, int id, int password) throws Exception {
        mc.InitSetWriteModeRequest(id, password, false);
        mc.execRequest();
    }

    public void setWriteMode(FlashModbusClient mc, int id, int password, boolean writeMode) throws Exception {
        int attempt = 0;
        if (mc != null) {
            block9: {
                log.info("Setting write mode to {}", (Object)writeMode);
                while (true) {
                    boolean exception;
                    mc.InitSetWriteModeRequest(id, password, writeMode);
                    if (mc.execRequest()) {
                        int model = mc.readInt16FromPDU(4, true);
                        int fw = mc.readInt16FromPDU(6, true);
                        log.info("OK. Model: {}, firmware: {}", (Object)model, (Object)fw);
                        if (this.program != null && this.program.device != null) {
                            if (model != this.program.device.ModelId) {
                                this.resetWriteMode(mc, id, password);
                                throw new Exception("Incompatible device model");
                            }
                            if (fw != this.program.device.Firmware) {
                                this.resetWriteMode(mc, id, password);
                                throw new Exception("Incompatible firmware");
                            }
                        }
                        break block9;
                    }
                    boolean bl = exception = mc.getResult() == 2;
                    if (exception && mc.getExceptionCode() == 16) {
                        throw new Exception("Wrong password (error 16)");
                    }
                    if (!exception || mc.getExceptionCode() != 17) break;
                    if (++attempt > 10) {
                        throw new Exception("Timeout while entering write mode");
                    }
                    log.warn("Need more time (error 17)");
                    Thread.sleep(500L);
                }
                throw new Exception(mc.getResultAsString());
            }
            this.notifyStep();
        } else {
            ++this.step;
        }
    }

    private int pagesCount(int bytesCount) {
        int i = bytesCount / 256;
        if (bytesCount % 256 > 0) {
            ++i;
        }
        return i;
    }

    private byte[] preparePage(int offset) {
        byte[] page = new byte[256];
        Arrays.fill(page, (byte)-1);
        for (int i = 0; i < 256 && i + offset < this.program.flash.length; ++i) {
            page[i] = this.program.flash[i + offset];
        }
        return page;
    }

    private void writeFlashPage(FlashModbusClient mc, int id, int pageNum, byte[] data) throws Exception {
        if (mc != null) {
            log.info("Send part 1 of page {}", (Object)pageNum);
            mc.InitStoreFlashHalfPageRequest(id, pageNum, data, false);
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
            this.notifyStep();
            log.info("Send part 2 of page {}", (Object)pageNum);
            mc.InitStoreFlashHalfPageRequest(id, pageNum, data, true);
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
            this.notifyStep();
            log.info("Write page {} to flash", (Object)pageNum);
            mc.InitWriteFlashPageRequest(id, pageNum);
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
            this.notifyStep();
        } else {
            this.step += 3;
        }
    }

    public void writeFlash(FlashModbusClient mc, int id) throws Exception {
        if (this.program.flashGapSize == 0) {
            for (int i = 0; i < this.pagesCount(this.program.flash.length); ++i) {
                this.writeFlashPage(mc, id, i, this.preparePage(i * 256));
            }
        } else {
            for (int i = 0; i < this.pagesCount(this.program.getFlashSize() - this.program.getConstSize() + 6); ++i) {
                this.writeFlashPage(mc, id, i, this.preparePage(i * 256));
            }
            int constOffset = this.program.Constants.startAddress - this.program.device.FlashStart;
            int pageOffset = constOffset / 256;
            for (int i = 0; i < this.pagesCount(this.program.getConstSize()); ++i) {
                this.writeFlashPage(mc, id, pageOffset + i, this.preparePage(constOffset + i * 256));
            }
        }
    }

    private int chunksCount(int bytesCount) {
        int i = bytesCount / 248;
        if (bytesCount % 248 > 0) {
            ++i;
        }
        return i;
    }

    private void writeChunk(FlashModbusClient mc, int id, byte[] data, int chunk, int startAddr, int memType, int dataSize) throws Exception {
        if (mc != null) {
            int addr = chunk * 248;
            byte[] cdata = Arrays.copyOfRange(data, addr, addr + Math.min(248, dataSize - addr));
            addr += startAddr;
            if (memType == 2) {
                log.info("Write {} bytes to NVRAM at {} (chunk {})", cdata.length, addr, chunk + 1);
                mc.InitWriteNvramRequest(id, addr, cdata);
            } else if (memType == 3) {
                log.info("Write {} bytes to External EEPROM at {} (chunk {})", cdata.length, addr, chunk + 1);
                mc.InitWriteExtEepromRequest(id, addr, cdata);
            } else {
                log.info("Write {} bytes to Internal EEPROM at {} (chunk {})", cdata.length, addr, chunk + 1);
                mc.InitWriteIntEepromRequest(id, addr, cdata);
            }
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
            this.notifyStep();
        } else {
            ++this.step;
        }
    }

    public void writeIntEeprom(FlashModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysStoreVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 1, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.store.length); ++i) {
            this.writeChunk(mc, id, this.program.store, i, this.program.StoreVars.startAddress & 0x3FFF, 1, this.program.store.length);
        }
    }

    public void writeNvRam(FlashModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysExtVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 2, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.ext.length); ++i) {
            this.writeChunk(mc, id, this.program.ext, i, this.program.ExtVars.startAddress & 0x3FFF, 2, this.program.ext.length);
        }
    }

    public void writeExtEeprom(FlashModbusClient mc, int id) throws Exception {
        if (!this.program.hasSchedule()) {
            return;
        }
        int block = 512;
        for (int i = 0; i < this.program.Schedules.items.length; ++i) {
            Schedule s = this.program.Schedules.items[i];
            if (s.var == null) continue;
            byte[] data = Arrays.copyOfRange(this.program.Schedules.eeprom, block * i, block * (i + 1));
            for (int j = 0; j < this.chunksCount(block); ++j) {
                this.writeChunk(mc, id, data, j, this.program.device.ExtEepromScheduleStart + block * i, 3, block);
            }
        }
    }

    private void readChunk(FlashModbusClient mc, int id, int memType, int chunk, byte[] buf, int memStart) throws Exception {
        int offset = chunk * 248;
        int size = Math.min(248, buf.length - offset);
        System.out.println("Read part " + (chunk + 1) + ", " + size + " bytes");
        if (memType == 0) {
            mc.InitReadFlashRequest(id, memStart + offset, size);
        } else if (memType == 1) {
            mc.InitReadIntEepromRequest(id, memStart + offset, size);
        } else if (memType == 2) {
            mc.InitReadNvramRequest(id, memStart + offset, size);
        } else {
            throw new IllegalStateException("MemType=" + memType);
        }
        if (!mc.execRequest()) {
            throw new Exception(mc.getResultAsString());
        }
        mc.readFromPdu(4, size, buf, offset);
    }

    private void read(FlashModbusClient mc, int id, int memType) throws Exception {
        int memStart;
        byte[] buf;
        if (memType == 0) {
            buf = this.readFlash;
            memStart = this.program.device.FlashStart;
        } else if (memType == 1) {
            buf = this.readStore;
            memStart = this.program.device.EepromStart & 0x3FFF;
        } else if (memType == 2) {
            buf = this.readExt;
            memStart = this.program.device.NvramStart & 0x3FFF;
        } else {
            throw new IllegalStateException("MemType=" + memType);
        }
        for (int i = 0; i < this.chunksCount(buf.length); ++i) {
            this.readChunk(mc, id, memType, i, buf, memStart);
        }
        System.out.println("OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProgram(String comPort, int id, int password, int speed) throws Exception {
        System.out.println("Reading program (" + comPort + ", speed: " + speed + " id:" + id + ", password=" + password + "). Press Ctrl+C to break.");
        System.out.println();
        this.readFlash = new byte[this.program.device.FlashSize];
        this.readStore = new byte[this.program.device.EepromSize];
        this.readExt = new byte[this.program.device.NvramSize];
        try (FlashModbusClient mc = new FlashModbusClient();){
            mc.setTransport(new RtuTransportJSerialComm(comPort, speed, 8, 0, 2, 1000, 100));
            System.out.println("Enter programming mode...");
            this.setWriteMode(mc, id, password, true);
            System.out.println("Reading FLASH...");
            this.read(mc, id, 0);
            System.out.println("Reading EEPROM...");
            this.read(mc, id, 1);
            System.out.println("Reading NVRAM...");
            this.read(mc, id, 2);
            System.out.println("Exit programming mode...");
            this.setWriteMode(mc, id, password, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBinFile(byte[] data, String fileName) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(fileName);){
            stream.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWriteStepsCount() {
        int res;
        int tmp = this.step;
        this.step = 0;
        try {
            try {
                this.setWriteMode(null, 0, 0, true);
                this.writeFlash(null, 0);
                this.writeIntEeprom(null, 0);
                this.writeNvRam(null, 0);
                this.writeExtEeprom(null, 0);
                this.setWriteMode(null, 0, 0, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            res = this.step;
            this.step = tmp;
        }
        return res;
    }

    public int getReadStepsCount() {
        return 10;
    }

    public void registerProgListener(ProgressListener listener) {
        this.listener = listener;
    }

    public int initWriteProgress() {
        return this.getWriteStepsCount();
    }

    public int initReadProgress() {
        return this.getReadStepsCount();
    }

    private void notifyStep() {
        ++this.step;
        if (this.listener != null) {
            this.listener.updateStep(this.step);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Command line parameters: <COM_port> <speed> <id> <password> <filename>");
                return;
            }
            Flash flash = new Flash(new Program());
            if (args.length >= 6 && "read".equalsIgnoreCase(args[5])) {
                flash.program.loadFromFile(args[3], true);
                flash.readProgram(args[0], Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[1]));
                flash.saveBinFile(flash.readFlash, "_flash.bin");
                flash.saveBinFile(flash.readStore, "_eeprom.bin");
                flash.saveBinFile(flash.readExt, "_nvram.bin");
            } else {
                flash.program.loadFromFile(args[4], true);
                flash.writeProgram(args[0], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            }
        }
        catch (NoSuchFileException e) {
            System.out.println("");
            System.out.println("ERROR. File not found: " + e.getMessage());
        }
        catch (Throwable e) {
            System.out.println("");
            System.out.println("ERROR (" + e.getClass().getName() + "): " + e.getMessage());
            System.out.println("");
            if (System.getProperty("debug") != null) {
                e.printStackTrace();
            }
            log.error("EXCEPTION", e);
        }
    }

    public static interface ProgressListener {
        public void updateStep(int var1);
    }
}

