/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.AlphanumComparator;
import certa.vics.Utils;
import certa.vics.compiler.Device;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.ClipboardUtils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.variables.RefList;
import certa.vics.ide.variables.SysVariableDialog;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariablePropsDialog;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesActions;
import certa.vics.ide.variables.VarsMapDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VariablesEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    private JPopupMenu popupMenu;
    VariablesActions actions;
    protected final MainFrame mainFrame;
    final ArrayList<VariableDef> list = new ArrayList();
    protected JTable table;
    private VarTableModel model;
    protected JScrollPane scroll;
    TableRowSorter<VarTableModel> sorter;
    VarsFilter filter;
    IdeTableCellRenderer commentRender = new IdeTableCellRenderer(2, 8);
    JComboBox<String> cbxFilter;
    static final String[] FILTER = new String[]{"\u0412\u0441\u0435", "\u041e\u0431\u044b\u0447\u043d\u044b\u0435", "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435"};
    public static final String JSON_VARS_KEY = "variables";
    Map<String, String> varMap;
    static final String PROP_COL_WIDTH = "vars.colwidth";
    static final int COL_BLOCK = 0;
    static final int COL_TYPE = 1;
    static final int COL_NAME = 2;
    static final int COL_ARRAY = 3;
    static final int COL_INIT = 4;
    static final int COL_USED = 5;
    static final int COL_COMMENT = 6;
    static final int COL_VALUE = 7;
    static final int COL_ALARM = 8;
    static final int COL_ARCHIVE = 9;
    static final int COL_SCHEDULE = 10;
    static final int COL_MODBUS = 11;
    static final int COL_UI = 12;
    static final String[] COLUMNS = new String[]{"\u041f\u0430\u043c\u044f\u0442\u044c", "\u0422\u0438\u043f", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "\u041c\u0430\u0441\u0441\u0438\u0432", "\u041d\u0430\u0447. \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "\u0410\u0432\u0430\u0440\u0438\u044f", "\u0410\u0440\u0445\u0438\u0432", "\u0420\u0430\u0441\u043f.", "modbus", "\u041c\u0435\u043d\u044e"};
    static final int[] DEF_COLUMNS_W = new int[]{130, 50, 200, 50, 150, 70, 500, 75, 50, 50, 50, 55, 50};
    static final int[] COLUMN_ORDER = new int[]{2, 1, 0, 3, 4, 7, 5, 12, 11, 10, 9, 8, 6};

    public VariablesEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435");
        this.mainFrame = mainFrame;
        this.model = new VarTableModel();
        this.table = new JTable(this.model);
        this.setupTable();
        this.loadProps();
        this.scroll = new JScrollPane(this.table);
        this.add((Component)this.scroll, "Center");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        IdeUtils.bindActions(this.table, this.actions);
        this.scroll.addMouseListener(this.focuser);
        this.table.getTableHeader().addMouseListener(this.focuser);
    }

    private boolean showPopup(MouseEvent e) {
        if (e.isPopupTrigger() && e.getComponent() == this.table) {
            this.table.requestFocusInWindow();
            int r = this.table.rowAtPoint(e.getPoint());
            int c = this.table.columnAtPoint(e.getPoint());
            if (r >= 0 && c >= 0) {
                this.table.changeSelection(r, c, false, false);
            } else {
                this.table.clearSelection();
            }
            if (this.table.getSelectedRow() >= 0) {
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            return true;
        }
        return false;
    }

    private void setupTable() {
        int i;
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(2).setCellRenderer(new VarNameRender());
        cm.getColumn(0).setCellRenderer(new MemTypeRender());
        cm.getColumn(1).setCellRenderer(new VarTypeRender());
        cm.getColumn(3).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(4).setCellRenderer(new InitValueRender(4, 8));
        cm.getColumn(5).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(6).setCellRenderer(this.commentRender);
        cm.getColumn(8).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(9).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(10).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(11).setCellRenderer(new ArrayRender(0, 1));
        cm.getColumn(12).setCellRenderer(new ArrayRender(0, 1));
        for (i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn c = cm.getColumn(i);
            if (c.getCellRenderer() != null) continue;
            c.setCellRenderer(new IdeTableCellRenderer(2, 8));
        }
        this.hideColumn(cm.getColumn(7));
        this.hideColumn(cm.getColumn(8));
        this.hideColumn(cm.getColumn(3));
        IdeUtils.setColumnOrder(cm, COLUMN_ORDER);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VariablesEditor.this.actions.update();
                VariablesEditor.this.mainFrame.repaintActiveEditor();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    VariablesEditor.this.actions.editProps.actionPerformed(null);
                } else {
                    VariablesEditor.this.showPopup(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VariablesEditor.this.showPopup(e);
            }
        });
        this.table.setDragEnabled(true);
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            public Transferable createTransferable(JComponent c) {
                VariableDef vd = VariablesEditor.this.getSelectedVariable();
                if (vd == null) {
                    return null;
                }
                IdeEditor ed = MainFrame.instance.getActiveEditor();
                if (ed instanceof FbdEditor) {
                    try {
                        return new FbdEditor.AddingItem(new FbdVariable(((FbdEditor)ed).currentPage(), new VariableRef(vd, 0)));
                    }
                    catch (Exception e) {
                        Utils.ProcessException(e, false);
                        return null;
                    }
                }
                return null;
            }

            @Override
            public void exportDone(JComponent c, Transferable t, int action) {
            }
        });
        this.table.getActionMap().put("copy", this.actions.copy);
        this.table.getTableHeader().setDefaultRenderer(new NoArrowHeaderRenderer());
        this.sorter = new TableRowSorter<VarTableModel>(this.model);
        this.sorter.setComparator(2, new AlphanumComparator());
        this.table.setRowSorter(this.sorter);
        this.sorter.setSortsOnUpdates(true);
        for (i = 0; i < cm.getColumnCount(); ++i) {
            this.sorter.setSortable(i, false);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.filter = new VarsFilter();
        this.sorter.setRowFilter(this.filter);
    }

    void hideColumn(TableColumn c) {
        c.setMinWidth(0);
        c.setMaxWidth(0);
        c.setWidth(0);
    }

    public VariableDef locateVar(String name, VariablesBlock block) {
        for (VariableDef vd : this.list) {
            if (!vd.getName().equalsIgnoreCase(name) || block != null && vd.getBlock() != block) continue;
            return vd;
        }
        return null;
    }

    private VariableDef locateVar(Variable.NameParser vnp) {
        for (VariableDef vd : this.list) {
            if (vd.isSystem() || vd.getValueType() != vnp.type || !vd.getName().equalsIgnoreCase(vnp.name) || !vd.getBlock().name.equalsIgnoreCase(vnp.domain)) continue;
            return vd;
        }
        return null;
    }

    protected int getSelectedColumn() {
        int col = this.table.getSelectedColumn();
        if (col >= 0) {
            col = this.table.convertColumnIndexToModel(col);
        }
        return col;
    }

    public void clearWindowsRefs() {
        for (VariableDef vd : this.list) {
            vd.refWindows.clear();
        }
    }

    public void clearCodeRefs() {
        for (VariableDef vd : this.list) {
            vd.refCodeLines.clear();
        }
    }

    public void clearModbusRefs() {
        for (VariableDef vd : this.list) {
            vd.refModbusRegs.clear();
        }
    }

    public void clearFbdRefs() {
        for (VariableDef vd : this.list) {
            vd.refFbdVars.clear();
        }
    }

    public void clearScheduleRefs() {
        for (VariableDef vd : this.list) {
            vd.refSchedTables.clear();
        }
    }

    public void clearArchiveRefs() {
        for (VariableDef vd : this.list) {
            vd.isArchived = false;
        }
    }

    private void updateFilter() {
        int si = this.cbxFilter.getSelectedIndex();
        this.filter.system = si != 1;
        this.filter.user = si != 2;
        this.updateTable();
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new VariablesActions(this);
        this.menu.add(new JMenuItem(this.actions.add));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.copy));
        this.menu.add(new JMenuItem(this.actions.cut));
        this.menu.add(new JMenuItem(this.actions.paste));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.delete));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.editProps));
        this.cbxFilter = new JComboBox<String>(new DefaultComboBoxModel<String>(FILTER));
        this.cbxFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariablesEditor.this.table.requestFocusInWindow();
                VariablesEditor.this.updateFilter();
            }
        });
        this.toolBar.add(IdeUtils.addMargins(new JLabel("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c:"), 0, 10, 0, 8));
        this.toolBar.add(this.cbxFilter).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.add).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.copy).setFocusable(false);
        this.toolBar.add(this.actions.cut).setFocusable(false);
        this.toolBar.add(this.actions.paste).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.delete).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.editProps).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(MainFrame.instance.actions.varsHelp).setFocusable(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.actions.add));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.copy));
        this.popupMenu.add(new JMenuItem(this.actions.cut));
        this.popupMenu.add(new JMenuItem(this.actions.paste));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.delete));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.editProps));
        return this.actions;
    }

    protected void updateTableView() {
        TableColumn col = this.table.getTableHeader().getColumnModel().getColumn(this.table.convertColumnIndexToView(6));
        int w = 100;
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            int i = this.table.convertRowIndexToModel(r);
            JLabel c = (JLabel)this.commentRender.getTableCellRendererComponent(this.table, this.model.getValueAt(i, 6), false, false, i, 6);
            Dimension ps = c.getPreferredSize();
            this.table.setRowHeight(r, ps.height + 2);
            w = Math.max(w, ps.width + 30);
        }
        col.setMinWidth(w);
        col.setPreferredWidth(w);
    }

    public void updateTable() {
        this.model.fireTableDataChanged();
        this.updateTableView();
    }

    public boolean hasSelection() {
        return this.table.getSelectedRow() >= 0;
    }

    protected int getSelectedIndex() {
        int sel = this.table.getSelectedRow();
        if (sel >= 0) {
            return this.table.convertRowIndexToModel(sel);
        }
        return sel;
    }

    public VariableDef getSelectedVariable() {
        int sel = this.getSelectedIndex();
        if (sel >= 0) {
            return this.list.get(sel);
        }
        return null;
    }

    public void editProperties(VariableDef vd) {
        if (vd.isSystem()) {
            if (vd.isWritable() && SysVariableDialog.showDialog(vd)) {
                this.commitAction(true);
            }
        } else if (VariablePropsDialog.showDialog(vd, this.getSelectedColumn(), false)) {
            this.commitAction(true);
            this.notifyChanged();
        }
    }

    public void deleteSelected() {
        int sel = this.getSelectedIndex();
        VariableDef vd = this.getSelectedVariable();
        if (vd == null || vd.isSystem()) {
            return;
        }
        if (vd.isUsed()) {
            JOptionPane.showMessageDialog(this.mainFrame, "\u042d\u0442\u0443 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442.\u043a. \u043e\u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            return;
        }
        this.list.remove(vd);
        this.model.fireTableRowsDeleted(sel, sel);
        this.updateTableView();
        ArrayList<VariableDef> vars = new ArrayList<VariableDef>();
        vars.add(vd);
        this.mainFrame.getFbdEditor().deleteVars(vars);
        this.notifyChanged();
    }

    public void selectVariable(VariableDef v) {
        int i;
        int n = i = v != null ? this.list.indexOf(v) : -1;
        if (i >= 0) {
            i = this.table.convertRowIndexToView(i);
            this.table.changeSelection(i, this.table.convertColumnIndexToView(2), false, false);
            this.table.requestFocusInWindow();
        } else {
            this.table.clearSelection();
        }
    }

    public VariableDef createVariable() {
        VariablesBlock block = this.mainFrame.program.RamVars;
        int type = 3;
        VariableDef vd = this.getSelectedVariable();
        if (vd != null) {
            type = vd.getValueType();
            if (!vd.isSystem()) {
                block = vd.getBlock();
            }
        }
        return new VariableDef(this, block, "", type, 0);
    }

    public void addVariable(VariableDef vd) {
        if (!this.list.contains(vd)) {
            this.list.add(vd);
        }
        this.updateTable();
        this.selectVariable(vd);
    }

    public void notifyChanged() {
        this.mainFrame.notifyVarsChanged();
    }

    public void commitAction(boolean updateRow) {
        int sel;
        if (updateRow && (sel = this.getSelectedIndex()) >= 0) {
            this.model.fireTableRowsUpdated(sel, sel);
            this.updateTableView();
        }
        this.markModified();
    }

    @Override
    public void titleClicked() {
        this.table.requestFocusInWindow();
    }

    @Override
    public void initFocus() {
    }

    @Override
    public void clear() {
        this.list.clear();
        this.updateTable();
    }

    private void processBlock(VariablesBlock block) {
        for (Variable v : block.map.values()) {
            if (v.hidden) continue;
            this.list.add(new VariableDef(this, block, v));
        }
    }

    private void initVarList() {
        Device dev = this.mainFrame.program.device;
        this.list.clear();
        this.processBlock(dev.SysInVars);
        this.processBlock(dev.SysOutVars);
        this.processBlock(dev.SysStoreVars);
        this.processBlock(dev.SysExtVars);
    }

    private void loadVarList(JSONObject json) throws FbdLoadError {
        Program prg = this.mainFrame.program;
        if (json != null) {
            try {
                this.loadVarsFromJson(json.getJSONArray(JSON_VARS_KEY));
            }
            catch (JSONException e) {
                throw new FbdLoadError("JSON error: " + e.getMessage(), e);
            }
        } else {
            this.processBlock(prg.Constants);
            this.processBlock(prg.RamVars);
            this.processBlock(prg.StoreVars);
            this.processBlock(prg.ExtVars);
        }
    }

    private void loadVarsFromJson(JSONArray src) throws JSONException, FbdLoadError {
        for (int i = 0; i < src.length(); ++i) {
            this.list.add(new VariableDef(this, src.getJSONObject(i)));
        }
    }

    @Override
    public void initNewProgram() {
        this.initVarList();
        this.updateTable();
        this.markSavedToDisk();
    }

    @Override
    public void loadProgram(JSONObject json, int version) throws FbdLoadError {
        this.initVarList();
        this.loadVarList(json);
        this.updateTable();
        this.markSavedToDisk();
    }

    private void saveFbdVars(JSONObject json) {
        VariablesEditor.saveToJson(json, this.list);
    }

    public static void saveToJson(JSONObject json, List<VariableDef> vars) {
        JSONArray jsonVars = new JSONArray();
        try {
            json.remove(JSON_VARS_KEY);
            json.put(JSON_VARS_KEY, jsonVars);
            for (VariableDef vd : vars) {
                if (vd.isSystem()) continue;
                JSONObject jso = new JSONObject();
                vd.saveToJson(jso);
                jsonVars.put(jso);
            }
        }
        catch (JSONException e) {
            Utils.ProcessException(e, false);
        }
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        for (VariableDef vd : this.list) {
            vd.compileVar();
        }
        if (json != null) {
            this.saveFbdVars(json);
        }
    }

    public void copyToClipboard(boolean cut) {
        VariableDef vd = this.getSelectedVariable();
        if (vd != null) {
            JSONObject json = new JSONObject();
            ArrayList<VariableDef> list = new ArrayList<VariableDef>();
            list.add(vd);
            VariablesEditor.saveToJson(json, list);
            ClipboardUtils.putData(json, 'v');
            if (cut) {
                this.deleteSelected();
            }
        }
    }

    public void pasteFromClipboard() {
        JSONObject json = ClipboardUtils.getData('v');
        if (json != null) {
            try {
                this.loadFromClipboard(json, true, true, null);
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
            }
        }
    }

    private ArrayList<NewVarInfo> newVarsFromClipboard(JSONArray src) throws SyntaxError, JSONException, FbdLoadError {
        ArrayList<NewVarInfo> res = null;
        for (int i = 0; i < src.length(); ++i) {
            JSONObject vs = src.getJSONObject(i);
            String fn = vs.getString("name");
            Variable.NameParser vn = new Variable.NameParser(fn);
            VariableDef vd = this.locateVar(vn);
            if (vd != null) continue;
            if (res == null) {
                res = new ArrayList<NewVarInfo>();
            }
            res.add(new NewVarInfo(fn, vn, vs.optString("comment"), vs.getInt("array"), vs.getBoolean("written"), vs.getBoolean("writtenfbd")));
        }
        return res;
    }

    String mapVarDomain(String src) {
        Program prg = this.mainFrame.program;
        Device dev = prg.device;
        if (dev.SysInVars.name.equalsIgnoreCase(src)) {
            return prg.RamVars.name;
        }
        if (dev.SysOutVars.name.equalsIgnoreCase(src)) {
            return prg.RamVars.name;
        }
        if (dev.SysStoreVars.name.equalsIgnoreCase(src)) {
            return prg.StoreVars.name;
        }
        if (dev.SysExtVars.name.equalsIgnoreCase(src)) {
            return prg.ExtVars.name;
        }
        return src;
    }

    public boolean loadFromClipboard(JSONObject json, boolean focus, boolean forceCreate, Map<String, String> varSubst) throws SyntaxError, JSONException, FbdLoadError {
        ArrayList<NewVarInfo> newVars;
        JSONArray src = json.getJSONArray(JSON_VARS_KEY);
        HashMap<String, String> varMap = forceCreate ? null : new HashMap<String, String>();
        ArrayList<NewVarInfo> arrayList = newVars = forceCreate ? null : this.newVarsFromClipboard(src);
        if (newVars != null && !VarsMapDialog.showDialog("\u0412\u0441\u0442\u0430\u0432\u043a\u0430 \u043d\u043e\u0432\u044b\u0445 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445", newVars, varMap)) {
            return false;
        }
        if (varSubst != null) {
            varSubst.clear();
        }
        for (int i = 0; i < src.length(); ++i) {
            String oldname;
            JSONObject vs = src.getJSONObject(i);
            String newname = oldname = vs.getString("name");
            if (!forceCreate && (newname = varMap.get(oldname)) == null) continue;
            if (forceCreate || this.locateVar(newname) == null) {
                Variable.NameParser vn = new Variable.NameParser(newname);
                newname = vn.name;
                while (this.locateVar(newname, null) != null) {
                    newname = newname + "_new";
                }
                newname = this.mapVarDomain(vn.domain) + "." + Variable.typeToString(vn.type) + "." + newname;
                vs.put("name", newname);
                VariableDef vd = new VariableDef(this, vs);
                this.list.add(vd);
                this.updateTable();
                this.markModified();
                this.notifyChanged();
                if (focus) {
                    this.selectVariable(vd);
                }
            }
            if (varSubst == null) continue;
            varSubst.put(oldname, newname);
        }
        return true;
    }

    public VariableDef locateVarDef(Variable var) {
        for (VariableDef vd : this.list) {
            if (vd.compiledVar != var) continue;
            return vd;
        }
        return null;
    }

    public VariableRef makeRef(Variable var) {
        VariableDef vd;
        if (var == null) {
            return null;
        }
        int index = 0;
        if (var.arrayStart != null) {
            index = var.indexInArray;
            var = var.arrayStart;
        }
        if ((vd = this.locateVarDef(var)) != null) {
            return new VariableRef(vd, index);
        }
        return null;
    }

    public void setVarMap(Map<String, String> varMap) {
        this.varMap = varMap;
    }

    public VariableRef locateVar(String fullName) {
        String s;
        if (this.varMap != null && (s = this.varMap.get(fullName)) != null) {
            fullName = s;
        }
        int i1 = fullName.lastIndexOf(91);
        int i2 = fullName.indexOf(93, i1 + 1);
        String defName = fullName;
        int index = -2;
        if (i1 > 0 && i2 > i1) {
            index = Utils.StringToIntDef(fullName.substring(i1 + 1, i2), -1);
            if (index < 0) {
                return null;
            }
            defName = fullName.substring(0, i1);
        } else {
            i1 = fullName.lastIndexOf(".size");
            if (i1 > 0) {
                defName = fullName.substring(0, i1);
                index = -1;
            }
        }
        for (VariableDef vd : this.list) {
            if (!vd.getFullName().equalsIgnoreCase(defName)) continue;
            if (index >= -1) {
                if (index >= vd.getArraySize() || vd.getArraySize() <= 0) {
                    return null;
                }
                return new VariableRef(vd, index);
            }
            return new VariableRef(vd, 0);
        }
        return null;
    }

    public ArrayList<VariableRef> getAllVariables(boolean sort, int type) {
        ArrayList<VariableRef> res = new ArrayList<VariableRef>();
        for (VariableDef vd : this.list) {
            if (type != 0 && vd.getValueType() != type) continue;
            int size = vd.getArraySize();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    res.add(new VariableRef(vd, i));
                }
                if (type != 2 && type != 0) continue;
                res.add(new VariableRef(vd, -1));
                continue;
            }
            res.add(new VariableRef(vd, 0));
        }
        if (sort) {
            Collections.sort(res, new AlphanumComparator());
        }
        return res;
    }

    public ArrayList<VariableDef> getAllDefines() {
        return this.list;
    }

    private void loadProps() {
        for (int i = 0; i < COLUMNS.length; ++i) {
            int mi = this.table.convertColumnIndexToModel(i);
            int w = Main.props.getInt(PROP_COL_WIDTH + mi, DEF_COLUMNS_W[mi]);
            if (w == 0) {
                w = DEF_COLUMNS_W[mi];
            }
            this.table.getColumnModel().getColumn(i).setPreferredWidth(w);
        }
    }

    @Override
    public void saveProps() {
        for (int i = 0; i < COLUMNS.length; ++i) {
            int mi = this.table.convertColumnIndexToModel(i);
            int w = this.table.getColumnModel().getColumn(i).getPreferredWidth();
            if (w <= 0) continue;
            Main.props.saveInt(PROP_COL_WIDTH + mi, w);
        }
    }

    public void selectAndEditVar(VariableDef vd) {
        this.selectVariable(vd);
        this.editProperties(vd);
    }

    public static String arrayToString(ArrayList<Double> list) {
        String s = "";
        Double d = list.get(0);
        if (!d.isNaN()) {
            s = Utils.numToString(d);
            for (int i = 1; i < list.size(); ++i) {
                s = s + ", " + Utils.numToString(list.get(i));
            }
        }
        return s;
    }

    @Override
    public void updateVarList() {
    }

    class NoArrowHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public NoArrowHeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                Color fgColor = null;
                Color bgColor = null;
                if (hasFocus) {
                    fgColor = (Color)UIManager.get("TableHeader.focusCellForeground");
                    bgColor = (Color)UIManager.get("TableHeader.focusCellBackground");
                }
                if (fgColor == null) {
                    fgColor = header.getForeground();
                }
                if (bgColor == null) {
                    bgColor = header.getBackground();
                }
                this.setForeground(fgColor);
                this.setBackground(bgColor);
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            Border border = null;
            if (hasFocus) {
                border = (Border)UIManager.get("TableHeader.focusCellBorder");
            }
            if (border == null) {
                border = (Border)UIManager.get("TableHeader.cellBorder");
            }
            this.setBorder(border);
            return this;
        }
    }

    class InitValueRender
    extends IdeTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public InitValueRender(int alignment, int padding) {
            super(alignment, padding);
        }

        @Override
        protected void setValue(Object value) {
            ArrayList list;
            String s = "";
            if (value instanceof ArrayList && (list = (ArrayList)value).get(0) instanceof Double) {
                s = VariablesEditor.arrayToString((ArrayList)value);
            }
            this.setText(s);
        }
    }

    class ArrayRender
    extends IdeTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ArrayRender(int alignment, int padding) {
            super(alignment, padding);
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                if (i > 0) {
                    this.setText(i.toString());
                } else {
                    this.setText("");
                }
            } else {
                this.setText(value == null ? "" : value.toString());
            }
        }
    }

    class VarTypeRender
    extends IdeTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font font;

        public VarTypeRender() {
            super(0, 1);
            this.font = null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (this.font == null) {
                this.font = this.getFont().deriveFont(1);
            }
            this.setFont(this.font);
            if (!isSelected && !hasFocus) {
                VariableDef vd = VariablesEditor.this.list.get(table.convertRowIndexToModel(row));
                this.setForeground(AFbdPin.typeColor(vd.getValueType()));
            }
            return this;
        }
    }

    class MemTypeRender
    extends IdeTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MemTypeRender() {
            super(0, 1);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            VariableDef vd = VariablesEditor.this.list.get(table.convertRowIndexToModel(row));
            if (!isSelected && !hasFocus) {
                this.setBackground(vd.getMemColor());
            }
            return this;
        }
    }

    class VarNameRender
    extends IdeTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font font;
        private boolean system;

        public VarNameRender() {
            super(2, 8);
            this.font = null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            VariableDef vd = VariablesEditor.this.list.get(table.convertRowIndexToModel(row));
            this.system = vd.isSystem();
            if (this.system) {
                if (this.font == null) {
                    this.font = this.getFont().deriveFont(2);
                }
                this.setFont(this.font);
            }
            return this;
        }
    }

    class VarTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        VarTableModel() {
        }

        @Override
        public int getRowCount() {
            return VariablesEditor.this.list.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMNS[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        private String accessKind(RefList<?> ref1, RefList<?> ref2) {
            if (ref1.isUsed() || ref2 != null && ref2.isUsed()) {
                if (ref1.isWritten() || ref2 != null && ref2.isWritten()) {
                    return "\u0437\u0430\u043f.";
                }
                return "\u0447\u0442.";
            }
            return "";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VariableDef vd = VariablesEditor.this.list.get(rowIndex);
            if (columnIndex == 0) {
                return vd.getMemTypeLong();
            }
            if (columnIndex == 1) {
                int ars = vd.getArraySize();
                return Variable.typeToUpperString(vd.getValueType()) + (ars > 0 ? "[" + ars + "]" : "");
            }
            if (columnIndex == 2) {
                return vd.toString();
            }
            if (columnIndex == 3) {
                return vd.getArraySize();
            }
            if (columnIndex == 4) {
                return vd.getInitValuesArray();
            }
            if (columnIndex == 5) {
                return this.accessKind(vd.refFbdVars, vd.refCodeLines);
            }
            if (columnIndex == 11) {
                return this.accessKind(vd.refModbusRegs, null);
            }
            if (columnIndex == 10) {
                return this.accessKind(vd.refSchedTables, null);
            }
            if (columnIndex == 9) {
                return vd.isArchived ? "\u0434\u0430" : "";
            }
            if (columnIndex == 12) {
                return this.accessKind(vd.refWindows, null);
            }
            if (columnIndex == 6) {
                return "<html>" + vd.getCommentHtml() + "</html>";
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }

    public class NewVarInfo {
        public final String fullName;
        public final Variable.NameParser parsedName;
        public final String comment;
        public final int arraySize;
        public final boolean written;
        public final boolean writtenInFbd;

        public NewVarInfo(String fullName, Variable.NameParser parsedName, String comment, int arraySize, boolean written, boolean writtenInFbd) {
            this.fullName = fullName;
            this.parsedName = parsedName;
            this.comment = comment;
            this.arraySize = arraySize;
            this.written = written;
            this.writtenInFbd = writtenInFbd;
        }

        public String toString() {
            return this.parsedName.name;
        }
    }

    private class VarsFilter
    extends RowFilter<VarTableModel, Object> {
        boolean system = true;
        boolean user = true;

        private VarsFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends VarTableModel, ? extends Object> entry) {
            int i = (Integer)entry.getIdentifier();
            VariableDef vd = VariablesEditor.this.list.get(i);
            if (!this.system && vd.isSystem()) {
                return false;
            }
            return this.user || vd.isSystem();
        }
    }
}

