/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.schedule;

import certa.vics.Utils;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.schedule.ScheduleCell;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class ScheduleCellEditor
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static ScheduleCellEditor dialog;
    boolean okPressed;
    JButton btnOk;
    JComboBox<String> cmbxHour;
    JComboBox<String> cmbxMinute;
    JTextField tfValue;
    JLabel lblValueError;
    double value;
    double min;
    double max;
    static final String[] HOURS;
    static final String[] MINUTES;

    public static boolean showDialog(ScheduleCell cell, int x, int y) {
        if (dialog == null) {
            dialog = new ScheduleCellEditor(MainFrame.instance);
        }
        ScheduleCellEditor.dialog.tfValue.requestFocusInWindow();
        ScheduleCellEditor.dialog.okPressed = false;
        dialog.setControls(cell);
        if (x > 0 && y > 0) {
            dialog.setLocation(x, y);
        } else {
            dialog.setLocationRelativeTo(dialog.getParent());
        }
        dialog.setVisible(true);
        if (ScheduleCellEditor.dialog.okPressed) {
            return dialog.updateCell(cell);
        }
        return false;
    }

    public ScheduleCellEditor(JFrame parent) {
        super(parent, "");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScheduleCellEditor.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        DocumentListener editValue = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ScheduleCellEditor.this.validData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScheduleCellEditor.this.validData();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScheduleCellEditor.this.validData();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.cmbxHour = new JComboBox();
        this.cmbxHour.setModel(new DefaultComboBoxModel<String>(HOURS));
        this.cmbxMinute = new JComboBox();
        this.cmbxMinute.setModel(new DefaultComboBoxModel<String>(MINUTES));
        this.tfValue = new JTextField(8);
        this.tfValue.getDocument().addDocumentListener(editValue);
        this.lblValueError = new DialogErrorLabel("Error");
        pnlContents.add((Component)new JLabel("\u0412\u0440\u0435\u043c\u044f:"), "ax right");
        pnlContents.add(this.cmbxHour, "");
        pnlContents.add((Component)new JLabel(":"), "");
        pnlContents.add(this.cmbxMinute, "span, wrap");
        pnlContents.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), "ax right");
        pnlContents.add((Component)this.tfValue, "span");
        pnlContents.add((Component)this.lblValueError, "newline, span, hidemode 3");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(ScheduleCell cell) {
        this.cmbxHour.setSelectedIndex(cell.hour);
        this.cmbxMinute.setSelectedIndex(cell.minute);
        this.value = cell.value;
        this.min = cell.table.min;
        this.max = cell.table.max;
        if (!Double.isNaN(this.value)) {
            this.tfValue.setText(cell.table.valueToString(this.value));
        } else {
            this.tfValue.setText("");
        }
        this.validData();
    }

    boolean updateCell(ScheduleCell cell) {
        if (!Double.isNaN(this.value)) {
            cell.update(this.cmbxHour.getSelectedIndex(), this.cmbxMinute.getSelectedIndex(), this.value);
            return true;
        }
        return true;
    }

    boolean validData() {
        this.value = Double.NaN;
        boolean error = false;
        String s = this.tfValue.getText();
        if (!Utils.strEmpty(s)) {
            try {
                this.value = Double.parseDouble(s.replace(',', '.'));
                if (this.value < this.min || this.value > this.max) {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
        }
        if (error) {
            this.lblValueError.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 " + Utils.numToString(this.min) + " \u0434\u043e " + Utils.numToString(this.max));
            this.lblValueError.setVisible(true);
        } else {
            this.lblValueError.setVisible(false);
        }
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }

    static {
        int i;
        HOURS = new String[24];
        MINUTES = new String[60];
        for (i = 0; i < HOURS.length; ++i) {
            ScheduleCellEditor.HOURS[i] = (i < 10 ? "0" : "") + i;
        }
        for (i = 0; i < MINUTES.length; ++i) {
            ScheduleCellEditor.MINUTES[i] = (i < 10 ? "0" : "") + i;
        }
    }
}

