/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.ErrorLabel;
import certa.vics.ide.Main;
import com.fazecast.jSerialComm.SerialPort;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;

public class CommSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ActionListener listener;
    JPanel pnlModbusType;
    ButtonGroup rgModbusType;
    JRadioButton rbModbusRtu;
    JRadioButton rbModbusTcp;
    JRadioButton rbMbRtuOverTcp;
    JPanel pnlRtuParams;
    JComboBox<String> cmbxComPort;
    JLabel lblComPortError;
    JComboBox<String> cmbxSpeed;
    JLabel lblSpeedError;
    JComboBox<String> cmbxStopBits;
    JComboBox<String> cmbxParity;
    JPanel pnlTcpParams;
    JTextField tfHost;
    JLabel lblHostError;
    JTextField tfTcpPort;
    JLabel lblPortError;
    JPanel pnlId;
    JTextField tfDevId;
    JLabel lblDevIdError;
    private static String[] SPEED = new String[]{"2400", "4800", "9600", "14400", "19200", "38400", "57600", "115200"};
    private static String[] STOP_BITS = new String[]{"1", "2"};
    private static String[] PARITY = new String[]{"NO", "ODD", "EVEN"};
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CommSettingsPanel.this.pnlRtuParams.setVisible(CommSettingsPanel.this.rbModbusRtu.isSelected());
            CommSettingsPanel.this.pnlTcpParams.setVisible(CommSettingsPanel.this.rbModbusTcp.isSelected() || CommSettingsPanel.this.rbMbRtuOverTcp.isSelected());
            CommSettingsPanel.this.validData();
            if (CommSettingsPanel.this.listener != null) {
                CommSettingsPanel.this.listener.actionPerformed(null);
            }
        }
    };
    DocumentListener editCheck = new DocumentListener(){

        public void doUpdate() {
            if (!CommSettingsPanel.this.inUpdate) {
                CommSettingsPanel.this.update.actionPerformed(null);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }
    };
    static final String MODBUS_TYPE = "comm.modbusType";
    static final String PORT_NAME = "comm.portName";
    static final String PORT_SPEED = "comm.portSpeed";
    static final String PORT_STOP = "comm.stopBits";
    static final String PORT_PARITY = "comm.parity";
    static final String TCP_HOST = "comm.tcpHost";
    static final String TCP_PORT = "comm.tcpPort";
    static final String DEVICE_ID = "comm.deviceId";
    boolean inUpdate;
    static final int BAD_VALUE = Integer.MIN_VALUE;
    int deviceId;
    String portName;
    int baudRate;
    int stopBits;
    int parity;
    String hostName;
    int tcpPort;
    boolean dataValid = false;

    void updatePortsList() {
        String s = this.getEditComboText(this.cmbxComPort);
        SerialPort[] ports = SerialPort.getCommPorts();
        String[] names = new String[ports.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ports[i].getSystemPortName();
        }
        this.cmbxComPort.setModel(new DefaultComboBoxModel<String>(names));
        this.cmbxComPort.setSelectedItem(s);
    }

    public CommSettingsPanel() {
        super(new MigLayout("insets 0", "", ""), true);
        this.pnlModbusType = new JPanel(new MigLayout("", "[]20[]20[]", ""));
        this.pnlModbusType.setBorder(BorderFactory.createTitledBorder("MODBUS"));
        this.rgModbusType = new ButtonGroup();
        this.rbModbusRtu = new JRadioButton("RTU");
        this.rbModbusTcp = new JRadioButton("TCP");
        this.rbMbRtuOverTcp = new JRadioButton("RTU over TCP");
        this.rgModbusType.add(this.rbModbusRtu);
        this.rgModbusType.add(this.rbModbusTcp);
        this.rgModbusType.add(this.rbMbRtuOverTcp);
        this.pnlModbusType.add(this.rbModbusRtu);
        this.pnlModbusType.add(this.rbModbusTcp);
        this.pnlModbusType.add(this.rbMbRtuOverTcp);
        this.rbModbusRtu.addActionListener(this.update);
        this.rbModbusTcp.addActionListener(this.update);
        this.rbMbRtuOverTcp.addActionListener(this.update);
        this.pnlRtuParams = new JPanel(new MigLayout("", "[align right][]", ""));
        this.pnlRtuParams.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u0442"));
        this.cmbxComPort = new JComboBox();
        this.cmbxComPort.setEditable(true);
        ((JTextComponent)this.cmbxComPort.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.editCheck);
        this.lblComPortError = new ErrorLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0440\u0442\u0430");
        this.cmbxSpeed = new JComboBox<String>(new DefaultComboBoxModel<String>(SPEED));
        this.cmbxSpeed.setEditable(true);
        ((JTextComponent)this.cmbxSpeed.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.editCheck);
        this.lblSpeedError = new ErrorLabel("\u0447\u0438\u0441\u043b\u043e \u043e\u0442 300 \u0434\u043e 115200");
        this.cmbxStopBits = new JComboBox<String>(new DefaultComboBoxModel<String>(STOP_BITS));
        this.cmbxParity = new JComboBox<String>(new DefaultComboBoxModel<String>(PARITY));
        this.pnlRtuParams.add((Component)this.lblComPortError, "skip 1, align left, hidemode 3, wrap");
        this.pnlRtuParams.add((Component)new JLabel("\u041f\u043e\u0440\u0442:"), "");
        this.pnlRtuParams.add(this.cmbxComPort, "wrap");
        this.pnlRtuParams.add((Component)new JLabel("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c:"), "");
        this.pnlRtuParams.add(this.cmbxSpeed, "wrap");
        this.pnlRtuParams.add((Component)this.lblSpeedError, "skip 1, align left, hidemode 3, wrap");
        this.pnlRtuParams.add((Component)new JLabel("\u0421\u0442\u043e\u043f-\u0431\u0438\u0442\u044b:"), "");
        this.pnlRtuParams.add(this.cmbxStopBits, "wrap");
        this.pnlRtuParams.add((Component)new JLabel("\u0427\u0435\u0442\u043d\u043e\u0441\u0442\u044c:"), "");
        this.pnlRtuParams.add(this.cmbxParity, "wrap");
        this.pnlTcpParams = new JPanel(new MigLayout("", "[align right][]", ""));
        this.pnlTcpParams.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b TCP/IP"));
        this.tfHost = new JTextField(20);
        this.tfHost.getDocument().addDocumentListener(this.editCheck);
        this.lblHostError = new ErrorLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441");
        this.tfTcpPort = new JTextField(8);
        this.tfTcpPort.getDocument().addDocumentListener(this.editCheck);
        this.lblPortError = new ErrorLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 1 \u0434\u043e 65535");
        this.pnlTcpParams.add((Component)this.lblHostError, "skip 1, align left, hidemode 3, wrap");
        this.pnlTcpParams.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), "");
        this.pnlTcpParams.add((Component)this.tfHost, "wrap");
        this.pnlTcpParams.add((Component)this.lblPortError, "skip 1, align left, hidemode 3, wrap");
        this.pnlTcpParams.add((Component)new JLabel("\u041f\u043e\u0440\u0442:"), "");
        this.pnlTcpParams.add((Component)this.tfTcpPort, "");
        this.pnlId = new JPanel(new MigLayout("", "", ""));
        this.tfDevId = new JTextField(5);
        this.tfDevId.getDocument().addDocumentListener(this.editCheck);
        this.lblDevIdError = new ErrorLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 0 \u0434\u043e 255");
        this.pnlId.add((Component)this.lblDevIdError, "span, alignx center, hidemode 3, wrap");
        this.pnlId.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0432 \u0441\u0435\u0442\u0438 MODBUS:"), "");
        this.pnlId.add((Component)this.tfDevId, "wrap");
        this.add((Component)this.pnlModbusType, "grow, span");
        this.add((Component)this.pnlRtuParams, "grow, span, newline, hidemode 3");
        this.add((Component)this.pnlTcpParams, "grow, span, newline, hidemode 3");
        this.add((Component)this.pnlId, "span, alignx center, newline, hidemode 3");
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    void setPanelEnabled(JPanel pnl, boolean en) {
        for (Component c : pnl.getComponents()) {
            c.setEnabled(en);
        }
        pnl.setEnabled(en);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setPanelEnabled(this.pnlModbusType, enabled);
        this.setPanelEnabled(this.pnlTcpParams, enabled);
        this.setPanelEnabled(this.pnlRtuParams, enabled);
        this.setPanelEnabled(this.pnlId, enabled);
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void initControls() {
        this.inUpdate = true;
        try {
            int t = Main.props.getInt(MODBUS_TYPE, 0);
            if (t == 0) {
                this.rbModbusRtu.doClick();
            } else if (t == 1) {
                this.rbModbusTcp.doClick();
            } else {
                this.rbMbRtuOverTcp.doClick();
            }
            this.cmbxComPort.setSelectedItem(Main.props.getString(PORT_NAME, ""));
            this.cmbxSpeed.setSelectedItem(Main.props.getString(PORT_SPEED, "38400"));
            this.cmbxStopBits.setSelectedItem(Main.props.getString(PORT_STOP, "2"));
            this.cmbxParity.setSelectedItem(Main.props.getString(PORT_PARITY, PARITY[0]));
            this.tfDevId.setText(Main.props.getString(DEVICE_ID, ""));
            this.tfHost.setText(Main.props.getString(TCP_HOST, ""));
            this.tfTcpPort.setText(Main.props.getString(TCP_PORT, ""));
            this.tfDevId.requestFocusInWindow();
        }
        finally {
            this.inUpdate = false;
        }
        this.validData();
    }

    String getEditComboText(JComboBox<String> cbx) {
        return ((JTextComponent)cbx.getEditor().getEditorComponent()).getText();
    }

    public void saveParams() {
        int t = 0;
        if (this.rbModbusTcp.isSelected()) {
            t = 1;
        } else if (this.rbMbRtuOverTcp.isSelected()) {
            t = 2;
        }
        Main.props.saveInt(MODBUS_TYPE, t);
        Main.props.saveString(PORT_NAME, this.getEditComboText(this.cmbxComPort));
        Main.props.saveString(PORT_SPEED, this.getEditComboText(this.cmbxSpeed));
        Main.props.saveString(PORT_STOP, (String)this.cmbxStopBits.getSelectedItem());
        Main.props.saveString(PORT_PARITY, (String)this.cmbxParity.getSelectedItem());
        Main.props.saveString(DEVICE_ID, this.tfDevId.getText());
        Main.props.saveString(TCP_HOST, this.tfHost.getText());
        Main.props.saveString(TCP_PORT, this.tfTcpPort.getText());
    }

    int getInt(String text, int min, int max, JLabel lbl) {
        int t;
        try {
            t = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            t = Integer.MIN_VALUE;
        }
        if (t < min || t > max) {
            t = Integer.MIN_VALUE;
        }
        lbl.setVisible(t == Integer.MIN_VALUE);
        return t;
    }

    private boolean validData() {
        boolean error = false;
        if (this.pnlRtuParams.isVisible()) {
            this.portName = this.getEditComboText(this.cmbxComPort);
            if (Utils.strEmpty(this.portName)) {
                this.lblComPortError.setVisible(true);
                error = true;
            } else {
                this.lblComPortError.setVisible(false);
            }
            this.baudRate = this.getInt(this.getEditComboText(this.cmbxSpeed), 300, 115200, this.lblSpeedError);
            this.stopBits = this.cmbxStopBits.getSelectedIndex() + 1;
            this.parity = this.cmbxParity.getSelectedIndex();
        }
        if (this.pnlTcpParams.isVisible()) {
            this.hostName = this.tfHost.getText();
            if (Utils.strEmpty(this.hostName)) {
                this.lblHostError.setVisible(true);
                error = true;
            } else {
                this.lblHostError.setVisible(false);
            }
            this.tcpPort = this.getInt(this.tfTcpPort.getText(), 1, 65535, this.lblPortError);
            error |= this.tcpPort == Integer.MIN_VALUE;
        }
        this.deviceId = this.getInt(this.tfDevId.getText(), 0, 255, this.lblDevIdError);
        this.dataValid = !(error |= this.deviceId == Integer.MIN_VALUE);
        return this.dataValid;
    }

    public boolean isDataValid() {
        return this.validData();
    }

    public boolean isRtu() {
        return this.rbModbusRtu.isSelected();
    }

    public boolean isTcp() {
        return this.rbModbusTcp.isSelected();
    }

    public boolean isRtuOverTcp() {
        return this.rbMbRtuOverTcp.isSelected();
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public String getTcpHost() {
        return this.hostName;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }
}

