/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.ArgumentDef;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.lcd.LcdFont;
import certa.vics.lcd.fonts.Cyrillic5x8;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Device {
    public final LcdFont FONT = new Cyrillic5x8();
    public final int DISPLAY_COLS = 8;
    public final int DISPLAY_ROWS = 2;
    public final int STRING_SIZE = 6;
    public final String PropsFile;
    public final String Name;
    public final int ModelId;
    public final int Firmware;
    public final int RamSize;
    public final int RamStart;
    public final int NvramSize;
    public final int NvramStart;
    public final int EepromSize;
    public final int EepromStart;
    public final int FlashSize;
    public final int FlashStart;
    public final int ConstStart;
    public final int CodeStart;
    public final int ExtEepromArchiveStart;
    public final int ExtEepromScheduleStart;
    public final int MaxConstSize;
    public final CommandDef[] CommandList;
    public final Map<String, CommandDef> CommandMap = new HashMap<String, CommandDef>();
    public final VariablesBlock SysInVars = new VariablesBlock("SysIn", "Sys. RAM", true);
    public final VariablesBlock SysOutVars = new VariablesBlock("SysOut", "Sys. RAM", false);
    public final VariablesBlock SysStoreVars = new VariablesBlock("SysStore", "Sys. EEPROM", false);
    public final VariablesBlock SysExtVars = new VariablesBlock("SysExt", "Sys. NVRAM", false);
    private Properties props;
    private static final ArgumentDef IN_BOOL = new ArgumentDef(1, false, false, false, false, true, false, false);
    private static final ArgumentDef IN_INT = new ArgumentDef(2, false, false, false, false, true, false, false);
    private static final ArgumentDef IN_FLOAT = new ArgumentDef(3, false, false, false, false, true, false, false);
    private static final ArgumentDef IN_BOOLARRAY = new ArgumentDef(1, true, false, false, false, true, false, false);
    private static final ArgumentDef IN_INTARRAY = new ArgumentDef(2, true, false, false, false, true, false, false);
    private static final ArgumentDef IN_FLOATARRAY = new ArgumentDef(3, true, false, false, false, true, false, false);
    private static final ArgumentDef IN_FLOATARRAY_S = new ArgumentDef(3, true, true, false, false, true, false, false);
    private static final ArgumentDef IN_BOOL_LIST = new ArgumentDef(1, false, false, true, false, true, false, false);
    private static final ArgumentDef IN_INT_LIST = new ArgumentDef(2, false, false, true, false, true, false, false);
    private static final ArgumentDef IN_FLOAT_LIST = new ArgumentDef(3, false, false, true, false, true, false, false);
    private static final ArgumentDef OUT_BOOL = new ArgumentDef(1, false, false, false, false, false, false, false);
    private static final ArgumentDef OUT_INT = new ArgumentDef(2, false, false, false, false, false, false, false);
    private static final ArgumentDef OUT_FLOAT = new ArgumentDef(3, false, false, false, false, false, false, false);
    private static final ArgumentDef OUT_BOOLARRAY_S = new ArgumentDef(1, true, true, false, false, false, false, false);
    private static final ArgumentDef OUT_INTARRAY_S = new ArgumentDef(2, true, true, false, false, false, false, false);
    private static final ArgumentDef OUT_FLOATARRAY_S = new ArgumentDef(3, true, true, false, false, false, false, false);
    private static final ArgumentDef G_BOOL = new ArgumentDef(1, false, false, false, false, false, true, false);
    private static final ArgumentDef G_INT = new ArgumentDef(2, false, false, false, false, false, true, false);
    private static final ArgumentDef G_INT_NV = new ArgumentDef(2, false, false, false, false, false, true, true);
    private static final ArgumentDef G_FLOAT = new ArgumentDef(3, false, false, false, false, false, true, false);
    private static final ArgumentDef IN_LABEL = new ArgumentDef(100, false, false, false, false, true, false, false);
    private static final ArgumentDef IN_SUB = new ArgumentDef(101, false, false, false, false, true, false, false);
    private static final ArgumentDef IN_BYTE_NUM = new ArgumentDef(102, false, false, false, false, false, false, false);
    private static final ArgumentDef G_BOOL_LIST_NO_S = new ArgumentDef(1, false, false, true, true, false, true, false);

    public Device(String propsFileName) throws FileNotFoundException, IOException, ErrorInFile {
        this.PropsFile = propsFileName;
        this.props = new Properties();
        try (InputStreamReader reader = new InputStreamReader(Utils.getResourceStream(propsFileName), "UTF8");){
            this.props.load(reader);
        }
        this.Name = this.props.getProperty("device.name");
        this.ModelId = this.getInt("device.id");
        this.Firmware = this.getInt("device.firmware");
        this.RamSize = this.getInt("ram.size");
        this.RamStart = this.getInt("ram.offset");
        this.NvramSize = this.getInt("nvram.size");
        this.NvramStart = this.getInt("nvram.offset");
        this.EepromSize = this.getInt("eeprom.size");
        this.EepromStart = this.getInt("eeprom.offset");
        this.FlashSize = this.getInt("flash.size");
        this.FlashStart = this.getInt("flash.offset");
        this.ConstStart = this.getInt("const.offset");
        this.CodeStart = this.getInt("code.offset");
        this.MaxConstSize = this.FlashSize - (this.ConstStart - this.FlashStart);
        this.ExtEepromArchiveStart = this.getInt("exteeprom.archive");
        this.ExtEepromScheduleStart = this.getInt("exteeprom.schedule");
        this.CommandList = new CommandDef[]{new CommandDef("AND", this, new ArgumentDef[]{IN_BOOL_LIST, OUT_BOOL}), new CommandDef("OR", this, new ArgumentDef[]{IN_BOOL_LIST, OUT_BOOL}), new CommandDef("XOR", this, new ArgumentDef[]{IN_BOOL_LIST, OUT_BOOL}), new CommandDef("NOT", this, new ArgumentDef[]{IN_BOOL, OUT_BOOL}), new CommandDef("AddI", this, new ArgumentDef[]{IN_INT_LIST, OUT_INT}), new CommandDef("AddF", this, new ArgumentDef[]{IN_FLOAT_LIST, OUT_FLOAT}), new CommandDef("AverI", this, new ArgumentDef[]{IN_INT_LIST, OUT_INT}), new CommandDef("AverF", this, new ArgumentDef[]{IN_FLOAT_LIST, OUT_FLOAT}), new CommandDef("SubI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_INT}), new CommandDef("SubF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("MulI", this, new ArgumentDef[]{IN_INT_LIST, OUT_INT}), new CommandDef("MulF", this, new ArgumentDef[]{IN_FLOAT_LIST, OUT_FLOAT}), new CommandDef("DivI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_INT}), new CommandDef("Mod", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_INT}), new CommandDef("DivF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("IntervI", this, new ArgumentDef[]{IN_INT, IN_INT, IN_INT, OUT_BOOL, OUT_BOOL, OUT_BOOL}), new CommandDef("IntervF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_BOOL, OUT_BOOL, OUT_BOOL}), new CommandDef("EquI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("LessI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("GrEqI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("EquF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("LessF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("GrEqF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("ItoB", this, new ArgumentDef[]{IN_INT, OUT_BOOL}), new CommandDef("BtoI", this, new ArgumentDef[]{IN_BOOL, OUT_INT}), new CommandDef("ItoF", this, new ArgumentDef[]{IN_INT, OUT_FLOAT}), new CommandDef("FtoI", this, new ArgumentDef[]{IN_FLOAT, OUT_INT}), new CommandDef("MovB", this, new ArgumentDef[]{IN_BOOL, OUT_BOOL}), new CommandDef("MovI", this, new ArgumentDef[]{IN_INT, OUT_INT}), new CommandDef("MovF", this, new ArgumentDef[]{IN_FLOAT, OUT_FLOAT}), new CommandDef("ArrayGetB", this, new ArgumentDef[]{IN_BOOLARRAY, IN_INT, OUT_BOOL}), new CommandDef("ArrayGetI", this, new ArgumentDef[]{IN_INTARRAY, IN_INT, OUT_INT}), new CommandDef("ArrayGetF", this, new ArgumentDef[]{IN_FLOATARRAY, IN_INT, OUT_FLOAT}), new CommandDef("ArrayPutB", this, new ArgumentDef[]{IN_BOOL, OUT_BOOLARRAY_S, IN_INT}), new CommandDef("ArrayPutI", this, new ArgumentDef[]{IN_INT, OUT_INTARRAY_S, IN_INT}), new CommandDef("ArrayPutF", this, new ArgumentDef[]{IN_FLOAT, OUT_FLOATARRAY_S, IN_INT}), new CommandDef("Jump", this, new ArgumentDef[]{IN_LABEL}), new CommandDef("JumpIfZ", this, new ArgumentDef[]{IN_BOOL, IN_LABEL}), new CommandDef("Call", this, new ArgumentDef[]{IN_SUB}), new CommandDef("Ret", this, null), new CommandDef("End", this, null), new CommandDef("Counter", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, IN_BOOL, IN_BOOL, IN_INT, OUT_BOOL, OUT_BOOL, OUT_INT, G_BOOL, G_BOOL, G_BOOL, G_BOOL, G_INT}), new CommandDef("Timer", this, new ArgumentDef[]{IN_BOOL, IN_INT, IN_INT, OUT_BOOL, OUT_INT, G_BOOL, G_INT}), new CommandDef("DelayOn", this, new ArgumentDef[]{IN_BOOL, IN_INT, OUT_BOOL, OUT_INT, G_BOOL, G_INT, G_INT}), new CommandDef("DelayOff", this, new ArgumentDef[]{IN_BOOL, IN_INT, OUT_BOOL, OUT_INT, G_BOOL, G_INT, G_INT}), new CommandDef("GisterI", this, new ArgumentDef[]{IN_INT, IN_INT, IN_INT, IN_INT, OUT_BOOL, G_BOOL}), new CommandDef("GisterF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_BOOL, G_BOOL}), new CommandDef("Pulse", this, new ArgumentDef[]{IN_BOOL, IN_INT, IN_INT, IN_INT, OUT_BOOL, OUT_INT, G_BOOL, G_INT}), new CommandDef("PID", this, new ArgumentDef[]{IN_BOOL, IN_INT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_FLOAT, G_INT, G_FLOAT, G_FLOAT, G_FLOAT, G_FLOAT}), new CommandDef("PI", this, new ArgumentDef[]{IN_BOOL, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_FLOAT, G_INT, G_FLOAT, G_FLOAT}), new CommandDef("ActuatorA", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, IN_BOOL, IN_BOOL, IN_INT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_FLOAT, G_BOOL, G_BOOL, G_INT}), new CommandDef("ActuatorD", this, new ArgumentDef[]{IN_BOOL, IN_INT, IN_INT, IN_INT, IN_INT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_BOOL, OUT_BOOL, OUT_BOOL, OUT_BOOL, OUT_BOOL, OUT_FLOAT, G_INT, G_INT, G_INT, G_FLOAT}), new CommandDef("XYTable", this, new ArgumentDef[]{IN_FLOATARRAY, IN_FLOATARRAY_S, IN_FLOAT, OUT_FLOAT}), new CommandDef("LineF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("NotEqI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("GreaterI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("LeEqI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_BOOL}), new CommandDef("NotEqF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("GreaterF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("LeEqF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_BOOL}), new CommandDef("AbsI", this, new ArgumentDef[]{IN_INT, OUT_INT}), new CommandDef("AbsF", this, new ArgumentDef[]{IN_FLOAT, OUT_FLOAT}), new CommandDef("SignI", this, new ArgumentDef[]{IN_INT, OUT_INT}), new CommandDef("SignF", this, new ArgumentDef[]{IN_FLOAT, OUT_FLOAT}), new CommandDef("RSt", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, OUT_BOOL, G_BOOL}), new CommandDef("SRt", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, OUT_BOOL, G_BOOL}), new CommandDef("SwiB", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, IN_BOOL, OUT_BOOL}), new CommandDef("SwiI", this, new ArgumentDef[]{IN_BOOL, IN_INT, IN_INT, OUT_INT}), new CommandDef("SwiF", this, new ArgumentDef[]{IN_BOOL, IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("SelB", this, new ArgumentDef[]{IN_INT, IN_BOOL_LIST, OUT_BOOL}), new CommandDef("SelI", this, new ArgumentDef[]{IN_INT, IN_INT_LIST, OUT_INT}), new CommandDef("SelF", this, new ArgumentDef[]{IN_INT, IN_FLOAT_LIST, OUT_FLOAT}), new CommandDef("LimMaxI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_INT}), new CommandDef("LimMinI", this, new ArgumentDef[]{IN_INT, IN_INT, OUT_INT}), new CommandDef("LimMaxF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("LimMinF", this, new ArgumentDef[]{IN_FLOAT, IN_FLOAT, OUT_FLOAT}), new CommandDef("Actuator3P", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, IN_BOOL, IN_BOOL, IN_BOOL, IN_INT, IN_INT, IN_FLOAT, IN_FLOAT, IN_FLOAT, OUT_BOOL, OUT_BOOL, G_BOOL, G_BOOL, G_INT, G_INT, G_INT, G_FLOAT, G_FLOAT}), new CommandDef("EquB", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, OUT_BOOL}), new CommandDef("MovIfB", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, OUT_BOOL, G_BOOL}), new CommandDef("MovIfI", this, new ArgumentDef[]{IN_BOOL, IN_INT, OUT_INT, G_BOOL}), new CommandDef("MovIfF", this, new ArgumentDef[]{IN_BOOL, IN_FLOAT, OUT_FLOAT, G_BOOL}), new CommandDef("Rotate2", this, new ArgumentDef[]{IN_BOOL, IN_BOOL, IN_INT, OUT_BOOL, OUT_BOOL, OUT_INT, G_BOOL, G_INT_NV, G_INT}), new CommandDef("Impulse", this, new ArgumentDef[]{IN_BOOL, OUT_BOOL, G_BOOL}), new CommandDef("ScheduleB", this, new ArgumentDef[]{IN_BYTE_NUM, IN_BOOL, IN_BOOL, G_INT}), new CommandDef("ScheduleI", this, new ArgumentDef[]{IN_BYTE_NUM, IN_BOOL, IN_INT, G_INT}), new CommandDef("ScheduleF", this, new ArgumentDef[]{IN_BYTE_NUM, IN_BOOL, IN_FLOAT, G_INT}), new CommandDef("Archive", this, new ArgumentDef[]{IN_BOOL_LIST, G_BOOL_LIST_NO_S})};
        for (CommandDef c : this.CommandList) {
            this.CommandMap.put(c.Name.toUpperCase(), c);
        }
        for (String key : this.props.stringPropertyNames()) {
            if (key.toUpperCase().startsWith("SYSIN.")) {
                this.parseSysVar(this.SysInVars, key, this.RamStart);
                continue;
            }
            if (key.toUpperCase().startsWith("SYSOUT.")) {
                this.parseSysVar(this.SysOutVars, key, this.RamStart);
                continue;
            }
            if (key.toUpperCase().startsWith("SYSSTORE.")) {
                this.parseSysVar(this.SysStoreVars, key, this.EepromStart);
                continue;
            }
            if (!key.toUpperCase().startsWith("SYSEXT.")) continue;
            this.parseSysVar(this.SysExtVars, key, this.NvramStart);
        }
    }

    private void parseSysVar(VariablesBlock domain, String key, int maxAddr) throws ErrorInFile {
        int dnl = domain.name.length();
        try {
            int v;
            int type;
            String s;
            try {
                s = key.substring(dnl + 1, dnl + 3);
            }
            catch (IndexOutOfBoundsException e) {
                s = null;
            }
            if (s.equalsIgnoreCase("B.")) {
                type = 1;
                --maxAddr;
            } else if (s.equalsIgnoreCase("I.")) {
                type = 2;
                maxAddr -= 2;
            } else if (s.equalsIgnoreCase("F.")) {
                type = 3;
                maxAddr -= 4;
            } else {
                throw new SyntaxError("Invalid variable type (b, i, f are expected): \"" + key + "\"");
            }
            try {
                s = key.substring(dnl + 3);
            }
            catch (IndexOutOfBoundsException e) {
                s = null;
            }
            if (s == null || s.length() == 0) {
                throw new SyntaxError("Invalid variable name: \"" + key + "\"");
            }
            String val = this.props.getProperty(key);
            if (val != null) {
                val = val.trim();
            }
            if (val == null || val.equals("")) {
                throw new ErrorInFile(this.PropsFile, "\"" + key + "\" not found");
            }
            int p = val.indexOf(35);
            String ts = p > 0 ? val.substring(0, p).trim() : val;
            try {
                v = Integer.decode(ts);
            }
            catch (NumberFormatException e) {
                throw new ErrorInFile(this.PropsFile, "Invalid \"" + key + "\" address: \"" + ts + "\"");
            }
            if (v > maxAddr) {
                throw new ErrorInFile(this.PropsFile, "Address of \"" + key + "\" (" + v + ") exceeds limit (" + maxAddr + ")");
            }
            Variable var = domain.createSimpleVar(s, type, false, v);
            if (p >= 0 && p < val.length() - 1) {
                var.comment = val.substring(p + 1, val.length()).trim();
            }
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.PropsFile, e);
        }
    }

    protected int getInt(String key) throws ErrorInFile {
        String s = this.props.getProperty(key);
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.equals("")) {
            throw new ErrorInFile(this.PropsFile, "\"" + key + "\" not found");
        }
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new ErrorInFile(this.PropsFile, "Invalid \"" + key + "\" value: \"" + s + "\"");
        }
    }
}

