/*
 * Decompiled with CFR 0.152.
 */
package ua.com.certa.modbus.server;

public class RegistersTable {
    private final int[] values;
    protected final int start;

    public RegistersTable(int startAddress, int count) {
        this.start = startAddress;
        this.values = new int[count];
    }

    public boolean isValidAddress(int address) {
        return address >= this.firstAddress() && address <= this.lastAddress();
    }

    public int firstAddress() {
        return this.start;
    }

    public int lastAddress() {
        return this.start + this.count() - 1;
    }

    public int count() {
        return this.values.length;
    }

    public synchronized int getInt(int address) {
        return this.values[address - this.start];
    }

    public synchronized void setInt(int address, int value) {
        this.values[address - this.start] = value;
    }

    public synchronized boolean getBool(int address) {
        return this.values[address - this.start] != 0;
    }

    public synchronized void setBool(int address, boolean value) {
        this.values[address - this.start] = value ? 1 : 0;
    }
}

