/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.VariablesBlock;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.StringsEditor;
import certa.vics.ide.ui.WindowView;
import certa.vics.ide.variables.ArrayEditDialog;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariablesEditor;
import certa.vics.lcd.LcdDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class VariablePropsDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static VariablePropsDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JComboBox<VariablesBlock> cmbxBlock;
    JComboBox<String> cmbxType;
    JTextField tfName;
    JPanel pnlVar;
    JPanel pnlInitValue;
    JLabel lblType;
    JLabel lblArray;
    JComboBox<String> cmbxArraySize;
    JLabel lblInitValue;
    JTextField tfInitValue;
    JButton btnEditArray;
    JPanel pnlComment;
    JTextArea txtComment;
    JLabel lblUsedMessage;
    JLabel lblWrittenMessage;
    JLabel lblNameError;
    JLabel lblInitError;
    VariableDef varDef;
    VariablesBlock varBlock;
    int varType;
    String varName;
    String varComment;
    int varArraySize;
    ArrayList<Double> varInit;
    JPanel pnlBoolParams;
    JCheckBox chkAlarm;
    JCheckBox chkAlarmReset;
    JCheckBox chkArchive;
    JPanel pnlEventName;
    LcdDisplay lcdEventName;
    JButton btnEditEventName;
    JLabel lblSchedule;
    JCheckBox chkSchedule;
    JButton btnEditSchedule;
    final String[] TYPE_NAMES = new String[]{"\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 (b)", "\u0426\u0435\u043b\u044b\u0439 (i)", "\u0412\u0435\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 (f)"};
    final ArrayList<Integer> TYPE_CODES = new ArrayList();
    private boolean inUpdate = false;
    String[] eventName = new String[]{"", ""};

    public static boolean showDialog(VariableDef varDef, int column, boolean isNew) {
        if (dialog == null) {
            dialog = new VariablePropsDialog(MainFrame.instance);
        }
        if (column == 4) {
            VariablePropsDialog.dialog.tfInitValue.requestFocusInWindow();
        } else if (column == 6) {
            VariablePropsDialog.dialog.txtComment.requestFocusInWindow();
        } else if (column == 2) {
            VariablePropsDialog.dialog.tfName.requestFocusInWindow();
        } else {
            VariablePropsDialog.dialog.btnOk.requestFocusInWindow();
        }
        VariablePropsDialog.dialog.okPressed = false;
        dialog.setControls(varDef);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (VariablePropsDialog.dialog.okPressed) {
            boolean changed = dialog.updateVar(varDef);
            MainFrame.instance.getFbdEditor().updateVars();
            return isNew || changed;
        }
        return false;
    }

    void editText() {
        LcdDisplay lcd = this.lcdEventName;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.eventName[0]);
        lines.add(this.eventName[1]);
        if (StringsEditor.editStrings(lines, true, false, lcd.getColumnsCount(), lcd.getLcdFont(), "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u0432\u0430\u0440\u0438\u0438/\u0441\u043e\u0431\u044b\u0442\u0438\u044f", this)) {
            this.eventName[0] = lines.get(0);
            this.eventName[1] = lines.get(1);
            WindowView.buildTextPreview(this.lcdEventName.getCharsBuffer(), this.eventName[0], this.eventName[1]);
            this.lcdEventName.repaint();
        }
    }

    public VariablePropsDialog(JFrame parent) {
        super(parent, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f");
        this.TYPE_CODES.add(1);
        this.TYPE_CODES.add(2);
        this.TYPE_CODES.add(3);
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VariablePropsDialog.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VariablePropsDialog.this.inUpdate) {
                    VariablePropsDialog.this.validData();
                }
            }
        };
        ActionListener updateArraySize = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VariablePropsDialog.this.inUpdate) {
                    return;
                }
                int s = VariablePropsDialog.this.cmbxArraySize.getSelectedIndex();
                if (s != VariablePropsDialog.this.varArraySize) {
                    if (s > 0) {
                        VariablePropsDialog.this.editArray(s);
                    } else {
                        ArrayList<Double> tmp = VariablePropsDialog.this.varInit;
                        VariablePropsDialog.this.varInit = new ArrayList(1);
                        VariablePropsDialog.this.varInit.add(tmp.get(0));
                        VariablePropsDialog.this.tfInitValue.setText(VariablesEditor.arrayToString(VariablePropsDialog.this.varInit));
                    }
                    VariablePropsDialog.this.validData();
                }
            }
        };
        ActionListener editArray = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariablePropsDialog.this.editArray(VariablePropsDialog.this.varArraySize);
            }
        };
        final ActionListener editText = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.editText();
            }
        };
        ActionListener editSchedule = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        DocumentListener editUpdate = new DocumentListener(){

            public void doUpdate() {
                if (!VariablePropsDialog.this.inUpdate) {
                    VariablePropsDialog.this.validData();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.cmbxBlock = new JComboBox();
        this.cmbxBlock.addActionListener(update);
        this.cmbxType = new JComboBox();
        this.cmbxType.setModel(new DefaultComboBoxModel<String>(this.TYPE_NAMES));
        this.cmbxType.addActionListener(update);
        this.lblArray = new JLabel("\u041c\u0430\u0441\u0441\u0438\u0432:");
        this.cmbxArraySize = new JComboBox();
        String[] s = new String[201];
        s[0] = "\u041d\u0435\u0442";
        for (int i = 1; i < s.length; ++i) {
            s[i] = Integer.toString(i);
        }
        this.cmbxArraySize.setModel(new DefaultComboBoxModel<String>(s));
        this.cmbxArraySize.addActionListener(updateArraySize);
        this.tfName = new JTextField(60);
        this.tfName.getDocument().addDocumentListener(editUpdate);
        this.lblArray = new JLabel("\u041c\u0430\u0441\u0441\u0438\u0432:");
        this.lblType = new JLabel("\u0422\u0438\u043f:");
        this.lblInitValue = new JLabel("<html><body style='text-align:right'>\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435<br>\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:</body><html>");
        this.tfInitValue = new JTextField(12);
        this.tfInitValue.getDocument().addDocumentListener(editUpdate);
        this.btnEditArray = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.btnEditArray.addActionListener(editArray);
        this.lblNameError = new DialogErrorLabel("NameError");
        this.lblInitError = new DialogErrorLabel("Error");
        this.lblUsedMessage = new JLabel("<html>\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043d\u0435\u043b\u044c\u0437\u044f,<br>\u0442.\u043a. \u043e\u043d\u0430 \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f</html>");
        this.lblUsedMessage.setOpaque(true);
        this.lblUsedMessage.setBackground(SystemColor.info);
        this.lblUsedMessage.setForeground(SystemColor.infoText);
        this.lblUsedMessage.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.lblWrittenMessage = new JLabel("<html>\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c<br>\u0432 <b>ROM</b> \u0438\u043b\u0438 <b>EEPROM</b>, \u0442.\u043a. \u0435\u0435<br>\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435</html>");
        this.lblWrittenMessage.setOpaque(true);
        this.lblWrittenMessage.setBackground(SystemColor.info);
        this.lblWrittenMessage.setForeground(SystemColor.infoText);
        this.lblWrittenMessage.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.txtComment = new JTextArea();
        this.txtComment.setLineWrap(false);
        this.txtComment.setFont(this.tfName.getFont());
        this.pnlComment = new JPanel(new BorderLayout());
        this.pnlComment.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        JScrollPane scroll = new JScrollPane(this.txtComment);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        this.pnlComment.add((Component)scroll, "Center");
        this.chkAlarm = new JCheckBox("\u0410\u0432\u0430\u0440\u0438\u044f");
        this.chkAlarm.addActionListener(update);
        this.chkAlarmReset = new JCheckBox("\u0441 \u0430\u0432\u0442\u043e\u0441\u0431\u0440\u043e\u0441\u043e\u043c");
        this.chkArchive = new JCheckBox("\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0442\u044c \u0432 \u0430\u0440\u0445\u0438\u0432");
        this.chkArchive.addActionListener(update);
        this.pnlEventName = new JPanel(new MigLayout("", "[]", "[][grow]"));
        this.pnlEventName.setBorder(BorderFactory.createTitledBorder("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u0432\u0430\u0440\u0438\u0438/\u0441\u043e\u0431\u044b\u0442\u0438\u044f"));
        this.lcdEventName = IdeUtils.createLcd(null, null);
        this.lcdEventName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                editText.actionPerformed(null);
            }
        });
        this.btnEditEventName = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.btnEditEventName.addActionListener(editText);
        this.pnlEventName.add((Component)this.lcdEventName, "");
        this.pnlEventName.add((Component)this.btnEditEventName, "");
        this.pnlBoolParams = new JPanel(new MigLayout("", "", ""));
        this.pnlBoolParams.setBorder(BorderFactory.createTitledBorder("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0438\u0437 0 \u0432 1"));
        this.pnlBoolParams.add((Component)this.chkAlarm, "");
        this.pnlBoolParams.add((Component)this.chkAlarmReset, "wrap");
        this.pnlBoolParams.add((Component)this.chkArchive, "span");
        this.pnlBoolParams.add((Component)this.pnlEventName, "span, newline, hidemode 3");
        this.lblSchedule = new JLabel("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435:");
        this.chkSchedule = new JCheckBox();
        this.chkSchedule.addActionListener(update);
        this.btnEditSchedule = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.btnEditSchedule.addActionListener(editSchedule);
        pnlContents.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), "alignx right");
        pnlContents.add((Component)this.tfName, "span, growx, width 200:200, wrap");
        pnlContents.add((Component)this.lblNameError, "skip 1, span, hidemode 3");
        this.pnlVar = new JPanel(new MigLayout("insets 0 0 0 0", "", ""));
        this.pnlVar.add((Component)this.lblType, "newline, alignx right");
        this.pnlVar.add(this.cmbxType, "");
        this.pnlVar.add((Component)this.lblUsedMessage, "span, hidemode 3");
        this.pnlVar.add((Component)new JLabel("\u0420\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u0435:"), "newline, alignx right");
        this.pnlVar.add(this.cmbxBlock, "");
        this.pnlVar.add((Component)this.lblWrittenMessage, "span, hidemode 3");
        this.pnlVar.add((Component)this.lblArray, "newline, alignx right");
        this.pnlVar.add(this.cmbxArraySize, "span 2, wrap");
        pnlContents.add((Component)this.pnlVar, "newline, span, hidemode 3");
        this.pnlInitValue = new JPanel(new MigLayout("insets 0 0 0 0", "", ""));
        this.pnlInitValue.add((Component)this.lblInitValue, "alignx right");
        this.pnlInitValue.add((Component)this.tfInitValue, "span, split 2, hidemode 3");
        this.pnlInitValue.add((Component)this.btnEditArray, "hidemode 3");
        this.pnlInitValue.add((Component)this.lblInitError, "newline, skip 1, span, hidemode 3");
        pnlContents.add((Component)this.pnlInitValue, "newline, span, hidemode 3");
        pnlContents.add((Component)this.pnlComment, "newline, growx, h 130px, span");
        JButton btnHelp = new JButton(MainFrame.instance.actions.varsHelp);
        btnHelp.setFocusable(false);
        btnHelp.setText("");
        pane.add((Component)btnHelp, "alignx left");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void fixArray() {
        Double d;
        int i;
        if (this.varType == 1) {
            for (i = 0; i < this.varInit.size(); ++i) {
                d = this.varInit.get(i);
                if (d.isNaN()) continue;
                this.varInit.set(i, d != 0.0 ? 1.0 : 0.0);
            }
        }
        if (this.varType == 2) {
            for (i = 0; i < this.varInit.size(); ++i) {
                d = this.varInit.get(i);
                if (d.isNaN()) continue;
                if (d < -32768.0) {
                    d = -32768.0;
                }
                if (d > 32767.0) {
                    d = 32767.0;
                }
                this.varInit.set(i, Double.valueOf(d.intValue()));
            }
        }
    }

    void editArray(int newSize) {
        ArrayList<Double> tmp = new ArrayList<Double>(newSize);
        if (!this.varInit.get(0).isNaN()) {
            for (int i = 0; i < newSize; ++i) {
                if (i < this.varInit.size()) {
                    tmp.add(this.varInit.get(i));
                    continue;
                }
                tmp.add(0.0);
            }
        } else {
            for (int i = 0; i < newSize; ++i) {
                tmp.add(Double.NaN);
            }
        }
        if (ArrayEditDialog.showDialog(tmp)) {
            this.varInit = tmp;
            this.varArraySize = newSize;
            this.fixArray();
        }
        this.inUpdate = true;
        this.cmbxArraySize.setSelectedIndex(this.varArraySize);
        this.validData();
        this.inUpdate = false;
    }

    void setControls(VariableDef varDef) {
        this.inUpdate = true;
        this.varDef = varDef;
        this.varBlock = varDef.getBlock();
        this.varType = varDef.getValueType();
        this.varName = varDef.getName();
        this.varComment = varDef.getCommentStr();
        this.varArraySize = varDef.getArraySize();
        this.varInit = new ArrayList<Double>(varDef.getInitValuesArray());
        boolean used = varDef.isUsed();
        this.lblUsedMessage.setVisible(used);
        this.lblType.setEnabled(!used);
        this.cmbxType.setEnabled(!used);
        this.lblWrittenMessage.setVisible(varDef.isWrittenInFbd());
        Program prg = MainFrame.instance.program;
        Vector<VariablesBlock> blocks = new Vector<VariablesBlock>();
        if (!varDef.isWritten()) {
            blocks.insertElementAt(prg.Constants, 0);
        }
        blocks.add(prg.RamVars);
        if (!varDef.isWrittenInFbd()) {
            blocks.add(prg.StoreVars);
        }
        if (prg.device.NvramSize > 0) {
            blocks.add(prg.ExtVars);
        }
        this.cmbxBlock.setModel(new DefaultComboBoxModel(blocks));
        this.tfName.setText(this.varName);
        this.txtComment.setText(this.varComment);
        this.cmbxBlock.setSelectedItem(this.varBlock);
        this.cmbxType.setSelectedIndex(this.TYPE_CODES.indexOf(this.varType));
        this.tfInitValue.setText(VariablesEditor.arrayToString(this.varInit));
        this.cmbxArraySize.setSelectedIndex(this.varArraySize);
        this.inUpdate = false;
        this.validData();
    }

    boolean updateVar(VariableDef varDef) {
        this.fixArray();
        boolean mod = false;
        mod |= varDef.setBlock(this.varBlock);
        mod |= varDef.setValueType(this.varType);
        mod |= varDef.setInitArray(this.varArraySize, this.varInit);
        mod |= varDef.setName(this.varName);
        return mod |= varDef.setComment(this.varComment);
    }

    boolean validData() {
        boolean error = false;
        this.varType = this.TYPE_CODES.get(this.cmbxType.getSelectedIndex());
        this.varBlock = (VariablesBlock)this.cmbxBlock.getSelectedItem();
        this.varComment = this.txtComment.getText();
        this.varName = this.tfName.getText();
        boolean hasSpace = false;
        if (this.varName != null) {
            this.varName = this.varName.trim();
            hasSpace = this.varName.indexOf(32) >= 0 || this.varName.indexOf(91) >= 0 || this.varName.indexOf(93) >= 0;
        }
        VariableDef vd = null;
        if (!hasSpace) {
            vd = MainFrame.instance.getVarsEditor().locateVar(this.varName, null);
        }
        if (Utils.strEmpty(this.varName) || hasSpace || vd != null && vd != this.varDef) {
            error = true;
            if (Utils.strEmpty(this.varName)) {
                this.lblNameError.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
            } else if (hasSpace) {
                this.lblNameError.setText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043f\u0440\u043e\u0431\u0435\u043b\u044b \u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u044b [ \u0438 ]");
            } else {
                this.lblNameError.setText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            this.lblNameError.setVisible(true);
        } else {
            this.lblNameError.setVisible(false);
        }
        this.pnlVar.setVisible(true);
        this.pnlInitValue.setVisible(true);
        this.pnlBoolParams.setVisible(this.varType == 1 && this.varArraySize == 0);
        this.chkAlarmReset.setVisible(this.chkAlarm.isSelected());
        this.pnlEventName.setVisible(this.chkAlarm.isSelected() || this.chkArchive.isSelected());
        this.chkSchedule.setVisible(this.varArraySize == 0);
        this.lblSchedule.setVisible(this.chkSchedule.isVisible());
        this.btnEditSchedule.setVisible(this.chkSchedule.isVisible() && this.chkSchedule.isSelected());
        this.varArraySize = this.cmbxArraySize.getSelectedIndex();
        this.tfInitValue.setEditable(this.varArraySize == 0);
        this.btnEditArray.setVisible(this.varArraySize > 0);
        if (this.varArraySize == 0) {
            double value = Double.NaN;
            double min = -999999.0;
            double max = 999999.0;
            boolean err = false;
            if (this.varType == 1) {
                min = 0.0;
                max = 1.0;
            } else if (this.varType == 1) {
                min = -32768.0;
                max = 32767.0;
            }
            String s = this.tfInitValue.getText();
            if (!Utils.strEmpty(s)) {
                try {
                    value = Double.parseDouble(s.replace(',', '.'));
                    if (value < min || value > max) {
                        err = true;
                    }
                }
                catch (NumberFormatException e) {
                    err = true;
                }
            }
            if (err) {
                error = true;
                this.lblInitError.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 " + Utils.numToString(min) + " \u0434\u043e " + Utils.numToString(max));
                this.lblInitError.setVisible(true);
            } else {
                this.varInit.set(0, value);
                this.lblInitError.setVisible(false);
            }
        } else {
            this.inUpdate = true;
            this.tfInitValue.setText(VariablesEditor.arrayToString(this.varInit));
            this.inUpdate = false;
            this.tfInitValue.setCaretPosition(0);
            this.lblInitError.setVisible(false);
        }
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }
}

