/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.FbdNumber;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.FbdVariable;
import java.lang.reflect.Constructor;
import org.json.JSONObject;

public class ItemsFactory {
    public static final String VAR_CLASS_NAME = "var";
    public static final String NUM_CLASS_NAME = "num";
    static final String blockClassPrefix = ItemsFactory.class.getPackage().getName() + ".blocks.";

    private ItemsFactory() {
    }

    static Class<?> getClassByName(String className) throws ClassNotFoundException {
        if (VAR_CLASS_NAME.equalsIgnoreCase(className)) {
            return FbdVariable.class;
        }
        if (NUM_CLASS_NAME.equalsIgnoreCase(className)) {
            return FbdNumber.class;
        }
        return Class.forName(blockClassPrefix + className);
    }

    static String getExceptionMessage(Throwable ex) {
        String s = ex.getMessage();
        if (Utils.strEmpty(s) && (ex = ex.getCause()) != null) {
            s = ItemsFactory.getExceptionMessage(ex);
        }
        return s;
    }

    public static AFbdItem createItem(String className, FbdPage page, JSONObject src) throws FbdLoadError {
        try {
            Constructor<?> ctor = ItemsFactory.getClassByName(className).getConstructor(FbdPage.class, JSONObject.class);
            return (AFbdItem)ctor.newInstance(page, src);
        }
        catch (Throwable e) {
            throw new FbdLoadError("Cannot create \"" + className + "\": " + ItemsFactory.getExceptionMessage(e), e);
        }
    }

    public static String getClassName(AFbdItem item) {
        if (item instanceof FbdVariable) {
            return VAR_CLASS_NAME;
        }
        if (item instanceof FbdNumber) {
            return NUM_CLASS_NAME;
        }
        return item.getClass().getSimpleName();
    }
}

