/*
 * Decompiled with CFR 0.152.
 */
package certa.vics;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class Version {
    public static final String major;
    public static final String minor;
    public static final String bugfix;
    public static final String revision;
    public static final String id;
    public static final String date;
    public static final boolean internal;
    public static final String version;

    private static String prop(Properties props, String key) {
        String s = props.getProperty(key);
        return s == null ? "?" : s;
    }

    static {
        Properties props = new Properties();
        InputStream in = ClassLoader.getSystemResourceAsStream("version.properties");
        if (in != null) {
            try (InputStreamReader reader = new InputStreamReader(in, "UTF8");){
                props.load(reader);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        major = Version.prop(props, "version.major");
        minor = Version.prop(props, "version.minor");
        bugfix = Version.prop(props, "version.bugfix");
        revision = Version.prop(props, "version.revision");
        id = Version.prop(props, "version.id");
        date = Version.prop(props, "version.date");
        internal = revision.isEmpty() || revision.contains("+");
        version = major + "." + minor + "." + bugfix + (internal ? "+" : "");
    }
}

