/*
 * Decompiled with CFR 0.152.
 */
package certa.vics;

import certa.vics.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;

public class PropertiesFile {
    private Path path;
    private Properties props;

    public PropertiesFile(String fileName) {
        this.loadFile(new File(fileName));
    }

    public PropertiesFile(URL url) {
        File file = null;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            Utils.ProcessException(e, url.toString(), false);
        }
        this.loadFile(file);
    }

    protected void loadFile(File file) {
        try {
            file.createNewFile();
            this.path = file.toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            this.path = null;
            Utils.ProcessException(e, "Cannot create: " + file.getPath(), false);
        }
        this.props = new Properties();
        if (this.path != null) {
            try (FileInputStream in = new FileInputStream(this.path.toString());){
                this.props.load(in);
            }
            catch (IOException e) {
                Utils.ProcessException(e, "Load error: " + this.path.toString(), false);
            }
        }
    }

    private void saveData() {
        if (this.path != null) {
            try (FileOutputStream out = new FileOutputStream(this.path.toString());){
                this.props.store(out, "Do not modify this file while program runs. Changes will be lost.");
            }
            catch (IOException e) {
                Utils.ProcessException(e, "Write error: " + this.path.toString(), false);
            }
        }
    }

    public synchronized String getString(String key, String defValue) {
        return this.props.getProperty(key, defValue);
    }

    public synchronized double getDouble(String key, double defValue) {
        String s = this.props.getProperty(key, null);
        double d = defValue;
        if (s != null && Double.isNaN(d = Utils.StringToDouble(s))) {
            Utils.ProcessError("Invalid double number: " + key + " = " + s + " in " + this.path.toString(), false);
            return defValue;
        }
        return d;
    }

    public synchronized int getInt(String key, int defValue) {
        String s = this.props.getProperty(key, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Utils.ProcessError("Invalid double number: " + key + " = " + s + " in " + this.path.toString(), false);
                return defValue;
            }
        }
        return defValue;
    }

    public synchronized boolean getBool(String key, boolean defValue) {
        String s = this.props.getProperty(key, defValue ? "1" : "").toUpperCase();
        return s.equals("TRUE") || s.equals("YES") || s.equals("1");
    }

    public synchronized void saveString(String key, String value) {
        this.props.setProperty(key, value != null ? value : "");
        this.saveData();
    }

    public synchronized void saveDouble(String key, double value) {
        this.props.setProperty(key, Double.toString(value));
        this.saveData();
    }

    public synchronized void saveInt(String key, int value) {
        this.props.setProperty(key, Integer.toString(value));
        this.saveData();
    }

    public synchronized void saveBool(String key, boolean value) {
        this.props.setProperty(key, value ? "1" : "0");
        this.saveData();
    }
}

