/*
 * Decompiled with CFR 0.152.
 */
package ua.com.certa.modbus.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.slf4j.LoggerFactory;
import ua.com.certa.modbus.ModbusPdu;
import ua.com.certa.modbus.client.AbstractRtuTransport;
import ua.com.certa.modbus.client.ModbusClient;

public class RtuOverUdpTransport
extends AbstractRtuTransport {
    private final String remoteAddressString;
    private final int remotePort;
    private final String localAddressString;
    private final int localPort;
    private DatagramSocket socket;
    private DatagramPacket inPacket;
    private DatagramPacket outPacket;

    public RtuOverUdpTransport(String remoteHost, int remotePort, String localIP, int localPort, int timeout, int pause) {
        super(timeout, pause, false, LoggerFactory.getLogger(RtuOverUdpTransport.class));
        this.remoteAddressString = remoteHost;
        this.remotePort = remotePort == 0 ? 502 : remotePort;
        this.localAddressString = localIP != null ? localIP : "0.0.0.0";
        this.localPort = localPort;
    }

    @Override
    protected synchronized void openPort() throws SocketException, UnknownHostException {
        if (this.socket == null || this.socket.isClosed()) {
            this.log.info("Opening socket: {}:{} <-> {}:{}", this.localAddressString, this.localPort, this.remoteAddressString, this.remotePort);
            InetSocketAddress remoteAddress = new InetSocketAddress(this.remoteAddressString, this.remotePort);
            InetSocketAddress localAddress = this.localAddressString == null || this.localAddressString.isEmpty() ? null : new InetSocketAddress(InetAddress.getByName(this.localAddressString), this.localPort);
            this.socket = new DatagramSocket(localAddress);
            this.socket.setSoTimeout(this.timeout);
            this.inPacket = new DatagramPacket(this.buffer, this.buffer.length);
            this.outPacket = new DatagramPacket(this.buffer, this.buffer.length, remoteAddress);
            this.log.info("Socket opened: {} <-> {}", (Object)this.socket.getLocalSocketAddress(), (Object)this.outPacket.getSocketAddress());
        }
    }

    @Override
    public synchronized void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.log.info("Closing socket");
            this.socket.close();
            this.log.info("Socket closed");
        }
    }

    @Override
    protected void clearInput() throws IOException {
    }

    @Override
    protected void sendData(int size) throws IOException {
        this.socket.send(this.outPacket);
    }

    boolean waitCorrectPacket(ModbusClient modbusClient) throws IOException {
        long now = System.currentTimeMillis();
        long deadline = now + (long)this.timeout;
        while (now < deadline) {
            try {
                this.socket.receive(this.inPacket);
            }
            catch (SocketTimeoutException te) {
                this.log.warn("socket.receive() timeout");
                return false;
            }
            if (this.inPacket.getSocketAddress().equals(this.outPacket.getSocketAddress()) && this.buffer[0] == modbusClient.getServerId()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Read: " + ModbusPdu.toHex(this.buffer, 0, this.inPacket.getLength()));
                }
                return true;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(this.buffer, 0, this.inPacket.getLength()));
            }
            now = System.currentTimeMillis();
        }
        this.log.warn("Response timeout");
        return false;
    }

    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        this.openPort();
        if (!this.waitCorrectPacket(modbusClient)) {
            return 1;
        }
        if (this.inPacket.getLength() < 5) {
            this.log.warn("Invalid size: {} (expected: >= 5)", (Object)this.inPacket.getLength());
            return 3;
        }
        if ((this.buffer[1] & 0x7F) != modbusClient.getFunction()) {
            this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)this.buffer[1], (Object)modbusClient.getFunction());
            return 3;
        }
        if ((this.buffer[1] & 0x80) != 0) {
            modbusClient.setPduSize(2);
            modbusClient.writeToPdu(this.buffer, 1, 2, 0);
            return 2;
        }
        int size = modbusClient.getExpectedPduSize();
        if (this.inPacket.getLength() < 3 + size) {
            this.log.warn("Invalid size: {} (expected: {})", (Object)this.inPacket.getLength(), (Object)(3 + size));
            return 3;
        }
        if (!this.crcValid(1 + size)) {
            this.log.warn("Invalid CRC");
            return 3;
        }
        modbusClient.setPduSize(size);
        modbusClient.writeToPdu(this.buffer, 1, size, 0);
        return 0;
    }

    @Override
    protected boolean readToBuffer(int start, int length, ModbusClient modbusClient) throws Exception {
        return false;
    }
}

