/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.Device;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.ClipboardUtils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.AView;
import certa.vics.ide.ui.GroupView;
import certa.vics.ide.ui.UiActions;
import certa.vics.ide.ui.WindowPropsDialog;
import certa.vics.ide.ui.WindowView;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UiEditor
extends IdeEditor
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int PAD_X = 30;
    public static final int PAD_Y = 10;
    public static final int GROUP_PAD_X = 0;
    public static final int GROUP_PAD_Y = 10;
    public static final int WIN_PAD_X = 10;
    public static final int WIN_PAD_Y = 15;
    public static int CELL_WIDTH;
    public static int CELL_HEIGHT;
    protected GroupView mainGroup;
    private int zoom = 100;
    protected GroupView hoveredGroup;
    protected WindowView hoveredWindow;
    protected String currentTipText;
    public GroupView focusedGroup;
    public WindowView focusedWindow;
    protected final WindowView[] keyWindows = new WindowView[4];
    protected List<AView> selectedList = new ArrayList<AView>();
    public List<WindowView> selectedWindows = new ArrayList<WindowView>();
    VariableDef selVar;
    private JPopupMenu popupMenu;
    UiActions actions;
    protected final MainFrame mainFrame;
    boolean exportPaint;
    private EditPane pane;
    private JScrollPane scroller;
    private boolean dragged;
    private boolean mouseDown;
    WindowView createSource;
    private long mouseUpClickTime = 0L;
    private WindowView prevFocusedWindow = null;
    private GroupView prevFocusedGroup = null;
    static final Cursor CURSOR_NORMAL;
    static final Cursor CURSOR_RELOCATE;
    static final String PROP_ZOOM = "ui.zoom";
    boolean relocating;
    private static final String JSON_WINDOWS = "windows";

    public UiEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043c\u0435\u043d\u044e");
        this.setBackground(Color.WHITE);
        this.mainFrame = mainFrame;
        this.zoom = Main.props.getInt(PROP_ZOOM, this.zoom);
        this.scroller = new JScrollPane(this.pane);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.add((Component)this.scroller, "Center");
        this.pane.addMouseListener(this);
        this.pane.addMouseMotionListener(this);
        this.setCursor(CURSOR_NORMAL);
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new UiActions(this);
        this.pane = new EditPane();
        IdeUtils.bindActions(this.pane, this.actions);
        this.menu.add(new JMenuItem(this.actions.copy));
        this.menu.add(new JMenuItem(this.actions.copyRec));
        this.menu.add(new JMenuItem(this.actions.cut));
        this.menu.add(new JMenuItem(this.actions.paste));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.moveLeft));
        this.menu.add(new JMenuItem(this.actions.moveRight));
        this.menu.add(new JMenuItem(this.actions.relocate));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.addWindow));
        this.menu.add(new JMenuItem(this.actions.addGroup));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.delete));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.editProps));
        this.toolBar.add(MainFrame.instance.actions.exportUi).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.copy).setFocusable(false);
        this.toolBar.add(this.actions.copyRec).setFocusable(false);
        this.toolBar.add(this.actions.cut).setFocusable(false);
        this.toolBar.add(this.actions.paste).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.moveLeft).setFocusable(false);
        this.toolBar.add(this.actions.moveRight).setFocusable(false);
        this.toolBar.add(this.actions.relocate).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.addWindow).setFocusable(false);
        this.toolBar.add(this.actions.addWindowL).setFocusable(false);
        this.toolBar.add(this.actions.addGroup).setFocusable(false);
        this.toolBar.add(this.actions.addWindowR).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.delete).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.editProps).setFocusable(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.actions.addWindow));
        this.popupMenu.add(new JMenuItem(this.actions.addWindowL));
        this.popupMenu.add(new JMenuItem(this.actions.addWindowR));
        this.popupMenu.add(new JMenuItem(this.actions.addGroup));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.moveLeft));
        this.popupMenu.add(new JMenuItem(this.actions.moveRight));
        this.popupMenu.add(new JMenuItem(this.actions.relocate));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.copy));
        this.popupMenu.add(new JMenuItem(this.actions.copyRec));
        this.popupMenu.add(new JMenuItem(this.actions.cut));
        this.popupMenu.add(new JMenuItem(this.actions.paste));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.delete));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.editProps));
        return this.actions;
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(int zoom) {
        if (zoom < 10) {
            zoom = 10;
        }
        if (zoom > 200) {
            zoom = 200;
        }
        if (this.zoom != zoom) {
            this.zoom = zoom;
            this.saveProps();
            this.pane.updateSize();
            this.pane.repaint();
            if (this.focusedWindow != null) {
                this.ensureVisible(this.focusedWindow);
            } else if (this.focusedGroup != null) {
                this.ensureVisible(this.focusedGroup);
            }
        }
    }

    public void commitAction() {
        this.updateVarRefs();
        this.pane.updateSize();
        this.pane.repaint();
        this.markModified();
    }

    protected void reset() {
        this.hoveredGroup = null;
        this.hoveredWindow = null;
        this.currentTipText = null;
        this.focusedGroup = null;
        this.focusedWindow = null;
        this.selectedList.clear();
        this.selectedWindows.clear();
        this.restoreFocus(this.mainGroup);
        this.selectElement(this.focusedWindow, false);
        this.selectElement(this.focusedGroup, false);
        this.pane.updateSize();
        this.pane.repaint();
        IdeAction.updateAll();
    }

    @Override
    public void clear() {
        this.reset();
        this.mainGroup = new GroupView(this, null);
    }

    private void restoreFocus(GroupView g) {
        if (g == null) {
            return;
        }
        if (g.focused) {
            this.focusedGroup = g;
        }
        for (WindowView w : g.getList()) {
            if (w.focused) {
                this.focusedWindow = w;
            }
            this.restoreFocus(w.getNestedGroup());
        }
    }

    private int getMaxX(GroupView g) {
        int x = g.x + g.width - 1;
        for (WindowView w : g.getList()) {
            GroupView g1 = w.getNestedGroup();
            if (g1 == null) continue;
            x = Math.max(x, this.getMaxX(g1));
        }
        return x;
    }

    private int getMaxY(GroupView g) {
        int y = g.y;
        for (WindowView w : g.getList()) {
            GroupView g1 = w.getNestedGroup();
            if (g1 == null) continue;
            y = Math.max(y, this.getMaxY(g1));
        }
        return y;
    }

    private void updateBounds(GroupView g) {
        if (g != null) {
            g.updateBounds();
            for (WindowView w : g.getList()) {
                this.updateBounds(w.getNestedGroup());
            }
        }
    }

    private void paintGroup(GroupView g, Graphics2D g2d) {
        if (g != null) {
            g.paintSelf(g2d);
            for (WindowView w : g.getList()) {
                w.paintSelf(g2d);
                this.paintGroup(w.getNestedGroup(), g2d);
            }
        }
    }

    private AView changeHover(AView oldObj, AView newObj) {
        if (oldObj != null) {
            oldObj.hovered = false;
        }
        if (newObj != null) {
            newObj.hovered = true;
        }
        return newObj;
    }

    private void ensureVisible(AView obj) {
        this.pane.scrollRectToVisible(obj.bounds);
    }

    public void focusWindow(WindowView w) {
        if (this.focusedGroup != null) {
            this.focusedGroup.focused = false;
        }
        this.focusedGroup = null;
        WindowView prev = this.focusedWindow;
        if (this.focusedWindow != null) {
            this.focusedWindow.focused = false;
        }
        this.focusedWindow = w;
        if (this.focusedWindow != null) {
            this.focusedWindow.focused = true;
            if (this.selectedList.size() == 1 && this.selectedList.contains(prev)) {
                this.selectElement(this.focusedWindow, false);
            }
            this.ensureVisible(this.focusedWindow);
        } else {
            this.clearSelection();
        }
        this.pane.repaint();
    }

    private AView changeFocus(AView oldObj, AView newObj) {
        if (oldObj != null) {
            oldObj.focused = false;
        }
        if (newObj != null) {
            newObj.focused = true;
        }
        return newObj;
    }

    private boolean updateHover(int x, int y) {
        GroupView g = this.mainGroup.groupAt(x, y);
        WindowView w = this.mainGroup.windowAt(x, y);
        if (this.hoveredGroup != g || this.hoveredWindow != w) {
            this.hoveredWindow = (WindowView)this.changeHover(this.hoveredWindow, w);
            this.hoveredGroup = (GroupView)this.changeHover(this.hoveredGroup, this.hoveredWindow == null ? g : null);
            if (this.hoveredWindow != null) {
                this.currentTipText = this.hoveredWindow.getTipText();
            } else if (this.hoveredGroup != null) {
                this.currentTipText = this.hoveredGroup.getTipText();
            }
            this.currentTipText = Utils.strEmpty(this.currentTipText) ? null : "<html>" + this.currentTipText + "</html>";
            return true;
        }
        return false;
    }

    private boolean updateFocus(GroupView g, WindowView w) {
        if (this.focusedGroup != g || this.focusedWindow != w) {
            this.focusedWindow = (WindowView)this.changeFocus(this.focusedWindow, w);
            this.focusedGroup = (GroupView)this.changeFocus(this.focusedGroup, this.focusedWindow == null ? g : null);
            IdeAction.updateAll();
            return true;
        }
        return false;
    }

    private void clearFocus() {
        this.focusedWindow = (WindowView)this.changeFocus(this.focusedWindow, null);
        this.focusedGroup = (GroupView)this.changeFocus(this.focusedGroup, null);
    }

    protected void clearSelection() {
        for (AView e : this.selectedList) {
            e.setSelected(false);
        }
        this.selectedList.clear();
        this.selectedWindows.clear();
    }

    public boolean unselectAll() {
        if (this.selectedList.size() > 0) {
            this.clearSelection();
            IdeAction.updateAll();
            return true;
        }
        return false;
    }

    private void addToSelLists(AView element) {
        element.setSelected(true);
        this.selectedList.add(element);
        if (element instanceof WindowView) {
            this.selectedWindows.add((WindowView)element);
        }
    }

    private void removeFromSelLists(AView element) {
        element.setSelected(false);
        this.selectedList.remove(element);
        if (element instanceof WindowView) {
            this.selectedWindows.remove((WindowView)element);
        }
    }

    public boolean selectElement(AView element, boolean addRemove) {
        if (element == null) {
            return false;
        }
        if (element instanceof GroupView && ((GroupView)element).isMain()) {
            this.clearSelection();
            IdeAction.updateAll();
            return false;
        }
        if (addRemove) {
            if (!element.isSelected()) {
                this.addToSelLists(element);
            } else {
                this.removeFromSelLists(element);
            }
            IdeAction.updateAll();
            return true;
        }
        if (!element.isSelected()) {
            this.clearSelection();
            this.addToSelLists(element);
            IdeAction.updateAll();
            return true;
        }
        return false;
    }

    private boolean updateSelection(GroupView g, WindowView w, boolean addRemove) {
        if (w != null) {
            return this.selectElement(w, addRemove);
        }
        if (g != null) {
            return this.selectElement(g, addRemove);
        }
        if (!addRemove) {
            return this.unselectAll();
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDown = true;
        this.pane.requestFocusInWindow();
        int mX = e.getX() * 100 / this.zoom;
        int mY = e.getY() * 100 / this.zoom;
        if (!SwingUtilities.isMiddleMouseButton(e)) {
            this.createSource = null;
            GroupView g = this.mainGroup.groupAt(mX, mY);
            WindowView w = this.mainGroup.windowAt(mX, mY);
            if (w != null && w.isRelocating() || g != null && g.isRelocating()) {
                w = null;
                g = null;
            }
            if (this.relocating && (w != null || g != null)) {
                if (w != null) {
                    this.relocateToWindow(this.getSelectedRoots(), w);
                } else {
                    this.relocateToGroup(this.getSelectedRoots(), g, g.windows.size());
                }
                this.arrangeWindows();
                this.commitAction();
            } else {
                if (w != null && (w.leftLinkHover || w.rightLinkHover || w.downLinkHover)) {
                    this.createSource = w;
                    w = null;
                    g = null;
                }
                boolean changed = this.updateFocus(g, w);
                int keyMask = 192;
                if (changed |= this.updateSelection(g, w, (e.getModifiersEx() & keyMask) != 0)) {
                    this.pane.repaint();
                }
            }
            if (this.relocating) {
                this.relocating = false;
                this.setCursor(CURSOR_NORMAL);
                return;
            }
        }
        if (e.isPopupTrigger() && (this.focusedGroup != null || this.focusedWindow != null)) {
            this.popupMenu.show(e.getComponent(), mX, mY);
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mouseDown) {
            this.mousePressed(e);
        }
        this.mouseDown = false;
        int mX = e.getX() * 100 / this.zoom;
        int mY = e.getY() * 100 / this.zoom;
        if (e.isPopupTrigger() && (this.focusedGroup != null || this.focusedWindow != null)) {
            this.popupMenu.show(e.getComponent(), mX, mY);
            return;
        }
        if (!SwingUtilities.isMiddleMouseButton(e) && this.dragged) {
            this.commitAction();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            long now = System.currentTimeMillis();
            if (now - this.mouseUpClickTime <= (long)Main.DOUBLE_CLICK_TIME && this.prevFocusedWindow == this.focusedWindow && this.prevFocusedGroup == this.focusedGroup) {
                if (this.actions.editProps.isEnabled()) {
                    this.actions.editProps.actionPerformed(null);
                }
                this.mouseUpClickTime = 0L;
            } else {
                this.mouseUpClickTime = now;
                this.prevFocusedWindow = this.focusedWindow;
                this.prevFocusedGroup = this.focusedGroup;
                if (this.createSource != null) {
                    if (this.createSource.leftLinkHover) {
                        this.createSource.leftLinkHover = false;
                        this.createWindow(this.createSource, true);
                    } else if (this.createSource.rightLinkHover) {
                        this.createSource.rightLinkHover = false;
                        this.createWindow(this.createSource, false);
                    } else if (this.createSource.downLinkHover) {
                        this.createSource.downLinkHover = false;
                        this.createSubMenu(this.createSource);
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX() * 100 / this.zoom;
        if (this.updateHover(x, y = e.getY() * 100 / this.zoom)) {
            this.pane.repaint();
        }
    }

    public boolean hasSelection() {
        return !this.selectedList.isEmpty();
    }

    private void delWindow(WindowView w) {
        this.selectedList.remove(w);
        if (this.focusedWindow == w) {
            this.focusedWindow.focused = false;
            this.focusedWindow = null;
        }
        if (w.getNestedGroup() != null) {
            this.delGroup(w.getNestedGroup());
        }
        GroupView pg = w.getParentGroup();
        pg.removeWindow(w);
        if (!pg.isMain() && pg.windows.isEmpty()) {
            this.delGroup(pg);
        }
    }

    private void delGroup(GroupView g) {
        this.selectedList.remove(g);
        if (this.focusedGroup == g) {
            this.focusedGroup.focused = false;
            this.focusedGroup = null;
        }
        if (g.ownerWindow != null) {
            g.ownerWindow.setNestedGroup(null);
        }
        while (!g.windows.isEmpty()) {
            this.delWindow(g.windows.get(0));
        }
    }

    ArrayList<WindowView> getAllSelectedWindows() {
        ArrayList<WindowView> list = new ArrayList<WindowView>();
        for (AView v : this.selectedList) {
            GroupView g = null;
            if (v instanceof WindowView) {
                WindowView w = (WindowView)v;
                if (!list.contains(w)) {
                    list.add(w);
                }
                g = w.getNestedGroup();
            } else if (v instanceof GroupView) {
                g = (GroupView)v;
            }
            if (g == null) continue;
            this.addWindows(g, list);
        }
        return list;
    }

    void addWindows(GroupView g, List<WindowView> list) {
        for (WindowView w : g.windows) {
            GroupView ng;
            if (!list.contains(w)) {
                list.add(w);
            }
            if ((ng = w.getNestedGroup()) == null) continue;
            this.addWindows(ng, list);
        }
    }

    public void deleteSelected() {
        ArrayList<WindowView> wlist = this.getAllSelectedWindows();
        if (wlist.size() > 1 && !IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u043a\u043d\u0430 (" + wlist.size() + " \u0448\u0442.)?")) {
            return;
        }
        while (!this.selectedList.isEmpty()) {
            AView v = this.selectedList.get(0);
            if (v instanceof WindowView) {
                this.delWindow((WindowView)v);
                continue;
            }
            if (!(v instanceof GroupView)) continue;
            this.delGroup((GroupView)v);
        }
        if (this.mainGroup.windows.isEmpty()) {
            new WindowView(this.mainGroup, 0);
        }
        this.arrangeWindows();
    }

    public GroupView groupAtCell(int x, int y) {
        return this.groupAtCell(x, y, this.mainGroup);
    }

    private GroupView groupAtCell(int x, int y, GroupView g) {
        if (g == null) {
            return null;
        }
        if (!g.isSelected() && g.containsCell(x, y)) {
            return g;
        }
        for (WindowView w : g.getList()) {
            GroupView g1 = this.groupAtCell(x, y, w.getNestedGroup());
            if (g1 == null) continue;
            return g1;
        }
        return null;
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
    }

    private void initLCD() {
        Device dev = this.mainFrame.program.device;
        WindowView.initLcd(dev.FONT, dev.DISPLAY_COLS, dev.DISPLAY_ROWS);
        CELL_WIDTH = WindowView.WIN_WIDTH + 20;
        CELL_HEIGHT = WindowView.WIN_HEIGHT + 50;
        this.scroller.getVerticalScrollBar().setUnitIncrement(CELL_HEIGHT / 3);
    }

    public void arrangeWindows() {
        this.mainGroup.arrange(0, 0);
        this.mainGroup.updateNames(null);
        this.pane.updateSize();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.initLCD();
        this.mainGroup = new GroupView(this, null);
        this.mainGroup.loadWindows(this.mainFrame.program, this.mainFrame.program.firstWindow);
        this.arrangeWindows();
        this.updateVarRefs();
        this.reset();
    }

    @Override
    public void initNewProgram() {
        this.initLCD();
        this.mainGroup = new GroupView(this, null);
        WindowView w = new WindowView(this.mainGroup);
        w.title = " Hello  ";
        w.text = " world! ";
        w.updatePreview();
        this.mainGroup.updateWidth();
        this.updateBounds(this.mainGroup);
        this.arrangeWindows();
        this.updateVarRefs();
        this.reset();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        this.mainGroup.updateNames(null);
        this.mainGroup.compileWindows(this.mainFrame.program);
    }

    @Override
    public void saveProps() {
        Main.props.saveInt(PROP_ZOOM, this.zoom);
    }

    private void updateGroupVarRefs(GroupView g) {
        for (WindowView w : g.windows) {
            GroupView g1;
            if (w.var != null) {
                w.var.varDef.addWindowRef(w, w.editable);
            }
            if (w.titleVar != null) {
                w.titleVar.varDef.addWindowRef(w, false);
            }
            if (w.visibleVar != null) {
                w.visibleVar.varDef.addWindowRef(w, false);
            }
            if ((g1 = w.getNestedGroup()) == null) continue;
            this.updateGroupVarRefs(g1);
        }
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearWindowsRefs();
        this.updateGroupVarRefs(this.mainGroup);
    }

    @Override
    public void updateVarList() {
    }

    @Override
    public void titleClicked() {
        this.initFocus();
    }

    @Override
    public void initFocus() {
        this.pane.requestFocusInWindow();
    }

    public void startRelocation() {
        this.relocating = true;
        this.clearFocus();
        this.setCursor(CURSOR_RELOCATE);
        this.pane.repaint();
        IdeAction.updateAll();
    }

    private List<AView> getSelectedRoots() {
        ArrayList<AView> res = new ArrayList<AView>(this.selectedList);
        Iterator it = res.iterator();
        while (it.hasNext()) {
            AView v = (AView)it.next();
            if (!v.parentSelected) continue;
            it.remove();
        }
        return res;
    }

    private void relocateToGroup(List<AView> items, GroupView target, int pos) {
        if (!target.canInsertWindow()) {
            return;
        }
        this.clearSelection();
        for (AView v : items) {
            GroupView g;
            if (v instanceof WindowView) {
                g = ((WindowView)v).getParentGroup();
                if (((WindowView)v).relocateTo(target, pos)) {
                    ++pos;
                }
                this.selectElement(v, true);
                if (!g.getList().isEmpty()) continue;
                this.delGroup(g);
                continue;
            }
            if (!(v instanceof GroupView)) continue;
            g = (GroupView)v;
            ArrayList<WindowView> wl = new ArrayList<WindowView>(g.getList());
            for (WindowView w : wl) {
                if (w.relocateTo(target, pos)) {
                    ++pos;
                }
                this.selectElement(w, true);
            }
            if (!g.getList().isEmpty()) continue;
            this.delGroup(g);
        }
        target.updateSelection();
    }

    private void relocateToWindow(List<AView> items, WindowView target) {
        if (target.leftLinkHover) {
            this.relocateToGroup(items, target.getParentGroup(), target.position);
        } else if (target.rightLinkHover) {
            this.relocateToGroup(items, target.getParentGroup(), target.position + 1);
        } else {
            if (!target.canAddNestedWindow()) {
                return;
            }
            boolean select = false;
            GroupView newGroup = target.getNestedGroup();
            if (newGroup == null) {
                for (AView v : items) {
                    if (!(v instanceof GroupView)) continue;
                    newGroup = (GroupView)v;
                    newGroup.relocateTo(target);
                    select = true;
                    break;
                }
                if (newGroup != null) {
                    items.remove(newGroup);
                } else {
                    newGroup = new GroupView(this, target);
                    select = true;
                }
            }
            this.relocateToGroup(items, newGroup, newGroup.getList().size());
            if (select) {
                this.selectElement(newGroup, false);
            }
        }
    }

    public boolean isRelocating() {
        return this.relocating;
    }

    public void copyToClipboard(boolean cut, boolean recursive) {
        if (this.hasSelection()) {
            ArrayList<WindowView> wlist = new ArrayList<WindowView>();
            for (AView v : this.selectedList) {
                if (v instanceof GroupView) {
                    for (WindowView w : ((GroupView)v).windows) {
                        if (wlist.contains(w)) continue;
                        wlist.add(w);
                    }
                    continue;
                }
                if (wlist.contains((WindowView)v)) continue;
                wlist.add((WindowView)v);
            }
            ClipboardUtils.putData(this.saveForClipboard(wlist, !recursive), 'w');
            if (cut) {
                this.deleteSelected();
            }
        }
    }

    public void pasteFromClipboard() {
        if (!this.canInsertWindow()) {
            return;
        }
        JSONObject json = ClipboardUtils.getData('w');
        if (json != null) {
            try {
                this.loadFromClipboard(json);
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
            }
        }
    }

    private JSONObject saveForClipboard(List<WindowView> list, boolean selectedOnly) {
        JSONArray jsa = new JSONArray();
        ArrayList<VariableDef> vars = new ArrayList<VariableDef>();
        this.mainGroup.clearStoredFlag();
        for (WindowView w : list) {
            JSONObject jso;
            if (!w.saveToJSON(jso = new JSONObject(), vars, selectedOnly)) continue;
            jsa.put(jso);
        }
        JSONObject jsonClipboard = new JSONObject();
        VariablesEditor.saveToJson(jsonClipboard, vars);
        jsonClipboard.put(JSON_WINDOWS, jsa);
        return jsonClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromClipboard(JSONObject json) throws SyntaxError, JSONException, FbdLoadError {
        JSONArray jsa = json.optJSONArray(JSON_WINDOWS);
        if (jsa == null) {
            return;
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        if (!ved.loadFromClipboard(json, false, false, varMap)) {
            return;
        }
        GroupView g = this.focusedGroup;
        if (g == null) {
            g = this.focusedWindow.getParentGroup();
        }
        if (g != null) {
            int position = 0;
            if (this.focusedWindow != null) {
                position = this.focusedWindow.position + 1;
            }
            this.clearFocus();
            this.clearSelection();
            ved.setVarMap(varMap);
            try {
                for (int i = 0; i < jsa.length(); ++i) {
                    WindowView w = new WindowView(g, position);
                    ++position;
                    w.loadFromJSON(this.mainFrame.program, jsa.getJSONObject(i));
                    this.addToSelLists(w);
                    if (i != 0) continue;
                    this.focusWindow(w);
                }
            }
            finally {
                ved.setVarMap(null);
            }
            g.updatePreview();
            this.arrangeWindows();
            this.commitAction();
            IdeAction.updateAll();
        }
    }

    public boolean canInsertWindow() {
        GroupView g = this.focusedGroup;
        if (g == null && this.focusedWindow != null) {
            g = this.focusedWindow.getParentGroup();
        }
        return g != null && g.canInsertWindow();
    }

    public void createWindow(WindowView start, boolean toLeft) {
        GroupView g;
        WindowView lastFocus = this.focusedWindow;
        this.clearSelection();
        GroupView groupView = g = start != null ? start.getParentGroup() : this.focusedGroup;
        if (g != null) {
            int pos = g.windows.size();
            if (start != null) {
                pos = start.position + (toLeft ? 0 : 1);
            }
            WindowView w = new WindowView(g, pos);
            g.updatePreview();
            this.arrangeWindows();
            this.focusWindow(w);
            this.commitAction();
            IdeAction.updateAll();
            if (!WindowPropsDialog.showDialog(w)) {
                this.delWindow(w);
                g.updatePreview();
                this.focusWindow(lastFocus);
            }
            if (start != null) {
                start.updatePreview();
            }
            this.arrangeWindows();
            this.commitAction();
            IdeAction.updateAll();
        }
    }

    public void createSubMenu(WindowView start) {
        WindowView lastFocus = this.focusedWindow;
        this.clearSelection();
        if (start != null) {
            GroupView g = new GroupView(this, start);
            WindowView w = new WindowView(g);
            g.updatePreview();
            this.arrangeWindows();
            this.focusWindow(w);
            this.commitAction();
            IdeAction.updateAll();
            if (!WindowPropsDialog.showDialog(w)) {
                this.selectElement(g, false);
                this.deleteSelected();
                this.focusWindow(lastFocus);
            }
            if (start != null) {
                start.updatePreview();
            }
            this.arrangeWindows();
            this.commitAction();
            IdeAction.updateAll();
        }
    }

    public void exportImage(File file, String format) throws IOException {
        MainFrame.instance.startWaitCursor();
        try {
            ImageIO.write((RenderedImage)this.pane.exportImage(), format, file);
        }
        finally {
            MainFrame.instance.stopWaitCursor();
        }
    }

    static {
        CURSOR_NORMAL = Cursor.getDefaultCursor();
        CURSOR_RELOCATE = Cursor.getPredefinedCursor(12);
    }

    class EditPane
    extends JComponent {
        private static final long serialVersionUID = 1L;

        EditPane() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            WindowView w = UiEditor.this.hoveredWindow;
            if (w != null && (w.leftLinkHover || w.rightLinkHover || w.downLinkHover)) {
                return null;
            }
            return UiEditor.this.currentTipText;
        }

        @Override
        public void paintComponent(Graphics g) {
            UiEditor.this.selVar = UiEditor.this.mainFrame.getVarsEditor().getSelectedVariable();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.scale((double)UiEditor.this.zoom / 100.0, (double)UiEditor.this.zoom / 100.0);
            UiEditor.this.paintGroup(UiEditor.this.mainGroup, g2d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage exportImage() {
            int scale = 1;
            int w = this.calcWidth() * scale;
            int h = this.calcHeight() * scale;
            BufferedImage img = new BufferedImage(w, h, 1);
            Graphics2D g2 = img.createGraphics();
            g2.scale(scale, scale);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, w, h);
            UiEditor.this.exportPaint = true;
            try {
                UiEditor.this.paintGroup(UiEditor.this.mainGroup, g2);
            }
            finally {
                UiEditor.this.exportPaint = false;
            }
            return img;
        }

        int calcWidth() {
            return (UiEditor.this.getMaxX(UiEditor.this.mainGroup) + 1) * CELL_WIDTH + 60;
        }

        int calcHeight() {
            return (UiEditor.this.getMaxY(UiEditor.this.mainGroup) + 1) * CELL_HEIGHT + 20;
        }

        protected void updateSize() {
            if (UiEditor.this.mainFrame.program != null) {
                this.setPreferredSize(new Dimension(this.calcWidth() * UiEditor.this.zoom / 100, this.calcHeight() * UiEditor.this.zoom / 100));
                this.setSize(this.getPreferredSize());
            }
        }
    }
}

