/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.LcdEditDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class CharButton
extends JButton {
    private static final long serialVersionUID = 1L;
    static final Insets margins = new Insets(2, 2, 2, 2);
    final int code;
    final LcdEditDisplay display;

    public CharButton(LcdEditDisplay display, int code) {
        this.code = code & 0xFF;
        this.display = display;
        LcdFont f = display.getLcdFont();
        BufferedImage img = new BufferedImage(f.charWidth() * 2, f.charHeight() * 2, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.BLACK);
        for (int y = 0; y < f.charHeight(); ++y) {
            for (int x = 0; x < f.charWidth(); ++x) {
                if (!f.getCharPoint((byte)code, x, y)) continue;
                g2.fillRect(x * 2, y * 2, 2, 2);
            }
        }
        this.setIcon(new ImageIcon(img));
        this.setFocusable(false);
        this.setMargin(margins);
        this.setToolTipText("#" + (this.code < 16 ? "0" : "") + Integer.toHexString(this.code));
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
        this.display.requestFocusInWindow();
        this.display.setCode((byte)this.code);
    }
}

