/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.BlockDef;
import certa.vics.ide.fbd.BlocksActions;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.blocks.AbsF;
import certa.vics.ide.fbd.blocks.AbsI;
import certa.vics.ide.fbd.blocks.Actuator3P;
import certa.vics.ide.fbd.blocks.ActuatorA;
import certa.vics.ide.fbd.blocks.ActuatorD;
import certa.vics.ide.fbd.blocks.AddF;
import certa.vics.ide.fbd.blocks.AddI;
import certa.vics.ide.fbd.blocks.And;
import certa.vics.ide.fbd.blocks.AverF;
import certa.vics.ide.fbd.blocks.AverI;
import certa.vics.ide.fbd.blocks.BtoI;
import certa.vics.ide.fbd.blocks.Counter;
import certa.vics.ide.fbd.blocks.CounterSimple;
import certa.vics.ide.fbd.blocks.DelayOff;
import certa.vics.ide.fbd.blocks.DelayOn;
import certa.vics.ide.fbd.blocks.DivF;
import certa.vics.ide.fbd.blocks.DivI;
import certa.vics.ide.fbd.blocks.EquB;
import certa.vics.ide.fbd.blocks.EquF;
import certa.vics.ide.fbd.blocks.EquI;
import certa.vics.ide.fbd.blocks.FtoI;
import certa.vics.ide.fbd.blocks.GisterF;
import certa.vics.ide.fbd.blocks.GisterI;
import certa.vics.ide.fbd.blocks.GrEqF;
import certa.vics.ide.fbd.blocks.GrEqI;
import certa.vics.ide.fbd.blocks.GreaterF;
import certa.vics.ide.fbd.blocks.GreaterI;
import certa.vics.ide.fbd.blocks.Impulse;
import certa.vics.ide.fbd.blocks.IntervF;
import certa.vics.ide.fbd.blocks.IntervI;
import certa.vics.ide.fbd.blocks.ItoB;
import certa.vics.ide.fbd.blocks.ItoF;
import certa.vics.ide.fbd.blocks.LeEqF;
import certa.vics.ide.fbd.blocks.LeEqI;
import certa.vics.ide.fbd.blocks.LessF;
import certa.vics.ide.fbd.blocks.LessI;
import certa.vics.ide.fbd.blocks.LimMaxF;
import certa.vics.ide.fbd.blocks.LimMaxI;
import certa.vics.ide.fbd.blocks.LimMinF;
import certa.vics.ide.fbd.blocks.LimMinI;
import certa.vics.ide.fbd.blocks.LineF;
import certa.vics.ide.fbd.blocks.Mod;
import certa.vics.ide.fbd.blocks.MovIfB;
import certa.vics.ide.fbd.blocks.MovIfF;
import certa.vics.ide.fbd.blocks.MovIfI;
import certa.vics.ide.fbd.blocks.MoveB;
import certa.vics.ide.fbd.blocks.MoveF;
import certa.vics.ide.fbd.blocks.MoveI;
import certa.vics.ide.fbd.blocks.MulF;
import certa.vics.ide.fbd.blocks.MulI;
import certa.vics.ide.fbd.blocks.Not;
import certa.vics.ide.fbd.blocks.NotEqB;
import certa.vics.ide.fbd.blocks.NotEqF;
import certa.vics.ide.fbd.blocks.NotEqI;
import certa.vics.ide.fbd.blocks.Or;
import certa.vics.ide.fbd.blocks.PI;
import certa.vics.ide.fbd.blocks.PID;
import certa.vics.ide.fbd.blocks.Pulse;
import certa.vics.ide.fbd.blocks.RSt;
import certa.vics.ide.fbd.blocks.Rotate2;
import certa.vics.ide.fbd.blocks.SRt;
import certa.vics.ide.fbd.blocks.SelB;
import certa.vics.ide.fbd.blocks.SelF;
import certa.vics.ide.fbd.blocks.SelI;
import certa.vics.ide.fbd.blocks.SignF;
import certa.vics.ide.fbd.blocks.SignI;
import certa.vics.ide.fbd.blocks.SubF;
import certa.vics.ide.fbd.blocks.SubI;
import certa.vics.ide.fbd.blocks.SwiB;
import certa.vics.ide.fbd.blocks.SwiF;
import certa.vics.ide.fbd.blocks.SwiI;
import certa.vics.ide.fbd.blocks.Timer;
import certa.vics.ide.fbd.blocks.XYTable;
import certa.vics.ide.fbd.blocks.Xor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class BlocksTree
extends JComponent {
    private static final long serialVersionUID = 1L;
    protected DefaultMutableTreeNode root;
    protected JTree tree;
    protected BlocksActions actions;
    protected JPopupMenu popup;

    public BlocksTree(final FbdEditor dropTarget, boolean usePopup) {
        this.setLayout(new BorderLayout());
        this.tree = new JTree(this.createLibrary());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        if (dropTarget != null) {
            this.tree.setDragEnabled(true);
            this.tree.setTransferHandler(new TransferHandler(){
                private static final long serialVersionUID = 1L;

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                public Transferable createTransferable(JComponent c) {
                    BlockDef bd = BlocksTree.this.getSelectedBlockDef();
                    FbdPage page = dropTarget.currentPage();
                    if (bd != null && page != null) {
                        return new FbdEditor.AddingItem(bd.createBlock(page));
                    }
                    return null;
                }

                @Override
                public void exportDone(JComponent c, Transferable t, int action) {
                }
            });
        }
        if (usePopup) {
            this.actions = new BlocksActions(this, dropTarget != null ? dropTarget.pnlBlocks : null);
            IdeUtils.bindActions(this.tree, this.actions);
            this.popup = new JPopupMenu();
            this.popup.add(new JMenuItem(this.actions.itemHelp));
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    BlocksTree.this.actions.update();
                }
            });
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        BlocksTree.this.tree.requestFocusInWindow();
                        int row = BlocksTree.this.tree.getClosestRowForLocation(e.getX(), e.getY());
                        BlocksTree.this.tree.setSelectionRow(row);
                        BlocksTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add((Component)treeView, "Center");
    }

    protected boolean selectBlockDef(Class<? extends AFbdBlock> blockClass, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            if (n == null) continue;
            if (n.isLeaf()) {
                Object obj = n.getUserObject();
                if (!(obj instanceof BlockDef)) continue;
                BlockDef b = (BlockDef)obj;
                if (b.blockClass != blockClass) continue;
                TreePath path = new TreePath(n.getPath());
                this.tree.setSelectionPath(path);
                this.tree.scrollPathToVisible(path);
                return true;
            }
            if (!this.selectBlockDef(blockClass, n)) continue;
            return true;
        }
        return false;
    }

    private void addBlockNode(DefaultMutableTreeNode cat, Class<? extends AFbdBlock> blockClass) {
        try {
            String name = (String)blockClass.getField("libName").get(null);
            String doc = (String)blockClass.getField("libDoc").get(null);
            cat.add(new DefaultMutableTreeNode(new BlockDef(blockClass, name, doc)));
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
        }
    }

    DefaultMutableTreeNode createLibrary() {
        this.root = new DefaultMutableTreeNode("\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0431\u043b\u043e\u043a\u043e\u0432");
        DefaultMutableTreeNode category = null;
        category = new DefaultMutableTreeNode("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435");
        this.root.add(category);
        this.addBlockNode(category, Not.class);
        this.addBlockNode(category, And.class);
        this.addBlockNode(category, Or.class);
        this.addBlockNode(category, Xor.class);
        category = new DefaultMutableTreeNode("\u0410\u0440\u0438\u0444\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435");
        this.root.add(category);
        this.addBlockNode(category, AddF.class);
        this.addBlockNode(category, AddI.class);
        this.addBlockNode(category, SubF.class);
        this.addBlockNode(category, SubI.class);
        this.addBlockNode(category, MulF.class);
        this.addBlockNode(category, MulI.class);
        this.addBlockNode(category, DivF.class);
        this.addBlockNode(category, DivI.class);
        this.addBlockNode(category, Mod.class);
        this.addBlockNode(category, AverF.class);
        this.addBlockNode(category, AverI.class);
        this.addBlockNode(category, AbsF.class);
        this.addBlockNode(category, AbsI.class);
        this.addBlockNode(category, SignF.class);
        this.addBlockNode(category, SignI.class);
        this.addBlockNode(category, LimMaxF.class);
        this.addBlockNode(category, LimMaxI.class);
        this.addBlockNode(category, LimMinF.class);
        this.addBlockNode(category, LimMinI.class);
        category = new DefaultMutableTreeNode("\u0421\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u0435");
        this.root.add(category);
        this.addBlockNode(category, EquF.class);
        this.addBlockNode(category, EquI.class);
        this.addBlockNode(category, EquB.class);
        this.addBlockNode(category, NotEqF.class);
        this.addBlockNode(category, NotEqI.class);
        this.addBlockNode(category, NotEqB.class);
        this.addBlockNode(category, LessF.class);
        this.addBlockNode(category, LessI.class);
        this.addBlockNode(category, GreaterF.class);
        this.addBlockNode(category, GreaterI.class);
        this.addBlockNode(category, LeEqF.class);
        this.addBlockNode(category, LeEqI.class);
        this.addBlockNode(category, GrEqF.class);
        this.addBlockNode(category, GrEqI.class);
        this.addBlockNode(category, IntervF.class);
        this.addBlockNode(category, IntervI.class);
        this.addBlockNode(category, GisterF.class);
        this.addBlockNode(category, GisterI.class);
        category = new DefaultMutableTreeNode("\u0421\u0435\u043b\u0435\u043a\u0442\u043e\u0440\u044b \u0438 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0442\u0435\u043b\u0438");
        this.root.add(category);
        this.addBlockNode(category, SwiB.class);
        this.addBlockNode(category, SwiI.class);
        this.addBlockNode(category, SwiF.class);
        this.addBlockNode(category, SelB.class);
        this.addBlockNode(category, SelI.class);
        this.addBlockNode(category, SelF.class);
        category = new DefaultMutableTreeNode("\u0418\u043d\u0442\u0435\u0440\u043f\u043e\u043b\u044f\u0446\u0438\u044f");
        this.root.add(category);
        this.addBlockNode(category, LineF.class);
        this.addBlockNode(category, XYTable.class);
        category = new DefaultMutableTreeNode("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445");
        this.root.add(category);
        this.addBlockNode(category, MoveF.class);
        this.addBlockNode(category, MoveI.class);
        this.addBlockNode(category, MoveB.class);
        this.addBlockNode(category, MovIfF.class);
        this.addBlockNode(category, MovIfI.class);
        this.addBlockNode(category, MovIfB.class);
        category = new DefaultMutableTreeNode("\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u043e\u0432");
        this.root.add(category);
        this.addBlockNode(category, FtoI.class);
        this.addBlockNode(category, ItoF.class);
        this.addBlockNode(category, BtoI.class);
        this.addBlockNode(category, ItoB.class);
        category = new DefaultMutableTreeNode("\u0422\u0440\u0438\u0433\u0433\u0435\u0440\u044b");
        this.root.add(category);
        this.addBlockNode(category, RSt.class);
        this.addBlockNode(category, SRt.class);
        category = new DefaultMutableTreeNode("\u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438");
        this.root.add(category);
        this.addBlockNode(category, CounterSimple.class);
        this.addBlockNode(category, Counter.class);
        category = new DefaultMutableTreeNode("\u0418\u043c\u043f\u0443\u043b\u044c\u0441\u044b \u0438 \u0442\u0430\u0439\u043c\u0435\u0440\u044b");
        this.root.add(category);
        this.addBlockNode(category, Impulse.class);
        this.addBlockNode(category, Pulse.class);
        this.addBlockNode(category, Timer.class);
        this.addBlockNode(category, DelayOn.class);
        this.addBlockNode(category, DelayOff.class);
        this.addBlockNode(category, Rotate2.class);
        category = new DefaultMutableTreeNode("\u0420\u0435\u0433\u0443\u043b\u044f\u0442\u043e\u0440\u044b");
        this.root.add(category);
        this.addBlockNode(category, Actuator3P.class);
        this.addBlockNode(category, PI.class);
        this.addBlockNode(category, PID.class);
        this.addBlockNode(category, ActuatorA.class);
        this.addBlockNode(category, ActuatorD.class);
        return this.root;
    }

    public BlockDef getSelectedBlockDef() {
        Object obj;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf() && (obj = node.getUserObject()) instanceof BlockDef) {
            return (BlockDef)obj;
        }
        return null;
    }
}

