/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AFbdBlock
extends AFbdItem {
    static final Color BODY_COLOR;
    static final Color HOVER_COLOR;
    protected int execOrder;
    protected ArrayList<InputPin> inputs;
    protected ArrayList<OutputPin> outputs;
    protected static final String JSON_INPUTS = "inputs";
    static final Font ORDER_FONT;
    static final Font ERROR_FONT;
    private String error = null;

    public AFbdBlock(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page, src);
    }

    protected static String imgUrl(String fileName) {
        return ClassLoader.getSystemResource(fileName).toString();
    }

    @Override
    protected void init(JSONObject src) throws JSONException, FbdLoadError {
        this.padLeft = 1;
        this.padTop = 1;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.createPins(src);
        this.cellBounds.width = this.initWidth(src) + this.padLeft;
        if (src != null) {
            JSONArray inputsArray = src.getJSONArray(JSON_INPUTS);
            for (int i = 0; i < this.inputs.size(); ++i) {
                this.inputs.get(i).initSourceId(inputsArray.getInt(i));
            }
        }
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
        JSONArray inputsArray = new JSONArray();
        jso.put(JSON_INPUTS, inputsArray);
        for (InputPin pin : this.inputs) {
            inputsArray.put(pin.getSourceId());
        }
    }

    protected abstract void createPins(JSONObject var1) throws JSONException, FbdLoadError;

    protected int initWidth(JSONObject src) throws JSONException, FbdLoadError {
        return 1;
    }

    public String getError() {
        return null;
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        this.error = this.getError();
        this.updateBounds();
        if (this.error == null) {
            g2d.setColor(this.page != null && this.page.editor.hoveredView == this ? HOVER_COLOR : BODY_COLOR);
        } else {
            g2d.setColor(Color.RED);
        }
        g2d.fillRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        g2d.setStroke(SHAPE_STROKE);
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        g2d.setColor(Color.BLACK);
        g2d.setFont(ORDER_FONT);
        g2d.drawString(Integer.toString(this.execOrder), this.pxBounds.x, this.pxBounds.y - 2);
        this.paintFocus(g2d);
        for (InputPin pin : this.inputs) {
            pin.paint(g2d);
        }
    }

    @Override
    public void paintLinks(Graphics2D g2d) {
        for (OutputPin pin : this.outputs) {
            pin.paint(g2d);
        }
        if (this.error != null) {
            g2d.setColor(Color.RED);
            g2d.setFont(ERROR_FONT);
            g2d.drawString(this.error, this.pxBounds.x, this.pxBounds.y + this.pxBounds.height + 20);
        }
    }

    @Override
    protected void resolveLinks(boolean strict) throws FbdLoadError {
        for (InputPin input : this.inputs) {
            input.resolveLink(strict);
        }
    }

    @Override
    public OutputPin getOutput(int index) {
        if (index >= 0 && index < this.outputs.size()) {
            return this.outputs.get(index);
        }
        return null;
    }

    @Override
    public int getOutputIndex(OutputPin pin) {
        return this.outputs.indexOf(pin);
    }

    private boolean needGlobalVar(OutputPin out) {
        for (InputPin in : out.targets) {
            if (in.owner instanceof AFbdBlock && ((AFbdBlock)in.owner).execOrder <= this.execOrder) {
                return true;
            }
            if (!(in.owner instanceof FbdVariable) || !this.needGlobalVar(((FbdVariable)in.owner).outPin)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void compileOutputVars() throws SyntaxError {
        for (OutputPin out : this.outputs) {
            if (this.needGlobalVar(out)) {
                out.setCompiledVar(this.page.editor.allocGlobalVar(out.type, 0.0));
                continue;
            }
            boolean needAlloc = out.targets.isEmpty();
            for (int i = 0; i < out.targets.size() && !needAlloc; ++i) {
                if (out.targets.get(i).isVariable()) continue;
                needAlloc = true;
            }
            if (needAlloc) {
                out.setCompiledVar(this.page.editor.allocLocalVar(out.type, 0.0));
                continue;
            }
            out.setCompiledVar(((FbdVariable)out.targets.get((int)0).owner).outPin.getCompiledVar());
        }
    }

    @Override
    public void compileInputVars() throws SyntaxError {
        for (InputPin in : this.inputs) {
            OutputPin src = in.getSource();
            if (src != null) {
                in.setCompiledVar(src.getCompiledVar());
                continue;
            }
            in.setCompiledVar(this.page.getNullVar(in.type, in.isArray));
        }
    }

    public abstract void makeSpecificCode(ArrayList<String> var1);

    public void compileCode(ArrayList<String> code) {
        this.makeSpecificCode(code);
        for (OutputPin out : this.outputs) {
            Variable src = out.getCompiledVar();
            for (InputPin tgt : out.targets) {
                Variable dest;
                if (!tgt.isVariable() || src == (dest = tgt.getCompiledVar())) continue;
                code.add(AFbdBlock.moveCmdName(out.type) + " " + src.fullName() + " " + dest.fullName());
            }
        }
    }

    private static String moveCmdName(int type) {
        if (type == 1) {
            return "MovB";
        }
        if (type == 2) {
            return "MovI";
        }
        return "MovF";
    }

    @Override
    public void updateBounds() {
        this.cellBounds.height = Math.max(this.inputs.size(), this.outputs.size()) + this.padTop;
        this.pxBounds.x = (this.cellBounds.x + this.padLeft) * 27;
        this.pxBounds.y = (this.cellBounds.y + this.padTop) * 27;
        this.pxBounds.width = (this.cellBounds.width - this.padLeft) * 27;
        this.pxBounds.height = (this.cellBounds.height - this.padTop) * 27;
    }

    @Override
    public AFbdPin getPinAt(int x, int y) {
        for (InputPin inputPin : this.inputs) {
            if (!inputPin.bounds.contains(x, y)) continue;
            return inputPin;
        }
        for (OutputPin outputPin : this.outputs) {
            if (!outputPin.bounds.contains(x, y)) continue;
            return outputPin;
        }
        return null;
    }

    @Override
    public AFbdPin getPinAt(Rectangle r) {
        for (InputPin inputPin : this.inputs) {
            if (!inputPin.bounds.intersects(r)) continue;
            return inputPin;
        }
        for (OutputPin outputPin : this.outputs) {
            if (!outputPin.bounds.intersects(r)) continue;
            return outputPin;
        }
        return null;
    }

    @Override
    public void disconnectAll() {
        for (OutputPin outputPin : this.outputs) {
            outputPin.disconnectTargets();
        }
        for (InputPin inputPin : this.inputs) {
            inputPin.connectSource(null);
        }
    }

    static {
        HOVER_COLOR = BODY_COLOR = new Color(0xD0D0D0);
        ORDER_FONT = new Font("Sans", 0, 12);
        ERROR_FONT = new Font("Sans", 0, 10);
    }
}

