/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.archive;

import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.archive.ArchiveActions;
import certa.vics.ide.archive.ArchiveItemView;
import certa.vics.ide.archive.ArchiveTableView;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import javax.swing.JMenu;
import org.json.JSONObject;

public class ArchiveEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    ArchiveActions actions;
    protected final MainFrame mainFrame;
    final ArchiveTableView table;
    static final String PROP_KEY = "archive";

    public ArchiveEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0410\u0440\u0445\u0438\u0432 \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
        this.mainFrame = mainFrame;
        this.table = new ArchiveTableView(this);
        this.loadProps();
        this.add((Component)this.table, "Center");
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new ArchiveActions(this);
        return this.actions;
    }

    @Override
    public void titleClicked() {
        this.table.requestFocusInWindow();
    }

    @Override
    public void initFocus() {
        this.table.updateVarList(this.mainFrame.getVarsEditor());
        this.table.requestFocusInWindow();
    }

    @Override
    public void clear() {
        this.table.load(null, null);
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        this.table.isModified = false;
    }

    private void buildLists() {
        this.table.load(this.mainFrame.program, this.mainFrame.getVarsEditor());
    }

    @Override
    public void initNewProgram() {
        this.buildLists();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.buildLists();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        this.table.compile(this.mainFrame.program);
    }

    private void loadProps() {
    }

    @Override
    public void saveProps() {
        this.table.saveProps();
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearArchiveRefs();
        for (ArchiveItemView ai : this.table.list) {
            if (ai.var == null) continue;
            ai.var.varDef.addArchiveRef();
        }
        ved.updateTable();
    }

    @Override
    public void updateVarList() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        this.table.updateVarList(ved);
    }
}

