/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import certa.vics.compiler.Argument;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.Program;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import java.io.PrintWriter;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;

public class ExportAsm
extends Program {
    private ExportAsm() {
    }

    public void printAsm() throws SyntaxError, ErrorInFile {
        this.makeBinaryData();
        System.out.println("; Source: " + this.SourceFile);
        System.out.println(";");
        System.out.println("; Memory usage (bytes)");
        System.out.println(";   RAM:          " + this.getRamSize() + ",   (max: " + this.device.RamSize + ")");
        System.out.println(";   EEPROM:       " + this.getStoreSize() + ",   (max: " + this.device.EepromSize + ")");
        System.out.println(";   NVRAM:        " + this.getExtSize() + ",   (max: " + this.device.NvramSize + ")");
        System.out.println(";   FLASH:        " + this.getFlashSize() + ",   (max: " + this.device.FlashSize + ")");
        System.out.println(";     code:       " + this.getAllCodeSize());
        System.out.println(";     modbus:     " + this.getModbusSize());
        System.out.println(";     RAM init:   " + this.getRamInitSize());
        System.out.println(";     windows:    " + this.getWindowsSize());
        System.out.println(";     constants:  " + this.getConstSize());
        System.out.println();
        System.out.println();
        System.out.println("; System variables default values:");
        System.out.println(";");
        this.printVars(this.device.SysOutVars, true, true);
        this.printVars(this.device.SysStoreVars, true, true);
        this.printVars(this.device.SysExtVars, true, true);
        System.out.println();
        System.out.println();
        System.out.println("; Variables and constants:");
        System.out.println(";");
        this.printVars(this.RamVars, true, false);
        this.printVars(this.StoreVars, true, false);
        this.printVars(this.ExtVars, true, false);
        this.printVars(this.Constants, true, false);
        System.out.println();
        System.out.println();
        System.out.println("; Main code at $" + Integer.toHexString(this.MainCode.startAddress));
        System.out.println(";");
        this.printCode(this.MainCode);
        System.out.println();
        System.out.println();
        this.printSubs();
        System.out.println("; Modbus table at $" + Integer.toHexString(this.Modbus.startAddress));
        System.out.println(";");
        int addr = this.Modbus.startAddress;
        addr = this.printModbus(addr, this.Modbus.Coils, "Coil", false);
        addr = this.printModbus(addr, this.Modbus.Inputs, "Input", false);
        addr = this.printModbus(addr, this.Modbus.HRs, "HR", true);
        addr = this.printModbus(addr, this.Modbus.IRs, "IR", true);
        System.out.println();
        System.out.println();
        System.out.println("; RAM init table at $" + Integer.toHexString(this.Modbus.startAddress + this.Modbus.getSize()));
        System.out.println(";");
        System.out.println();
        System.out.println();
        System.out.println("; Windows and strings at $" + Integer.toHexString(this.getWindowsAddress()));
        System.out.println(";");
        this.printWindows();
        System.out.println();
        System.out.println();
        PrintWriter pw = new PrintWriter(System.out);
        this.dumpBinaryData(pw);
        pw.close();
    }

    private void printVars(VariablesBlock vd, boolean value, boolean initOnly) {
        for (Variable v : vd.map.values()) {
            String init = "";
            if (value && !Double.isNaN(v.initValue)) {
                init = " = ";
                init = v.type == 3 ? init + v.initValue : init + Math.round(v.initValue);
            }
            if (initOnly && init.isEmpty()) continue;
            System.out.println(this.codeAddress(v.getAddress()) + v.fullArrayNameSize() + init);
        }
    }

    private String codeAddress(int addr) {
        return "; $" + this.wordToHex2(addr) + ":  ";
    }

    private int printModbus(int addr, ArrayList<ModbusReg> list, String prefix, boolean withType) {
        System.out.println(this.codeAddress(addr) + prefix + "s count: " + list.size());
        ++addr;
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            if (r != null) {
                System.out.println(this.codeAddress(addr) + prefix + i + " -> " + r.var.fullName());
            } else {
                System.out.println(this.codeAddress(addr) + prefix + i + " -> NULL");
            }
            addr += 2;
            if (!withType) continue;
            ++addr;
        }
        return addr;
    }

    private void printSubs() throws SyntaxError {
        for (CodeBlock cb : this.Subs.values()) {
            System.out.println("; Subprogram \"" + cb.Name + "\", address: $" + Integer.toHexString(cb.startAddress));
            System.out.println(";");
            this.printCode(cb);
            System.out.println();
            System.out.println();
        }
    }

    private void printCode(CodeBlock cb) throws SyntaxError {
        for (Command ci : cb.Items) {
            for (String lbl : cb.Labels.keySet()) {
                if (cb.Labels.get(lbl) != ci.offset) continue;
                System.out.println("; :" + lbl);
            }
            String s = this.codeAddress(cb.startAddress + ci.offset) + ci.cmdDef.Name;
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    s = s + " " + (Integer)arg.Value;
                    continue;
                }
                if (arg.Type == 5) {
                    s = s + " " + (Integer)arg.Value;
                    continue;
                }
                if (arg.Type == 2) {
                    if (arg.def.IsArray) {
                        s = s + " " + ((Variable)arg.Value).fullArrayName();
                        continue;
                    }
                    s = s + " " + ((Variable)arg.Value).fullName();
                    continue;
                }
                s = s + " " + (String)arg.Value;
            }
            System.out.println(s);
        }
    }

    private void printWindowString(String param, WindowString value) {
        System.out.println(";           " + param + " " + value.Source);
    }

    private void printWindowWord(String param, int value, String strValue) {
        System.out.println(";           " + param + " " + strValue);
    }

    private void printWindowRef(String param, Window w) throws SyntaxError {
        System.out.println(";           " + param + " " + w.Name);
    }

    private void printWindowRefs(Window w, boolean up, boolean down) throws SyntaxError {
        if (up) {
            this.printWindowRef("up     ", w.upLink);
        }
        if (down) {
            this.printWindowRef("down   ", w.downLink);
        }
        this.printWindowRef("left   ", w.leftLink);
        this.printWindowRef("right  ", w.rightLink);
    }

    private void printVar(Window w) {
        System.out.println(";           var     " + w.var.fullName());
        if (w.var.type == 3) {
            System.out.println(";           digits  " + w.digits);
        }
    }

    private void printWindows() throws SyntaxError {
        for (Window w : this.Windows.values()) {
            System.out.println(this.codeAddress(w.startAddress) + "Window " + w.fullName());
            if (w.type != Window.WindowType.PASSWORD) {
                System.out.println(";           visible " + (w.visible != null ? w.visible.fullName() : "0"));
            }
            if (w.type == Window.WindowType.STATIC) {
                this.printWindowString("title  ", w.title);
                this.printWindowString("text   ", w.text);
                this.printWindowRefs(w, true, true);
            } else if (w.type == Window.WindowType.DISP_NUM) {
                this.printWindowString("title  ", w.title);
                this.printVar(w);
                this.printWindowRefs(w, true, true);
            } else if (w.type == Window.WindowType.DISP_TEXT) {
                this.printWindowString("title  ", w.title);
                this.printVar(w);
                this.printWindowWord("strings", w.strings.startAddress, w.strings.Name);
                this.printWindowRefs(w, true, true);
            } else if (w.type == Window.WindowType.EDIT_NUM) {
                this.printWindowString("title  ", w.title);
                this.printVar(w);
                if (w.var.type != 1) {
                    this.printWindowWord("min    ", w.min, Integer.toString(w.min));
                    this.printWindowWord("max    ", w.max, Integer.toString(w.max));
                }
                this.printWindowRefs(w, true, false);
            } else if (w.type == Window.WindowType.EDIT_TEXT) {
                this.printWindowString("title  ", w.title);
                this.printVar(w);
                this.printWindowWord("strings", w.strings.startAddress, w.strings.Name);
                this.printWindowRefs(w, true, false);
            } else if (w.type == Window.WindowType.INST_EDIT) {
                this.printWindowString("title  ", w.title);
                this.printVar(w);
                if (w.var.type != 1) {
                    this.printWindowWord("min    ", w.min, Integer.toString(w.min));
                    this.printWindowWord("max    ", w.max, Integer.toString(w.max));
                }
                this.printWindowRefs(w, true, false);
            } else if (w.type == Window.WindowType.PASSWORD) {
                this.printWindowString("title  ", w.title);
                System.out.println(";           level   " + w.level);
                this.printWindowRef("right  ", w.rightLink);
                this.printWindowRef("left   ", w.leftLink);
            } else if (w.type == Window.WindowType.TABLEEDIT) {
                this.printVar(w);
                System.out.println(";           titleVar " + w.titleVar.fullName());
                System.out.println(";           titleDigits " + w.titleDigits);
                this.printWindowWord("min    ", w.min, Integer.toString(w.min));
                this.printWindowWord("max    ", w.max, Integer.toString(w.max));
                this.printWindowRef("up     ", w.upLink);
            }
            System.out.println(";");
        }
        for (StringList sl : this.Strings.values()) {
            System.out.println(this.codeAddress(sl.startAddress) + "Strings " + sl.Name);
            for (int i = 0; i < sl.Strings.size(); ++i) {
                WindowString ws = sl.Strings.get(i);
                System.out.println(";           " + i + " " + ws.Source);
            }
            System.out.println(";");
        }
    }

    public static void main(String[] args) {
        block4: {
            try {
                if (args.length == 0) {
                    System.out.println("Source file name is absent");
                    return;
                }
                ExportAsm p = new ExportAsm();
                p.loadFromFile(args[0], true);
                p.printAsm();
            }
            catch (NoSuchFileException e) {
                System.out.println("");
                System.out.println("ERROR. File not found: " + e.getMessage());
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR (" + e.getClass().getSimpleName() + "): " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") == null) break block4;
                e.printStackTrace();
            }
        }
    }
}

