/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.lcd.LcdDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.Timer;
import javax.swing.UIManager;

class LcdEditDisplay
extends LcdDisplay
implements ActionListener,
KeyListener,
MouseListener,
FocusListener,
Accessible {
    private static final long serialVersionUID = 1L;
    protected int cursorX;
    protected int cursorY;
    protected boolean focused;
    Timer timer;
    protected Color cursorColor;
    boolean cursorBlink;
    private boolean dropKeyTyped;

    public LcdEditDisplay(LcdFont font, int columns, int rows) {
        super(font, columns, rows);
        this.params.backgroundColor = SystemColor.text;
        this.params.pixelOnColor = SystemColor.textText;
        this.params.pixelOffColor = this.params.backgroundColor;
        this.params.pixelGap = 0;
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.updateSize();
        this.cursorColor = this.params.pixelOnColor;
        this.timer = new Timer(530, this);
        this.timer.setInitialDelay(530);
        this.timer.start();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public void setCode(byte code) {
        if (this.params.font.isCharPresent(code)) {
            this.setCode(this.cursorX, this.cursorY, code);
            this.setCursorXY(this.cursorX + 1, this.cursorY);
        }
    }

    private void paintCursor(Graphics g) {
        int x = LcdEditDisplay.getCharX0(this.params, this.cursorX);
        int y = LcdEditDisplay.getCharY0(this.params, this.cursorY);
        int w = LcdEditDisplay.getCharWidth(this.params);
        int h = LcdEditDisplay.getCharHeight(this.params);
        if (this.cursorBlink && this.focused) {
            g.setColor(this.cursorColor);
            g.drawRect(x - 1, y - 1, w + 1, h + 1);
            g.drawRect(x - 2, y - 2, w + 3, h + 3);
        } else {
            g.setColor(this.params.backgroundColor);
            g.drawRect(x - 2, y - 2, w + 3, h + 3);
            g.drawRect(x - 1, y - 1, w + 1, h + 1);
        }
    }

    private void updateCursor() {
        this.cursorBlink = true;
        this.timer.restart();
        this.repaint();
    }

    private void setCursorXY(int x, int y) {
        x = Math.max(x, 0);
        x = Math.min(x, this.getColumnsCount() - 1);
        y = Math.max(y, 0);
        y = Math.min(y, this.getRowsCount() - 1);
        this.cursorX = x;
        this.cursorY = y;
        this.updateCursor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cursorBlink = !this.cursorBlink;
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paintCursor(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintCursor(g);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focused = true;
        this.updateCursor();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focused = false;
        this.updateCursor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.setCursorXY(e.getX() / (LcdEditDisplay.getCharWidth(this.params) + this.params.charGap), e.getY() / (LcdEditDisplay.getCharHeight(this.params) + this.params.charGap));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getID() == 400) {
            if (!this.dropKeyTyped) {
                this.setCode(this.params.font.utf8CharToByte(e.getKeyChar()));
                this.updateCursor();
            }
            this.dropKeyTyped = false;
        }
    }

    private void deleteToLeft() {
        int maxX = this.getColumnsCount() - 1;
        for (int i = this.cursorX; i < maxX; ++i) {
            this.setCode(i, this.cursorY, this.getCode(i + 1, this.cursorY));
        }
        this.setCode(maxX, this.cursorY, this.params.font.utf8CharToByte(' '));
        this.updateCursor();
    }

    private void insertToRight() {
        for (int i = this.getColumnsCount() - 1; i > this.cursorX; --i) {
            this.setCode(i, this.cursorY, this.getCode(i - 1, this.cursorY));
        }
        this.setCode(this.cursorX, this.cursorY, this.params.font.utf8CharToByte(' '));
        this.updateCursor();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getID() == 401) {
            this.dropKeyTyped = true;
            int k = e.getKeyCode();
            if (k == 37) {
                this.setCursorXY(this.cursorX - 1, this.cursorY);
            } else if (k == 39) {
                this.setCursorXY(this.cursorX + 1, this.cursorY);
            } else if (k == 36) {
                this.setCursorXY(0, this.cursorY);
            } else if (k == 35) {
                this.setCursorXY(this.getColumnsCount() - 1, this.cursorY);
            } else if (k == 38) {
                this.setCursorXY(this.cursorX, this.cursorY - 1);
            } else if (k == 40) {
                this.setCursorXY(this.cursorX, this.cursorY + 1);
            } else if (k == 10 && !e.isControlDown() && this.getRowsCount() > 1) {
                e.consume();
                this.setCursorXY(0, this.cursorY + 1);
            } else if (k == 155) {
                this.insertToRight();
            } else if (k == 127) {
                this.deleteToLeft();
            } else if (k == 8) {
                if (this.cursorX == 0) {
                    return;
                }
                this.setCursorXY(this.cursorX - 1, this.cursorY);
                this.deleteToLeft();
            } else {
                this.dropKeyTyped = false;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

