/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.schedule;

import certa.vics.compiler.Schedule;
import certa.vics.compiler.ScheduleBlock;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.schedule.ScheduleActions;
import certa.vics.ide.schedule.ScheduleCell;
import certa.vics.ide.schedule.ScheduleTableView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONObject;

public class ScheduleEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    JPopupMenu popupMenu;
    ScheduleActions actions;
    protected final MainFrame mainFrame;
    final ScheduleTableView[] tabs = new ScheduleTableView[12];
    JTabbedPane tabbedPane;
    ArrayList<VariableRef> varList;
    ArrayList<VariableRef> enableList;

    public ScheduleEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        this.mainFrame = mainFrame;
        this.tabbedPane = new JTabbedPane();
        for (int i = 0; i < 12; ++i) {
            ScheduleTableView t = new ScheduleTableView(this, i + 1);
            this.tabbedPane.addTab(t.getTitle(), null, t, null);
            this.tabs[i] = t;
        }
        this.loadProps();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScheduleEditor.this.initFocus();
            }
        });
        this.tabbedPane.addMouseListener(this.focuser);
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new ScheduleActions(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.actions.editProps));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.clearEvents));
        return this.actions;
    }

    ScheduleTableView activeTable() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            return this.tabs[i];
        }
        return null;
    }

    List<ScheduleCell> getSelectedCells() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            return this.tabs[i].getSelectedCells();
        }
        return null;
    }

    @Override
    public void titleClicked() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            this.tabs[i].table.requestFocusInWindow();
        }
    }

    @Override
    public void initFocus() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            ScheduleTableView t = this.tabs[i];
            t.table.requestFocusInWindow();
            this.refreshVarLists();
            t.updateVarList(this.varList, this.enableList);
        }
    }

    @Override
    public void clear() {
        for (ScheduleTableView t : this.tabs) {
            t.loadData(null, null);
        }
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        for (ScheduleTableView t : this.tabs) {
            t.isModified = false;
        }
    }

    private void buildLists() {
        ScheduleBlock sb = this.mainFrame.program.Schedules;
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].loadData(sb.items[i], ved);
        }
    }

    @Override
    public void initNewProgram() {
        this.buildLists();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.buildLists();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    public VariableRef[] getVarList() {
        VariableRef[] vl = new VariableRef[12];
        for (ScheduleTableView t : this.tabs) {
            vl[t.number - 1] = t.var;
        }
        return vl;
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        ScheduleBlock sb = this.mainFrame.program.Schedules;
        for (ScheduleTableView t : this.tabs) {
            int n = t.number;
            Schedule schedule = new Schedule(n);
            sb.items[n - 1] = schedule;
            Schedule s = schedule;
            t.compileData(s, this.mainFrame.program);
        }
    }

    private void loadProps() {
    }

    @Override
    public void saveProps() {
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearScheduleRefs();
        for (ScheduleTableView t : this.tabs) {
            if (t.var != null) {
                t.var.varDef.addScheduleRef(t, true);
            }
            if (t.varEnable == null) continue;
            t.varEnable.varDef.addScheduleRef(t, false);
        }
        ved.updateTable();
    }

    void refreshVarLists() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        if (ved == null) {
            this.varList = new ArrayList(0);
            this.enableList = new ArrayList(0);
            return;
        }
        this.enableList = ved.getAllVariables(true, 1);
        this.enableList.add(0, null);
        this.varList = ved.getAllVariables(true, 0);
        Iterator<VariableRef> it = this.varList.iterator();
        while (it.hasNext()) {
            if (it.next().isWritable()) continue;
            it.remove();
        }
        this.varList.add(0, null);
    }

    @Override
    public void updateVarList() {
        this.refreshVarLists();
        for (ScheduleTableView t : this.tabs) {
            t.updateVarList(this.varList, this.enableList);
        }
    }

    public boolean isCorrect(int schedule) {
        int i = schedule - 1;
        return i >= 0 && i < this.tabs.length && this.tabs[schedule - 1].var != null;
    }
}

