/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import certa.vics.Utils;
import certa.vics.compiler.Archive;
import certa.vics.compiler.Argument;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.Device;
import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.StringList;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ExportSource {
    private ExportSource() {
    }

    public static void printSource(Program program, PrintWriter out, boolean fbd) {
        out.println("# Memory usage (bytes)");
        out.println("#   RAM:         " + program.getRamSize() + ",   (max: " + program.device.RamSize + ")");
        out.println("#   EEPROM:      " + program.getStoreSize() + ",   (max: " + program.device.EepromSize + ")");
        out.println("#   NVRAM:       " + program.getExtSize() + ",   (max: " + program.device.NvramSize + ")");
        out.println("#   FLASH:       " + program.getFlashSize() + ",   (max: " + program.device.FlashSize + ")");
        out.println("#     system data:  " + (program.device.CodeStart - program.device.FlashStart));
        out.println("#     schedule:     60");
        out.println("#     code:         " + program.getAllCodeSize());
        out.println("#     modbus:       " + program.getModbusSize());
        out.println("#     RAM init:     " + program.getRamInitSize());
        out.println("#     windows:      " + program.getWindowsSize());
        out.println("#     arc. strings: " + program.archive.getFlashSize());
        out.println("#     constants:    " + program.getConstSize());
        out.println();
        out.println("FileVersion 3");
        out.println("ID " + (Utils.strEmpty(program.id) ? "_" : program.id));
        out.println("CodeCRC " + program.codeCrc);
        out.println("Target " + program.device.PropsFile);
        ExportSource.printVars(program.device.SysOutVars, out, true);
        ExportSource.printVars(program.device.SysStoreVars, out, true);
        ExportSource.printVars(program.device.SysExtVars, out, true);
        if (!fbd) {
            ExportSource.printVars(program.Constants, out, false);
            ExportSource.printVars(program.RamVars, out, false);
            ExportSource.printVars(program.ExtVars, out, false);
            ExportSource.printVars(program.StoreVars, out, false);
        }
        out.println("Modbus");
        ExportSource.printModbus(program.Modbus, program.Modbus.Inputs, "input", out);
        ExportSource.printModbus(program.Modbus, program.Modbus.Coils, "coil", out);
        ExportSource.printModbus(program.Modbus, program.Modbus.IRs, "ir", out);
        ExportSource.printModbus(program.Modbus, program.Modbus.HRs, "hr", out);
        out.println("EndModbus");
        ExportSource.printStrings(program, out);
        ExportSource.printSchedules(program, out);
        out.println("Archive");
        Archive arc = program.archive;
        for (int i = 0; i < arc.size(); ++i) {
            Variable v = arc.getVar(i);
            if (v != null) {
                out.println("  " + v.fullName() + " " + arc.getString1((int)i).Source + " " + arc.getString2((int)i).Source);
                continue;
            }
            out.println("  0");
        }
        out.println("EndArchive");
        ExportSource.printWindows(program, out);
        ExportSource.printKeys(program, out);
        if (!fbd) {
            if (program.codeSource.size() > 0) {
                for (String s : program.codeSource) {
                    out.println(s);
                }
            } else {
                ExportSource.printCodeBlock(program.MainCode, program.device, out);
                ExportSource.printSubs(program, out);
            }
        }
        out.println("End");
        out.println(program.extraData);
    }

    private static void printVars(VariablesBlock vd, PrintWriter out, boolean sysInit) {
        out.println(vd.name);
        for (Variable v : vd.map.values()) {
            String comment;
            if (v.hidden) continue;
            String init = "";
            if (v.hasInitValue()) {
                init = " = ";
                init = v.type == 3 ? init + Utils.numToString(v.initValue) : init + Utils.Round(v.initValue);
                if (v.arrayItems != null) {
                    for (int i = 1; i < v.arrayItems.length; ++i) {
                        Variable v1 = v.arrayItems[i];
                        init = v1.type == 3 ? init + " " + Utils.numToString(v1.initValue) : init + " " + Utils.Round(v1.initValue);
                    }
                }
            } else if (sysInit) continue;
            String string = comment = !Utils.strEmpty(v.comment) && !sysInit ? " # " + v.comment : "";
            if (v.arrayItems != null) {
                out.println("  " + Variable.typeToString(v.type) + "." + v.arrayName() + "{" + v.arrayItems.length + "}" + init + comment);
                continue;
            }
            out.println("  " + Variable.typeToString(v.type) + "." + v.name + init + comment);
        }
        out.println("End" + vd.name);
    }

    private static void printModbus(ModbusBlock block, ArrayList<ModbusReg> list, String prefix, PrintWriter out) {
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            if (!block.isEmpty(r)) {
                String k = "";
                if (r.var.type == 3) {
                    k = " $ " + r.digits;
                }
                out.println("  " + prefix + i + " " + r.var.fullName() + k);
                continue;
            }
            out.println("  " + prefix + i + " 0");
        }
    }

    private static void printCodeBlock(CodeBlock cb, Device device, PrintWriter out) {
        out.println(cb.Name);
        ExportSource.printCode(cb, device, out);
        out.println("End" + cb.Name);
    }

    private static void printSubs(Program program, PrintWriter out) {
        for (CodeBlock cb : program.Subs.values()) {
            out.println("Sub " + cb.Name);
            ExportSource.printCode(cb, program.device, out);
            out.println("EndSub");
        }
    }

    private static void printCode(CodeBlock cb, Device device, PrintWriter out) {
        for (Command ci : cb.Items) {
            for (String lbl : cb.Labels.keySet()) {
                if (cb.Labels.get(lbl) != ci.offset) continue;
                out.println(":" + lbl);
            }
            String s = "  " + ci.cmdDef.Name;
            if (ci.cmdDef == device.CommandMap.get("END") || ci.cmdDef == device.CommandMap.get("ENDI") || ci.cmdDef == device.CommandMap.get("RET")) {
                s = "#" + s;
            }
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    s = s + " " + (Integer)arg.Value;
                    continue;
                }
                if (arg.Type == 5) continue;
                if (arg.Type == 2) {
                    if (arg.def.IsArray) {
                        s = s + " " + ((Variable)arg.Value).fullArrayName();
                        continue;
                    }
                    s = s + " " + ((Variable)arg.Value).fullName();
                    continue;
                }
                s = s + " " + (String)arg.Value;
            }
            out.println(s);
        }
    }

    private static void printStrings(Program program, PrintWriter out) {
        for (StringList sl : program.Strings.values()) {
            out.println("Strings " + sl.Name);
            int i = 0;
            for (WindowString ws : sl.Strings) {
                out.println("  " + i + " " + ws.Source);
                ++i;
            }
            out.println("EndStrings");
        }
    }

    private static void printWindowLinks(Window w, boolean up, boolean down, boolean left, boolean right, PrintWriter out) {
        if (up) {
            out.println("  up " + (w.upLink != w ? w.upLink.Name : "0"));
        }
        if (down) {
            out.println("  down " + (w.downLink != w ? w.downLink.Name : "0"));
        }
        if (left) {
            out.println("  left " + (w.leftLink != w ? w.leftLink.Name : "0"));
        }
        if (right) {
            out.println("  right " + (w.rightLink != w ? w.rightLink.Name : "0"));
        }
    }

    private static void printSchedules(Program program, PrintWriter out) {
        for (Schedule s : program.Schedules.items) {
            if (s == null) continue;
            out.println("Schedule " + s.number);
            out.println("  strict " + (s.strict ? "1" : "0"));
            if (s.var != null) {
                out.println("  var " + s.var.fullName());
                if (s.var.type == 3) {
                    out.println("  digits " + Integer.toString(s.digits));
                }
                if (s.var.type == 3 || s.var.type == 2 && s.strings == null) {
                    out.println("  min " + Utils.FormatDouble(s.min, s.digits));
                    out.println("  max " + Utils.FormatDouble(s.max, s.digits));
                }
                if (s.strings != null) {
                    out.println("  strings " + s.strings.Name);
                }
            }
            if (s.enabled != null) {
                out.println("  enable " + s.enabled.fullName());
            }
            for (int i = 0; i < 7; ++i) {
                String ts = s.encodeArray(i);
                if (Utils.strEmpty(ts)) continue;
                out.println("  day" + (i + 1) + " " + ts);
            }
            out.println("EndSchedule");
        }
    }

    private static void printWindows(Program program, PrintWriter out) {
        for (Window w : program.Windows.values()) {
            out.println("Window " + w.fullName());
            if (w.type != Window.WindowType.PASSWORD) {
                out.println("  visible " + (w.visible != null ? w.visible.fullName() : "0"));
            }
            if (w.type == Window.WindowType.STATIC) {
                out.println("  title " + w.title.Source);
                out.println("  text " + w.text.Source);
                ExportSource.printWindowLinks(w, true, true, true, true, out);
            } else if (w.type == Window.WindowType.DISP_NUM) {
                out.println("  title " + w.title.Source);
                out.println("  var " + w.var.fullName());
                if (w.var.type == 3) {
                    out.println("  digits " + w.digits);
                }
                ExportSource.printWindowLinks(w, true, true, true, true, out);
            } else if (w.type == Window.WindowType.DISP_TEXT) {
                out.println("  title " + w.title.Source);
                out.println("  var " + w.var.fullName());
                out.println("  strings " + w.strings.Name);
                ExportSource.printWindowLinks(w, true, true, true, true, out);
            } else if (w.type == Window.WindowType.EDIT_NUM) {
                out.println("  title " + w.title.Source);
                out.println("  var " + w.var.fullName());
                if (w.var.type == 3) {
                    out.println("  digits " + w.digits);
                }
                if (w.var.type == 2 || w.var.type == 3) {
                    out.println("  min " + w.min);
                    out.println("  max " + w.max);
                }
                ExportSource.printWindowLinks(w, true, false, true, true, out);
            } else if (w.type == Window.WindowType.EDIT_TEXT) {
                out.println("  title " + w.title.Source);
                out.println("  var " + w.var.fullName());
                out.println("  strings " + w.strings.Name);
                ExportSource.printWindowLinks(w, true, false, true, true, out);
            } else if (w.type == Window.WindowType.INST_EDIT) {
                out.println("  title " + w.title.Source);
                out.println("  var " + w.var.fullName());
                if (w.var.type == 3) {
                    out.println("  digits " + w.digits);
                }
                if (w.var.type == 2 || w.var.type == 3) {
                    out.println("  min " + w.min);
                    out.println("  max " + w.max);
                }
                ExportSource.printWindowLinks(w, true, false, true, true, out);
            } else if (w.type == Window.WindowType.PASSWORD) {
                out.println("  title " + w.title.Source);
                out.println("  level " + w.level);
                ExportSource.printWindowLinks(w, false, false, true, true, out);
            } else if (w.type == Window.WindowType.TABLEEDIT) {
                out.println("  var " + w.var.fullArrayName());
                out.println("  digits " + w.digits);
                out.println("  titleVar " + w.titleVar.fullArrayName());
                out.println("  titleDigits " + w.titleDigits);
                out.println("  min " + w.min);
                out.println("  max " + w.max);
                out.println("  up " + (w.upLink != w ? w.upLink.Name : "0"));
            } else if (w.type == Window.WindowType.SCHEDULE) {
                out.println("  title " + w.title.Source);
                out.println("  text " + w.text.Source);
                out.println("  schedindex " + w.schedule);
                ExportSource.printWindowLinks(w, true, false, true, true, out);
            } else if (w.type == Window.WindowType.ARCHIVE) {
                out.println("  title " + w.title.Source);
                out.println("  text " + w.text.Source);
                ExportSource.printWindowLinks(w, true, false, true, true, out);
            } else {
                throw new IllegalStateException("Invalid window type: " + (Object)((Object)w.type));
            }
            out.println("EndWindow");
        }
    }

    private static void printKeys(Program program, PrintWriter out) {
        out.println("Keys");
        for (int i = 0; i < Program.KEYS.length; ++i) {
            Window w = program.keyWindows[i];
            out.println("  " + Program.KEYS[i] + " " + (w != null ? w.Name : "0"));
        }
        out.println("EndKeys");
    }

    public static void main(String[] args) {
        block3: {
            try {
                if (args.length == 0) {
                    System.out.println("Source file name is absent");
                    return;
                }
                Program p = new Program();
                p.loadFromFile(args[0], true);
                ExportSource.printSource(p, new PrintWriter(System.out, true), false);
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR: " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") == null) break block3;
                e.printStackTrace();
            }
        }
    }
}

