/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.lcd;

import certa.vics.lcd.fonts.Cyrillic5x8;
import java.util.Arrays;

public abstract class LcdFont {
    public static final LcdFont CYRILLIC_5x8 = new Cyrillic5x8();

    public abstract byte utf8CharToByte(char var1);

    public abstract int charWidth();

    public abstract int charHeight();

    public abstract boolean getCharPoint(byte var1, int var2, int var3);

    public abstract boolean isCharPresent(byte var1);

    public void encodeString(String s, byte[] buffer) {
        Arrays.fill(buffer, this.utf8CharToByte(' '));
        int i = 0;
        int bi = 0;
        if (s == null) {
            return;
        }
        while (i < s.length() && bi < buffer.length) {
            char c = s.charAt(i);
            if (c == '#' && s.length() > i + 2) {
                try {
                    buffer[bi] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                    i += 3;
                    ++bi;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buffer[bi] = this.utf8CharToByte(c);
            ++i;
            ++bi;
        }
    }

    public String decodeString(byte[] chars) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            int c = chars[i] & 0xFF;
            sb.append('#');
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }
}

