/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.GroupView;
import certa.vics.ide.ui.LcdTextField;
import certa.vics.lcd.LcdDisplay;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class GroupPropsDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static GroupPropsDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JCheckBox chckbxLoop;
    JPanel pnlLcd;
    LcdDisplay lcdTitle;
    JComboBox cbxPwdLevel;

    public static boolean showDialog(GroupView group) {
        if (dialog == null) {
            dialog = new GroupPropsDialog(MainFrame.instance);
        }
        dialog.setLocationRelativeTo(dialog.getParent());
        GroupPropsDialog.dialog.btnOk.requestFocusInWindow();
        GroupPropsDialog.dialog.okPressed = false;
        dialog.updateControls(group);
        dialog.setVisible(true);
        if (GroupPropsDialog.dialog.okPressed) {
            dialog.updateGroup(group);
            return true;
        }
        return false;
    }

    public GroupPropsDialog(JFrame parent) {
        super(parent, "\u041c\u0435\u043d\u044e");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        ActionListener pwdLevel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pwd = dialog.cbxPwdLevel.getSelectedIndex();
                dialog.pnlLcd.setVisible(pwd > 0);
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnl = new JPanel();
        pnl.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnl, "alignx center,wrap");
        this.chckbxLoop = new JCheckBox("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043f\u043e \u043a\u0440\u0443\u0433\u0443");
        pnl.add((Component)this.chckbxLoop, "wrap, span");
        pnl.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c: "), "aligny center");
        String[] pwdLevels = new String[]{"\u041d\u0435\u0442", "\u0412\u044b\u0441\u043e\u043a\u0438\u0439 (1)", "\u0421\u0440\u0435\u0434\u043d\u0438\u0439 (2)", "\u041d\u0438\u0437\u043a\u0438\u0439 (3)"};
        this.cbxPwdLevel = new JComboBox<String>(pwdLevels);
        this.cbxPwdLevel.addActionListener(pwdLevel);
        pnl.add((Component)this.cbxPwdLevel, "aligny center,wrap");
        this.pnlLcd = new JPanel();
        this.pnlLcd.setLayout(new MigLayout("insets 0", "", ""));
        this.pnlLcd.add((Component)new JLabel("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043e\u043a\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f: "), "wrap");
        this.lcdTitle = new LcdTextField(null, 8, 1, false, "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043e\u043a\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f", this);
        this.pnlLcd.add((Component)this.lcdTitle, "");
        pnl.add((Component)this.pnlLcd, "span");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void updateControls(GroupView group) {
        this.chckbxLoop.setSelected(group.looped);
        this.cbxPwdLevel.setSelectedIndex(group.pwdLevel + 1);
        this.lcdTitle.setLcdFont(group.editor.mainFrame.program.device.FONT);
        this.lcdTitle.setLcdSize(group.editor.mainFrame.program.device.DISPLAY_COLS, 1);
        this.lcdTitle.setText(0, group.pwdTitle);
        this.pack();
    }

    void updateGroup(GroupView group) {
        group.looped = GroupPropsDialog.dialog.chckbxLoop.isSelected();
        group.pwdLevel = Math.max(-1, this.cbxPwdLevel.getSelectedIndex() - 1);
        if (group.pwdLevel >= 0) {
            group.pwdTitle = this.lcdTitle.getText(0);
        }
    }
}

