/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.PageRenameDialog;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class PageActions
extends ActionsBundle {
    final FbdEditor editor;
    public final Action addPage = new AddPage(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443", "add_page.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443", 0, null);
    public final RenamePage renamePage = new RenamePage(this, "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c", "props.png", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b", 0, null);
    public final Action deletePage = new DeletePage(this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443", 0, KeyStroke.getKeyStroke("DELETE"));
    public final Action movePageUp = new MovePageUp(this, "\u0412\u0432\u0435\u0440\u0445", "up.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0448\u0435", 0, KeyStroke.getKeyStroke("control UP"));
    public final Action movePageDown = new MovePageDown(this, "\u0412\u043d\u0438\u0437", "down.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0438\u0436\u0435", 0, KeyStroke.getKeyStroke("control DOWN"));
    public final Action copy = new Copy(this, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "copy.png", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(67, 2), false);
    public final Action cut = new Copy(this, "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(88, 2), true);
    public final Action paste = new Paste(this, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(86, 2));

    public PageActions(FbdEditor editor) {
        super(editor.pnlPages);
        this.editor = editor;
    }

    public class Paste
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Paste(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageActions.this.editor.pastePagesFromClipboard();
        }
    }

    public class Copy
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean cut;

        public Copy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean cut) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.cut = cut;
        }

        @Override
        public boolean canExec() {
            return PageActions.this.editor.getPageIndex() >= 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageActions.this.editor.copyPagesToClipboard(this.cut);
        }
    }

    public class MovePageDown
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public MovePageDown(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return PageActions.this.editor.getPageIndex() >= 0 && PageActions.this.editor.getPageIndex() < PageActions.this.editor.getPagesCount() - 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdPage page = PageActions.this.editor.pagesList.getSelectedValue();
            int i = PageActions.this.editor.pages.indexOf(page);
            if (i >= 0 && i < PageActions.this.editor.pages.size() - 1) {
                PageActions.this.editor.cancelMouseOperations();
                PageActions.this.editor.pages.remove(page);
                PageActions.this.editor.pages.add(i + 1, page);
                PageActions.this.editor.pagesModel.update();
                PageActions.this.editor.pagesList.setSelectedIndex(i + 1);
                PageActions.this.editor.markModified();
                PageActions.this.editor.commitAction();
            }
        }
    }

    public class MovePageUp
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public MovePageUp(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return PageActions.this.editor.getPageIndex() > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdPage page = PageActions.this.editor.pagesList.getSelectedValue();
            int i = PageActions.this.editor.pages.indexOf(page);
            if (i >= 1) {
                PageActions.this.editor.cancelMouseOperations();
                PageActions.this.editor.pages.remove(page);
                PageActions.this.editor.pages.add(i - 1, page);
                PageActions.this.editor.pagesModel.update();
                PageActions.this.editor.pagesList.setSelectedIndex(i - 1);
                PageActions.this.editor.markModified();
                PageActions.this.editor.commitAction();
            }
        }
    }

    public class DeletePage
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public DeletePage(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return PageActions.this.editor.getPageIndex() >= 0 && PageActions.this.editor.getPagesCount() > 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageActions.this.editor.deletePage();
        }
    }

    public class RenamePage
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public RenamePage(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return PageActions.this.editor.getPageIndex() >= 0;
        }

        public void perform(int x, int y) {
            String name;
            FbdPage page = PageActions.this.editor.pagesList.getSelectedValue();
            if (page != null && (name = PageRenameDialog.showDialog(page.getName(), PageActions.this.editor.pagesScroll, x, y)) != null) {
                page.setName(name);
                PageActions.this.editor.pagesModel.update();
                PageActions.this.editor.commitAction();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.perform(-1, -1);
        }
    }

    public class AddPage
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddPage(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageActions.this.editor.cancelMouseOperations();
            String name = PageRenameDialog.showDialog("Page", PageActions.this.editor.pagesScroll, -1, -1);
            if (name != null) {
                FbdPage newPage = new FbdPage(PageActions.this.editor, name);
                PageActions.this.editor.pages.add(newPage);
                PageActions.this.editor.pagesModel.update();
                PageActions.this.editor.pagesList.setSelectedValue(newPage, true);
                PageActions.this.editor.pagesList.requestFocusInWindow();
                PageActions.this.editor.markModified();
                PageActions.this.editor.commitAction();
            }
        }
    }
}

