/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import certa.vics.ide.variables.VariableRef;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdVariable
extends AFbdItem {
    protected OutputPin outPin;
    private InputPin inPin;
    private VariableRef var;
    static final String JSON_VAR_REF = "ref";
    static final String JSON_VAR_INPUT = "input";
    static final Font NAME_FONT = new Font("Sans", 0, 12);
    static final Font SYS_NAME_FONT = new Font("Sans", 3, 12);
    static final Font SYS_MARK_FONT = new Font("Sans", 1, 10);
    static final Stroke FOCUS_STROKE = new BasicStroke(3.0f);

    public FbdVariable(FbdPage page, VariableRef vr) throws JSONException, FbdLoadError {
        super(page, null);
        this.var = vr;
        this.outPin = new OutputPin(this, vr.type(), null, 0);
        if (vr.isWritableInFbd()) {
            this.inPin = new InputPin(this, vr.type(), null, 0);
        }
    }

    public FbdVariable(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page, src);
        assert (src != null);
        String s = src.getString(JSON_VAR_REF);
        this.var = page.locateVar(s);
        if (this.var == null) {
            throw new FbdLoadError("Unknown variable: \"" + s + "\"");
        }
        this.outPin = new OutputPin(this, this.var.type(), null, 0);
        if (this.var.isWritableInFbd()) {
            this.inPin = new InputPin(this, this.var.type(), null, 0);
            this.inPin.initSourceId(src.optInt(JSON_VAR_INPUT, -1));
        }
    }

    @Override
    protected void init(JSONObject src) throws JSONException, FbdLoadError {
        this.padLeft = 1;
        this.padTop = 0;
        this.cellBounds.width = 7 + this.padLeft;
        this.cellBounds.height = 1 + this.padTop;
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
        jso.put(JSON_VAR_REF, this.var.fullName());
        if (this.inPin != null) {
            jso.put(JSON_VAR_INPUT, this.inPin.getSourceId());
        }
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        Color body;
        boolean selVar = this.var != null && this.page.editor.selVar == this.var.varDef;
        this.updateBounds();
        boolean sys = this.var.varDef.isSystem();
        Color hover = body = this.var.varDef.getMemColor();
        g2d.setColor(this.page.editor.hoveredView == this ? hover : body);
        g2d.fillRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        if (selVar) {
            g2d.setColor(SystemColor.textHighlight);
            g2d.fillRect(this.pxBounds.x + 10, this.pxBounds.y, this.pxBounds.width - 20, this.pxBounds.height);
        }
        g2d.setStroke(SHAPE_STROKE);
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        g2d.setFont(sys ? SYS_NAME_FONT : NAME_FONT);
        String s = this.var.shortName();
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(s, g2d);
        g2d.setColor(selVar ? SystemColor.textHighlightText : Color.BLACK);
        g2d.drawString(s, this.pxBounds.x + (this.pxBounds.width - (int)rect.getWidth()) / 2 + 6, this.pxBounds.y + this.pxBounds.height - 4);
        if (sys) {
            g2d.setFont(SYS_MARK_FONT);
            g2d.setColor(Color.BLACK);
            g2d.drawString("S", this.pxBounds.x + this.pxBounds.width - 8, this.pxBounds.y + 10);
        }
        this.paintFocus(g2d);
        if (this.inPin != null) {
            this.inPin.paint(g2d);
        }
    }

    @Override
    public void paintLinks(Graphics2D g2d) {
        this.outPin.paint(g2d);
    }

    @Override
    protected void resolveLinks(boolean strict) throws FbdLoadError {
        if (this.inPin != null) {
            this.inPin.resolveLink(strict);
        }
    }

    @Override
    public OutputPin getOutput(int index) {
        if (index == 0) {
            return this.outPin;
        }
        return null;
    }

    @Override
    public int getOutputIndex(OutputPin pin) {
        if (pin != null && pin == this.outPin) {
            return 0;
        }
        return -1;
    }

    @Override
    public void compileOutputVars() {
        Variable v = this.var.getCompiledVar();
        this.outPin.setCompiledVar(v);
        if (this.inPin != null) {
            this.inPin.setCompiledVar(v);
        }
    }

    @Override
    public void compileInputVars() throws SyntaxError {
    }

    public boolean isWritten() {
        return this.inPin != null && this.inPin.getSource() != null;
    }

    public VariableRef getVariable() {
        return this.var;
    }

    public void setVariable(VariableRef var) {
        if (this.var != var && var != null && var.type() == this.var.type()) {
            this.var = var;
            if (var.isWritableInFbd()) {
                if (this.inPin == null) {
                    this.inPin = new InputPin(this, var.type(), null, 0);
                    this.inPin.updateBounds();
                }
            } else if (this.inPin != null) {
                this.inPin.connectSource(null);
                this.inPin = null;
            }
            this.markModified();
        }
    }

    @Override
    public void updateBounds() {
        this.pxBounds.x = (this.cellBounds.x + 1) * 27;
        this.pxBounds.y = this.cellBounds.y * 27 + 4;
        this.pxBounds.width = (this.cellBounds.width - 1) * 27;
        this.pxBounds.height = this.cellBounds.height * 27 - 9;
    }

    @Override
    public AFbdPin getPinAt(int x, int y) {
        if (this.outPin.bounds.contains(x, y)) {
            return this.outPin;
        }
        if (this.inPin != null && this.inPin.bounds.contains(x, y)) {
            return this.inPin;
        }
        return null;
    }

    @Override
    public AFbdPin getPinAt(Rectangle r) {
        if (this.outPin.bounds.intersects(r)) {
            return this.outPin;
        }
        if (this.inPin != null && this.inPin.bounds.intersects(r)) {
            return this.inPin;
        }
        return null;
    }

    @Override
    public void disconnectAll() {
        this.outPin.disconnectTargets();
        if (this.inPin != null) {
            this.inPin.connectSource(null);
        }
    }

    protected void updateVarRef() {
        boolean w = this.isWritten();
        boolean r = this.outPin.hasTargets();
        if (r || w) {
            this.var.varDef.addFbdRef(this, w);
        }
    }

    public void updatePins() {
        boolean wrChanged;
        boolean typeChanged = this.var.type() != this.outPin.type;
        boolean bl = wrChanged = this.var.isWritableInFbd() != (this.inPin != null);
        if (typeChanged || wrChanged) {
            InputPin inputPin = this.inPin = this.var.isWritableInFbd() ? new InputPin(this, this.var.type(), null, 0) : null;
            if (typeChanged) {
                this.outPin.disconnectTargets();
                this.outPin = new OutputPin(this, this.var.type(), null, 0);
            }
        }
    }
}

