/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AbstractOperation;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ADynInputsOperation
extends AbstractOperation {
    private int fixedCount;

    public ADynInputsOperation(FbdPage page, JSONObject src, String operation, String name) throws JSONException, FbdLoadError {
        super(page, src, operation, name);
    }

    protected abstract int getInputType();

    protected abstract int getOutputType();

    protected String getInputName(int index) {
        return "";
    }

    public int getFixedInputsCount() {
        return this.fixedCount;
    }

    public int getDynIputsCount() {
        return this.inputs.size() - this.fixedCount;
    }

    public void setDynInputsCount(int count) {
        count += this.fixedCount;
        int oldSize = this.inputs.size();
        this.trimInputs();
        while (this.inputs.size() < count) {
            this.pushY(true, false, false);
            int i = this.inputs.size();
            this.inputs.add(new InputPin(this, this.getInputType(), this.getInputName(i - this.fixedCount), this.inputs.size()));
            this.pushY(false, false, false);
            this.updateBounds();
        }
        if (this.inputs.size() != oldSize) {
            this.markModified();
        }
    }

    private void trimInputs() {
        int i;
        while (this.inputs.size() > 2 && ((InputPin)this.inputs.get(i = this.inputs.size() - 1)).getSource() == null) {
            this.inputs.remove(i);
        }
        this.updateBounds();
    }

    @Override
    protected void createPins(JSONObject src) throws JSONException, FbdLoadError {
        this.fixedCount = this.inputs.size();
        int count = 2;
        if (src != null) {
            count = src.getJSONArray("inputs").length() - this.fixedCount;
        }
        for (int i = 0; i < count; ++i) {
            this.inputs.add(new InputPin(this, this.getInputType(), this.getInputName(i), this.inputs.size()));
        }
        this.outputs.add(new OutputPin(this, this.getOutputType(), "", 0));
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        super.paintShape(g2d);
        g2d.setColor(Color.BLACK);
        int x0 = this.pxBounds.x + 3;
        int y0 = this.pxBounds.y + this.pxBounds.height - 6;
        int[] x = new int[]{x0, x0 + 8, x0 + 4};
        int[] y = new int[]{y0, y0, y0 + 4};
        g2d.fillPolygon(x, y, x.length);
    }

    @Override
    public void makeSpecificCode(ArrayList<String> code) {
        int i;
        String cmd = this.operation;
        for (i = 0; i < this.fixedCount; ++i) {
            cmd = cmd + " " + ((InputPin)this.inputs.get(i)).getCompiledVar().fullName();
        }
        cmd = cmd + " " + (this.inputs.size() - this.fixedCount);
        for (i = this.fixedCount; i < this.inputs.size(); ++i) {
            cmd = cmd + " " + ((InputPin)this.inputs.get(i)).getCompiledVar().fullName();
        }
        for (OutputPin out : this.outputs) {
            cmd = cmd + " " + out.getCompiledVar().fullName();
        }
        code.add(cmd);
    }
}

