/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.WindowString;
import java.util.ArrayList;

public class Archive {
    private final ArrayList<String> strVars = new ArrayList();
    private final ArrayList<Variable> vars = new ArrayList();
    private final ArrayList<WindowString> strings1 = new ArrayList();
    private final ArrayList<WindowString> strings2 = new ArrayList();
    public int startAddressFlash;

    public int getFlashSize() {
        int s = this.vars.size();
        if (s > 0) {
            return s * this.strings1.get((int)0).Bytes.length * 2;
        }
        return 0;
    }

    public int size() {
        return this.vars.size();
    }

    public void add(String var, WindowString string1, WindowString string2) {
        if (this.strVars.size() < 255) {
            this.strVars.add(var);
            this.strings1.add(string1);
            this.strings2.add(string2);
        }
    }

    public void addCompiled(Variable var, WindowString string1, WindowString string2) {
        if (this.vars.size() < 255) {
            this.vars.add(var);
            this.strings1.add(string1);
            this.strings2.add(string2);
        }
    }

    public void clear() {
        this.strVars.clear();
        this.vars.clear();
        this.strings1.clear();
        this.strings2.clear();
    }

    public void resolve(Program prg) throws SyntaxError {
        if (this.vars.isEmpty() && !this.strVars.isEmpty()) {
            if (this.strVars.size() != this.strings1.size() || this.strVars.size() != this.strings2.size()) {
                throw new SyntaxError("Internal error ");
            }
            for (String vs : this.strVars) {
                Variable var;
                Variable variable = var = vs != null ? prg.locateVar(vs) : null;
                if (var != null && var.type != 1) {
                    throw new SyntaxError("Archive variable #" + this.vars.size() + 1 + " (" + var.fullName() + ") must be boolean");
                }
                this.vars.add(var);
            }
        }
    }

    public Variable getVar(int index) {
        return this.vars.get(index);
    }

    public WindowString getString1(int index) {
        return this.strings1.get(index);
    }

    public WindowString getString2(int index) {
        return this.strings2.get(index);
    }

    int compileData(byte[] buf, int offset, Program prg) throws SyntaxError {
        for (int i = 0; i < this.strings1.size(); ++i) {
            offset = prg.fillWindowString(this.strings1.get(i), buf, offset);
            offset = prg.fillWindowString(this.strings2.get(i), buf, offset);
        }
        return offset;
    }

    public void compileCode(ArrayList<String> code, Variable defZero, Program prg) throws SyntaxError {
        int size = this.size();
        if (size > 0) {
            Variable var;
            int i;
            if (size > 255) {
                throw new SyntaxError("Too many archive events: " + size + " (max: 255)");
            }
            code.add("# ARCHIVE");
            StringBuilder sb = new StringBuilder("Archive ");
            sb.append(size);
            for (i = 0; i < size; ++i) {
                var = this.vars.get(i);
                if (var == null) {
                    var = defZero;
                }
                sb.append(" ").append(var.fullName());
            }
            for (i = 0; i < size; ++i) {
                var = prg.RamVars.createSimpleVar("__bArchiveMem" + i, 1, false, -1);
                sb.append(" ").append(var.fullName());
            }
            code.add(sb.toString());
        }
    }
}

