/*
 * Decompiled with CFR 0.152.
 */
package ua.com.certa.modbus.client;

import java.util.Arrays;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.slf4j.LoggerFactory;
import ua.com.certa.modbus.ModbusPdu;
import ua.com.certa.modbus.client.AbstractRtuTransport;
import ua.com.certa.modbus.client.ModbusClient;

public class RtuTransportJssc
extends AbstractRtuTransport {
    private final int baudRate;
    private final int dataBits;
    private final int parity;
    private final int stopBits;
    private final SerialPort port;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;

    public RtuTransportJssc(String portName, int baudRate, int dataBits, int parity, int stopBits, int timeout, int pause) {
        super(timeout, pause, true, LoggerFactory.getLogger(RtuTransportJssc.class));
        this.port = new SerialPort(portName);
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.parity = parity;
        this.stopBits = stopBits;
    }

    public static String parityStr(int code) {
        return code == 0 ? "N" : (code == 1 ? "O" : (code == 2 ? "E" : "?"));
    }

    @Override
    protected synchronized void openPort() throws SerialPortException {
        if (!this.port.isOpened()) {
            this.log.info("Opening port: {}, {}, {}-{}-{}", this.port.getPortName(), this.baudRate, this.dataBits, RtuTransportJssc.parityStr(this.parity), this.stopBits);
            try {
                this.port.openPort();
                this.port.setParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            }
            catch (SerialPortException e) {
                this.close();
                throw e;
            }
            this.log.info("Port opened: {}", (Object)this.port.getPortName());
        }
    }

    @Override
    public synchronized void close() {
        if (this.port.isOpened()) {
            this.log.info("Closing port: {}", (Object)this.port.getPortName());
            try {
                this.port.closePort();
            }
            catch (SerialPortException e) {
                this.log.error("Error closing port {}: {}", (Object)this.port.getPortName(), (Object)e);
            }
            this.log.info("Port {} closed", (Object)this.port.getPortName());
        }
    }

    @Override
    protected void clearInput() throws SerialPortException {
        byte[] buf = this.port.readBytes();
        while (buf != null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(buf, 0, buf.length));
            }
            buf = this.port.readBytes();
        }
    }

    @Override
    protected void sendData(int size) throws SerialPortException {
        this.port.writeBytes(Arrays.copyOfRange(this.buffer, 0, size));
    }

    @Override
    protected boolean readToBuffer(int start, int length, ModbusClient modbusClient) throws SerialPortException, InterruptedException {
        int res;
        long now = System.currentTimeMillis();
        long deadline = now + (long)this.timeout;
        int offset = start;
        int bytesToRead = length;
        boolean lastTry = false;
        while (bytesToRead > 0) {
            int avail = Math.min(this.port.getInputBufferBytesCount(), bytesToRead);
            if (avail > 0) {
                byte[] buf = this.port.readBytes(avail);
                avail = buf.length;
                System.arraycopy(buf, 0, this.buffer, offset, avail);
                offset += avail;
                bytesToRead -= avail;
            }
            if (bytesToRead <= 0) continue;
            Thread.sleep(20L);
            now = System.currentTimeMillis();
            if (now <= deadline) continue;
            if (lastTry) break;
            lastTry = true;
        }
        if ((res = length - bytesToRead) < length) {
            if (res > 0 && this.log.isTraceEnabled()) {
                this.log.trace("Read (incomplete): " + ModbusPdu.toHex(this.buffer, 0, start + res));
            }
            this.log.warn("Response from {} timeout ({} bytes, need {})", modbusClient.getServerId(), start + res, this.expectedBytes);
            return false;
        }
        return true;
    }
}

