/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.Utils;
import certa.vics.compiler.Device;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.schedule.ScheduleTableView;
import certa.vics.ide.ui.WindowView;
import certa.vics.ide.variables.RefList;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Color;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VariableDef {
    public final VariablesEditor editor;
    private String name;
    private String fullName;
    private String comment = "";
    private VariablesBlock block;
    private boolean alias = false;
    private VariableDef aliasPeer = null;
    private int valueType;
    private int arraySize;
    private ArrayList<Double> initValues = new ArrayList(1);
    protected RefList<WindowView> refWindows = new RefList();
    protected RefList<Integer> refCodeLines = new RefList();
    protected RefList<RegView> refModbusRegs = new RefList();
    protected RefList<FbdVariable> refFbdVars = new RefList();
    protected RefList<ScheduleTableView> refSchedTables = new RefList();
    protected Variable compiledVar;
    public static final Color EEPROM_COLOR = new Color(13546652);
    public static final Color RAM_COLOR;
    public static final Color RO_RAM_COLOR;
    public static final Color FLASH_COLOR;
    public static final Color NVRAM_COLOR;
    static final String JSON_ALIAS = "alias";
    static final String JSON_NAME = "name";
    static final String JSON_COMMENT = "comment";
    static final String JSON_ARRAYSIZE = "array";
    static final String JSON_INIT = "init";

    public VariableDef(VariablesEditor editor, VariablesBlock block, String name, int valueType, int arraySize) {
        this.editor = editor;
        this.name = name;
        this.block = block;
        this.valueType = valueType;
        this.arraySize = arraySize;
        this.compiledVar = null;
        if (arraySize > 0) {
            this.initValues.ensureCapacity(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                this.initValues.add(new Double(Double.NaN));
            }
        } else {
            this.initValues.add(new Double(Double.NaN));
        }
        this.updateFullName();
    }

    public VariableDef(VariablesEditor editor, VariablesBlock block, Variable var) {
        this.editor = editor;
        this.name = var.arrayName();
        this.comment = var.comment;
        this.block = block;
        this.valueType = var.type;
        this.arraySize = var.arraySize();
        this.compiledVar = var;
        if (this.arraySize > 0) {
            this.initValues.ensureCapacity(this.arraySize);
            for (int i = 0; i < this.arraySize; ++i) {
                this.initValues.add(var.arrayItems[i].initValue);
            }
        } else {
            this.initValues.add(var.initValue);
        }
        this.updateFullName();
    }

    public VariableDef(VariablesEditor editor, String name, VariableDef aliasSrc) {
        this.editor = editor;
        this.name = name;
        this.linkAlias(aliasSrc);
    }

    public Color getMemColor() {
        Program prg = this.editor.mainFrame.program;
        Device dev = prg.device;
        if (this.block == dev.SysInVars) {
            return RO_RAM_COLOR;
        }
        if (this.block == dev.SysOutVars || this.block == prg.RamVars) {
            return RAM_COLOR;
        }
        if (this.block == dev.SysStoreVars || this.block == prg.StoreVars) {
            return EEPROM_COLOR;
        }
        if (this.block == dev.SysExtVars || this.block == prg.ExtVars) {
            return NVRAM_COLOR;
        }
        return FLASH_COLOR;
    }

    public VariableDef(VariablesEditor editor, JSONObject src) throws FbdLoadError, JSONException {
        this.editor = editor;
        try {
            String s = src.optString(JSON_ALIAS);
            if (!Utils.strEmpty(s)) {
                Variable.NameParser vn = new Variable.NameParser(s);
                this.block = VariableDef.locateSysBlock(editor.mainFrame.program, vn.domain);
                if (this.block == null) {
                    throw new FbdLoadError("Unknown variable domain: \"" + s + "\"");
                }
                this.aliasPeer = editor.locateVar(vn.name, this.block);
                if (this.aliasPeer == null) {
                    throw new FbdLoadError("Unknown variable: \"" + s + "\"");
                }
                if (!this.aliasPeer.isSystem()) {
                    throw new FbdLoadError("Variable must be system: \"" + s + "\"");
                }
                if (this.aliasPeer.aliasPeer != null) {
                    throw new FbdLoadError("Multiple alias for: \"" + s + "\"");
                }
                this.name = src.getString(JSON_NAME);
                this.comment = src.optString(JSON_COMMENT, "");
                this.linkAlias(this.aliasPeer);
            } else {
                s = src.getString(JSON_NAME);
                Variable.NameParser vn = new Variable.NameParser(s);
                this.block = VariableDef.locateBlock(editor.mainFrame.program, vn.domain);
                if (this.block == null) {
                    throw new FbdLoadError("Unknown variable domain: \"" + s + "\"");
                }
                this.valueType = vn.type;
                this.name = vn.name;
                if (editor.locateVar(this.name, this.block) != null) {
                    throw new FbdLoadError("Duplicate variable: \"" + s + "\"");
                }
                this.comment = src.optString(JSON_COMMENT, "");
                this.arraySize = src.getInt(JSON_ARRAYSIZE);
                this.compiledVar = null;
                if (this.arraySize > 0) {
                    JSONArray inArray = src.optJSONArray(JSON_INIT);
                    this.initValues.ensureCapacity(this.arraySize);
                    if (inArray != null) {
                        for (int i = 0; i < this.arraySize; ++i) {
                            this.initValues.add(inArray.getDouble(i));
                        }
                    } else {
                        for (int i = 0; i < this.arraySize; ++i) {
                            this.initValues.add(Double.NaN);
                        }
                    }
                } else {
                    this.initValues.add(src.optDouble(JSON_INIT));
                }
            }
        }
        catch (SyntaxError e) {
            throw new FbdLoadError(e.getMessage());
        }
        this.updateFullName();
    }

    private void linkAlias(VariableDef aliasSrc) {
        this.alias = true;
        this.aliasPeer = aliasSrc;
        this.aliasPeer.aliasPeer = this;
        this.block = aliasSrc.block;
        this.valueType = aliasSrc.valueType;
        this.arraySize = 0;
        this.compiledVar = aliasSrc.compiledVar;
        this.refWindows = aliasSrc.refWindows;
        this.refCodeLines = aliasSrc.refCodeLines;
        this.refModbusRegs = aliasSrc.refModbusRegs;
        this.refFbdVars = aliasSrc.refFbdVars;
        this.refSchedTables = aliasSrc.refSchedTables;
        this.updateFullName();
    }

    private void unlinkAlias() {
        this.alias = false;
        this.aliasPeer.aliasPeer = null;
        this.aliasPeer = null;
        this.block = this.editor.mainFrame.program.RamVars;
        this.valueType = 1;
        this.arraySize = 0;
        this.initValues = new ArrayList(1);
        this.initValues.add(new Double(Double.NaN));
        this.compiledVar = null;
        this.refWindows = new RefList();
        this.refCodeLines = new RefList();
        this.refModbusRegs = new RefList();
        this.refFbdVars = new RefList();
        this.refSchedTables = new RefList();
        this.updateFullName();
    }

    static VariablesBlock locateBlock(Program prg, String blockName) throws FbdLoadError {
        VariablesBlock b = prg.locateUserBlock(blockName);
        if (b == null) {
            throw new FbdLoadError("Unknown user variable domain: " + blockName);
        }
        return b;
    }

    static VariablesBlock locateSysBlock(Program prg, String blockName) throws FbdLoadError {
        VariablesBlock b = prg.locateSysBlock(blockName);
        if (b == null) {
            throw new FbdLoadError("Unknown system variable domain: " + blockName);
        }
        return b;
    }

    public void saveToJson(JSONObject jso) throws JSONException {
        if (this.isAlias()) {
            jso.put(JSON_NAME, this.name);
            jso.put(JSON_ALIAS, this.aliasPeer.fullName);
        } else {
            jso.put(JSON_NAME, this.fullName);
            jso.put(JSON_ARRAYSIZE, this.arraySize);
            if (this.arraySize > 0) {
                if (!this.initValues.get(0).isNaN()) {
                    JSONArray arr = new JSONArray();
                    for (Double d : this.initValues) {
                        arr.put(d.isNaN() ? 0.0 : d);
                    }
                    jso.put(JSON_INIT, arr);
                }
            } else {
                Double d = this.initValues.get(0);
                if (!d.isNaN()) {
                    jso.put(JSON_INIT, d);
                }
            }
        }
        jso.putOpt(JSON_COMMENT, this.comment);
    }

    public void addWindowRef(WindowView w, boolean write) {
        this.refWindows.add(w, write);
    }

    public void addCodeLineRef(int line, boolean write) {
        this.refCodeLines.add(line, write);
    }

    public void addModbusRef(RegView reg, boolean write) {
        this.refModbusRegs.add(reg, write);
    }

    public void addFbdRef(FbdVariable var, boolean write) {
        this.refFbdVars.add(var, write);
    }

    public void addScheduleRef(ScheduleTableView table) {
        this.refSchedTables.add(table, true);
    }

    public boolean isUsed() {
        return this.refWindows.isUsed() || this.refCodeLines.isUsed() || this.refFbdVars.isUsed() || this.refModbusRegs.isUsed() || this.refSchedTables.isUsed();
    }

    public boolean isWritten() {
        return this.refWindows.isWritten() || this.refCodeLines.isWritten() || this.refFbdVars.isWritten() || this.refModbusRegs.isWritten() || this.refSchedTables.isWritten();
    }

    public boolean isWrittenInFbd() {
        return this.refFbdVars.isWritten();
    }

    public static String encodeLF(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>");
    }

    public static String decodeLF(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("&lt;", "<").replace("&gt;", ">").replace("<br>", "\n");
    }

    public void compileVar() throws SyntaxError {
        if (this.isAlias()) {
            return;
        }
        Program prg = this.editor.mainFrame.program;
        Device dev = prg.device;
        if (this.block == dev.SysInVars) {
            return;
        }
        if (this.block == dev.SysStoreVars || this.block == dev.SysExtVars || this.block == dev.SysOutVars) {
            this.updateInit();
            return;
        }
        this.compiledVar = this.arraySize > 0 ? this.block.createArrayVar(this.name, this.valueType, this.arraySize, prg.Constants) : this.block.createSimpleVar(this.name, this.valueType, false, -1);
        this.updateInit();
        this.compiledVar.comment = this.comment;
    }

    private void updateInit() {
        if (this.isAlias()) {
            return;
        }
        if (this.compiledVar.isArray()) {
            int i = 0;
            for (Variable v : this.compiledVar.arrayItems) {
                v.initValue = this.initValues.get(i++);
            }
        } else {
            this.compiledVar.initValue = this.initValues.get(0);
        }
    }

    protected VariableDef getAliasSrc() {
        return this.aliasPeer;
    }

    protected boolean setAliasSrc(VariableDef v) {
        if (this.checkNotSystem(true) && this.aliasPeer != v) {
            this.unlinkAlias();
            if (v != null) {
                this.linkAlias(v);
            }
            return true;
        }
        return false;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public boolean isSystem() {
        Device dev = this.editor.mainFrame.program.device;
        return !this.alias && (this.block == dev.SysInVars || this.block == dev.SysOutVars || this.block == dev.SysStoreVars || this.block == dev.SysExtVars);
    }

    public boolean isWritable() {
        Program prg = this.editor.mainFrame.program;
        return this.block != prg.Constants && this.block != prg.device.SysInVars;
    }

    public boolean isWritableInFbd() {
        return this.isWritable() && !this.hasLimitedWrites();
    }

    public boolean hasLimitedWrites() {
        Program prg = this.editor.mainFrame.program;
        return this.block == prg.StoreVars || this.block == prg.device.SysStoreVars;
    }

    public String toString() {
        if (this.aliasPeer != null) {
            return this.name + "  (" + this.aliasPeer.name + ")";
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    private void updateFullName() {
        this.fullName = this.isAlias() ? this.aliasPeer.fullName : this.block.name + "." + Variable.typeToString(this.valueType) + "." + this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getMemTypeShort() {
        Program prg = this.editor.mainFrame.program;
        if (this.block == prg.RamVars || this.block == prg.device.SysInVars || this.block == prg.device.SysOutVars) {
            return "R";
        }
        if (this.block == prg.StoreVars || this.block == prg.device.SysStoreVars) {
            return "E";
        }
        if (this.block == prg.ExtVars || this.block == prg.device.SysExtVars) {
            return "N";
        }
        return "F";
    }

    public String getMemTypeLong() {
        return this.block.memType;
    }

    public String getCommentHtml() {
        return this.comment;
    }

    public String getCommentStr() {
        return VariableDef.decodeLF(this.comment);
    }

    public VariablesBlock getBlock() {
        return this.block;
    }

    public int getValueType() {
        return this.valueType;
    }

    public boolean setValueType(int t) {
        if (this.checkNotSystem(false) && this.valueType != t) {
            this.valueType = t;
            this.updateFullName();
            return true;
        }
        return false;
    }

    public double getInitValue() {
        if (this.isAlias()) {
            return this.aliasPeer.getInitValue();
        }
        return this.initValues.get(0);
    }

    public boolean setInitValue(double v) {
        if (this.isAlias()) {
            return this.aliasPeer.setInitValue(v);
        }
        double t = this.initValues.get(0);
        if (t != v || Double.isNaN(t) ^ Double.isNaN(v)) {
            this.initValues.set(0, v);
            return true;
        }
        return false;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    protected ArrayList<Double> getInitValuesArray() {
        if (this.isAlias()) {
            return this.aliasPeer.initValues;
        }
        return this.initValues;
    }

    public boolean setInitArray(int size, ArrayList<Double> init) {
        if (this.checkNotSystem(false) && (size != this.arraySize || !this.initValues.equals(init))) {
            if (size > 1 && size != init.size()) {
                throw new IllegalArgumentException("Invalid init array size");
            }
            this.arraySize = size;
            this.initValues = init;
            return true;
        }
        return false;
    }

    private boolean checkNotSystem(boolean aliasAllowed) {
        if (this.isSystem() || !aliasAllowed && this.isAlias()) {
            throw new IllegalStateException("Trying to modify system variable!");
        }
        return true;
    }

    public boolean setName(String name) {
        if (this.checkNotSystem(true) && !this.name.equals(name)) {
            this.name = name;
            this.updateFullName();
            return true;
        }
        return false;
    }

    public boolean setComment(String c) {
        if (this.checkNotSystem(true)) {
            String s;
            if (c != null) {
                c = c.trim();
            }
            if (!this.comment.equals(s = VariableDef.encodeLF(c))) {
                this.comment = s;
                return true;
            }
        }
        return false;
    }

    public boolean setBlock(VariablesBlock b) {
        if (this.checkNotSystem(false) && this.block != b) {
            this.block = b;
            this.updateFullName();
            return true;
        }
        return false;
    }

    static {
        RO_RAM_COLOR = RAM_COLOR = new Color(0xAFEEEE);
        FLASH_COLOR = new Color(0xFFFF99);
        NVRAM_COLOR = new Color(0xDDA0DD);
    }
}

