/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.AView;
import certa.vics.ide.ui.GroupView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import certa.vics.lcd.LcdDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class WindowView
extends AView {
    public static final int LCD_MARGIN = 2;
    public static int WIN_WIDTH;
    public static int WIN_HEIGHT;
    public static final Font FONT;
    public static final LcdDisplay.LcdParams LCD;
    private static int lcdWidth;
    private static int lcdHeight;
    private final byte[][] lcdChars;
    private GroupView parentGroup;
    private GroupView nestedGroup;
    protected String name;
    public int position;
    protected String title = null;
    protected VariableRef visibleVar = null;
    protected String text = null;
    protected VariableRef var = null;
    protected StringList strings = null;
    protected int digits = 0;
    protected boolean editable = false;
    protected boolean instEdit = false;
    protected int min = 0;
    protected int max = 0;
    protected int schedule = 0;
    protected VariableRef titleVar = null;
    protected int titleDigits = 0;
    static final String[] fmtDigits;
    public static final Stroke LINK_STROKE;
    static final AlphaComposite RELOCATE_ALPHA;
    static final Color FORBIDDEN_TARGET;
    static final Color ALLOWED_TARGET;
    static final int MARKER_SIZE = 7;
    static final int MARKER_SHIFT = 3;
    static final Color LINK_MARKER;
    static final Color LINK_MARKER_HOVER;
    static final Color SELECT_BORDER;
    static final Color HOVER_BORDER;
    static final Color NORMAL_FILL;
    static final Color FOCUS_FILL;
    static final String[] KEYS;
    boolean leftLinkHover = false;
    boolean rightLinkHover = false;
    boolean downLinkHover = false;
    boolean markerMiddle;
    Rectangle leftMarker;
    Rectangle rightMarker;
    Rectangle downMarker;
    static final String JSON_TITLE = "title";
    static final String JSON_VISVAR = "visvar";
    static final String JSON_TEXT = "text";
    static final String JSON_VAR = "var";
    static final String JSON_STRINGS = "strings";
    static final String JSON_DIGITS = "digits";
    static final String JSON_EDITABLE = "editable";
    static final String JSON_INSTEDIT = "instedit";
    static final String JSON_MIN = "min";
    static final String JSON_MAX = "max";
    static final String JSON_SCHEDULE = "schedule";
    static final String JSON_TITLEVAR = "titlevar";
    static final String JSON_TITLEDIGITS = "titledigits";
    static final String JSON_NESTEDGROUP = "nestedgroup";

    public static void initLcd(LcdFont font, int columns, int rows) {
        WindowView.LCD.font = font;
        WindowView.LCD.rowsCount = rows;
        WindowView.LCD.columnsCount = columns;
        WindowView.LCD.pixelHeight = 2;
        WindowView.LCD.pixelWidth = 2;
        WindowView.LCD.pixelGap = 0;
        WindowView.LCD.charGap = 2;
        WindowView.LCD.pixelOffColor = null;
        WindowView.LCD.backgroundColor = null;
        lcdWidth = LcdDisplay.getCharX0(LCD, WindowView.LCD.columnsCount);
        lcdHeight = LcdDisplay.getCharY0(LCD, WindowView.LCD.rowsCount);
        WIN_WIDTH = lcdWidth + 4;
        WIN_HEIGHT = lcdHeight + 4;
    }

    public WindowView(GroupView group, int position) {
        super(group.editor);
        this.parentGroup = group;
        this.position = position;
        group.getList().add(position, this);
        this.updateBounds();
        this.lcdChars = new byte[2][8];
    }

    public WindowView(GroupView group) {
        this(group, 0);
        group.getList().remove(this);
        group.getList().add(this);
        WindowView w = group.getRightmostWindow(this);
        if (w != null) {
            this.setPosition(w.position + 1);
        }
    }

    public boolean relocateTo(GroupView group, int pos) {
        if (group.canInsertWindow() && (this.canHaveSiblings() || group.getList().isEmpty())) {
            GroupView oldGroup = this.parentGroup;
            this.parentGroup = group;
            if (oldGroup == this.parentGroup && this.position <= pos) {
                --pos;
            }
            oldGroup.getList().remove(this);
            this.parentGroup.getList().add(pos, this);
            this.parentGroup.updatePreview();
            if (oldGroup != this.parentGroup) {
                oldGroup.updatePreview();
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.nestedGroup != null) {
            this.nestedGroup.updateNames(name);
        }
    }

    public void setPosition(int pos) {
        this.position = pos;
        this.updateBounds();
    }

    public GroupView getParentGroup() {
        return this.parentGroup;
    }

    public GroupView getNestedGroup() {
        return this.nestedGroup;
    }

    public void setNestedGroup(GroupView g) {
        if (this.nestedGroup != null) {
            this.nestedGroup.ownerWindow = null;
        }
        if (g != null) {
            g.ownerWindow = this;
        }
        this.nestedGroup = g;
    }

    public static void buildTextPreview(byte[][] chars, String title, String text) {
        WindowView.LCD.font.encodeString(title, chars[0]);
        WindowView.LCD.font.encodeString(text, chars[1]);
    }

    static String formatDigits(VariableRef var, int digits, boolean edit, boolean inst) {
        if (var == null) {
            return null;
        }
        if (digits > 3) {
            digits = 3;
        }
        if (digits < 0) {
            digits = 0;
        }
        if (edit) {
            digits = inst ? (digits += 8) : (digits += 4);
        }
        return fmtDigits[digits];
    }

    public static void buildVarPreview(byte[][] chars, String title, VariableRef var, int digits, StringList strings, boolean edit, boolean inst) {
        WindowView.LCD.font.encodeString(title, chars[0]);
        if (var == null) {
            WindowView.LCD.font.encodeString(null, chars[1]);
            return;
        }
        if (var.type() != 3) {
            digits = 0;
        }
        if (!StringList.isEmpty(strings) && var.type() != 3) {
            byte[] s = strings.Strings.get((int)0).Bytes;
            for (int i = 1; i <= Math.min(s.length, chars[1].length - 2); ++i) {
                chars[1][i] = s[i - 1];
            }
            chars[1][0] = WindowView.LCD.font.utf8CharToByte((char)(edit ? (inst ? 91 : 60) : 32));
            chars[1][chars[1].length - 1] = WindowView.LCD.font.utf8CharToByte((char)(edit ? (inst ? 93 : 62) : 32));
        } else {
            WindowView.LCD.font.encodeString(WindowView.formatDigits(var, digits, edit, inst), chars[1]);
        }
    }

    public static void buildTablePreview(byte[][] chars, VariableRef titleVar, int titleDigits, VariableRef var, int varDigits) {
        WindowView.LCD.font.encodeString(WindowView.formatDigits(titleVar, titleDigits, false, false), chars[0]);
        WindowView.LCD.font.encodeString(WindowView.formatDigits(var, varDigits, true, false), chars[1]);
    }

    private Rectangle initMarker(Rectangle old, boolean exists) {
        if (exists) {
            return old != null ? old : new Rectangle();
        }
        return null;
    }

    public void updatePreview() {
        if (this.var == null) {
            WindowView.buildTextPreview(this.lcdChars, this.title, this.text);
        } else if (this.titleVar == null || !this.var.isArray()) {
            WindowView.buildVarPreview(this.lcdChars, this.title, this.var, this.digits, this.strings, this.editable, this.instEdit);
        } else {
            WindowView.buildTablePreview(this.lcdChars, this.titleVar, this.titleDigits, this.var, this.digits);
        }
        this.leftMarker = this.initMarker(this.leftMarker, this.canHaveSiblings() && this.position == 0);
        this.markerMiddle = this.position < this.parentGroup.windows.size() - 1;
        this.rightMarker = this.initMarker(this.rightMarker, this.canHaveSiblings());
        this.downMarker = this.initMarker(this.downMarker, this.canHaveNestedGroup());
    }

    private void updateMarker(Rectangle r, int x, int y, boolean middle) {
        if (r != null) {
            r.x = middle ? x + 6 : x;
            r.y = y;
            r.width = middle ? 8 : 7;
            r.height = 7;
        }
    }

    @Override
    void updateBounds() {
        this.bounds.x = (this.parentGroup.x + this.position) * UiEditor.CELL_WIDTH + 0 + 10 + 30;
        this.bounds.y = this.parentGroup.y * UiEditor.CELL_HEIGHT + 20 + 15 + 10;
        this.bounds.width = WIN_WIDTH;
        this.bounds.height = WIN_HEIGHT;
        int y = this.bounds.y + this.bounds.height / 2 - 3;
        this.updateMarker(this.leftMarker, this.bounds.x - 7, y, false);
        this.updateMarker(this.rightMarker, this.bounds.x + this.bounds.width, y, this.markerMiddle);
        this.updateMarker(this.downMarker, this.bounds.x + this.bounds.width / 2 - 3, this.bounds.y + this.bounds.height, false);
    }

    void paintLinkMarker(Graphics2D g2d, Rectangle r, boolean hovered) {
        if (r != null) {
            g2d.setColor(hovered ? LINK_MARKER_HOVER : LINK_MARKER);
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void paintSelf(Graphics2D g2d) {
        Composite comp = g2d.getComposite();
        boolean reloc = this.isRelocating();
        if (reloc) {
            g2d.setComposite(RELOCATE_ALPHA);
        }
        try {
            int x;
            g2d.setColor(NORMAL_FILL);
            g2d.fill(this.bounds);
            if (this.canHaveNestedGroup()) {
                x = this.bounds.x + this.bounds.width / 2;
                int y = this.bounds.y + this.bounds.height;
                if (this.nestedGroup != null) {
                    g2d.setStroke(LINK_STROKE);
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(x, y, x, this.nestedGroup.bounds.y);
                } else {
                    this.paintLinkMarker(g2d, this.downMarker, this.downLinkHover);
                }
            }
            if (this.position == 0 && this.parentGroup.ownerWindow != null) {
                g2d.setStroke(LINK_STROKE);
                g2d.setColor(Color.BLACK);
                x = this.bounds.x + this.bounds.width / 2;
                g2d.drawLine(x, this.bounds.y, x, this.parentGroup.bounds.y);
            }
            if (this.canHaveSiblings()) {
                WindowView rw = this.getRightLink();
                if (rw != null) {
                    g2d.setStroke(LINK_STROKE);
                    g2d.setColor(Color.BLACK);
                    int x1 = this.bounds.x + this.bounds.width;
                    int y1 = this.bounds.y + this.bounds.height / 2;
                    int x2 = rw.bounds.x;
                    int y2 = rw.bounds.y + rw.bounds.height / 2;
                    if (rw.position > this.position) {
                        g2d.drawLine(x1, y1, x2, y2);
                    }
                }
                this.paintLinkMarker(g2d, this.leftMarker, this.leftLinkHover);
                this.paintLinkMarker(g2d, this.rightMarker, this.rightLinkHover);
            }
            if (this.focused) {
                g2d.setColor(Color.GREEN);
                g2d.fill(this.bounds);
            }
            LcdDisplay.paintChars(LCD, this.lcdChars, this.bounds.x + 2, this.bounds.y + 2, lcdWidth, lcdHeight, g2d);
            if (this.isSelected()) {
                g2d.setStroke(THICK_STROKE);
                g2d.setColor(SELECT_BORDER);
                g2d.drawRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 1);
            } else if (this.parentSelected) {
                g2d.setStroke(THIN_STROKE);
                g2d.setColor(SELECT_BORDER);
                g2d.draw(this.bounds);
            }
            if (this.hovered && !reloc && this.editor.isRelocating() && !this.leftLinkHover && !this.rightLinkHover && !this.downLinkHover) {
                if (this.canAddNestedWindow()) {
                    g2d.setColor(ALLOWED_TARGET);
                    g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                } else {
                    g2d.setColor(FORBIDDEN_TARGET);
                    g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    g2d.setStroke(THICK_STROKE);
                    g2d.setColor(Color.WHITE);
                    g2d.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1);
                    g2d.drawLine(this.bounds.x, this.bounds.y + this.bounds.height - 1, this.bounds.x + this.bounds.width - 1, this.bounds.y);
                }
            }
            if (this.name != null) {
                g2d.setColor(Color.BLACK);
                g2d.setFont(FONT);
                g2d.drawString(this.name, this.bounds.x, this.bounds.y - 2);
            }
            for (int i = 0; i < this.editor.keyWindows.length; ++i) {
                if (this.editor.keyWindows[i] != this) continue;
                g2d.setColor(Color.BLUE);
                g2d.setFont(FONT);
                g2d.drawString(KEYS[i], this.bounds.x, this.bounds.y + this.bounds.height + 10);
            }
            if (this.schedule > 0) {
                String s = "\u0440\u0430\u0441\u043f. " + this.schedule;
                g2d.setColor(Color.BLUE);
                g2d.setFont(FONT);
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(s, g2d);
                g2d.drawString(s, this.bounds.x + this.bounds.width - (int)rect.getWidth(), this.bounds.y + this.bounds.height + 10);
            }
        }
        finally {
            g2d.setComposite(comp);
        }
    }

    private boolean positionAllowed(int pos) {
        WindowView w = this.parentGroup.windowAtPos(pos);
        return w == null || w == this;
    }

    public boolean moveTo(int pos) {
        if (pos != this.position) {
            if (pos < 0) {
                if (this.parentGroup.growLeft(-pos)) {
                    this.setPosition(0);
                    return true;
                }
                return false;
            }
            if (pos >= this.parentGroup.width) {
                if (this.parentGroup.growRight(pos - this.parentGroup.width + 1)) {
                    this.setPosition(pos);
                    return true;
                }
                return false;
            }
            if (this.positionAllowed(pos)) {
                this.setPosition(pos);
                return true;
            }
            return false;
        }
        return false;
    }

    public WindowView makeClone(GroupView clonedParent) {
        WindowView w = new WindowView(clonedParent, this.position);
        w.focused = this.focused;
        w.title = this.title;
        w.visibleVar = this.visibleVar;
        w.text = this.text;
        w.var = this.var;
        w.strings = this.strings;
        w.digits = this.digits;
        w.editable = this.editable;
        w.instEdit = this.instEdit;
        w.min = this.min;
        w.max = this.max;
        w.schedule = this.schedule;
        w.titleVar = this.titleVar;
        w.titleDigits = this.titleDigits;
        if (this.nestedGroup != null) {
            w.nestedGroup = this.nestedGroup.makeClone(w);
        }
        w.name = this.name;
        w.updatePreview();
        return w;
    }

    public boolean sameAs(WindowView w) {
        if (w == null) {
            return false;
        }
        if (this.position != w.position) {
            return false;
        }
        if (this.title != w.title) {
            return false;
        }
        if (!VariableRef.sameVar(this.visibleVar, w.visibleVar)) {
            return false;
        }
        if (this.text != w.text) {
            return false;
        }
        if (!VariableRef.sameVar(this.var, w.var)) {
            return false;
        }
        if (this.strings != w.strings) {
            return false;
        }
        if (this.digits != w.digits) {
            return false;
        }
        if (this.editable != w.editable) {
            return false;
        }
        if (this.instEdit != w.instEdit) {
            return false;
        }
        if (this.min != w.min) {
            return false;
        }
        if (this.max != w.max) {
            return false;
        }
        if (this.schedule != w.schedule) {
            return false;
        }
        if (!VariableRef.sameVar(this.titleVar, w.titleVar)) {
            return false;
        }
        if (this.titleDigits != w.titleDigits) {
            return false;
        }
        if (this.nestedGroup != null) {
            return this.nestedGroup.sameAs(w.nestedGroup);
        }
        return w.nestedGroup == null;
    }

    public Window.WindowType getTargetType() {
        if (this.var != null) {
            if (this.editable) {
                if (this.titleVar != null && this.var.isArray() && this.titleVar.arraySize() == this.var.arraySize() && this.var.type() == 3 && this.titleVar.type() == this.var.type()) {
                    return Window.WindowType.TABLEEDIT;
                }
                if (this.var.type() != 3 && this.strings != null) {
                    return Window.WindowType.EDIT_TEXT;
                }
                if (this.instEdit) {
                    return Window.WindowType.INST_EDIT;
                }
                return Window.WindowType.EDIT_NUM;
            }
            if (this.var.type() != 3 && this.strings != null) {
                return Window.WindowType.DISP_TEXT;
            }
            return Window.WindowType.DISP_NUM;
        }
        if (this.schedule > 0) {
            return Window.WindowType.SCHEDULE;
        }
        return Window.WindowType.STATIC;
    }

    private String getWndName(WindowView w) {
        if (w != null) {
            return w.getName();
        }
        return null;
    }

    public void loadWindow(Program prg, Window wnd) {
        VariablesEditor ved = MainFrame.instance.getVarsEditor();
        this.title = wnd.title != null ? wnd.title.Source.replace('_', ' ') : null;
        this.text = wnd.text != null ? wnd.text.Source.replace('_', ' ') : null;
        this.editable = wnd.type == Window.WindowType.EDIT_NUM || wnd.type == Window.WindowType.EDIT_TEXT || wnd.type == Window.WindowType.INST_EDIT || wnd.type == Window.WindowType.TABLEEDIT;
        this.instEdit = wnd.type == Window.WindowType.INST_EDIT;
        this.var = ved.makeRef(wnd.var);
        this.titleVar = ved.makeRef(wnd.titleVar);
        this.visibleVar = ved.makeRef(wnd.visible);
        if (!StringList.isEmpty(wnd.strings)) {
            this.strings = new StringList(wnd.strings, prg);
        }
        this.digits = wnd.digits;
        this.titleDigits = wnd.titleDigits;
        this.min = wnd.min;
        this.max = wnd.max;
        this.schedule = wnd.schedule;
        if (wnd.canLinkDown() && wnd.downLink != wnd) {
            new GroupView(this.editor, this);
            this.nestedGroup.loadWindows(prg, wnd.downLink);
        }
        for (int i = 0; i < prg.keyWindows.length; ++i) {
            if (prg.keyWindows[i] != wnd) continue;
            this.editor.keyWindows[i] = this;
        }
        this.updatePreview();
    }

    public void compileWindow(Program prg) throws SyntaxError {
        Window wnd = new Window(this.getTargetType(), this.name, prg);
        wnd.title = new WindowString(this.title != null ? this.title.replace(' ', '_') : null, prg.device.FONT, prg.device.DISPLAY_COLS);
        wnd.text = new WindowString(this.text != null ? this.text.replace(' ', '_') : null, prg.device.FONT, prg.device.DISPLAY_COLS);
        wnd.var = this.var != null ? this.var.getCompiledVar() : null;
        wnd.titleVar = this.titleVar != null ? this.titleVar.getCompiledVar() : null;
        Variable variable = wnd.visible = this.visibleVar != null ? this.visibleVar.getCompiledVar() : null;
        if (!StringList.isEmpty(this.strings)) {
            prg.registerStrings(this.strings);
            wnd.strings = this.strings;
        }
        wnd.digits = this.digits;
        wnd.titleDigits = this.titleDigits;
        wnd.min = this.min;
        wnd.max = this.max;
        wnd.schedule = this.schedule;
        wnd.upStr = this.getWndName(this.parentGroup.ownerWindow);
        if (this.nestedGroup != null && wnd.canLinkDown()) {
            wnd.downStr = this.nestedGroup.pwdLevel >= 0 ? this.nestedGroup.getPwdWindowName() : this.getWndName(this.nestedGroup.getLeftmostWindow());
        }
        if (wnd.canLinkLeftRight()) {
            wnd.leftStr = this.getWndName(this.getLeftLink());
            wnd.rightStr = this.getWndName(this.getRightLink());
        }
        prg.registerWindow(wnd);
        if (wnd.canLinkDown() && this.nestedGroup != null) {
            this.nestedGroup.compileWindows(prg);
        }
        for (int i = 0; i < this.editor.keyWindows.length; ++i) {
            if (this.editor.keyWindows[i] != this) continue;
            prg.keyWindows[i] = wnd;
        }
    }

    public WindowView getLeftLink() {
        int p = 0;
        WindowView w1 = null;
        for (WindowView w : this.parentGroup.windows) {
            if (w == this || w.position < p || w.position >= this.position) continue;
            p = w.position;
            w1 = w;
        }
        if (w1 == null && this.parentGroup.looped) {
            w1 = this.parentGroup.getRightmostWindow(null);
        }
        return w1;
    }

    public WindowView getRightLink() {
        int p = Integer.MAX_VALUE;
        WindowView w1 = null;
        for (WindowView w : this.parentGroup.windows) {
            if (w == this || w.position > p || w.position <= this.position) continue;
            p = w.position;
            w1 = w;
        }
        if (w1 == null && this.parentGroup.looped) {
            w1 = this.parentGroup.getLeftmostWindow();
        }
        return w1;
    }

    public WindowView getUpLink() {
        return this.parentGroup.ownerWindow;
    }

    public WindowView getDownLink() {
        if (this.nestedGroup != null) {
            return this.nestedGroup.getLeftmostWindow();
        }
        return null;
    }

    public boolean canHaveNestedGroup() {
        return !this.editable && this.schedule == 0;
    }

    public boolean canHaveSiblings() {
        return !this.editable || this.titleVar == null;
    }

    public boolean canAddNestedWindow() {
        return this.canHaveNestedGroup() && (this.nestedGroup == null || this.nestedGroup.canInsertWindow());
    }

    public boolean canInsertGroup() {
        return this.canHaveNestedGroup() && this.nestedGroup == null;
    }

    boolean isSelectedAnyWay() {
        if (this.isSelected()) {
            return true;
        }
        return this.parentGroup.isSelectedAnyWay();
    }

    boolean isRelocating() {
        if (this.editor.isRelocating()) {
            return this.isSelectedAnyWay();
        }
        return false;
    }

    @Override
    void updateSelection() {
        if (this.nestedGroup != null) {
            this.nestedGroup.parentSelected = this.parentSelected || this.isSelected();
            this.nestedGroup.updateSelection();
        }
    }

    void saveVar(VariableRef vr, String key, JSONObject jso, List<VariableDef> vars) {
        if (vr != null) {
            jso.put(key, vr.fullName());
            vars.add(vr.varDef);
        }
    }

    void saveToJSON(JSONObject jso, List<VariableDef> vars) {
        jso.put(JSON_TITLE, this.title);
        this.saveVar(this.visibleVar, JSON_VISVAR, jso, vars);
        jso.put(JSON_TEXT, this.text);
        this.saveVar(this.var, JSON_VAR, jso, vars);
        if (this.strings != null) {
            JSONArray t = new JSONArray();
            this.strings.saveToJSON(t);
            jso.put(JSON_STRINGS, t);
        }
        jso.put(JSON_DIGITS, this.digits);
        jso.put(JSON_EDITABLE, this.editable);
        jso.put(JSON_INSTEDIT, this.instEdit);
        jso.put(JSON_MIN, this.min);
        jso.put(JSON_MAX, this.max);
        jso.put(JSON_SCHEDULE, this.schedule);
        this.saveVar(this.titleVar, JSON_TITLEVAR, jso, vars);
        jso.put(JSON_TITLEDIGITS, this.titleDigits);
        if (this.nestedGroup != null) {
            JSONObject g = new JSONObject();
            this.nestedGroup.saveToJSON(g, vars);
            jso.put(JSON_NESTEDGROUP, g);
        }
    }

    VariableRef loadVar(String key, JSONObject jso) {
        String s = jso.optString(key);
        if (!Utils.strEmpty(s)) {
            return this.editor.mainFrame.getVarsEditor().locateVar(s);
        }
        return null;
    }

    void loadFromJSON(JSONObject src) {
        this.title = src.optString(JSON_TITLE);
        this.visibleVar = this.loadVar(JSON_VISVAR, src);
        this.text = src.optString(JSON_TEXT);
        this.var = this.loadVar(JSON_VAR, src);
        JSONArray t = src.optJSONArray(JSON_STRINGS);
        this.strings = t != null ? new StringList(t, this.editor.mainFrame.program) : null;
        this.digits = src.optInt(JSON_DIGITS);
        this.editable = src.optBoolean(JSON_EDITABLE);
        this.instEdit = src.optBoolean(JSON_INSTEDIT);
        this.min = src.optInt(JSON_MIN);
        this.max = src.optInt(JSON_MAX);
        this.schedule = src.optInt(JSON_SCHEDULE);
        this.titleVar = this.loadVar(JSON_TITLEVAR, src);
        this.titleDigits = src.optInt(JSON_TITLEDIGITS);
        this.validateVars();
        JSONObject g = src.optJSONObject(JSON_NESTEDGROUP);
        if (g != null) {
            this.nestedGroup = new GroupView(this.editor, this);
            this.nestedGroup.loadFromJSON(g);
        } else {
            this.nestedGroup = null;
        }
    }

    boolean validateVars() {
        if (this.visibleVar != null && this.visibleVar.type() != 1) {
            this.visibleVar = null;
            return false;
        }
        if (!(this.var == null || this.titleVar == null || this.var.type() == 3 && this.titleVar.type() == 3 && this.var.arraySize() == this.titleVar.arraySize() && this.var.isArray())) {
            this.titleVar = null;
            return false;
        }
        return true;
    }

    boolean isHovered(int x, int y) {
        boolean body = this.bounds.contains(x, y);
        this.leftLinkHover = this.leftMarker != null && this.leftMarker.contains(x, y);
        this.rightLinkHover = this.rightMarker != null && this.rightMarker.contains(x, y);
        this.downLinkHover = this.downMarker != null && this.downMarker.contains(x, y);
        return body || this.leftLinkHover || this.rightLinkHover || this.downLinkHover;
    }

    static {
        FONT = new Font("Sans", 0, 12);
        LCD = new LcdDisplay.LcdParams();
        fmtDigits = new String[]{"      0 ", "    0.0 ", "   0.00 ", "  0.000 ", "<     0>", "<   0.0>", "<  0.00>", "< 0.000>", "[     0]", "[   0.0]", "[  0.00]", "[ 0.000]"};
        LINK_STROKE = new BasicStroke(1.0f);
        RELOCATE_ALPHA = AlphaComposite.getInstance(3, 0.3f);
        FORBIDDEN_TARGET = new Color(255, 0, 0, 128);
        ALLOWED_TARGET = new Color(0, 255, 0, 64);
        LINK_MARKER = new Color(0, 128, 0);
        LINK_MARKER_HOVER = new Color(0, 255, 0);
        SELECT_BORDER = new Color(0, 0, 255);
        HOVER_BORDER = new Color(0, 255, 255);
        NORMAL_FILL = new Color(180, 180, 180);
        FOCUS_FILL = new Color(0, 210, 80);
        KEYS = new String[]{"\u21e7 + \u21e9", "\u21e6 + \u21e8", "\u21e9 + \u21e6", "\u21e7 + \u21e8"};
    }
}

