/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.StringsEditor;
import certa.vics.lcd.LcdDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.UIManager;

public class LcdTextField
extends LcdDisplay
implements MouseListener {
    private static final long serialVersionUID = 1L;
    String dialogTitle;
    Component dialogOwner;
    boolean showNumbers;

    public LcdTextField(LcdFont font, int columns, int rows, boolean showNumbers, String dlgTitle, Component owner) {
        super(font, columns, rows);
        this.dialogTitle = dlgTitle;
        this.dialogOwner = owner;
        this.showNumbers = showNumbers;
        this.params.backgroundColor = SystemColor.text;
        this.params.pixelOnColor = SystemColor.textText;
        this.params.pixelOffColor = this.params.backgroundColor;
        this.params.pixelWidth = 2;
        this.params.pixelHeight = 2;
        this.params.pixelGap = 0;
        this.addMouseListener(this);
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.updateSize();
    }

    void editText() {
        int rc = this.getRowsCount();
        if (rc == 1) {
            String s = StringsEditor.editString(this.getText(0), this.getColumnsCount(), this.getLcdFont(), this.dialogTitle, this.dialogOwner);
            if (s != null) {
                this.setText(0, s);
            }
        } else {
            int i;
            ArrayList<String> s = new ArrayList<String>(rc);
            for (i = 0; i < rc; ++i) {
                s.add(this.getText(i));
            }
            if (StringsEditor.editStrings(s, this.showNumbers, false, this.getColumnsCount(), this.getLcdFont(), this.dialogTitle, this.dialogOwner)) {
                for (i = 0; i < rc; ++i) {
                    this.setText(i, s.get(i));
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.editText();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

