/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.CharButton;
import certa.vics.ide.ui.LcdEditDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.GridLayout;
import javax.swing.JPanel;

class LcdDisplayEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    public final LcdEditDisplay display;
    private JPanel keysPanel;

    public LcdDisplayEditor(LcdFont font, int columns, int rows) {
        this.display = new LcdEditDisplay(font, columns, rows);
        this.add(this.display);
        this.keysPanel = new JPanel(new GridLayout(0, 16));
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int code = i * 16 + j;
                if (!this.display.getLcdFont().isCharPresent((byte)code)) continue;
                this.keysPanel.add(new CharButton(this.display, code));
            }
        }
        this.add(this.keysPanel);
        this.initFocus();
    }

    public void initFocus() {
        this.display.cursorX = 0;
        this.display.cursorY = 0;
        this.display.requestFocusInWindow();
    }

    public void setLcdText(int rowIndex, String text) {
        this.display.setText(rowIndex, text);
    }

    public String getLcdText(int rowIndex) {
        return this.display.getText(rowIndex);
    }

    public void setLcdSize(int columns, int rows) {
        this.display.setLcdSize(columns, rows);
    }

    public void setLcdRows(int rows) {
        this.display.setLcdSize(this.display.getColumnsCount(), rows);
    }
}

