/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusActions;
import certa.vics.ide.modbus.ModbusTableView;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONObject;

public class ModbusEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    ModbusActions actions;
    protected final MainFrame mainFrame;
    final ModbusTableView inputs;
    final ModbusTableView coils;
    final ModbusTableView iregs;
    final ModbusTableView hregs;
    final ArrayList<ModbusTableView> tabs = new ArrayList();
    JTabbedPane tabbedPane;
    static final String PROP_KEY = "modbus";

    public ModbusEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0422\u0430\u0431\u043b\u0438\u0446\u044b MODBUS");
        this.mainFrame = mainFrame;
        this.inputs = new ModbusTableView(this, "INPUTS", false, false, "modbus.inputs");
        this.coils = new ModbusTableView(this, "COILS", false, true, "modbus.coils");
        this.iregs = new ModbusTableView(this, "INPUT REGS", true, false, "modbus.iregs");
        this.hregs = new ModbusTableView(this, "HOLDING REGS", true, true, "modbus.hregs");
        this.tabbedPane = new JTabbedPane();
        this.addTab(this.inputs, "Inputs", "Read only 1-bit discretes");
        this.addTab(this.coils, "Coils", "Writable 1-bit discretes");
        this.addTab(this.iregs, "Input registers", "Read only 16-bit registers");
        this.addTab(this.hregs, "Holding registers", "Writable 16-bit registers");
        this.loadProps();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ModbusEditor.this.initFocus();
            }
        });
        this.tabbedPane.addMouseListener(this.focuser);
    }

    private void addTab(ModbusTableView table, String title, String hint) {
        this.tabbedPane.addTab(title, null, table, hint);
        this.tabs.add(table);
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new ModbusActions(this);
        return this.actions;
    }

    @Override
    public void titleClicked() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            this.tabs.get((int)i).table.requestFocusInWindow();
        }
    }

    @Override
    public void initFocus() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0) {
            ModbusTableView t = this.tabs.get(i);
            t.table.requestFocusInWindow();
            t.updateVarList(this.mainFrame.getVarsEditor());
        }
    }

    @Override
    public void clear() {
        this.inputs.loadRegs(null, null, null);
        this.coils.loadRegs(null, null, null);
        this.iregs.loadRegs(null, null, null);
        this.hregs.loadRegs(null, null, null);
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        for (ModbusTableView t : this.tabs) {
            t.isModified = false;
        }
    }

    private void buildLists() {
        ModbusBlock mb = this.mainFrame.program.Modbus;
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        this.inputs.loadRegs(mb, mb.Inputs, ved);
        this.coils.loadRegs(mb, mb.Coils, ved);
        this.iregs.loadRegs(mb, mb.IRs, ved);
        this.hregs.loadRegs(mb, mb.HRs, ved);
    }

    @Override
    public void initNewProgram() {
        this.buildLists();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.buildLists();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        ModbusBlock mb = this.mainFrame.program.Modbus;
        this.inputs.compileRegs(mb, 1);
        this.coils.compileRegs(mb, 2);
        this.iregs.compileRegs(mb, 3);
        this.hregs.compileRegs(mb, 4);
    }

    private void loadProps() {
    }

    @Override
    public void saveProps() {
        this.inputs.saveProps();
        this.coils.saveProps();
        this.iregs.saveProps();
        this.hregs.saveProps();
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearModbusRefs();
        for (ModbusTableView t : this.tabs) {
            for (RegView r : t.list) {
                if (r.var == null) continue;
                r.var.varDef.addModbusRef(r, t.isWritable);
            }
        }
        ved.updateTable();
    }

    @Override
    public void updateVarList() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        for (ModbusTableView t : this.tabs) {
            t.updateVarList(ved);
            t.model.fireTableDataChanged();
        }
    }
}

