/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.InputPin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class OutputPin
extends AFbdPin {
    public final ArrayList<InputPin> targets = new ArrayList();
    static final Stroke LINK_STROKE = new BasicStroke(1.0f);
    static final Stroke PIN_STROKE = new BasicStroke(3.0f);
    private int nameWidth = -1;

    public OutputPin(AFbdItem owner, int type, String name, int row) {
        super(owner, type, name, row);
    }

    protected void registerTarget(InputPin target) {
        if (target != null) {
            assert (!this.targets.contains(target)) : "Target already registered";
            assert (target.type == this.type) : "Incompatible target type";
            this.targets.add(target);
        }
    }

    protected void unRegisterTarget(InputPin target) {
        this.targets.remove(target);
    }

    protected void disconnectTargets() {
        while (this.targets.size() > 0) {
            this.targets.get(0).connectSource(null);
        }
    }

    protected boolean hasTargets() {
        return !this.targets.isEmpty();
    }

    public void paintLink(Graphics2D g2d, Point tp) {
        g2d.drawLine(this.linkPoint.x, this.linkPoint.y, tp.x, tp.y);
    }

    public void paintSource(Graphics2D g2d) {
        if (this.owner.page != null) {
            g2d.setColor(this.owner.page.editor.sourcePin == this ? Color.ORANGE : (this.owner.page.editor.hoveredPin == this ? HOVER_COLOR : OutputPin.typeColor(this.type)));
        } else {
            g2d.setColor(OutputPin.typeColor(this.type));
        }
        OutputPin.paintPin(g2d, this.type, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public void paintTarget(Graphics2D g2d, Point tp, boolean hovered, boolean allowed) {
        g2d.setColor(allowed ? (hovered ? HOVER_COLOR : OutputPin.typeColor(this.type)) : Color.RED);
        OutputPin.paintPin(g2d, this.type, tp.x, tp.y - 5, 11, 11);
    }

    @Override
    public void paint(Graphics2D g2d) {
        this.updateBounds();
        g2d.setStroke(LINK_STROKE);
        Color lnk = OutputPin.typeColor(this.type);
        for (InputPin pin : this.targets) {
            if (pin == this.owner.page.editor.oldTargetPin) continue;
            g2d.setColor(lnk);
            Point tp = pin.getLinkPoint();
            this.paintLink(g2d, tp);
            this.paintTarget(g2d, tp, pin == this.owner.page.editor.hoveredPin, true);
        }
        this.paintSource(g2d);
        if (!Utils.strEmpty(this.name)) {
            g2d.setFont(NAME_FONT);
            if (this.nameWidth < 0) {
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(this.name, g2d);
                this.nameWidth = (int)rect.getWidth();
            }
            g2d.setColor(Color.BLACK);
            g2d.drawString(this.name, this.bounds.x - this.nameWidth - 2, this.bounds.y + this.bounds.height - 1);
        }
    }

    @Override
    protected void updateBounds() {
        this.linkPoint.x = this.owner.pxBounds.x + this.owner.pxBounds.width + 11 - 1;
        this.linkPoint.y = (this.owner.cellBounds.y + this.row + this.owner.padTop) * 27 + 13;
        this.bounds.x = this.linkPoint.x - 10;
        this.bounds.y = this.linkPoint.y - 5;
        this.bounds.width = 11;
        this.bounds.height = 11;
    }
}

