/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.AFbdComment;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.AFbdView;
import certa.vics.ide.fbd.FbdCommentRect;
import certa.vics.ide.fbd.FbdCommentText;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.fbd.FbdNumber;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.fbd.ItemsFactory;
import certa.vics.ide.fbd.OutputPin;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdPage {
    public final FbdEditor editor;
    protected final ArrayList<AFbdItem> items = new ArrayList();
    protected final ArrayList<AFbdBlock> blocksOrder = new ArrayList();
    protected final ArrayList<AFbdComment> comments = new ArrayList();
    private String name;
    static final String JSON_NAME = "name";
    static final String JSON_ITEMS = "items";
    static final String JSON_ITEM_CLASS = "_class";
    static final String JSON_COMMENTS = "comments";
    static final String JSON_COMMENT_TYPE = "type";
    static final String COMMENT_TYPE_RECT = "rect";
    static final String COMMENT_TYPE_TEXT = "text";
    private boolean internalUpdate = true;
    static List<AFbdItem> currentList;

    public FbdPage(FbdEditor editor, String name) {
        this.editor = editor;
        this.name = name;
        this.internalUpdate = false;
    }

    public FbdPage(FbdEditor editor, JSONObject src, boolean fromClipboard) throws JSONException, FbdLoadError {
        this.editor = editor;
        this.name = src.getString(JSON_NAME);
        this.loadFromJson(src, fromClipboard, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AFbdView> loadFromJson(JSONObject src, boolean swallowErrors, boolean dontAdd) throws JSONException, FbdLoadError {
        ArrayList<AFbdView> result = new ArrayList<AFbdView>();
        this.internalUpdate = true;
        try {
            JSONObject jso;
            JSONArray jsArray = src.optJSONArray(JSON_ITEMS);
            if (jsArray != null) {
                currentList = new ArrayList<AFbdItem>();
                for (int i = 0; i < jsArray.length(); ++i) {
                    AFbdItem item;
                    block15: {
                        jso = jsArray.getJSONObject(i);
                        item = null;
                        try {
                            item = ItemsFactory.createItem(jso.getString(JSON_ITEM_CLASS), this, jso);
                        }
                        catch (FbdLoadError | JSONException e) {
                            Utils.ProcessException(e, false);
                            if (swallowErrors) break block15;
                            throw e;
                        }
                    }
                    if (item != null && !dontAdd) {
                        this.addItem(item);
                    }
                    currentList.add(item);
                }
                for (AFbdItem item : currentList) {
                    if (item == null) continue;
                    item.resolveLinks(!swallowErrors);
                    result.add(item);
                }
            }
            if ((jsArray = src.optJSONArray(JSON_COMMENTS)) != null) {
                for (int i = 0; i < jsArray.length(); ++i) {
                    jso = jsArray.getJSONObject(i);
                    String type = jso.getString(JSON_COMMENT_TYPE);
                    AFbdComment c = null;
                    if (COMMENT_TYPE_TEXT.equals(type)) {
                        c = new FbdCommentText(this, jso);
                    } else if (COMMENT_TYPE_RECT.equals(type)) {
                        c = new FbdCommentRect(this, jso);
                    }
                    if (c == null) continue;
                    if (!dontAdd) {
                        this.comments.add(c);
                    }
                    result.add(c);
                }
            }
        }
        finally {
            this.internalUpdate = false;
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    private static void removeBlocks(List<AFbdItem> list) {
        Iterator<AFbdItem> it = list.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AFbdBlock)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveItemsToJSON(JSONObject json, List<AFbdItem> list, List<VariableDef> vars, boolean arrange) {
        JSONArray jsArray = new JSONArray();
        if (arrange) {
            ArrayList<AFbdItem> tmp = new ArrayList<AFbdItem>(list);
            FbdPage.removeBlocks(list);
            for (AFbdBlock b : this.blocksOrder) {
                if (!tmp.contains(b)) continue;
                list.add(b);
            }
        }
        currentList = list;
        try {
            for (AFbdItem item : list) {
                VariableDef vd;
                JSONObject jsItem = new JSONObject();
                item.saveToJson(jsItem);
                jsItem.put(JSON_ITEM_CLASS, ItemsFactory.getClassName(item));
                jsArray.put(jsItem);
                if (vars == null || !(item instanceof FbdVariable) || (vd = ((FbdVariable)item).getVariable().varDef).isSystem() || vars.indexOf(vd) >= 0) continue;
                vars.add(vd);
            }
            json.put(JSON_ITEMS, jsArray);
        }
        finally {
            currentList = null;
        }
    }

    protected static void saveCommentsToJSON(JSONObject json, List<AFbdComment> list) {
        JSONArray jsArray = new JSONArray();
        for (AFbdComment c : list) {
            if (c.isEmpty()) continue;
            JSONObject jsItem = new JSONObject();
            c.saveToJson(jsItem);
            jsItem.put(JSON_COMMENT_TYPE, c instanceof FbdCommentText ? COMMENT_TYPE_TEXT : COMMENT_TYPE_RECT);
            jsArray.put(jsItem);
        }
        json.put(JSON_COMMENTS, jsArray);
    }

    public void saveToJson(JSONObject jso, List<VariableDef> vars) {
        jso.put(JSON_NAME, this.name);
        FbdPage.removeBlocks(this.items);
        for (AFbdBlock b : this.blocksOrder) {
            this.items.add(b);
        }
        this.saveItemsToJSON(jso, this.items, vars, false);
        FbdPage.saveCommentsToJSON(jso, this.comments);
    }

    public VariableRef locateVar(String fullName) {
        return this.editor.mainFrame.getVarsEditor().locateVar(fullName);
    }

    protected Variable getNullVar(int type, boolean array) {
        if (type == 1) {
            return array ? this.editor.bNullArray : this.editor.bNull;
        }
        if (type == 2) {
            return array ? this.editor.iNullArray : this.editor.iNull;
        }
        return array ? this.editor.fNullArray : this.editor.fNull;
    }

    public void compileVars() throws SyntaxError {
        for (AFbdItem item : this.items) {
            if (!(item instanceof FbdVariable) && !(item instanceof FbdNumber)) continue;
            item.compileOutputVars();
        }
        this.editor.freeUsedLocalVars();
        for (AFbdBlock b : this.blocksOrder) {
            b.compileOutputVars();
        }
        for (AFbdBlock b : this.blocksOrder) {
            b.compileInputVars();
        }
    }

    public void compileCode(ArrayList<String> code) {
        code.add("# PAGE \"" + this.name + "\"");
        int i = 1;
        for (AFbdBlock b : this.blocksOrder) {
            String title = "# " + i++ + ": " + b.getClass().getSimpleName();
            code.add(title);
            b.compileCode(code);
        }
    }

    static int getOutPinId(OutputPin pin) {
        if (pin == null) {
            return -1;
        }
        int itemIndex = currentList.indexOf(pin.owner);
        if (itemIndex < 0) {
            return -1;
        }
        int pinIndex = pin.owner.getOutputIndex(pin);
        return itemIndex * 1000 + pinIndex;
    }

    static OutputPin locateOutPinById(int id) {
        int itemIndex = id / 1000;
        int pinIndex = id % 1000;
        if (itemIndex >= 0 && itemIndex < currentList.size()) {
            AFbdItem item = currentList.get(itemIndex);
            if (item != null) {
                return item.getOutput(pinIndex);
            }
            return null;
        }
        return null;
    }

    public void markModified() {
        if (!this.internalUpdate) {
            this.editor.markModified();
        }
    }

    public void addItem(AFbdItem item) {
        this.items.add(item);
        if (item instanceof AFbdBlock) {
            this.blocksOrder.add((AFbdBlock)item);
            this.updateBlocksOrder();
        }
        this.markModified();
    }

    public void removeItem(AFbdItem item) {
        item.disconnectAll();
        this.items.remove(item);
        if (item instanceof AFbdBlock) {
            this.blocksOrder.remove((AFbdBlock)item);
            this.updateBlocksOrder();
        }
        this.markModified();
    }

    public void setExecOrder(AFbdBlock block, int order) {
        if (order != block.execOrder && order >= 1 && order <= this.blocksOrder.size()) {
            this.blocksOrder.remove(block);
            this.blocksOrder.add(order - 1, block);
            this.updateBlocksOrder();
            this.markModified();
        }
    }

    private void updateBlocksOrder() {
        for (int i = 0; i < this.blocksOrder.size(); ++i) {
            this.blocksOrder.get((int)i).execOrder = i + 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals(this.name)) {
            this.name = name;
            this.editor.markModified();
        }
    }

    public AFbdView getViewAtPx(int x, int y) {
        int i;
        for (AFbdView aFbdView : this.items) {
            if (!aFbdView.containsPx(x, y)) continue;
            return aFbdView;
        }
        for (i = this.comments.size() - 1; i >= 0; --i) {
            AFbdView aFbdView = this.comments.get(i);
            if (!(aFbdView instanceof FbdCommentRect) || !aFbdView.containsPx(x, y)) continue;
            return aFbdView;
        }
        for (i = this.comments.size() - 1; i >= 0; --i) {
            AFbdView aFbdView = this.comments.get(i);
            if (!aFbdView.containsPx(x, y)) continue;
            return aFbdView;
        }
        return null;
    }

    public AFbdPin getPinAt(int x, int y) {
        for (AFbdItem item : this.items) {
            AFbdPin pin = item.getPinAt(x, y);
            if (pin == null) continue;
            return pin;
        }
        return null;
    }

    public AFbdPin getPinAt(Rectangle r) {
        for (AFbdItem item : this.items) {
            AFbdPin pin = item.getPinAt(r);
            if (pin == null) continue;
            return pin;
        }
        return null;
    }

    public AFbdItem getItemAtCell(int cx, int cy) {
        for (AFbdItem item : this.items) {
            if (!item.cellBounds.contains(cx, cy)) continue;
            return item;
        }
        return null;
    }

    public boolean hasItemsAtCells(Rectangle r) {
        for (AFbdItem item : this.items) {
            if (!item.cellBounds.intersects(r)) continue;
            return true;
        }
        return false;
    }

    public void updateVars() {
        for (AFbdItem item : this.items) {
            if (!(item instanceof FbdVariable)) continue;
            ((FbdVariable)item).updatePins();
        }
    }

    public void deleteVars(List<VariableDef> vars) {
        int i = 0;
        while (i < this.items.size()) {
            AFbdItem item = this.items.get(i);
            if (item instanceof FbdVariable) {
                FbdVariable v = (FbdVariable)item;
                if (vars.contains(v.getVariable().varDef)) {
                    item.disconnectAll();
                    this.items.remove(item);
                    continue;
                }
            }
            ++i;
        }
    }
}

