/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.code;

import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.Program;
import certa.vics.ide.code.MyTokenMap;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.util.ArrayList;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class VicsCodeTokenMaker
extends AbstractTokenMaker {
    protected static VicsCodeTokenMaker lastInstance;
    private MyTokenMap reservedWords;
    private MyTokenMap commands;
    private MyTokenMap variables;
    private MyTokenMap identifiers;
    private int currentTokenStart;
    private int currentTokenType;
    private Segment currentText;
    private int newStartOffset;

    public VicsCodeTokenMaker() {
        lastInstance = this;
        this.reservedWords = new MyTokenMap();
        this.variables = new MyTokenMap();
        this.identifiers = new MyTokenMap();
        int reservedWord = 6;
        this.reservedWords.put("Time", reservedWord);
        this.reservedWords.put("EndTime", reservedWord);
        this.reservedWords.put("Main", reservedWord);
        this.reservedWords.put("EndMain", reservedWord);
        this.reservedWords.put("Sub", reservedWord);
        this.reservedWords.put("EndSub", reservedWord);
    }

    public void updateVariables(VariablesEditor ved) {
        this.variables.clear();
        ArrayList<VariableRef> vars = ved.getAllVariables(false, 0);
        for (VariableRef vr : vars) {
            this.variables.put(vr.fullName(), 17);
        }
        ArrayList<VariableDef> defs = ved.getAllDefines();
        for (VariableDef vd : defs) {
            if (vd.getArraySize() <= 0) continue;
            this.variables.put(vd.getFullName(), 17);
        }
    }

    private void addLabels(CodeBlock cb) {
        for (String s : cb.Labels.keySet()) {
            this.identifiers.put(s, 20);
        }
    }

    public void updateIdentifiers(Program program) {
        if (this.commands == null && program.device != null) {
            this.commands = new MyTokenMap();
            for (CommandDef cd : program.device.CommandList) {
                this.commands.put(cd.Name, 8);
            }
        }
        this.identifiers.clear();
        this.addLabels(program.MainCode);
        for (String s : program.Subs.keySet()) {
            this.identifiers.put(s, 20);
        }
        for (CodeBlock cb : program.Subs.values()) {
            this.addLabels(cb);
        }
    }

    @Override
    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        if (tokenType == 20) {
            tokenType = this.reservedWords.getTypeAndFixCase(segment.array, start, end);
            if (tokenType == -1 && this.commands != null) {
                tokenType = this.commands.getTypeAndFixCase(segment.array, start, end);
            }
            if (tokenType == -1) {
                tokenType = this.variables.getTypeAndFixCase(segment.array, start, end);
            }
            if (tokenType == -1) {
                tokenType = this.identifiers.getTypeAndFixCase(segment.array, start, end);
            }
            if (tokenType == -1) {
                tokenType = 24;
            }
        }
        super.addToken(segment.array, start, end, tokenType, startOffset);
    }

    @Override
    public String[] getLineCommentStartAndEnd(int languageIndex) {
        return new String[]{"# ", null};
    }

    @Override
    public boolean getMarkOccurrencesOfTokenType(int type) {
        return type == 20 || type == 17;
    }

    @Override
    public TokenMap getWordsToHighlight() {
        return null;
    }

    private void addCurrentToken(int nextTokenStart) {
        this.addToken(this.currentText, this.currentTokenStart, nextTokenStart - 1, this.currentTokenType, this.newStartOffset + this.currentTokenStart);
        this.currentTokenStart = nextTokenStart;
    }

    @Override
    public Token getTokenList(Segment text, int startTokenType, int startOffset) {
        this.resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        this.newStartOffset = startOffset - offset;
        this.currentText = text;
        this.currentTokenStart = offset;
        this.currentTokenType = startTokenType;
        block31: for (int i = offset; i < end; ++i) {
            char c = array[i];
            switch (this.currentTokenType) {
                case 0: {
                    this.currentTokenStart = i;
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.currentTokenType = 21;
                            continue block31;
                        }
                        case '#': {
                            this.currentTokenType = 1;
                            continue block31;
                        }
                        case ':': {
                            this.currentTokenType = 7;
                            continue block31;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) {
                        this.currentTokenType = 10;
                        continue block31;
                    }
                    this.currentTokenType = 20;
                    continue block31;
                }
                case 21: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case '#': {
                            this.addCurrentToken(i);
                            this.currentTokenType = 1;
                            continue block31;
                        }
                        case ':': {
                            this.addCurrentToken(i);
                            this.currentTokenType = 7;
                            continue block31;
                        }
                    }
                    this.addCurrentToken(i);
                    if (RSyntaxUtilities.isDigit(c)) {
                        this.currentTokenType = 10;
                        continue block31;
                    }
                    this.currentTokenType = 20;
                    continue block31;
                }
                case 7: {
                    this.addCurrentToken(i);
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.currentTokenType = 21;
                            continue block31;
                        }
                        case '#': {
                            this.currentTokenType = 1;
                            continue block31;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) {
                        this.currentTokenType = 10;
                        continue block31;
                    }
                    this.currentTokenType = 20;
                    continue block31;
                }
                case 20: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addCurrentToken(i);
                            this.currentTokenType = 21;
                            continue block31;
                        }
                    }
                    continue block31;
                }
                case 10: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addCurrentToken(i);
                            this.currentTokenType = 21;
                            continue block31;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) continue block31;
                    this.currentTokenType = 20;
                    continue block31;
                }
                case 1: {
                    i = end - 1;
                    this.addToken(text, this.currentTokenStart, i, this.currentTokenType, this.newStartOffset + this.currentTokenStart);
                    this.currentTokenType = 0;
                    continue block31;
                }
            }
        }
        switch (this.currentTokenType) {
            case 0: {
                this.addNullToken();
                break;
            }
            default: {
                this.addToken(text, this.currentTokenStart, end - 1, this.currentTokenType, this.newStartOffset + this.currentTokenStart);
                this.addNullToken();
            }
        }
        return this.firstToken;
    }
}

