/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.Main;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HelpWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    static HashMap<String, HelpWindow> windows = new HashMap();
    static HTMLEditorKit kit;
    private JEditorPane htmlPane;

    static void showHelp(String folder, String title, String propKey) {
        HelpWindow w = windows.get(folder);
        if (w == null) {
            w = new HelpWindow(title, propKey, folder);
            windows.put(folder, w);
        }
        w.setVisible(true);
        w.setExtendedState(0);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 800;
        w.setSize(width, dim.height * 85 / 100);
        w.setLocation(dim.width / 2 - w.getWidth() / 2, dim.height / 2 - w.getHeight() / 2);
        w.toFront();
    }

    public HelpWindow(String title, final String checkKey, String folder) {
        super(title);
        this.setDefaultCloseOperation(1);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setMinimumSize(new Dimension(300, 200));
        if (checkKey != null) {
            final JCheckBox chkShow = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u044d\u0442\u043e \u043e\u043a\u043d\u043e \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
            chkShow.setFocusable(false);
            chkShow.setSelected(Main.props.getBool(checkKey, true));
            chkShow.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Main.props.saveBool(checkKey, chkShow.isSelected());
                }
            });
            this.add((Component)chkShow, "South");
        }
        if (kit == null) {
            kit = new HTMLEditorKit();
            this.initCSS(kit);
        }
        this.htmlPane = new JEditorPane("text/html", "");
        this.htmlPane.setEditable(false);
        this.htmlPane.setEditorKit(kit);
        JScrollPane docView = new JScrollPane(this.htmlPane);
        docView.setPreferredSize(new Dimension(550, 500));
        this.add((Component)docView, "Center");
        folder = "help/" + folder;
        String contents = Utils.loadStringFromFile(folder + "/contents.html");
        if (contents != null) {
            String imgPrefix = "<img src='" + Utils.getResource(folder + "/contents.html").toString().replace("contents.html", "");
            contents = contents.replace("<img src='", imgPrefix);
            Document doc = kit.createDefaultDocument();
            this.htmlPane.setDocument(doc);
            this.htmlPane.setText(contents);
            this.htmlPane.setCaretPosition(0);
        }
    }

    private void initCSS(HTMLEditorKit kit) {
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("body { color:#000; font-family:times; margin: 10px; }");
        styleSheet.addRule("h1 { color: black; }");
        styleSheet.addRule("ul { list-style-type: none; }");
    }
}

