/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.variables.SysVariableDialog;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariablePropsDialog;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class VariablesActions
extends ActionsBundle {
    final VariablesEditor editor;
    public final IdeAction add = new AddVar(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", "add_var.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", 0, KeyStroke.getKeyStroke("INSERT"));
    public final IdeAction delete = new Delete(this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", 0, KeyStroke.getKeyStroke("DELETE"));
    public final IdeAction editProps = new EditProps(this, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", "props.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", 0, KeyStroke.getKeyStroke("ENTER"));
    public final IdeAction copy = new Copy(this, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "copy.png", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(67, UNI_CTRL_MASK), false);
    public final IdeAction cut = new Copy(this, "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(88, UNI_CTRL_MASK), true);
    public final IdeAction paste = new Paste(this, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(86, UNI_CTRL_MASK));

    public VariablesActions(VariablesEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public class Paste
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Paste(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesActions.this.editor.pasteFromClipboard();
        }
    }

    public class Copy
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean cut;

        public Copy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean cut) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.cut = cut;
        }

        @Override
        protected boolean canExec() {
            VariableDef vd = VariablesActions.this.editor.getSelectedVariable();
            return vd != null && !vd.isSystem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesActions.this.editor.copyToClipboard(this.cut);
        }
    }

    public class EditProps
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public EditProps(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            VariableDef vd = VariablesActions.this.editor.getSelectedVariable();
            return vd != null && (!vd.isSystem() || vd.isWritable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariableDef vd = VariablesActions.this.editor.getSelectedVariable();
            if (vd != null) {
                if (vd.isSystem()) {
                    if (vd.isWritable() && SysVariableDialog.showDialog(vd)) {
                        VariablesActions.this.editor.commitAction(true);
                    }
                } else if (VariablePropsDialog.showDialog(vd, VariablesActions.this.editor.getSelectedColumn(), false)) {
                    VariablesActions.this.editor.commitAction(true);
                    VariablesActions.this.editor.notifyChanged();
                }
            }
        }
    }

    public class Delete
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Delete(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            VariableDef vd = VariablesActions.this.editor.getSelectedVariable();
            return vd != null && !vd.isSystem() && !vd.isUsed();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesActions.this.editor.deleteSelected();
            VariablesActions.this.editor.commitAction(false);
        }
    }

    public class AddVar
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddVar(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        protected boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariableDef sel = VariablesActions.this.editor.getSelectedVariable();
            VariableDef vd = VariablesActions.this.editor.createVariable();
            VariablesActions.this.editor.selectVariable(null);
            if (VariablePropsDialog.showDialog(vd, 2, true)) {
                VariablesActions.this.editor.addVariable(vd);
                VariablesActions.this.editor.commitAction(true);
                VariablesActions.this.editor.notifyChanged();
            } else {
                VariablesActions.this.editor.selectVariable(sel);
            }
        }
    }
}

