/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.Main;
import certa.vics.ide.ui.GroupPropsDialog;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.ui.WindowPropsDialog;
import certa.vics.ide.ui.WindowView;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class UiActions
extends ActionsBundle {
    final UiEditor editor;
    public final Action moveRight = new Move(this, "\u0412\u043f\u0440\u0430\u0432\u043e", "right.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043f\u0440\u0430\u0432\u043e", 0, KeyStroke.getKeyStroke("control RIGHT"), true);
    public final Action moveLeft = new Move(this, "\u0412\u043b\u0435\u0432\u043e", "left.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043b\u0435\u0432\u043e", 0, KeyStroke.getKeyStroke("control LEFT"), false);
    public final Action focusRight = new Focus(this, "\u0412\u043f\u0440\u0430\u0432\u043e", null, "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u043f\u0440\u0430\u0432\u043e", 0, KeyStroke.getKeyStroke("RIGHT"), 3);
    public final Action focusLeft = new Focus(this, "\u0412\u043b\u0435\u0432\u043e", null, "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u043b\u0435\u0432\u043e", 0, KeyStroke.getKeyStroke("LEFT"), 2);
    public final Action focusUp = new Focus(this, "\u0412\u0432\u0435\u0440\u0445", null, "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u0432\u0435\u0440\u0445", 0, KeyStroke.getKeyStroke("UP"), 0);
    public final Action focusDown = new Focus(this, "\u0412\u043d\u0438\u0437", null, "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432\u043d\u0438\u0437", 0, KeyStroke.getKeyStroke("DOWN"), 1);
    public final Action arrange = new Arrange(this, "\u0423\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0438\u0442\u044c", "arrange.png", "\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u044b\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u0441\u0435 \u043e\u043a\u043d\u0430", 0, null);
    public final Action delete = new Delete(this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b", 0, KeyStroke.getKeyStroke("DELETE"));
    public final Action editProps = new EditProps(this, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", "props.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", 0, null);
    public final Action addWindow = new AddWindow(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u043a\u043d\u043e", "add_window.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043e\u043a\u043d\u043e \u0432 \u043c\u0435\u043d\u044e", 0, null, false, true);
    public final Action addWindowL = new AddWindow(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u043a\u043d\u043e \u0441\u043b\u0435\u0432\u0430", "add_window_l.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043e\u043a\u043d\u043e \u0441\u043b\u0435\u0432\u0430 \u043e\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e", 0, null, true, false);
    public final Action addWindowR = new AddWindow(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u043a\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u0430", "add_window_r.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043e\u043a\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u0430 \u043e\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e", 0, null, false, false);
    public final Action addGroup = new AddGroup(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043c\u0435\u043d\u044e", "add_group.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", 0, null);
    public final Action copy = new Copy(this, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "copy.png", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(67, 2), false);
    public final Action cut = new Copy(this, "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(88, 2), true);
    public final Action paste = new Paste(this, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(86, 2));
    public final Action relocate = new Relocate(this, "\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438", "relocate.png", "\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0432 \u0434\u0440\u0443\u0433\u043e\u0435 \u043c\u0435\u0441\u0442\u043e", 0, null);
    static final String PROP_RELOCATE_HINT = "ui.reloc_hint";

    public UiActions(UiEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public class Relocate
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Relocate(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.startRelocation();
            if (Main.props.getBool(UiActions.PROP_RELOCATE_HINT, true)) {
                this.showHintMsg();
            }
        }

        private void showHintMsg() {
            JCheckBox checkbox = new JCheckBox("\u0411\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c");
            String message = "<html>\u0429\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043d\u0430 \u043e\u043a\u043d\u043e, \u0438\u043b\u0438 \u043c\u0435\u043d\u044e, \u0447\u0442\u043e\u0431\u044b \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0442\u0443\u0434\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b,<br>\u0438\u043b\u0438 \u0449\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043d\u0430 \u043f\u0443\u0441\u0442\u043e\u043c \u043c\u0435\u0441\u0442\u0435 \u044d\u043a\u0440\u0430\u043d\u0430, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435.</html>";
            Object[] params = new Object[]{message, checkbox};
            JOptionPane.showMessageDialog(UiActions.this.editor, params, "\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430", 1);
            Main.props.saveBool(UiActions.PROP_RELOCATE_HINT, !checkbox.isSelected());
        }
    }

    public class AddWindow
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean toLeft;
        final boolean toGroup;

        public AddWindow(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean left, boolean group) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.toLeft = left;
            this.toGroup = group;
        }

        @Override
        public boolean canExec() {
            if (this.toGroup == (UiActions.this.editor.focusedGroup != null)) {
                return UiActions.this.editor.canInsertWindow();
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.createWindow(this.toGroup ? null : UiActions.this.editor.focusedWindow, this.toLeft);
        }
    }

    public class AddGroup
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddGroup(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.focusedWindow != null && UiActions.this.editor.focusedWindow.canInsertGroup();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.createSubMenu(UiActions.this.editor.focusedWindow);
        }
    }

    public class Paste
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Paste(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.canInsertWindow();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.pasteFromClipboard();
        }
    }

    public class Copy
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean cut;

        public Copy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean cut) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.cut = cut;
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.copyToClipboard(this.cut);
        }
    }

    public class EditProps
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public EditProps(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.focusedGroup != null || UiActions.this.editor.focusedWindow != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UiActions.this.editor.focusedWindow != null || UiActions.this.editor.focusedGroup != null) {
                boolean ok = false;
                ok = UiActions.this.editor.focusedWindow != null ? WindowPropsDialog.showDialog(UiActions.this.editor.focusedWindow) : GroupPropsDialog.showDialog(UiActions.this.editor.focusedGroup);
                if (ok) {
                    UiActions.this.editor.commitAction();
                }
            }
        }
    }

    public class Delete
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Delete(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.deleteSelected();
            UiActions.this.editor.commitAction();
        }
    }

    public class Arrange
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Arrange(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.arrangeWindows();
            UiActions.this.editor.commitAction();
        }
    }

    public class Focus
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        public static final int GO_UP = 0;
        public static final int GO_DOWN = 1;
        public static final int GO_LEFT = 2;
        public static final int GO_RIGHT = 3;
        private final int dir;

        public Focus(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, int dir) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dir = dir;
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WindowView w = UiActions.this.editor.focusedWindow;
            if (w != null) {
                WindowView target = null;
                if (this.dir == 0) {
                    target = w.getUpLink();
                } else if (this.dir == 1) {
                    target = w.getDownLink();
                } else if (this.dir == 2) {
                    target = w.getLeftLink();
                } else if (this.dir == 3) {
                    target = w.getRightLink();
                } else {
                    this.setEnabled(false);
                }
                if (target != null) {
                    UiActions.this.editor.focusWindow(target);
                }
            }
        }
    }

    public class Move
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        private final boolean toRight;

        public Move(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean toRight) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.toRight = toRight;
        }

        @Override
        public boolean canExec() {
            if (!UiActions.this.editor.selectedWindows.isEmpty()) {
                if (this.toRight) {
                    for (WindowView w : UiActions.this.editor.selectedWindows) {
                        if (w.getRightLink() != null) continue;
                        return false;
                    }
                } else {
                    for (WindowView w : UiActions.this.editor.selectedWindows) {
                        if (w.getLeftLink() != null) continue;
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UiActions.this.editor.selectedWindows.isEmpty()) {
                if (this.toRight) {
                    Collections.sort(UiActions.this.editor.selectedWindows, new Comparator<WindowView>(){

                        @Override
                        public int compare(WindowView o1, WindowView o2) {
                            return o2.position - o1.position;
                        }
                    });
                    for (WindowView w : UiActions.this.editor.selectedWindows) {
                        w.getParentGroup().moveRight(w.position);
                    }
                } else {
                    Collections.sort(UiActions.this.editor.selectedWindows, new Comparator<WindowView>(){

                        @Override
                        public int compare(WindowView o1, WindowView o2) {
                            return o1.position - o2.position;
                        }
                    });
                    for (WindowView w : UiActions.this.editor.selectedWindows) {
                        w.getParentGroup().moveLeft(w.position);
                    }
                }
                UiActions.this.editor.arrangeWindows();
                UiActions.this.editor.commitAction();
            }
        }
    }
}

